/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.gift.ui.pannel.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.FP;
import com.yy.base.utils.StringUtils;
import com.yy.hiyo.wallet.R;
import com.yy.hiyo.wallet.base.revenue.gift.bean.GiftItemInfo;
import java.util.ArrayList;
import java.util.List;

public class GiftAmountAdapter
extends RecyclerView.Adapter<MyViewHolder> {
    private List<GiftItemInfo.Number> mAmountList = new ArrayList<GiftItemInfo.Number>();
    private OnAmountClickListener mListener;
    private String mSelectedAmount;

    public void setData(List<GiftItemInfo.Number> list) {
        this.mAmountList.clear();
        if (!FP.empty(list)) {
            this.mAmountList.addAll(list);
        }
        this.notifyDataSetChanged();
    }

    public int getItemCount() {
        if (!FP.empty(this.mAmountList)) {
            return this.mAmountList.size();
        }
        return 0;
    }

    public void setSelectedItem(String amount) {
        this.mSelectedAmount = amount;
    }

    public void setOnClickListener(OnAmountClickListener listener) {
        this.mListener = listener;
    }

    @NonNull
    public MyViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View view = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.item_gift_amount, parent, false);
        return new MyViewHolder(view);
    }

    public void onBindViewHolder(@NonNull MyViewHolder holder, int position) {
        final GiftItemInfo.Number number = this.mAmountList.get(position);
        if (number != null) {
            holder.mTvAmount.setText((CharSequence)(number.getNumber() + ""));
            holder.mTvAmount.setTextColor(-1);
            if (StringUtils.equal((String)this.mSelectedAmount, (String)String.valueOf(number.getNumber()))) {
                holder.mTvAmount.setTextColor(-15867);
            }
            holder.mTvAmount.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (GiftAmountAdapter.this.mListener != null) {
                        GiftAmountAdapter.this.mListener.onClickAmount(number);
                    }
                }
            });
        }
    }

    public static interface OnAmountClickListener {
        public void onClickAmount(GiftItemInfo.Number var1);
    }

    public class MyViewHolder
    extends RecyclerView.ViewHolder {
        public YYTextView mTvAmount;

        public MyViewHolder(View view) {
            super(view);
            this.mTvAmount = (YYTextView)view.findViewById(R.id.tv_gift_amount);
        }
    }
}

