/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.gift.ui.pannel;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.DiffUtil;
import com.yy.hiyo.wallet.base.revenue.gift.param.GiftUserInfo;
import java.util.List;

public class ReceiverListDiffCallback
extends DiffUtil.Callback {
    private List<GiftUserInfo> mOldData;
    private List<GiftUserInfo> mNewData;

    public ReceiverListDiffCallback(@NonNull List<GiftUserInfo> oldData, @NonNull List<GiftUserInfo> newData) {
        this.mOldData = oldData;
        this.mNewData = newData;
    }

    public int getOldListSize() {
        return this.mOldData == null ? 0 : this.mOldData.size();
    }

    public int getNewListSize() {
        return this.mNewData == null ? 0 : this.mNewData.size();
    }

    public boolean areItemsTheSame(int oldItemPosition, int newItemPosition) {
        if (this.mNewData == null && this.mOldData == null) {
            return true;
        }
        if (this.mNewData == null || this.mOldData == null) {
            return false;
        }
        GiftUserInfo oldItem = this.mOldData.get(oldItemPosition);
        GiftUserInfo newItem = this.mNewData.get(newItemPosition);
        return oldItem.getUserInfo().uid == newItem.getUserInfo().uid && oldItem.isSelected() == newItem.isSelected();
    }

    public boolean areContentsTheSame(int oldItemPosition, int newItemPosition) {
        if (this.mNewData == null && this.mOldData == null) {
            return true;
        }
        if (this.mNewData == null || this.mOldData == null) {
            return false;
        }
        GiftUserInfo oldItem = this.mOldData.get(oldItemPosition);
        GiftUserInfo newItem = this.mNewData.get(newItemPosition);
        if (oldItem.getUserType() != newItem.getUserType()) {
            return false;
        }
        if (oldItem.getIndex() != newItem.getIndex()) {
            return false;
        }
        if (oldItem.getUserInfo().sex != newItem.getUserInfo().sex) {
            return false;
        }
        if (oldItem.getUserType() != newItem.getUserType()) {
            return false;
        }
        if (oldItem.getUserInfo().avatar != newItem.getUserInfo().avatar) {
            return false;
        }
        return oldItem.isSelected() == newItem.isSelected();
    }
}

