/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.gift.ui.pannel;

import android.content.Context;
import android.os.Bundle;
import android.os.Message;
import android.util.LongSparseArray;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yy.appbase.AppbaseMsgDef;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.UnifyConfig;
import com.yy.appbase.unifyconfig.config.AConfigData;
import com.yy.appbase.unifyconfig.config.ProfileCardGiftEntryConfig;
import com.yy.base.env.RuntimeContext;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.LanguageUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.SystemUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.framework.core.MsgDispatcher;
import com.yy.hiyo.channel.common.CharStorageFileHelper;
import com.yy.hiyo.proto.callback.SimpleProtoCallback;
import com.yy.hiyo.wallet.R;
import com.yy.hiyo.wallet.base.IActivityService;
import com.yy.hiyo.wallet.base.IPayLevelService;
import com.yy.hiyo.wallet.base.IPayService;
import com.yy.hiyo.wallet.base.IRedPacketService;
import com.yy.hiyo.wallet.base.action.ActivityAction;
import com.yy.hiyo.wallet.base.action.ActivityActionList;
import com.yy.hiyo.wallet.base.action.ActivityActionWrapper;
import com.yy.hiyo.wallet.base.action.ActivityTagInfo;
import com.yy.hiyo.wallet.base.action.GiftPanelAction;
import com.yy.hiyo.wallet.base.pay.bean.BalanceInfo;
import com.yy.hiyo.wallet.base.pay.bean.BalanceResponse;
import com.yy.hiyo.wallet.base.pay.bean.RechargeInfo;
import com.yy.hiyo.wallet.base.pay.callback.IPayCallback;
import com.yy.hiyo.wallet.base.revenue.gift.bean.GiftExpandInfo;
import com.yy.hiyo.wallet.base.revenue.gift.bean.GiftItemInfo;
import com.yy.hiyo.wallet.base.revenue.gift.bean.LoadGiftResult;
import com.yy.hiyo.wallet.base.revenue.gift.event.IGiftCallback;
import com.yy.hiyo.wallet.base.revenue.gift.event.IShowGiftInterceptor;
import com.yy.hiyo.wallet.base.revenue.gift.param.GiftHandlerParam;
import com.yy.hiyo.wallet.base.revenue.gift.param.GiftUserInfo;
import com.yy.hiyo.wallet.base.revenue.gift.param.ShowGiftPanelParam;
import com.yy.hiyo.wallet.base.revenue.moneyreport.IMoneyReportService;
import com.yy.hiyo.wallet.base.revenue.moneyreport.ViewType;
import com.yy.hiyo.wallet.base.revenue.pay.IRechargeSuccessListener;
import com.yy.hiyo.wallet.base.revenue.redpacket.room.IRedPacketHandler;
import com.yy.hiyo.wallet.base.revenue.redpacket.room.bean.RedPacketEntrance;
import com.yy.hiyo.wallet.base.revenue.redpacket.room.bean.RedPacketEntranceReqParam;
import com.yy.hiyo.wallet.gift.data.bean.ArGiftInfo;
import com.yy.hiyo.wallet.gift.data.bean.CheckGiftInfo;
import com.yy.hiyo.wallet.gift.data.bean.ConsumeGuideNotifyInfo;
import com.yy.hiyo.wallet.gift.data.result.GiftOperationNotifyResult;
import com.yy.hiyo.wallet.gift.data.result.SendGiftRes;
import com.yy.hiyo.wallet.gift.model.GiftOperationModel;
import com.yy.hiyo.wallet.gift.statis.GiftHiidoReport;
import com.yy.hiyo.wallet.gift.ui.activitygift.greetingcard.GreetingCardEditDialog;
import com.yy.hiyo.wallet.gift.ui.pannel.GiftPanelContract;
import com.yy.hiyo.wallet.gift.ui.pannel.GiftReceiverHeaderManager;
import com.yy.hiyo.wallet.gift.ui.pannel.IGiftPanelCallBack;
import com.yy.hiyo.wallet.gift.ui.pannel.IGiftPanelCallback;
import com.yy.hiyo.wallet.gift.ui.pannel.IGiftPanelOperator;
import com.yy.hiyo.wallet.gift.ui.pannel.act.GiftPanelActManager;
import com.yy.hiyo.wallet.gift.ui.pannel.act.IGiftPanelActManager;
import com.yy.hiyo.wallet.gift.ui.pannel.adapter.GiftItemViewType;
import com.yy.hiyo.wallet.gift.ui.pannel.bean.ActBannerGiftInfo;
import com.yy.hiyo.wallet.gift.ui.pannel.bean.GiftPanelItemInfo;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import net.ihago.act.api.luckygift.GetPeriodPoolInfoRes;
import net.ihago.active.api.activity.PropOneLimit;
import net.ihago.argift.srv.upgrade.GiftStatus;
import net.ihago.money.api.giftpanel.GetGiftDescriptionRes;
import net.ihago.money.api.pay.FreeGiftConversionNotify;
import net.ihago.money.api.paylevel.RechargeScene;
import net.ihago.money.api.weekgift.GiftPanelRes;
import org.json.JSONException;
import org.json.JSONObject;

public class GiftPanelPresenter
implements GiftPanelContract.Presenter,
IGiftPanelOperator {
    public static final String TAG = "_GiftPanelPresenter";
    private static final int ACTIVITY_BANNER_INFO_LOCATION = 4;
    public static final String GIFT_ACT_TAB_KEY = "gift_act_tab_key";
    public static final String GIFT_REPORT_KEY = "gift_report_key";
    private static final int GIFT_DIALOG_ACT_LOCATION = 18;
    private static final int GIFT_TAB_ACT_LOCATION = 20;
    public static final String BACKGROUND_RES_ID = "background_res_id";
    private GiftPanelItemInfo mSelectedGift;
    private int mSelectedGiftNum;
    private ActivityTagInfo mRoomTag;
    private ActivityAction giftDialogAction;
    private List<ActivityAction> actTabActionList = new ArrayList<ActivityAction>();
    private IGiftPanelCallback mCallback;
    private GiftOperationModel mModel;
    private IShowGiftInterceptor mInterceptor;
    private DecimalFormat df;
    private String mLang;
    private String mSelectedTab = "";
    private List<ArGiftInfo> mArGiftInfoList = new ArrayList<ArGiftInfo>();
    private GiftPanelActManager mGiftPanelActManager = new GiftPanelActManager();
    private String mRoomId;
    private int mRoomMode;
    private int mRoomSubMode;
    private String mCurGameId = "";
    private long mRoomAnchorUid;
    private boolean mCanInitPagersPosition = true;
    private boolean hasFamilyTab = true;
    private long lastRefreshTime = 0L;
    private ConcurrentHashMap<Integer, GiftItemInfo> mPackMap;
    private CopyOnWriteArrayList<GiftItemInfo> mGiftList;
    private Map<Integer, GiftItemInfo> mSpecialGiftList = new HashMap<Integer, GiftItemInfo>();
    private ConsumeGuideNotifyInfo mConsumeGuideData;
    private Map<String, List<List<GiftPanelItemInfo>>> mCacheAllGiftByTabMap = new HashMap<String, List<List<GiftPanelItemInfo>>>();
    private Map<Integer, List<GiftPanelItemInfo>> mCacheAllGiftByPropIdMap = new HashMap<Integer, List<GiftPanelItemInfo>>();
    private List<GiftExpandInfo.GiftPanelTabInfo> mGiftTabList = new ArrayList<GiftExpandInfo.GiftPanelTabInfo>();
    private HashMap<String, GiftExpandInfo.GiftPanelTabInfo> mActBannerGiftTabMap = new HashMap(5);
    private GiftPanelContract.View mView;
    private GreetingCardEditDialog mGreetingCardEditDialog;
    private IActivityService.OnActivityUpdateListener mOnActivityUpdateListener;
    private GiftReceiverHeaderManager mGiftReceiverHeaderManager = new GiftReceiverHeaderManager(this);
    private CharStorageFileHelper mCharStorageFileHelper = new CharStorageFileHelper(20, "gift_act_tab_key");
    private CharStorageFileHelper mGiftReportHelper = new CharStorageFileHelper(20, "gift_report_key");
    private int mPanelFrom;
    private int mH5SelectPropId;
    private boolean selectPropPacketTab = false;
    private boolean isDefaultGift = false;
    private IGiftCallback<LoadGiftResult> mLoadGiftCallbak = new IGiftCallback<LoadGiftResult>(){

        public void onSucceed(LoadGiftResult result) {
            FeatureLog.i((String)"FTGiftPanel_GiftPanelPresenter", (String)"mLoadGiftCallbak, onSucceed : %d", (Object[])new Object[]{result != null ? result.getGiftList().size() : 0});
            if (result != null) {
                GiftPanelPresenter.this.mGiftList = new CopyOnWriteArrayList(result.getGiftList());
                GiftPanelPresenter.this.mGiftTabList = result.getGiftExpand().getGiftTabList();
            }
            GiftPanelPresenter.this.handleGiftData();
            GiftPanelPresenter.this.hideLoading();
        }

        public void onFailed(int code, String msg) {
            FeatureLog.i((String)"FTGiftPanel_GiftPanelPresenter", (String)"mLoadGiftCallbak, onFailed : %s", (Object[])new Object[]{msg});
            GiftPanelPresenter.this.hideLoading();
        }
    };
    private IGiftCallback<List<GiftItemInfo>> mLoadPackageCallback = new IGiftCallback<List<GiftItemInfo>>(){

        public void onSucceed(List<GiftItemInfo> result) {
            FeatureLog.i((String)"FTGiftPanel_GiftPanelPresenter", (String)"mLoadPackageCallback, onSucceed size: %d", (Object[])new Object[]{result.size()});
            if (result != null) {
                GiftPanelPresenter.this.convertPackListToMap(result);
            }
            GiftPanelPresenter.this.handleGiftData();
        }

        public void onFailed(int code, String msg) {
            FeatureLog.i((String)"FTGiftPanel_GiftPanelPresenter", (String)"mLoadPackageCallback, onFailed : %s", (Object[])new Object[]{msg});
        }
    };
    private IGiftCallback<List<ArGiftInfo>> arGiftCallback = new IGiftCallback<List<ArGiftInfo>>(){

        public void onSucceed(List<ArGiftInfo> result) {
            FeatureLog.i((String)"FTGiftPanel_GiftPanelPresenter", (String)"refresh,onSucceed result : %s", (Object[])new Object[]{result});
            if (GiftPanelPresenter.this.refresh(result)) {
                FeatureLog.i((String)"FTGiftPanel_GiftPanelPresenter", (String)"refresh", (Object[])new Object[0]);
                GiftPanelPresenter.this.mArGiftInfoList.clear();
                GiftPanelPresenter.this.mArGiftInfoList.addAll(result);
                GiftPanelPresenter.this.handleGiftData();
            }
        }

        public void onFailed(int code, String msg) {
            FeatureLog.i((String)"FTGiftPanel_GiftPanelPresenter", (String)"refresh, onFailed code: %s", (Object[])new Object[]{code});
        }
    };
    private IGiftPanelCallBack.IGiftDecsCallback mGiftDecsCallback = new IGiftPanelCallBack.IGiftDecsCallback(){

        @Override
        public void onGiftDesShow(@org.jetbrains.annotations.Nullable GiftItemInfo gift, @org.jetbrains.annotations.Nullable String jumpUrl, int from) {
            if (gift != null) {
                GiftHiidoReport.giftDesShow(GiftPanelPresenter.this.getRoomId(), String.valueOf(gift.getPropsId()), jumpUrl, from, GiftPanelPresenter.this.mRoomAnchorUid, GiftPanelPresenter.this.mCurGameId);
            }
        }

        @Override
        public void onGiftDesClick(@org.jetbrains.annotations.Nullable GiftItemInfo gift, @org.jetbrains.annotations.Nullable String jumpUrl, int from) {
            if (gift != null) {
                GiftHiidoReport.giftDesClick(GiftPanelPresenter.this.getRoomId(), String.valueOf(gift.getPropsId()), jumpUrl, from, GiftPanelPresenter.this.mRoomAnchorUid, GiftPanelPresenter.this.mCurGameId);
            }
        }

        @Override
        public void getPrizePoolInfo(int propId, @org.jetbrains.annotations.Nullable SimpleProtoCallback<GetPeriodPoolInfoRes> callback) {
            GiftPanelPresenter.this.mModel.requestPrizePoolInfo(propId, callback);
        }

        @Override
        public void getGiftDescription(int propId, @org.jetbrains.annotations.Nullable SimpleProtoCallback<GetGiftDescriptionRes> callback) {
            GiftPanelPresenter.this.mModel.requestGiftDescription(propId, callback);
        }

        @Override
        public void reqWeekGiftDecs(long propId, @org.jetbrains.annotations.Nullable SimpleProtoCallback<GiftPanelRes> callback) {
            GiftPanelPresenter.this.mModel.reqWeekGiftDecs(propId, callback);
        }

        @Override
        public void onDecsVisibilityChange(int visibility, int from) {
            if (GiftPanelPresenter.this.mView != null) {
                GiftPanelPresenter.this.mView.onDecsVisibilityChange(visibility);
            }
        }

        @Override
        public int getSelectPropId() {
            return GiftPanelPresenter.this.mSelectedGift != null ? GiftPanelPresenter.this.mSelectedGift.getPropsId() : 0;
        }
    };
    private IRechargeSuccessListener mPayCallback = new IRechargeSuccessListener(){

        public void onSuccess(RechargeInfo info) {
            FeatureLog.i((String)"FTGiftPanel_GiftPanelPresenter", (String)"mPayCallback, onSucceed : %s", (Object[])new Object[]{info});
            if (!FP.empty((CharSequence)GiftPanelPresenter.this.mRoomId)) {
                ((IActivityService)ServiceManagerProxy.getServiceManager().getService(IActivityService.class)).updateActivity(GiftPanelPresenter.this.mRoomId, GiftPanelPresenter.this.mRoomTag, true);
            }
            GiftPanelPresenter.this.getBalance();
        }
    };

    private boolean refresh(List<ArGiftInfo> result) {
        if (result.size() != this.mArGiftInfoList.size()) {
            return true;
        }
        for (ArGiftInfo arGiftInfo : result) {
            boolean equ = false;
            for (ArGiftInfo cache : this.mArGiftInfoList) {
                if (!arGiftInfo.equals(cache)) continue;
                equ = true;
                break;
            }
            if (equ) continue;
            return true;
        }
        return false;
    }

    @Override
    public Map<String, List<List<GiftPanelItemInfo>>> getCacheGiftItemMap() {
        return this.mCacheAllGiftByTabMap;
    }

    @Override
    public List<GiftExpandInfo.GiftPanelTabInfo> getGiftTabList() {
        ArrayList<GiftExpandInfo.GiftPanelTabInfo> mTabList = new ArrayList<GiftExpandInfo.GiftPanelTabInfo>(this.mGiftTabList);
        mTabList.addAll(this.mActBannerGiftTabMap.values());
        return mTabList;
    }

    public GiftPanelPresenter(GiftPanelContract.View view, @NonNull IGiftPanelCallback callback, IShowGiftInterceptor interceptor, int mode) {
        this.mView = view;
        this.mCallback = callback;
        this.mInterceptor = interceptor;
        this.mModel = new GiftOperationModel();
        this.mPackMap = new ConcurrentHashMap();
        this.mGiftList = new CopyOnWriteArrayList();
        this.mGiftReceiverHeaderManager.inflateView(this.mView.getPlaceHolderView(), mode);
        this.mView.setPresenter(this);
        this.mView.setGiftDecsCallback(this.mGiftDecsCallback);
        ((IPayService)ServiceManagerProxy.getServiceManager().getService(IPayService.class)).addPayListener(this.mPayCallback);
    }

    @Override
    public void showConsumeGuidePop(ConsumeGuideNotifyInfo data) {
        if (this.mView != null && this.mView.isShowWithoutAnim()) {
            this.mView.showConsumeGuide(data);
        } else {
            this.mConsumeGuideData = data;
        }
    }

    @Override
    public boolean canInitPagersPosition() {
        return this.mCanInitPagersPosition;
    }

    @Override
    public void canInitPagersPosition(boolean canInitPagersPosition) {
        this.mCanInitPagersPosition = canInitPagersPosition;
    }

    @Override
    public int getFrom() {
        return this.mPanelFrom;
    }

    @Override
    public IGiftCallback<LoadGiftResult> getLoadGiftCallbak() {
        return this.mLoadGiftCallbak;
    }

    @Override
    public IGiftCallback<List<GiftItemInfo>> getLoadPackageCallback() {
        return this.mLoadPackageCallback;
    }

    @Override
    public IRechargeSuccessListener getPayCallback() {
        return this.mPayCallback;
    }

    private void handleGiftData() {
        this.checkSpecialGifts();
        this.refreshData();
    }

    private void refreshData() {
        if (!FP.empty(this.mGiftList)) {
            FeatureLog.i((String)"FTGiftPanel_GiftPanelPresenter", (String)"handleGiftData, list : %s", (Object[])new Object[]{this.mGiftList.size()});
            boolean hasFamilyTab = this.isHasFamilyTab();
            HashMap<String, List<GiftPanelItemInfo>> giftTypeList = new HashMap<String, List<GiftPanelItemInfo>>();
            this.mActBannerGiftTabMap.clear();
            this.mCacheAllGiftByPropIdMap.clear();
            this.filterSpecialGifts();
            StringBuilder invisibleLog = new StringBuilder("visible false giftid: ");
            for (GiftItemInfo giftInfo : this.mGiftList) {
                IShowGiftInterceptor.Opt result;
                if (giftInfo == null) continue;
                if (giftInfo.isForceHidden()) {
                    FeatureLog.i((String)"FTGiftPanel_GiftPanelPresenter", (String)"handleGiftData, fore hidden , id: %d", (Object[])new Object[]{giftInfo.getPropsId()});
                    continue;
                }
                GiftItemInfo pack = this.mPackMap.get(giftInfo.getPropsId());
                if (pack == null || pack.getCount() <= 0) {
                    giftInfo.setCount(0);
                } else {
                    giftInfo.setCount(pack.getCount());
                    this.addPackageGift(giftTypeList, giftInfo);
                    MLog.info((Object)TAG, (String)"gift pack more then one, giftid: %d, count: %d", (Object[])new Object[]{giftInfo.getPropsId(), pack.getCount()});
                }
                IShowGiftInterceptor.Opt opt = result = this.mInterceptor == null ? IShowGiftInterceptor.Opt.NONE : this.mInterceptor.intercept(giftInfo);
                if (result != IShowGiftInterceptor.Opt.NONE) {
                    MLog.info((Object)TAG, (String)"handle by interceptor with result: %s, giftid: %d", (Object[])new Object[]{result, giftInfo.getPropsId()});
                }
                if ("3".equals(giftInfo.getTabId()) && !hasFamilyTab) continue;
                if (result == IShowGiftInterceptor.Opt.FORCE_SHOW) {
                    this.addGift(giftTypeList, giftInfo);
                    continue;
                }
                if (result == IShowGiftInterceptor.Opt.FORCE_HIDE) continue;
                if (giftInfo.isVisible() || this.arGiftUpgrade(giftInfo)) {
                    this.addGift(giftTypeList, giftInfo);
                    continue;
                }
                invisibleLog.append(giftInfo.getPropsId() + ",");
            }
            MLog.info((Object)TAG, (String)invisibleLog.toString(), (Object[])new Object[0]);
            int index = 0;
            int count = 8;
            ArrayList<GiftPanelItemInfo> singleList = null;
            HashMap<String, List<List<GiftPanelItemInfo>>> giftTabList = new HashMap<String, List<List<GiftPanelItemInfo>>>();
            for (Map.Entry giftList : giftTypeList.entrySet()) {
                if (!giftTabList.containsKey(giftList.getKey())) {
                    giftTabList.put((String)giftList.getKey(), new ArrayList(giftTypeList.size()));
                }
                CopyOnWriteArrayList<GiftPanelItemInfo> giftItemInfos = new CopyOnWriteArrayList<GiftPanelItemInfo>((Collection)giftList.getValue());
                List totalList = (List)giftTabList.get(giftList.getKey());
                if ("0".equals(giftList.getKey())) {
                    this.insertRedPacket(giftItemInfos);
                }
                index = 0;
                for (GiftPanelItemInfo giftInfo : giftItemInfos) {
                    if (index == count) {
                        index = 0;
                    }
                    if (index == 0) {
                        singleList = new ArrayList<GiftPanelItemInfo>(count);
                        totalList.add(singleList);
                    }
                    singleList.add(giftInfo);
                    if (giftInfo.getViewType() == GiftItemViewType.BANNER_ITEM) {
                        index += 3;
                        continue;
                    }
                    ++index;
                }
                if (!LanguageUtils.isRtl() || FP.empty((Collection)totalList)) continue;
                Collections.reverse(totalList);
            }
            if (this.mView != null) {
                this.getSelectPropId(giftTabList);
                this.mCacheAllGiftByTabMap.clear();
                this.mCacheAllGiftByTabMap.putAll(giftTabList);
                if (this.mSelectedGift == null) {
                    MLog.error((Object)TAG, (String)"error ! mSelectedGift is null", (Object[])new Object[0]);
                } else {
                    MLog.info((Object)TAG, (String)"getDefaultGift getPropsId %s getName %s", (Object[])new Object[]{this.mSelectedGift.getPropsId(), this.mSelectedGift.getName()});
                }
                this.mView.updateGiftItems(this.getJumpType());
                this.mView.hideLoading();
            }
        }
    }

    private void checkSpecialGifts() {
        if (!FP.empty(this.mGiftList)) {
            HashSet<Long> idList = new HashSet<Long>();
            Iterator<GiftItemInfo> iterator = this.mGiftList.iterator();
            final ArrayList<GiftItemInfo> infoList = new ArrayList<GiftItemInfo>();
            while (iterator.hasNext()) {
                GiftItemInfo giftInfo = iterator.next();
                if (giftInfo.getType() != 22 || !idList.add(Long.valueOf(giftInfo.getPropsId()))) continue;
                infoList.add(giftInfo);
                this.mGiftList.remove(giftInfo);
            }
            if (!FP.empty(idList)) {
                this.mModel.requestCheckGiftInfo(new ArrayList<Long>(idList), new IGiftCallback<LongSparseArray<CheckGiftInfo>>(){

                    public void onSucceed(LongSparseArray<CheckGiftInfo> result) {
                        HashMap tempMap = new HashMap();
                        tempMap.putAll(GiftPanelPresenter.this.mSpecialGiftList);
                        GiftPanelPresenter.this.mSpecialGiftList = new HashMap();
                        boolean needRefresh = false;
                        for (GiftItemInfo giftItemInfo : infoList) {
                            boolean isSamePosition;
                            CheckGiftInfo checkGiftInfo = (CheckGiftInfo)result.get((long)giftItemInfo.getPropsId());
                            if (checkGiftInfo == null) continue;
                            GiftItemInfo tempGift = (GiftItemInfo)tempMap.get(checkGiftInfo.getPosition() - 1);
                            boolean bl = isSamePosition = tempGift != null && (long)tempGift.getPropsId() == checkGiftInfo.getGiftId();
                            if (!(needRefresh || checkGiftInfo.isVisible() == giftItemInfo.isVisible() && isSamePosition)) {
                                needRefresh = true;
                            }
                            giftItemInfo.setVisible(checkGiftInfo.isVisible());
                            GiftPanelPresenter.this.mSpecialGiftList.put(checkGiftInfo.getPosition() - 1, giftItemInfo);
                        }
                        if (needRefresh) {
                            GiftPanelPresenter.this.refreshData();
                        }
                    }

                    public void onFailed(int code, String msg) {
                    }
                });
            }
        }
    }

    private void filterSpecialGifts() {
        if (!FP.empty(this.mGiftList) && !FP.empty(this.mSpecialGiftList)) {
            this.mGiftList.removeAll(this.mSpecialGiftList.values());
            for (Map.Entry<Integer, GiftItemInfo> entry : this.mSpecialGiftList.entrySet()) {
                if (entry.getKey() >= this.mGiftList.size() || entry.getKey() < 0) continue;
                this.mGiftList.add(entry.getKey(), entry.getValue());
            }
        }
    }

    private boolean isHasFamilyTab() {
        if (System.currentTimeMillis() - this.lastRefreshTime < 30000L) {
            return this.hasFamilyTab;
        }
        this.lastRefreshTime = System.currentTimeMillis();
        if (null == this.mCallback || null == this.mCallback.getMyFamilyInfo() || FP.empty((CharSequence)this.mCallback.getMyFamilyInfo().getFid())) {
            this.hasFamilyTab = false;
        }
        return this.hasFamilyTab;
    }

    private String getJumpType() {
        if (this.mH5SelectPropId > 0 && this.mSelectedGift != null) {
            return this.mSelectedGift.getRealTabId();
        }
        if (this.actTabActionList.size() > 0) {
            for (ActivityAction action : this.actTabActionList) {
                String bannerTab = this.getGiftActTabId(action);
                if (this.mCharStorageFileHelper.isShowed(bannerTab) || !this.mActBannerGiftTabMap.containsKey(bannerTab)) continue;
                return bannerTab;
            }
        }
        return this.mSelectedTab;
    }

    private String getGiftActTabId(ActivityAction activityAction) {
        return "act_tab" + activityAction.id;
    }

    private void getSelectPropId(Map<String, List<List<GiftPanelItemInfo>>> giftTabList) {
        if (this.isDefaultGift) {
            this.mSelectedGift = null;
            this.isDefaultGift = false;
        }
        GiftPanelItemInfo mLastSelectedGift = this.mSelectedGift;
        this.mSelectedGift = null;
        if (this.mH5SelectPropId > 0) {
            if (this.findByIdAndTabId(this.mH5SelectPropId, this.selectPropPacketTab ? "packet" : "0")) {
                return;
            }
            if (this.findByIdAndTabId(this.mH5SelectPropId, this.selectPropPacketTab ? "0" : "packet")) {
                return;
            }
        } else if (mLastSelectedGift != null && this.findByIdAndTabId(mLastSelectedGift.getPropsId(), mLastSelectedGift.getRealTabId())) {
            return;
        }
        if (this.mSelectedGift == null && !this.getDefaultGift(giftTabList, "0")) {
            for (GiftExpandInfo.GiftPanelTabInfo tabInfo : this.getGiftTabList()) {
                if (!this.getDefaultGift(giftTabList, tabInfo.getTabId())) continue;
                return;
            }
            if (this.mSelectedGift == null) {
                this.getDefaultGift(giftTabList, "packet");
            }
        }
    }

    private boolean findByIdAndTabId(int propId, String tabId) {
        List<GiftPanelItemInfo> list = this.mCacheAllGiftByPropIdMap.get(propId);
        if (list == null) {
            return false;
        }
        for (GiftPanelItemInfo giftInfo : list) {
            if (propId != giftInfo.getPropsId() || !tabId.equals(giftInfo.getRealTabId())) continue;
            giftInfo.setSelected(true);
            this.mSelectedGift = giftInfo;
            return true;
        }
        for (GiftExpandInfo.GiftPanelTabInfo tab : this.getGiftTabList()) {
            for (GiftPanelItemInfo giftInfo : list) {
                if (propId != giftInfo.getPropsId() || !giftInfo.getRealTabId().equals(tab.getTabId())) continue;
                giftInfo.setSelected(true);
                this.mSelectedGift = giftInfo;
                return true;
            }
        }
        return false;
    }

    private boolean getDefaultGift(Map<String, List<List<GiftPanelItemInfo>>> giftTabList, String tabId) {
        List<List<GiftPanelItemInfo>> tabsList = giftTabList.get(tabId);
        if (tabsList != null && tabsList.size() > 0) {
            GiftPanelItemInfo defaultGift = tabsList.get(0).get(0);
            defaultGift.setSelected(true);
            this.mSelectedGift = defaultGift;
            this.isDefaultGift = true;
            return true;
        }
        return false;
    }

    public boolean arGiftUpgrade(GiftItemInfo giftInfo) {
        for (ArGiftInfo cache : this.mArGiftInfoList) {
            if (giftInfo.getPropsId() != cache.getPropId()) continue;
            return cache.getStatus() == GiftStatus.OPENED.getValue();
        }
        return false;
    }

    private void addPackageGift(@NonNull Map<String, List<GiftPanelItemInfo>> giftTypeList, GiftItemInfo giftInfo) {
        if (!giftTypeList.containsKey("packet")) {
            ArrayList filterList = new ArrayList();
            giftTypeList.put("packet", filterList);
        }
        this.createGiftPanelItemInfo(giftTypeList, giftInfo, "packet");
    }

    private void addActBannerGift(@NonNull Map<String, List<GiftPanelItemInfo>> giftTypeList, GiftItemInfo giftInfo) {
        for (ActivityAction action : this.actTabActionList) {
            if (!action.giftIds.contains(String.valueOf(giftInfo.getPropsId()))) continue;
            String tabId = this.getGiftActTabId(action);
            if (!giftTypeList.containsKey(tabId)) {
                ArrayList<ActBannerGiftInfo> filterList = new ArrayList<ActBannerGiftInfo>();
                if (!this.mActBannerGiftTabMap.containsKey(tabId)) {
                    filterList.add(new ActBannerGiftInfo(giftInfo, tabId, action.iconUrl, action.linkUrl, action.id));
                    GiftExpandInfo.GiftPanelTabInfo tabInfo = new GiftExpandInfo.GiftPanelTabInfo();
                    tabInfo.setTabId(tabId);
                    tabInfo.setTabName(action.title);
                    this.mActBannerGiftTabMap.put(tabId, tabInfo);
                }
                giftTypeList.put(tabId, filterList);
            }
            this.createGiftPanelItemInfo(giftTypeList, giftInfo, tabId);
        }
    }

    private void addGift(@NonNull Map<String, List<GiftPanelItemInfo>> giftTypeList, GiftItemInfo giftInfo) {
        String tabId = giftInfo.getTabId();
        if (!giftTypeList.containsKey(tabId)) {
            if (!"0".equals(tabId) && this.hasTabTypeConfig(tabId)) {
                ArrayList filterList = new ArrayList();
                giftTypeList.put(tabId, filterList);
            } else {
                if (!giftTypeList.containsKey("0")) {
                    giftTypeList.put("0", new ArrayList());
                }
                tabId = "0";
            }
        }
        this.createGiftPanelItemInfo(giftTypeList, giftInfo, tabId);
        this.addActBannerGift(giftTypeList, giftInfo);
    }

    private void createGiftPanelItemInfo(@NonNull Map<String, List<GiftPanelItemInfo>> giftTypeList, GiftItemInfo giftInfo, String tabId) {
        GiftPanelItemInfo giftPanelItemInfo = new GiftPanelItemInfo(giftInfo, tabId);
        List<GiftPanelItemInfo> propIdList = this.mCacheAllGiftByPropIdMap.get(giftPanelItemInfo.getPropsId());
        if (propIdList == null) {
            propIdList = new ArrayList<GiftPanelItemInfo>();
        }
        propIdList.add(giftPanelItemInfo);
        this.mCacheAllGiftByPropIdMap.put(giftPanelItemInfo.getPropsId(), propIdList);
        if (giftTypeList.get(tabId) != null) {
            giftTypeList.get(tabId).add(giftPanelItemInfo);
        }
    }

    @Override
    public boolean hasTabTypeConfig(String tabId) {
        List<GiftExpandInfo.GiftPanelTabInfo> mTabList = this.getGiftTabList();
        for (GiftExpandInfo.GiftPanelTabInfo tabInfo : mTabList) {
            if (!tabId.equals(tabInfo.getTabId())) continue;
            return true;
        }
        return false;
    }

    private void insertRedPacket(List<GiftPanelItemInfo> list) {
        RedPacketEntranceReqParam param;
        RedPacketEntrance entrance;
        IRedPacketHandler handler;
        if (list == null) {
            list = new ArrayList<GiftPanelItemInfo>();
        }
        if ((handler = ((IRedPacketService)ServiceManagerProxy.getServiceManager().getService(IRedPacketService.class)).getHandler(this.mRoomId)) != null && this.mRoomTag != null && (entrance = handler.getRedPacketEntrance(param = new RedPacketEntranceReqParam(this.mRoomTag.getRoomTag(), this.mCurGameId))) != null && entrance.isShow()) {
            JSONObject jsonObject = JsonParser.obtainJSONObject();
            try {
                jsonObject.put(BACKGROUND_RES_ID, R.drawable.selector_item_red_gift_bg);
            }
            catch (JSONException e) {
                MLog.error((Object)TAG, (Throwable)e);
                e.printStackTrace();
            }
            GiftItemInfo giftItemInfo = new GiftItemInfo();
            giftItemInfo.setType(1000);
            giftItemInfo.setStaticIcon(entrance.getIconUrl());
            giftItemInfo.setVisible(true);
            giftItemInfo.setExpand(jsonObject);
            giftItemInfo.setName(ResourceUtils.getString((int)R.string.short_tips_lucky_pocket));
            if (list.size() == 0 || entrance.getPosModel() == 0) {
                list.add(new GiftPanelItemInfo(giftItemInfo, "0"));
            } else if (list.size() - 1 <= entrance.getPos()) {
                list.add(new GiftPanelItemInfo(giftItemInfo, "0"));
            } else {
                list.add(entrance.getPos(), new GiftPanelItemInfo(giftItemInfo, "0"));
            }
        }
    }

    @Override
    public void setSelectedGift(GiftPanelItemInfo gift) {
        this.mH5SelectPropId = 0;
        this.selectPropPacketTab = false;
        this.isDefaultGift = false;
        this.mSelectedGift = gift;
        if (this.mView != null) {
            this.mView.updateGiftAmountList(gift);
        }
        FeatureLog.i((String)"FTGiftPanel_GiftPanelPresenter", (String)"setSelectedGift : %s", (Object[])new Object[]{gift.getPropsId()});
    }

    @Override
    public void onGiftClick(GiftPanelItemInfo gift) {
        if (gift != null) {
            GiftHiidoReport.giftClick(this.getRoomId(), String.valueOf(gift.getPropsId()));
        }
    }

    @Override
    public void updateSelect() {
        if (this.getSelectedGift() != null) {
            this.mGiftReceiverHeaderManager.updateSelect(this.getSelectedGift().getGiftInfo());
        }
    }

    @Override
    public void notifyCurrentTab(String jumpTabType) {
        this.mCharStorageFileHelper.addNewId(jumpTabType);
        if (StringUtils.equal((String)jumpTabType, (String)this.mSelectedTab)) {
            this.mSelectedTab = "";
        }
    }

    @Override
    public boolean isFirstBannerShow(String tabId) {
        if (this.mGiftReportHelper.isShowed(tabId)) {
            return false;
        }
        this.mGiftReportHelper.addNewId(tabId);
        return true;
    }

    @Override
    public void sendGifts(int number) {
        this.mSelectedGiftNum = number;
        GiftHiidoReport.reportAfClickGift();
        if (!NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext)) {
            ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)ResourceUtils.getString((int)R.string.check_network_and_retry), (int)0);
        } else if (this.mCallback != null) {
            FeatureLog.i((String)"FTGiftPanel_GiftPanelPresenter", (String)"sendGifts,  mSelectedGift : %s,number :%s", (Object[])new Object[]{this.mSelectedGift, number});
            if (this.mSelectedGift == null) {
                ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)ResourceUtils.getString((int)R.string.tips_no_select_gift), (int)0);
                return;
            }
            if (this.mGiftReceiverHeaderManager.getSelectedReceiver().size() <= 0) {
                ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)ResourceUtils.getString((int)R.string.tips_error_send_gift_reciver_empty), (int)0);
                return;
            }
            if (this.mGiftReceiverHeaderManager.getSeatHeaderList().size() <= 0 || this.mGiftReceiverHeaderManager.getSeatHeaderList().get(0) == null) {
                ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)ResourceUtils.getString((int)R.string.tips_no_user_on_seat), (int)0);
                return;
            }
            if (!this.configSwitch()) {
                FeatureLog.i((String)"FTGiftPanel_GiftPanelPresenter", (String)"sendGifts can not send to self", (Object[])new Object[0]);
                ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)ResourceUtils.getString((int)R.string.tips_gift_banned_send), (int)0);
                return;
            }
            if (this.mSelectedGift.getType() == 21 || this.mSelectedGift.getType() == 20) {
                this.mSelectedGift.setShowCombo(false);
            }
            if (this.mSelectedGift.getType() == 13) {
                this.showGreetingCardEditDialog();
            } else {
                this.onPacketNumToast(number);
                this.mCallback.sendGift(this.mGiftReceiverHeaderManager.getSelectedReceiver(), this.mPanelFrom, this.mSelectedGift.getGiftInfo(), number, null);
            }
        }
    }

    private void onPacketNumToast(int number) {
        if (this.mSelectedGift != null && this.mSelectedGift.getCount() > 0 && !this.mSelectedGift.getRealTabId().equals("packet")) {
            ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)ResourceUtils.getString((int)R.string.tips_packet_gift), (int)0);
        }
    }

    private boolean configSwitch() {
        AConfigData config;
        return this.mRoomMode != 14 || !((config = UnifyConfig.INSTANCE.getConfigData(BssCode.PROFILE_CARD_GIFT_ENTRY_SWITCH)) instanceof ProfileCardGiftEntryConfig) || !((ProfileCardGiftEntryConfig)config).isClose(AccountUtil.realCountry()) || !this.isSendToSelf();
    }

    private boolean isSendToSelf() {
        for (GiftUserInfo giftUserInfo : this.mGiftReceiverHeaderManager.getSelectedReceiver()) {
            if (giftUserInfo.uid() != AccountUtil.getUid()) continue;
            return true;
        }
        return false;
    }

    private void showGreetingCardEditDialog() {
        if (null != this.mView) {
            if (null == this.mGreetingCardEditDialog) {
                this.mGreetingCardEditDialog = new GreetingCardEditDialog(this.mView.getDialogContext(), this.mSelectedGift.getGiftInfo(), (dialog2, info) -> this.mCallback.sendGift(this.mGiftReceiverHeaderManager.getSelectedReceiver(), this.mPanelFrom, this.mSelectedGift.getGiftInfo(), this.mSelectedGiftNum, info, new IGiftCallback<SendGiftRes>(){

                    public void onSucceed(SendGiftRes result) {
                        dialog2.dismiss();
                    }

                    public void onFailed(int code, String msg) {
                        if (code != 20978) {
                            dialog2.dismiss();
                        }
                    }
                }));
            }
            this.mGreetingCardEditDialog.show();
            this.mView.hide();
        }
    }

    @Override
    public void onPanelHidden() {
        this.mGiftReceiverHeaderManager.hideGiftPanel();
        if (this.mCallback != null) {
            this.mCallback.onPanelHidden();
        }
        this.mConsumeGuideData = null;
    }

    @Override
    public void onPanelShown(boolean showAction) {
        if (this.mCallback != null) {
            this.mCallback.onGiftPanelShown(showAction);
            if (this.mConsumeGuideData != null && this.mView != null) {
                this.mView.showConsumeGuide(this.mConsumeGuideData);
            }
        }
    }

    @Override
    public List<GiftUserInfo> getSelectedReceiver() {
        return this.mGiftReceiverHeaderManager.getSelectedReceiver();
    }

    @Override
    public GiftPanelItemInfo getSelectedGift() {
        return this.mSelectedGift;
    }

    @Override
    public GiftPanelItemInfo getH5SelectedGift() {
        if (this.mH5SelectPropId > 0 && this.mSelectedGift != null && this.mSelectedGift.getPropsId() == this.mH5SelectPropId) {
            return this.mSelectedGift;
        }
        return null;
    }

    @Override
    public IGiftPanelOperator getOperator() {
        return this;
    }

    @Override
    public void notifyReceivedGift(GiftOperationNotifyResult result) {
        if (result != null && result.getReceivedNotify() != null) {
            FreeGiftConversionNotify notify = result.getReceivedNotify();
            for (GiftItemInfo info : this.mGiftList) {
                PropOneLimit limit;
                if (info == null || (long)info.getPropsId() != notify.prop_id) continue;
                if (notify.conversion_count > 0) {
                    GiftItemInfo giftInfo = this.mPackMap.get(info.getPropsId());
                    if (giftInfo == null) {
                        info.setCount(notify.conversion_count.intValue());
                        this.mPackMap.put(info.getPropsId(), info);
                        continue;
                    }
                    giftInfo.setCount(giftInfo.getCount() + notify.conversion_count);
                    continue;
                }
                if (!notify.reach_limit.booleanValue() || (limit = this.mCallback.getGiftLimit(info.getPropsId())) == null) continue;
                GiftItemInfo pack = this.mPackMap.get(info.getPropsId());
                if (pack == null) {
                    info.setCount(limit.max_cnt_limit.intValue());
                    this.mPackMap.put(info.getPropsId(), info);
                    continue;
                }
                pack.setCount(limit.max_cnt_limit.intValue());
            }
            this.mCanInitPagersPosition = false;
            this.handleGiftData();
        }
    }

    @Override
    public void onConsumeGift(GiftItemInfo giftInfo, int gitNumber) {
        GiftItemInfo pack;
        if (giftInfo != null && gitNumber > 0 && (pack = this.mPackMap.get(giftInfo.getPropsId())) != null) {
            if (gitNumber <= pack.getCount()) {
                pack.setCount(pack.getCount() - gitNumber);
            } else {
                pack.setCount(0);
            }
        }
    }

    @Override
    public void showGiftPanel(ShowGiftPanelParam param, String gid) {
        FeatureLog.i((String)"FTGiftPanel_GiftPanelPresenter", (String)"showGiftPanel, param : %s", (Object[])new Object[]{param});
        if (this.mView == null) {
            return;
        }
        if (param == null) {
            return;
        }
        this.mCurGameId = gid;
        this.mSelectedTab = param.getGiftTab();
        this.refreshArGiftCache();
        if (this.mView.isShowWithAnim() || this.mView.isAnimating()) {
            FeatureLog.i((String)"FTGiftPanel_GiftPanelPresenter", (String)"showGiftPanel, isGiftPanelShow = %s, isAnimating = %s", (Object[])new Object[]{this.mView.isShowWithAnim(), this.mView.isAnimating()});
            if (param.getPropId() > 0) {
                this.mSelectedGift = null;
                this.mH5SelectPropId = param.getPropId();
                this.selectPropPacketTab = param.isSelectPropPacketTab();
                this.getSelectPropId(this.mCacheAllGiftByTabMap);
                this.mView.refreshPropId(this.getJumpType());
            }
            return;
        }
        this.mGiftReceiverHeaderManager.showGiftPanel(param, gid);
        this.mView.showLoading();
        if (param.getPropId() > 0) {
            this.mH5SelectPropId = param.getPropId();
            this.selectPropPacketTab = param.isSelectPropPacketTab();
            this.mSelectedGift = null;
        }
        this.mView.show(gid, this.mRoomId, param.getPropId(), param.isSelectPropPacketTab());
        if (!param.isShowHeadList()) {
            this.mGiftReceiverHeaderManager.hideReceiverList();
        }
        this.mGiftPanelActManager.onShow();
    }

    private void refreshArGiftCache() {
        if (this.isVideo()) {
            this.mModel.reqUpgradeArGiftList(this.arGiftCallback);
        } else {
            this.mArGiftInfoList.clear();
        }
    }

    @Override
    public boolean isVideo() {
        return this.mRoomSubMode == 2;
    }

    @Override
    public void hideGiftPanel() {
        FeatureLog.i((String)"FTGiftPanel_GiftPanelPresenter", (String)"hideGiftPanel", (Object[])new Object[0]);
        this.mGiftReceiverHeaderManager.hideGiftPanel();
        if (this.mView == null) {
            return;
        }
        if (!this.mView.isShowWithAnim() || this.mView.isAnimating()) {
            FeatureLog.i((String)"FTGiftPanel_GiftPanelPresenter", (String)"hideGiftPanel, isGiftPanelShow = %s, isAnimating = %s", (Object[])new Object[]{this.mView.isShowWithAnim(), this.mView.isAnimating()});
            return;
        }
        this.mH5SelectPropId = 0;
        this.selectPropPacketTab = false;
        this.mView.hide();
    }

    @Override
    public String getTittle(String type) {
        for (GiftExpandInfo.GiftPanelTabInfo tabInfo : this.getGiftTabList()) {
            if (tabInfo == null || tabInfo.getTabId() == null || !tabInfo.getTabId().equals(type)) continue;
            return tabInfo.getTabName();
        }
        if ("packet".equals(type)) {
            return "";
        }
        return ResourceUtils.getString((int)R.string.tips_gift_panel_default_tab);
    }

    @Override
    public IGiftPanelActManager getGiftPanelActManager() {
        return this.mGiftPanelActManager;
    }

    @Override
    public void destroy() {
        FeatureLog.i((String)"FTGiftPanel_GiftPanelPresenter", (String)"destroy isAnimating %b, isShowWithAnim %b", (Object[])new Object[]{this.mView.isAnimating(), this.mView.isShowWithAnim()});
        ((IPayService)ServiceManagerProxy.getServiceManager().getService(IPayService.class)).removePayListener(this.mPayCallback);
        ((IActivityService)ServiceManagerProxy.getServiceManager().getService(IActivityService.class)).removeOnActivityUpdateListener(this.mOnActivityUpdateListener);
        this.mSelectedGift = null;
        this.mGiftReceiverHeaderManager.destroy();
        if (null != this.mGreetingCardEditDialog && this.mGreetingCardEditDialog.isShowing()) {
            this.mGreetingCardEditDialog.dismiss();
        }
        if (this.mView != null) {
            this.mView.hide();
        }
        this.mGiftPanelActManager.onDestroy();
    }

    public void start() {
        YYTaskExecutor.execute(() -> {
            try {
                ((IPayLevelService)ServiceManagerProxy.getServiceManager().getService(IPayLevelService.class)).updateRechargeUrl(RechargeScene.RechargeSceneGiftPanel);
            }
            catch (Exception e) {
                MLog.error((Object)TAG, (Throwable)e);
            }
        });
        this.getBalance();
        this.fetchActivity();
        this.fetchActivityBannerInfo();
        this.fetchTabActivity();
        this.fetchDialogActivity();
        if (this.mCallback != null) {
            List<GiftItemInfo> packageList;
            List<GiftItemInfo> giftList = this.mCallback.getAllGift();
            if (giftList != null) {
                this.mGiftList = new CopyOnWriteArrayList<GiftItemInfo>(this.mCallback.getAllGift());
            }
            if ((packageList = this.mCallback.getPackageList(AccountUtil.getUid())) != null) {
                this.convertPackListToMap(packageList);
            }
            this.handleGiftData();
        }
        if (this.mView != null) {
            this.mView.updateGiftAmount("1");
        }
    }

    private void getBalance() {
        ((IPayService)ServiceManagerProxy.getServiceManager().getService(IPayService.class)).queryBalance(3, (IPayCallback)new IPayCallback<BalanceResponse>(){

            public void onSucceed(@Nullable BalanceResponse response) {
                if (response != null) {
                    FeatureLog.i((String)"FTGiftPanel_GiftPanelPresenter", (String)"getBalance, onSucceed data : %s", (Object[])new Object[]{response.accountList});
                    if (GiftPanelPresenter.this.mView != null) {
                        GiftPanelPresenter.this.mView.updateBalance("0");
                    }
                    if (!FP.empty((Collection)response.accountList)) {
                        for (BalanceInfo info : response.accountList) {
                            if (GiftPanelPresenter.this.mView == null || info == null || info.currencyType != 1805) continue;
                            GiftPanelPresenter.this.mView.updateBalance(GiftPanelPresenter.this.transformNumFormat(info.amount));
                        }
                    }
                }
            }

            public void onFailed(int code, String msg) {
                FeatureLog.i((String)"FTGiftPanel_GiftPanelPresenter", (String)"getBalance, onFailed code = %s, msg = %s", (Object[])new Object[]{code, msg});
            }
        });
    }

    private String transformNumFormat(Long num) {
        String lang = SystemUtils.getLang();
        if (!StringUtils.equalsIgnoreCase((String)lang, (String)this.mLang)) {
            this.df = null;
        }
        this.mLang = lang;
        if (this.df == null) {
            this.df = new DecimalFormat("###,###", new DecimalFormatSymbols(new Locale(this.mLang)));
        }
        return this.df.format(num) == null ? "0" : this.df.format(num);
    }

    private void hideLoading() {
        if (this.mView != null) {
            this.mView.hideLoading();
        }
    }

    private void convertPackListToMap(List<GiftItemInfo> packList) {
        if (!FP.empty(packList)) {
            this.mPackMap.clear();
            for (GiftItemInfo giftInfo : packList) {
                if (giftInfo == null) continue;
                this.mPackMap.put(giftInfo.getPropsId(), giftInfo);
            }
        } else {
            this.mPackMap.clear();
        }
    }

    private void fetchActivity() {
        if (!FP.empty((CharSequence)this.mRoomId) && this.mRoomTag != null) {
            ((IActivityService)ServiceManagerProxy.getServiceManager().getService(IActivityService.class)).fetchGiftActivities(this.mRoomId, this.mRoomTag, this::updateActivityEntry);
        }
    }

    private void fetchDialogActivity() {
        if (!FP.empty((CharSequence)this.mRoomId) && this.mRoomTag != null) {
            ((IActivityService)ServiceManagerProxy.getServiceManager().getService(IActivityService.class)).fetchActivityBannerInfo(this.mRoomId, this.mRoomTag, 18, this::updateGifDialogEntry);
        }
    }

    private void fetchTabActivity() {
        if (!FP.empty((CharSequence)this.mRoomId) && this.mRoomTag != null) {
            ((IActivityService)ServiceManagerProxy.getServiceManager().getService(IActivityService.class)).fetchActivityBannerInfo(this.mRoomId, this.mRoomTag, 20, this::updateGifTabEntry);
        }
    }

    private void fetchActivityBannerInfo() {
        if (!FP.empty((CharSequence)this.mRoomId) && this.mRoomTag != null) {
            ((IActivityService)ServiceManagerProxy.getServiceManager().getService(IActivityService.class)).fetchActivityBannerInfo(this.mRoomId, this.mRoomTag, 4, this::updateGifAboveActivityEntry);
        }
    }

    private void updateActivityEntry(GiftPanelAction data) {
        MLog.info((Object)TAG, (String)"updateActivityEntry roomId %s, roomTag: %s, action %s, view %s", (Object[])new Object[]{this.mRoomId, this.mRoomTag, data, this.mView});
        if (this.mView != null) {
            this.mView.setActivityEntryData(data, this.mRoomId);
        }
    }

    private void updateGifTabEntry(ActivityActionList activityActionList) {
        MLog.info((Object)TAG, (String)"updateGifTabEntry roomId %s, roomTag: %s, action %s, view %s", (Object[])new Object[]{this.mRoomId, this.mRoomTag, activityActionList, this.mView});
        this.actTabActionList.clear();
        if (activityActionList != null && activityActionList.list != null && activityActionList.list.size() > 0) {
            this.actTabActionList.addAll(activityActionList.list);
        }
    }

    private void updateGifDialogEntry(ActivityActionList activityActionList) {
        MLog.info((Object)TAG, (String)"updateGifDialogEntry roomId %s, roomTag: %s, action %s, view %s", (Object[])new Object[]{this.mRoomId, this.mRoomTag, activityActionList, this.mView});
        this.giftDialogAction = activityActionList != null && activityActionList.list != null && activityActionList.list.size() > 0 ? (ActivityAction)activityActionList.list.get(0) : null;
    }

    private void updateGifAboveActivityEntry(ActivityActionList activityActionList) {
        MLog.info((Object)TAG, (String)"updateGifAboveActivityEntry roomId %s, roomTag: %s, action %s, view %s", (Object[])new Object[]{this.mRoomId, this.mRoomTag, activityActionList, this.mView});
        if (activityActionList == null || FP.empty((Collection)activityActionList.list)) {
            return;
        }
        if (this.mView != null) {
            this.mView.setGifAboveActivityData(activityActionList.list, this.mRoomId);
        }
    }

    public void setRoomInfo(GiftHandlerParam mHandlerParam) {
        this.mRoomId = mHandlerParam.getRoomId();
        this.mRoomTag = mHandlerParam.getRoomTag();
        this.mRoomMode = mHandlerParam.getBehavior().getMode();
        this.mRoomSubMode = mHandlerParam.getBehavior().getSubMode();
        this.mRoomAnchorUid = mHandlerParam.getAnchorUid();
        this.mGiftPanelActManager.setRoomInfo(this.mRoomId, this.mRoomMode, mHandlerParam.getChannelId(), this.mRoomTag);
        MLog.info((Object)TAG, (String)"setRoomInfo roomId %s, roomTag %s", (Object[])new Object[]{this.mRoomId, this.mRoomMode});
        if (this.mOnActivityUpdateListener == null) {
            this.mOnActivityUpdateListener = new IActivityService.OnActivityUpdateListener(){

                public void onGiftActivityUpdate(List<ActivityActionWrapper<GiftPanelAction>> data) {
                    ActivityActionWrapper item = ((IActivityService)ServiceManagerProxy.getServiceManager().getService(IActivityService.class)).find(data, GiftPanelPresenter.this.mRoomId, GiftPanelPresenter.this.mRoomTag);
                    MLog.info((Object)GiftPanelPresenter.TAG, (String)"onGiftActivityUpdate list size %d, item %s", (Object[])new Object[]{FP.size(data), item});
                    GiftPanelPresenter.this.updateActivityEntry(item != null ? (GiftPanelAction)item.action : null);
                }
            };
        }
        ((IActivityService)ServiceManagerProxy.getServiceManager().getService(IActivityService.class)).addOnActivityUpdateListener(this.mOnActivityUpdateListener);
    }

    @Override
    public String getRoomId() {
        return this.mRoomId;
    }

    @Override
    public int getRoomMode() {
        return this.mRoomMode;
    }

    @Override
    public ActivityTagInfo getRoomTag() {
        return this.mRoomTag;
    }

    @Override
    public void openRecharge() {
        MLog.info((Object)TAG, (String)"openRecharge", (Object[])new Object[0]);
        Message msg = Message.obtain();
        Bundle bundle = new Bundle();
        bundle.putString("gid", this.mCurGameId);
        bundle.putString("roomId", this.getRoomId());
        bundle.putInt("fromType", 3);
        bundle.putInt("recharge_dialog_act_type", 2);
        if (this.giftDialogAction != null && !this.giftDialogAction.isH5BigPage) {
            bundle.putSerializable("activity_action", (Serializable)this.giftDialogAction);
            if (this.giftDialogAction.actExtraInfos != null && this.giftDialogAction.actExtraInfos.containsKey("selectTab")) {
                String index = (String)this.giftDialogAction.actExtraInfos.get("selectTab");
                FeatureLog.i((String)"FTGiftPanel_GiftPanelPresenter", (String)"index=%s", (Object[])new Object[]{index});
                if ("1".equals(index)) {
                    bundle.putBoolean("is_select_activity", true);
                } else {
                    bundle.putBoolean("is_select_activity", false);
                }
            }
        }
        msg.setData(bundle);
        msg.what = AppbaseMsgDef.SHOW_RECHARGE_DIALOG;
        MsgDispatcher.getInstance().sendMessage(msg);
        ((IMoneyReportService)ServiceManagerProxy.getInstance().getService(IMoneyReportService.class)).openViewEventReport(ViewType.TYPE_DIAMOND_RECHARGE, "", "", this.mRoomId);
    }

    public void setPanelFromType(int mPanelFrom) {
        this.mPanelFrom = mPanelFrom;
    }

    public void onVideoModeChanged(String channelId, boolean isVideoMode) {
        MLog.info((Object)TAG, (String)"onVideoModeChanged isVideoMode = %s", (Object[])new Object[]{isVideoMode});
        if (this.mView == null) {
            return;
        }
    }
}

