/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.gift.ui.mood;

import android.content.Context;
import android.os.SystemClock;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import com.yy.appbase.degrade.DiscardResult;
import com.yy.appbase.degrade.ISceneDegradedService;
import com.yy.appbase.degrade.ISceneOptLimiter;
import com.yy.appbase.degrade.ISceneOptLimiterCallback;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ResolutionUtils;
import com.yy.hiyo.wallet.base.revenue.gift.GiftUtils;
import com.yy.hiyo.wallet.base.revenue.gift.bean.GiftBroResult;
import com.yy.hiyo.wallet.base.revenue.gift.bean.GiftBroadcastInfo;
import com.yy.hiyo.wallet.base.revenue.gift.bean.GiftComboInfo;
import com.yy.hiyo.wallet.base.revenue.gift.bean.GiftItemInfo;
import com.yy.hiyo.wallet.base.revenue.gift.event.IGiftBehavior;
import com.yy.hiyo.wallet.gift.effect.IEffectPresenter;
import com.yy.hiyo.wallet.gift.ui.mood.IMoodEffectView;
import com.yy.hiyo.wallet.gift.ui.mood.MoodEffectInfo;
import com.yy.hiyo.wallet.gift.ui.mood.MoodEffectViewConfig;
import com.yy.hiyo.wallet.gift.ui.mood.MoodEffectViewContainer;
import com.yy.hiyo.wallet.gift.ui.mood.MoodEffectViewInfo;
import java.util.Collection;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.PriorityBlockingQueue;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001cH\u0016J\u0010\u0010 \u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001cH\u0002J\b\u0010!\u001a\u00020\u001eH\u0016J\b\u0010\"\u001a\u00020\u0014H\u0002J\b\u0010#\u001a\u00020\u001eH\u0002J\u0018\u0010$\u001a\u00020\u001e2\u0006\u0010%\u001a\u00020\u00122\u0006\u0010&\u001a\u00020\rH\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/yy/hiyo/wallet/gift/ui/mood/MoodEffectPresenter;", "Lcom/yy/hiyo/wallet/gift/effect/IEffectPresenter;", "Lcom/yy/hiyo/wallet/gift/ui/mood/IMoodEffectView;", "rootView", "Landroid/view/ViewGroup;", "behavior", "Lcom/yy/hiyo/wallet/base/revenue/gift/event/IGiftBehavior;", "roomId", "", "(Landroid/view/ViewGroup;Lcom/yy/hiyo/wallet/base/revenue/gift/event/IGiftBehavior;Ljava/lang/String;)V", "INTERVAL", "", "canAnimate", "", "checkTask", "Ljava/lang/Runnable;", "configList", "", "Lcom/yy/hiyo/wallet/gift/ui/mood/MoodEffectViewInfo;", "container", "Lcom/yy/hiyo/wallet/gift/ui/mood/MoodEffectViewContainer;", "effectQueue", "Ljava/util/Queue;", "Lcom/yy/hiyo/wallet/gift/ui/mood/MoodEffectInfo;", "isGapTime", "lastShowTime", "mSceneOptLimiter", "Lcom/yy/appbase/degrade/ISceneOptLimiter;", "Lcom/yy/hiyo/wallet/base/revenue/gift/bean/GiftBroResult;", "addGiftEffect", "", "result", "appendEffect", "destroy", "getContainer", "next", "onPlayFinish", "info", "isFail", "wallet_billDebug"})
public final class MoodEffectPresenter
implements IEffectPresenter,
IMoodEffectView {
    private final Queue<MoodEffectInfo> effectQueue;
    private final List<MoodEffectViewInfo> configList;
    private long lastShowTime;
    private final long INTERVAL = 66L;
    private boolean isGapTime;
    private final Runnable checkTask;
    private MoodEffectViewContainer container;
    private boolean canAnimate;
    private final ISceneOptLimiter<GiftBroResult> mSceneOptLimiter;
    private final ViewGroup rootView;
    private final IGiftBehavior behavior;
    private final String roomId;

    @Override
    public void addGiftEffect(@NotNull GiftBroResult result) {
        Intrinsics.checkParameterIsNotNull((Object)result, (String)"result");
        if (result.getGiftInfo() == null) {
            MLog.error((Object)"FTGiftMood", (String)"addGiftEffect result.giftInfo is null", (Object[])new Object[0]);
            return;
        }
        this.mSceneOptLimiter.addItem((Object)result, this.effectQueue.size());
    }

    /*
     * WARNING - void declaration
     */
    private final void appendEffect(GiftBroResult result) {
        long l;
        Object[] objectArray = new Object[3];
        GiftBroadcastInfo giftBroadcastInfo = result.getGiftBroInfo();
        Intrinsics.checkExpressionValueIsNotNull((Object)giftBroadcastInfo, (String)"result.giftBroInfo");
        objectArray[0] = giftBroadcastInfo.getPropsId();
        GiftBroadcastInfo giftBroadcastInfo2 = result.getGiftBroInfo();
        Intrinsics.checkExpressionValueIsNotNull((Object)giftBroadcastInfo2, (String)"result.giftBroInfo");
        objectArray[1] = giftBroadcastInfo2.getRevUserInfos().size();
        GiftBroadcastInfo giftBroadcastInfo3 = result.getGiftBroInfo();
        Intrinsics.checkExpressionValueIsNotNull((Object)giftBroadcastInfo3, (String)"result.giftBroInfo");
        objectArray[2] = giftBroadcastInfo3.getPropsCount();
        MLog.debug((Object)"FTGiftMood", (String)"addGiftEffect id: %d, revUserInfos: %d, propsCount: %d", (Object[])objectArray);
        GiftBroadcastInfo giftBroadcastInfo4 = result.getGiftBroInfo();
        Intrinsics.checkExpressionValueIsNotNull((Object)giftBroadcastInfo4, (String)"result.giftBroInfo");
        int n = giftBroadcastInfo4.getRevUserInfos().size();
        GiftBroadcastInfo giftBroadcastInfo5 = result.getGiftBroInfo();
        Intrinsics.checkExpressionValueIsNotNull((Object)giftBroadcastInfo5, (String)"result.giftBroInfo");
        int count = n * giftBroadcastInfo5.getPropsCount();
        GiftComboInfo giftComboInfo = result.getGiftComboInfo();
        if (giftComboInfo != null) {
            l = giftComboInfo.getUseTimeMs();
        } else {
            GiftBroadcastInfo giftBroadcastInfo6 = result.getGiftBroInfo();
            Intrinsics.checkExpressionValueIsNotNull((Object)giftBroadcastInfo6, (String)"result.giftBroInfo");
            l = giftBroadcastInfo6.getUsedTime();
        }
        long sendTime = l;
        int n2 = 1;
        int n3 = count;
        if (n2 <= n3) {
            while (true) {
                void i;
                GiftBroadcastInfo giftBroadcastInfo7 = result.getGiftBroInfo();
                Intrinsics.checkExpressionValueIsNotNull((Object)giftBroadcastInfo7, (String)"result.giftBroInfo");
                int n4 = giftBroadcastInfo7.getAppId();
                GiftItemInfo giftItemInfo = result.getGiftInfo();
                if (giftItemInfo == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)giftItemInfo, (String)"result.giftInfo!!");
                String string2 = giftItemInfo.getMoodSvga();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"result.giftInfo!!.moodSvga");
                this.effectQueue.add(new MoodEffectInfo(result, sendTime, n4, string2));
                this.next();
                if (i == n3) break;
                ++i;
            }
        }
    }

    @Override
    public void destroy() {
        YYTaskExecutor.removeTask((Runnable)this.checkTask);
        this.effectQueue.clear();
        this.mSceneOptLimiter.destroy();
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(this){
            final /* synthetic */ MoodEffectPresenter this$0;

            public final void run() {
                block5: {
                    MoodEffectViewContainer moodEffectViewContainer = MoodEffectPresenter.access$getContainer$p(this.this$0);
                    if (moodEffectViewContainer != null) {
                        View $this$removeSelfFromParent$iv = (View)moodEffectViewContainer;
                        boolean $i$f$removeSelfFromParent = false;
                        if ($this$removeSelfFromParent$iv.getParent() != null && $this$removeSelfFromParent$iv.getParent() instanceof ViewGroup) {
                            try {
                                ViewParent viewParent = $this$removeSelfFromParent$iv.getParent();
                                if (viewParent == null) {
                                    throw new TypeCastException("null cannot be cast to non-null type android.view.ViewGroup");
                                }
                                ((ViewGroup)viewParent).removeView($this$removeSelfFromParent$iv);
                            }
                            catch (Exception e$iv) {
                                MLog.error((Object)"removeSelfFromParent", (Throwable)e$iv);
                                if (!RuntimeContext.isLocalBuild()) break block5;
                                throw (Throwable)e$iv;
                            }
                        }
                    }
                }
                MoodEffectPresenter.access$setContainer$p(this.this$0, null);
            }
            {
                this.this$0 = moodEffectPresenter;
            }
        });
    }

    private final void next() {
        if (!this.canAnimate) {
            MLog.info((Object)"FTGiftMood", (String)"next canAnimate: %b, size: %d", (Object[])new Object[]{this.canAnimate, this.effectQueue.size()});
        }
        if (this.effectQueue.isEmpty()) {
            MoodEffectViewContainer moodEffectViewContainer = this.container;
            if (moodEffectViewContainer != null) {
                MoodEffectViewContainer moodEffectViewContainer2 = moodEffectViewContainer;
                boolean bl = false;
                boolean bl2 = false;
                MoodEffectViewContainer it = moodEffectViewContainer2;
                boolean bl3 = false;
                moodEffectViewContainer = it.getChildCount() <= 0 ? moodEffectViewContainer2 : null;
                if (moodEffectViewContainer != null) {
                    block15: {
                        moodEffectViewContainer2 = moodEffectViewContainer;
                        bl = false;
                        bl2 = false;
                        it = moodEffectViewContainer2;
                        boolean bl4 = false;
                        View $this$removeSelfFromParent$iv = (View)it;
                        boolean $i$f$removeSelfFromParent = false;
                        if ($this$removeSelfFromParent$iv.getParent() != null && $this$removeSelfFromParent$iv.getParent() instanceof ViewGroup) {
                            try {
                                ViewParent viewParent = $this$removeSelfFromParent$iv.getParent();
                                if (viewParent == null) {
                                    throw new TypeCastException("null cannot be cast to non-null type android.view.ViewGroup");
                                }
                                ((ViewGroup)viewParent).removeView($this$removeSelfFromParent$iv);
                            }
                            catch (Exception e$iv) {
                                MLog.error((Object)"removeSelfFromParent", (Throwable)e$iv);
                                if (!RuntimeContext.isLocalBuild()) break block15;
                                throw (Throwable)e$iv;
                            }
                        }
                    }
                    this.container = null;
                }
            }
            return;
        }
        if (this.isGapTime) {
            return;
        }
        long cur = SystemClock.elapsedRealtime();
        long gap = cur - this.lastShowTime;
        if (gap > this.INTERVAL) {
            MoodEffectViewInfo next;
            Object v2;
            boolean bl;
            Object object;
            block16: {
                object = this.configList;
                bl = false;
                Iterable iterable = object;
                boolean bl5 = false;
                for (Object t : iterable) {
                    MoodEffectViewInfo it = (MoodEffectViewInfo)t;
                    boolean bl6 = false;
                    if (!it.isValid()) continue;
                    v2 = t;
                    break block16;
                }
                v2 = null;
            }
            MoodEffectViewInfo moodEffectViewInfo = next = (MoodEffectViewInfo)v2;
            if (moodEffectViewInfo != null) {
                object = moodEffectViewInfo;
                bl = false;
                boolean bl7 = false;
                Object it = object;
                boolean bl8 = false;
                MoodEffectInfo info = this.effectQueue.poll();
                MLog.debug((Object)"FTGiftMood", (String)"show info: %s", (Object[])new Object[]{it});
                if (info != null) {
                    ((MoodEffectViewInfo)it).setSvgaUrl(info.getSvgaUrl());
                    ((MoodEffectViewInfo)it).setShowTime(cur);
                    ((MoodEffectViewInfo)it).setIdle(false);
                    this.getContainer().addEffectView((MoodEffectViewInfo)it, this);
                    this.lastShowTime = cur;
                    if (!this.effectQueue.isEmpty()) {
                        YYTaskExecutor.removeTask((Runnable)this.checkTask);
                        YYTaskExecutor.postToMainThread((Runnable)this.checkTask, (long)this.INTERVAL);
                    }
                }
            }
        } else {
            this.isGapTime = true;
            YYTaskExecutor.removeTask((Runnable)this.checkTask);
            YYTaskExecutor.postToMainThread((Runnable)this.checkTask, (long)(this.INTERVAL - gap));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final MoodEffectViewContainer getContainer() {
        if (this.container == null) {
            void $this$dp$iv;
            Context context = this.rootView.getContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"rootView.context");
            this.container = new MoodEffectViewContainer(context, null, 0, 6, null);
            int n = 200;
            int n2 = ResolutionUtils.getScreenWidth();
            boolean $i$f$getDp = false;
            int n3 = ResolutionUtils.dip2Px((float)((float)$this$dp$iv));
            int width = n2 + n3;
            ViewGroup.LayoutParams lp = new ViewGroup.LayoutParams(width, -1);
            this.rootView.addView((View)this.container, lp);
        }
        MoodEffectViewContainer moodEffectViewContainer = this.container;
        if (moodEffectViewContainer == null) {
            Intrinsics.throwNpe();
        }
        return moodEffectViewContainer;
    }

    @Override
    public void onPlayFinish(@NotNull MoodEffectViewInfo info, boolean isFail) {
        Intrinsics.checkParameterIsNotNull((Object)info, (String)"info");
        MLog.debug((Object)"FTGiftMood", (String)"onPlayFinish info: %s", (Object[])new Object[]{info});
        info.setIdle(true);
        this.next();
    }

    public MoodEffectPresenter(@NotNull ViewGroup rootView2, @NotNull IGiftBehavior behavior, @NotNull String roomId) {
        Intrinsics.checkParameterIsNotNull((Object)rootView2, (String)"rootView");
        Intrinsics.checkParameterIsNotNull((Object)behavior, (String)"behavior");
        Intrinsics.checkParameterIsNotNull((Object)roomId, (String)"roomId");
        this.rootView = rootView2;
        this.behavior = behavior;
        this.roomId = roomId;
        this.effectQueue = new PriorityBlockingQueue();
        this.configList = CollectionsKt.mutableListOf((Object[])new MoodEffectViewInfo[]{new MoodEffectViewInfo(new MoodEffectViewConfig(1, 0, 1.0f, 84, 547, false)), new MoodEffectViewInfo(new MoodEffectViewConfig(2, 30, 0.85f, 58, 511, false)), new MoodEffectViewInfo(new MoodEffectViewConfig(3, -30, 0.7f, 187, 612, true)), new MoodEffectViewInfo(new MoodEffectViewConfig(4, -10, 0.85f, 108, 512, true)), new MoodEffectViewInfo(new MoodEffectViewConfig(5, 16, 0.7f, 81, 479, false)), new MoodEffectViewInfo(new MoodEffectViewConfig(6, -17, 0.85f, 138, 469, true)), new MoodEffectViewInfo(new MoodEffectViewConfig(7, 25, 1.0f, 10, 446, false)), new MoodEffectViewInfo(new MoodEffectViewConfig(8, -25, 1.0f, 163, 532, true)), new MoodEffectViewInfo(new MoodEffectViewConfig(9, 30, 0.7f, 2, 428, false)), new MoodEffectViewInfo(new MoodEffectViewConfig(10, -40, 0.7f, 236, 523, true))});
        this.INTERVAL = 66L;
        this.checkTask = new Runnable(this){
            final /* synthetic */ MoodEffectPresenter this$0;

            public final void run() {
                MoodEffectPresenter.access$setGapTime$p(this.this$0, false);
                MoodEffectPresenter.access$next(this.this$0);
            }
            {
                this.this$0 = moodEffectPresenter;
            }
        };
        this.canAnimate = true;
        this.mSceneOptLimiter = ((ISceneDegradedService)ServiceManagerProxy.getService(ISceneDegradedService.class)).createLimiter("gift_mood", (ISceneOptLimiterCallback)new ISceneOptLimiterCallback<GiftBroResult>(this){
            final /* synthetic */ MoodEffectPresenter this$0;

            @Nullable
            public List<GiftBroResult> needDiscardWhenOnDiscard(@NotNull List<? extends GiftBroResult> items, float discardRatio, int discardMinRemain, int maxRemain) {
                Intrinsics.checkParameterIsNotNull(items, (String)"items");
                return GiftUtils.discardStrategy((Collection)items, (float)discardRatio, (int)discardMinRemain, (int)maxRemain);
            }

            @NotNull
            public DiscardResult onDiscard(@NotNull GiftBroResult item, float discardRatio, int discardMinRemain, int maxRemain) {
                Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
                List list = GiftUtils.discardStrategy((Collection)MoodEffectPresenter.access$getEffectQueue$p(this.this$0), (float)discardRatio, (int)discardMinRemain, (int)maxRemain);
                if (list == null) {
                    return DiscardResult.NONE;
                }
                List remove = list;
                for (MoodEffectInfo result : remove) {
                    MoodEffectPresenter.access$getEffectQueue$p(this.this$0).remove(result);
                }
                return DiscardResult.DISCARD_ADD_NEW;
            }

            public boolean isDisCardOldDataFrequency() {
                return false;
            }

            public boolean needSkip(@NotNull GiftBroResult item) {
                Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
                return item.isMySendOrReceive();
            }

            public void onAppendItem(@NotNull GiftBroResult item) {
                Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
                MoodEffectPresenter.access$appendEffect(this.this$0, item);
            }

            public void onRecoverAnimate() {
                MoodEffectPresenter.access$setCanAnimate$p(this.this$0, true);
                MoodEffectPresenter.access$next(this.this$0);
            }

            public void onStopAnimate() {
                MoodEffectPresenter.access$setCanAnimate$p(this.this$0, false);
            }
            {
                this.this$0 = $outer;
            }
        });
    }

    public static final /* synthetic */ MoodEffectViewContainer access$getContainer$p(MoodEffectPresenter $this) {
        return $this.container;
    }

    public static final /* synthetic */ void access$setContainer$p(MoodEffectPresenter $this, MoodEffectViewContainer moodEffectViewContainer) {
        $this.container = moodEffectViewContainer;
    }

    public static final /* synthetic */ boolean access$isGapTime$p(MoodEffectPresenter $this) {
        return $this.isGapTime;
    }

    public static final /* synthetic */ void access$setGapTime$p(MoodEffectPresenter $this, boolean bl) {
        $this.isGapTime = bl;
    }

    public static final /* synthetic */ void access$next(MoodEffectPresenter $this) {
        $this.next();
    }

    public static final /* synthetic */ Queue access$getEffectQueue$p(MoodEffectPresenter $this) {
        return $this.effectQueue;
    }

    public static final /* synthetic */ void access$appendEffect(MoodEffectPresenter $this, GiftBroResult result) {
        $this.appendEffect(result);
    }

    public static final /* synthetic */ boolean access$getCanAnimate$p(MoodEffectPresenter $this) {
        return $this.canAnimate;
    }

    public static final /* synthetic */ void access$setCanAnimate$p(MoodEffectPresenter $this, boolean bl) {
        $this.canAnimate = bl;
    }
}

