/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.gift.ui.freegift;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.widget.ImageView;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.LanguageUtils;
import com.yy.base.utils.ResolutionUtils;
import com.yy.hiyo.wallet.R;
import com.yy.hiyo.wallet.base.revenue.gift.bean.ActivityPropertyInfo;
import com.yy.hiyo.wallet.base.revenue.gift.bean.GiftItemInfo;
import com.yy.hiyo.wallet.base.revenue.gift.param.GiftAnimDesParam;
import com.yy.hiyo.wallet.gift.ui.freegift.FloatingPropertyContract;
import java.util.Random;

public class FloatingView
extends YYFrameLayout
implements FloatingPropertyContract.View,
View.OnClickListener {
    public static final String TAG = "FreeGiftView";
    protected Random mRandom;
    protected FloatingItem mFloatingItem;
    protected ViewGroup mLayer;
    protected AnimatorSet mCollectAnimSet;
    protected ObjectAnimator mFloatAnimator;
    private FloatingPropertyContract.Presenter mPresenter;
    protected ViewGroup.LayoutParams mLayoutParams;
    private RecycleImageView mRivGiftIcon;
    protected int mWidth;
    protected int mHeight;
    private int mDesX;
    private int mDesY;
    protected int mRangeX;
    protected int mRangeY;
    protected int mScreenWidth;
    protected int mScreenHeight;
    protected volatile boolean mClicked;

    public FloatingView(Context context, FloatingPropertyContract.Presenter presenter, GiftAnimDesParam param) {
        super(context);
        View view = LayoutInflater.from((Context)context).inflate(R.layout.layout_free_gift, (ViewGroup)this, true);
        this.mRivGiftIcon = (RecycleImageView)view.findViewById(R.id.riv_icon_free_gift);
        this.mRandom = new Random();
        this.mWidth = ResolutionUtils.dip2Px((float)61.0f);
        this.mHeight = ResolutionUtils.dip2Px((float)61.0f);
        this.mScreenWidth = ResolutionUtils.getScreenWidth((Context)context);
        this.mScreenHeight = ResolutionUtils.getScreenHeight((Context)context);
        this.mLayoutParams = new ViewGroup.LayoutParams(this.mWidth, this.mHeight);
        if (param != null) {
            this.mDesX = param.getmDesX() + param.getmDesWidth() / 2 - this.mWidth / 2;
            this.mDesY = param.getmDesY() + param.getmDesHeight() / 2 - this.mHeight / 2;
        } else {
            MLog.info((Object)TAG, (String)"GiftAnimDesParam = null", (Object[])new Object[0]);
        }
        this.setOnClickListener(this::onClick);
        this.setPresenter(presenter);
    }

    @Override
    public void setGiftInfo(Object itemInfo) {
        if (this.mFloatingItem != null) {
            this.mFloatingItem.setInfo(itemInfo);
        } else {
            this.mFloatingItem = new FloatingItem(itemInfo);
        }
        if (this.mFloatingItem.getType() == 1) {
            GiftItemInfo giftItemInfo = (GiftItemInfo)this.mFloatingItem.getInfo();
            ImageLoader.loadImage((ImageView)this.mRivGiftIcon, (String)giftItemInfo.getStaticIcon(), (int)R.drawable.icon_gift_default);
        } else if (this.mFloatingItem.getType() == 2) {
            ActivityPropertyInfo propertyInfo = (ActivityPropertyInfo)this.mFloatingItem.getInfo();
            ImageLoader.loadImage((ImageView)this.mRivGiftIcon, (String)propertyInfo.getPicUrl(), (int)R.drawable.icon_gift_default);
        }
    }

    @Override
    public void enterAnim(ViewGroup layer) {
        this.setEnabled(true);
        this.mLayer = layer;
        long delay = this.mRandom.nextInt(5001);
        if (this.getParent() != null) {
            MLog.info((Object)"FreeGiftPresenter", (String)"removed from parent : %s", (Object[])new Object[]{this.hashCode()});
            ((ViewGroup)this.getParent()).removeView((View)this);
        }
        this.mLayer.addView((View)this, this.mLayoutParams);
        this.mRangeX = this.mRandom.nextInt(this.mScreenWidth - this.mWidth);
        if (LanguageUtils.isRtl()) {
            this.mRangeX = -this.mRangeX;
        }
        this.mRangeY = this.mScreenHeight - this.mHeight;
        MLog.info((Object)"enterAnim", (String)"mRangeY = %s", (Object[])new Object[]{this.mRangeY});
        this.setTranslationX(this.mRangeX);
        if (this.mFloatAnimator == null) {
            this.mFloatAnimator = ObjectAnimator.ofFloat((Object)this, (String)"translationY", (float[])new float[]{0.0f, this.mRangeY});
        }
        this.mFloatAnimator.removeAllListeners();
        this.mFloatAnimator.setStartDelay(delay);
        this.mFloatAnimator.setDuration(8000L);
        this.setVisibility(8);
        this.mFloatAnimator.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
                MLog.info((Object)"FreeGiftPresenter", (String)"start float animation : %s", (Object[])new Object[]{FloatingView.this.hashCode()});
                FloatingView.this.setVisibility(0);
            }

            public void onAnimationEnd(Animator animation) {
                MLog.info((Object)"FreeGiftPresenter", (String)"float animation end: %s", (Object[])new Object[]{FloatingView.this.hashCode()});
                if (FloatingView.this.mClicked) {
                    if (FloatingView.this.mFloatingItem.getType() == 2) {
                        FloatingView.this.reset();
                    }
                } else if (FloatingView.this.getParent() != null) {
                    FloatingView.this.reset();
                }
            }

            public void onAnimationCancel(Animator animation) {
                MLog.info((Object)"FreeGiftPresenter", (String)"float animation cancel: %s", (Object[])new Object[]{FloatingView.this.hashCode()});
                if (FloatingView.this.mClicked && FloatingView.this.mFloatingItem.getType() == 2) {
                    FloatingView.this.reset();
                }
            }

            public void onAnimationRepeat(Animator animation) {
            }
        });
        this.mFloatAnimator.start();
    }

    private void initCollectAnim() {
        int[] location = new int[2];
        this.getLocationInWindow(location);
        float currentY = this.getTranslationY();
        double timePerPixel = 1500 / (this.mScreenHeight / 2);
        this.mCollectAnimSet = new AnimatorSet();
        long duration = (long)(timePerPixel * (double)((float)this.mScreenHeight - currentY));
        AnimatorSet transAndScale = new AnimatorSet();
        transAndScale.setDuration(duration);
        transAndScale.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
        float desTransX = this.mDesX - location[0] + this.mRangeX;
        float desTransY = (float)(this.mDesY - location[1]) + currentY;
        ObjectAnimator xAnim = ObjectAnimator.ofFloat((Object)this, (String)"translationX", (float[])new float[]{desTransX});
        ObjectAnimator yAnim = ObjectAnimator.ofFloat((Object)this, (String)"translationY", (float[])new float[]{desTransY});
        ObjectAnimator scaleXForTrans = ObjectAnimator.ofFloat((Object)this, (String)"scaleX", (float[])new float[]{1.0f, 0.3f});
        ObjectAnimator scaleYForTrans = ObjectAnimator.ofFloat((Object)this, (String)"scaleY", (float[])new float[]{1.0f, 0.3f});
        transAndScale.play((Animator)xAnim).with((Animator)yAnim).with((Animator)scaleXForTrans).with((Animator)scaleYForTrans);
        AnimatorSet scaleSet = new AnimatorSet();
        scaleSet.setDuration(200L);
        ObjectAnimator scaleXAnim = ObjectAnimator.ofFloat((Object)this, (String)"scaleX", (float[])new float[]{0.3f, 0.0f});
        ObjectAnimator scaleYAnim = ObjectAnimator.ofFloat((Object)this, (String)"scaleY", (float[])new float[]{0.3f, 0.0f});
        scaleSet.play((Animator)scaleXAnim).with((Animator)scaleYAnim);
        this.mCollectAnimSet.play((Animator)scaleSet).after((Animator)transAndScale);
        this.mCollectAnimSet.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
                MLog.info((Object)"FreeGiftPresenter", (String)"start click animation : %s", (Object[])new Object[]{FloatingView.this.hashCode()});
            }

            public void onAnimationEnd(Animator animation) {
                MLog.info((Object)"FreeGiftPresenter", (String)"click animation end: %s", (Object[])new Object[]{FloatingView.this.hashCode()});
                FloatingView.this.reset();
            }

            public void onAnimationCancel(Animator animation) {
                MLog.info((Object)"FreeGiftPresenter", (String)"click animation cancel: %s", (Object[])new Object[]{FloatingView.this.hashCode()});
                FloatingView.this.reset();
            }

            public void onAnimationRepeat(Animator animation) {
            }
        });
    }

    private void onFloatingStopNextRunnable() {
        if (this.mFloatAnimator != null) {
            this.mFloatAnimator.cancel();
            this.mFloatAnimator.removeAllListeners();
        }
    }

    private void onFloatingStop() {
        YYTaskExecutor.postToMainThread(this::onFloatingStopNextRunnable);
    }

    protected void reset() {
        this.mLayer.removeView((View)this);
        this.mPresenter.onViewRemoved(this);
        this.onFloatingStopNextRunnable();
        this.mClicked = false;
        this.setScaleX(1.0f);
        this.setScaleY(1.0f);
        MLog.info((Object)"FreeGiftPresenter", (String)"onFloatingStop: %s", (Object[])new Object[]{this.hashCode()});
    }

    public void setPresenter(FloatingPropertyContract.Presenter presenter) {
        this.mPresenter = presenter;
    }

    public void onClick(View v) {
        this.mClicked = true;
        this.onFloatingStop();
        if (this.mFloatingItem.getType() == 1) {
            this.initCollectAnim();
            this.mCollectAnimSet.start();
        }
        this.mPresenter.onItemClick(this, this.mFloatingItem);
        this.setEnabled(false);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mClicked = false;
        this.onFloatingStop();
    }

    public static class FloatingItem {
        private int type;
        private Object info;

        public FloatingItem(Object info) {
            this.setInfo(info);
        }

        public void setInfo(Object info) {
            if (info instanceof GiftItemInfo) {
                this.type = 1;
                this.info = info;
            } else if (info instanceof ActivityPropertyInfo) {
                this.type = 2;
                this.info = info;
            }
        }

        public int getType() {
            return this.type;
        }

        public Object getInfo() {
            return this.info;
        }
    }

    static interface Type {
        public static final int UNKNOW = 0;
        public static final int GIFT = 1;
        public static final int ACTIVITY_PROPERTY = 2;
    }
}

