/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.gift.ui.flymic;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.content.Context;
import android.graphics.Point;
import android.text.SpannableStringBuilder;
import android.util.Property;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import com.yy.appbase.DpToPxDef;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYConstraintLayout;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.LanguageUtils;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.YYImageUtils;
import com.yy.hiyo.wallet.R;
import com.yy.hiyo.wallet.gift.ui.flymic.GiftFlyMicCallBack;
import com.yy.hiyo.wallet.gift.ui.flymic.GiftFlyMicPresent;

public class FlyMicView
extends YYConstraintLayout {
    private static final String TAG = "FlyMicView";
    private final int giftWidth;
    private int sendUserX;
    private int screenWidth;
    private int screenHeight;
    private GiftFlyMicCallBack mUICallBack;
    private int sendUserY;
    private int receiveUserX;
    private int receiveUserY;
    private int mGiftType;
    private float mDesScale;
    private float mDesTranslationY;
    private RecycleImageView flyImg;
    private YYTextView tvCombo;
    private int animType = 0;

    public int getAnimType() {
        return this.animType;
    }

    public FlyMicView(Context context, GiftFlyMicPresent giftFlyMicPresent, Point sendPoint, Point recvPoint, int animType) {
        super(context);
        LayoutInflater.from((Context)context).inflate(R.layout.layout_fly_mic_view, (ViewGroup)this);
        this.flyImg = (RecycleImageView)this.findViewById(R.id.fly_img);
        this.tvCombo = (YYTextView)this.findViewById(R.id.tv_combo);
        this.mUICallBack = giftFlyMicPresent;
        this.animType = animType;
        this.screenHeight = ResolutionUtils.getScreenHeight((Context)context);
        this.screenWidth = ResolutionUtils.getScreenWidth((Context)context);
        if (sendPoint != null && recvPoint != null) {
            this.receiveUserX = recvPoint.x;
            this.receiveUserY = recvPoint.y;
            this.sendUserX = sendPoint.x;
            this.sendUserY = sendPoint.y;
        }
        this.giftWidth = animType == 0 ? DpToPxDef.RESOLUTION_80_DP : DpToPxDef.RESOLUTION_50_DP;
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(this.giftWidth, this.giftWidth);
        this.setLayoutParams((ViewGroup.LayoutParams)params);
        FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)this.getLayoutParams();
        layoutParams.setMarginStart(this.sendUserX - this.giftWidth / 2);
        layoutParams.topMargin = this.sendUserY - this.giftWidth / 2;
        this.setVisibility(8);
    }

    public void setGiftType(int type) {
        this.mGiftType = type;
    }

    public void enterAnim() {
        AnimatorSet animatorSet = this.animType == 0 ? this.getEnterAnim() : this.getNewEnterAnim();
        animatorSet.start();
        this.setAlpha(1.0f);
    }

    private AnimatorSet getNewEnterAnim() {
        AnimatorSet enterAnimSet = new AnimatorSet();
        this.mDesTranslationY = -DpToPxDef.RESOLUTION_70_DP;
        if (this.animType == 3) {
            this.mDesTranslationY = (this.screenHeight >> 1) - this.sendUserY - this.giftWidth;
        }
        ObjectAnimator scaleAfterTrans = ObjectAnimator.ofPropertyValuesHolder((Object)((Object)this), (PropertyValuesHolder[])new PropertyValuesHolder[]{PropertyValuesHolder.ofFloat((Property)View.SCALE_X, (float[])new float[]{1.0f, 0.88f}), PropertyValuesHolder.ofFloat((Property)View.SCALE_Y, (float[])new float[]{1.0f, 0.88f})});
        ObjectAnimator scaleBeforeTrans = ObjectAnimator.ofPropertyValuesHolder((Object)((Object)this), (PropertyValuesHolder[])new PropertyValuesHolder[]{PropertyValuesHolder.ofFloat((Property)View.SCALE_X, (float[])new float[]{2.0f, 1.3f, 2.0f}), PropertyValuesHolder.ofFloat((Property)View.SCALE_Y, (float[])new float[]{2.0f, 1.3f, 2.0f})});
        int mTranslationX = this.screenWidth / 2 - this.sendUserX;
        if (LanguageUtils.isRtl()) {
            mTranslationX = -mTranslationX;
        }
        ObjectAnimator enterAnim2 = ObjectAnimator.ofPropertyValuesHolder((Object)((Object)this), (PropertyValuesHolder[])new PropertyValuesHolder[]{PropertyValuesHolder.ofFloat((Property)View.TRANSLATION_X, (float[])new float[]{0.0f, mTranslationX}), PropertyValuesHolder.ofFloat((Property)View.TRANSLATION_Y, (float[])new float[]{0.0f, this.mDesTranslationY}), PropertyValuesHolder.ofFloat((Property)View.SCALE_X, (float[])new float[]{0.88f, 2.0f}), PropertyValuesHolder.ofFloat((Property)View.SCALE_Y, (float[])new float[]{0.88f, 2.0f})});
        scaleAfterTrans.setDuration(100L);
        enterAnim2.setDuration(700L);
        scaleBeforeTrans.setDuration(367L);
        if (this.animType == 1 || this.animType == 3) {
            enterAnimSet.play((Animator)enterAnim2).after((Animator)scaleAfterTrans).before((Animator)scaleBeforeTrans);
        } else {
            enterAnimSet.play((Animator)enterAnim2).after((Animator)scaleAfterTrans);
        }
        AnimatorSet exitAnimSet = new AnimatorSet();
        int mTransX = this.receiveUserX - this.sendUserX;
        if (LanguageUtils.isRtl()) {
            mTransX = -mTransX;
        }
        ObjectAnimator exitAnim = ObjectAnimator.ofPropertyValuesHolder((Object)((Object)this), (PropertyValuesHolder[])new PropertyValuesHolder[]{PropertyValuesHolder.ofFloat((Property)View.TRANSLATION_X, (float[])new float[]{mTransX}), PropertyValuesHolder.ofFloat((Property)View.TRANSLATION_Y, (float[])new float[]{this.receiveUserY - this.sendUserY}), PropertyValuesHolder.ofFloat((Property)View.SCALE_X, (float[])new float[]{2.0f, 1.0f}), PropertyValuesHolder.ofFloat((Property)View.SCALE_Y, (float[])new float[]{2.0f, 1.0f})});
        ObjectAnimator exitScaleBefore = ObjectAnimator.ofPropertyValuesHolder((Object)((Object)this), (PropertyValuesHolder[])new PropertyValuesHolder[]{PropertyValuesHolder.ofFloat((Property)View.SCALE_X, (float[])new float[]{1.0f, 0.9f, 1.15f, 0.5f}), PropertyValuesHolder.ofFloat((Property)View.SCALE_Y, (float[])new float[]{1.0f, 0.9f, 1.15f, 0.5f})});
        ObjectAnimator alphaExitBefore = ObjectAnimator.ofPropertyValuesHolder((Object)((Object)this), (PropertyValuesHolder[])new PropertyValuesHolder[]{PropertyValuesHolder.ofFloat((Property)View.ALPHA, (float[])new float[]{1.0f, 0.0f})});
        exitScaleBefore.setDuration(600L);
        exitAnim.setDuration(566L);
        alphaExitBefore.setDuration(100L);
        alphaExitBefore.setStartDelay(500L);
        exitAnimSet.play((Animator)exitScaleBefore).after((Animator)exitAnim).with((Animator)alphaExitBefore);
        AnimatorSet flyAnim = new AnimatorSet();
        flyAnim.setStartDelay(433L);
        flyAnim.play((Animator)enterAnimSet).before((Animator)exitAnimSet);
        enterAnimSet.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                super.onAnimationStart(animation);
                FlyMicView.this.setVisibility(0);
            }
        });
        flyAnim.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                FlyMicView.this.mUICallBack.removeFlyMicAnim(FlyMicView.this);
                MLog.info((Object)FlyMicView.TAG, (String)"", (Object[])new Object[0]);
            }
        });
        return flyAnim;
    }

    private AnimatorSet getEnterAnim() {
        AnimatorSet animatorSet = new AnimatorSet();
        this.mDesTranslationY = this.mGiftType == 1 ? (float)((this.screenHeight >> 1) - this.sendUserY - this.giftWidth) * 0.7f : (float)((this.screenHeight >> 1) - this.sendUserY - this.giftWidth);
        int mTranslationX = this.screenWidth / 2 - this.sendUserX;
        if (LanguageUtils.isRtl()) {
            mTranslationX = -(this.screenWidth / 2 - this.sendUserX);
        }
        PropertyValuesHolder valuesHolderEnterX = PropertyValuesHolder.ofFloat((Property)View.TRANSLATION_X, (float[])new float[]{0.0f, mTranslationX});
        PropertyValuesHolder valuesHolderEnterY = PropertyValuesHolder.ofFloat((Property)View.TRANSLATION_Y, (float[])new float[]{0.0f, this.mDesTranslationY});
        ObjectAnimator enterAnim2 = ObjectAnimator.ofPropertyValuesHolder((Object)((Object)this), (PropertyValuesHolder[])new PropertyValuesHolder[]{valuesHolderEnterX, valuesHolderEnterY});
        PropertyValuesHolder scaleAfterTransEnterX = PropertyValuesHolder.ofFloat((Property)View.SCALE_X, (float[])new float[]{0.0f, 0.5f, 0.18f});
        PropertyValuesHolder scaleAfterTransEnterY = PropertyValuesHolder.ofFloat((Property)View.SCALE_Y, (float[])new float[]{0.0f, 0.5f, 0.18f});
        ObjectAnimator scaleAfterTrans = ObjectAnimator.ofPropertyValuesHolder((Object)((Object)this), (PropertyValuesHolder[])new PropertyValuesHolder[]{scaleAfterTransEnterX, scaleAfterTransEnterY});
        this.mDesScale = this.mGiftType == 1 ? 0.56f : 0.8f;
        PropertyValuesHolder scaleWithTransEnterX = PropertyValuesHolder.ofFloat((Property)View.SCALE_X, (float[])new float[]{0.18f, this.mDesScale});
        PropertyValuesHolder scaleWithTransEnterY = PropertyValuesHolder.ofFloat((Property)View.SCALE_Y, (float[])new float[]{0.18f, this.mDesScale});
        ObjectAnimator scaleWithTrans = ObjectAnimator.ofPropertyValuesHolder((Object)((Object)this), (PropertyValuesHolder[])new PropertyValuesHolder[]{scaleWithTransEnterX, scaleWithTransEnterY});
        scaleAfterTrans.setDuration(500L);
        enterAnim2.setDuration(800L);
        scaleWithTrans.setDuration(800L);
        animatorSet.play((Animator)enterAnim2).after((Animator)scaleAfterTrans).with((Animator)scaleWithTrans);
        this.setVisibility(0);
        animatorSet.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        FlyMicView.this.exitAnim();
                    }
                }, (long)128L);
            }
        });
        return animatorSet;
    }

    private void exitAnim() {
        AnimatorSet animatorSet = new AnimatorSet();
        int mTranslationX = this.receiveUserX - this.sendUserX;
        if (LanguageUtils.isRtl()) {
            mTranslationX = -mTranslationX;
        }
        PropertyValuesHolder valuesHolderExitX = PropertyValuesHolder.ofFloat((Property)View.TRANSLATION_X, (float[])new float[]{mTranslationX});
        PropertyValuesHolder valuesHolderExitY = PropertyValuesHolder.ofFloat((Property)View.TRANSLATION_Y, (float[])new float[]{this.receiveUserY - this.sendUserY});
        ObjectAnimator exitAnim = ObjectAnimator.ofPropertyValuesHolder((Object)((Object)this), (PropertyValuesHolder[])new PropertyValuesHolder[]{valuesHolderExitX, valuesHolderExitY});
        PropertyValuesHolder scaleWithTransX = PropertyValuesHolder.ofFloat((Property)View.SCALE_X, (float[])new float[]{this.mDesScale, 0.24f});
        PropertyValuesHolder scaleWithTransY = PropertyValuesHolder.ofFloat((Property)View.SCALE_Y, (float[])new float[]{this.mDesScale, 0.24f});
        ObjectAnimator exitScaleWithTrans = ObjectAnimator.ofPropertyValuesHolder((Object)((Object)this), (PropertyValuesHolder[])new PropertyValuesHolder[]{scaleWithTransX, scaleWithTransY});
        PropertyValuesHolder scaleBeforeX = PropertyValuesHolder.ofFloat((Property)View.SCALE_X, (float[])new float[]{0.24f, 0.5f, 0.0f});
        PropertyValuesHolder scaleBeforeY = PropertyValuesHolder.ofFloat((Property)View.SCALE_Y, (float[])new float[]{0.24f, 0.5f, 0.0f});
        ObjectAnimator scaleBeforeTrans = ObjectAnimator.ofPropertyValuesHolder((Object)((Object)this), (PropertyValuesHolder[])new PropertyValuesHolder[]{scaleBeforeX, scaleBeforeY});
        scaleBeforeTrans.setDuration(500L);
        exitAnim.setDuration(800L);
        exitScaleWithTrans.setDuration(800L);
        animatorSet.play((Animator)exitAnim).with((Animator)exitScaleWithTrans).before((Animator)scaleBeforeTrans);
        animatorSet.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                FlyMicView.this.mUICallBack.removeFlyMicAnim(FlyMicView.this);
            }
        });
        animatorSet.start();
    }

    public void loadImg(String giftIcon) {
        ImageLoader.loadImage((ImageView)this.flyImg, (String)(giftIcon + YYImageUtils.getThumbSmall()));
    }

    public void setComboNum(SpannableStringBuilder giftNumSpannable) {
        this.tvCombo.setVisibility(0);
        this.tvCombo.setText((CharSequence)giftNumSpannable);
    }
}

