/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.gift.ui.flash;

import android.content.Context;
import android.graphics.Point;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yy.appbase.degrade.DiscardResult;
import com.yy.appbase.degrade.ISceneDegradedService;
import com.yy.appbase.degrade.ISceneOptLimiter;
import com.yy.appbase.degrade.ISceneOptLimiterCallback;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.unifyconfig.config.SceneOptConfigItem;
import com.yy.base.env.RuntimeContext;
import com.yy.base.event.kvo.Kvo;
import com.yy.base.event.kvo.KvoEventIntent;
import com.yy.base.event.kvo.KvoMethodAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.logger.MLog;
import com.yy.base.utils.ResolutionUtils;
import com.yy.hiyo.wallet.base.revenue.gift.GiftUtils;
import com.yy.hiyo.wallet.base.revenue.gift.IGiftHandler;
import com.yy.hiyo.wallet.base.revenue.gift.bean.GiftBroResult;
import com.yy.hiyo.wallet.base.revenue.gift.bean.GiftComboInfo;
import com.yy.hiyo.wallet.base.revenue.gift.bean.GiftItemInfo;
import com.yy.hiyo.wallet.base.revenue.gift.param.GiftFlashLocation;
import com.yy.hiyo.wallet.base.revenue.gift.param.GiftHandlerParam;
import com.yy.hiyo.wallet.gift.effect.IEffectPresenter;
import com.yy.hiyo.wallet.gift.handler.IGiftHandlerCallback;
import com.yy.hiyo.wallet.gift.ui.flash.GiftAnimatorPresent;
import com.yy.hiyo.wallet.gift.ui.flash.GiftFlashAnimHelper;
import com.yy.hiyo.wallet.gift.ui.flash.IFlashPresenterCallback;
import java.util.Collection;
import java.util.List;
import java.util.Queue;
import java.util.Random;
import java.util.concurrent.PriorityBlockingQueue;
import org.jetbrains.annotations.NotNull;

public class GiftFlashPresenter
implements IEffectPresenter,
IFlashPresenterCallback {
    private static final String TAG = "GiftFlashPresenter";
    private final int maxMarginTop;
    private int mFlashGap;
    private int mFlashLeftMargin;
    private final Queue<GiftBroResult> mSelfSendGiftQueue = new PriorityBlockingQueue<GiftBroResult>();
    private final Queue<GiftBroResult> mGiftQueue = new PriorityBlockingQueue<GiftBroResult>();
    private GiftFlashLocation mFlashLocation;
    private GiftAnimatorPresent mGiftAnimator1;
    private GiftAnimatorPresent mGiftAnimator2;
    private GiftAnimatorPresent mComboModeAnimator = null;
    private Random mRandom;
    private final int maxMarginBottom;
    private final int screenHeight;
    private int enterType = 0;
    private IGiftHandler mGiftHandler;
    private GiftHandlerParam mGiftHandlerParam;
    private IGiftHandlerCallback mHandlerCallback;
    private GiftFlashAnimHelper mGiftFlashAnimHelper;
    private boolean canAnimate = true;
    private ISceneOptLimiter<GiftBroResult> mSceneOptLimiter;

    @NotNull
    private ISceneOptLimiter<GiftBroResult> getLimiter() {
        if (this.mSceneOptLimiter != null) {
            return this.mSceneOptLimiter;
        }
        this.mSceneOptLimiter = ((ISceneDegradedService)ServiceManagerProxy.getService(ISceneDegradedService.class)).createLimiter("gift_flash", (ISceneOptLimiterCallback)new ISceneOptLimiterCallback<GiftBroResult>(){

            public void onRecoverAnimate() {
                GiftFlashPresenter.this.canAnimate = true;
                GiftFlashPresenter.this.next();
            }

            public void onStopAnimate() {
                GiftFlashPresenter.this.canAnimate = false;
            }

            @Nullable
            public List<GiftBroResult> needDiscardWhenOnDiscard(@NotNull List<? extends GiftBroResult> items, float discardRatio, int discardMinRemain, int maxRemain) {
                return GiftUtils.discardStrategy(items, (float)discardRatio, (int)discardMinRemain, (int)maxRemain);
            }

            @NotNull
            public DiscardResult onDiscard(GiftBroResult item, float discardRatio, int discardMinRemain, int maxRemain) {
                List remove = GiftUtils.discardStrategy((Collection)GiftFlashPresenter.this.mGiftQueue, (float)discardRatio, (int)discardMinRemain, (int)maxRemain);
                if (remove == null) {
                    return DiscardResult.NONE;
                }
                GiftFlashPresenter.this.mGiftQueue.removeAll(remove);
                return DiscardResult.DISCARD_ADD_NEW;
            }

            public boolean isDisCardOldDataFrequency() {
                return false;
            }

            public boolean needSkip(GiftBroResult item) {
                return item.isMySendOrReceive();
            }

            public void onAppendItem(GiftBroResult item) {
                GiftFlashPresenter.this.appendGiftEffect(item);
            }
        });
        return this.mSceneOptLimiter;
    }

    public GiftFlashPresenter(ViewGroup rootView2, GiftHandlerParam param, IGiftHandler giftHandler, IGiftHandlerCallback handlerCallback) {
        this.mGiftHandlerParam = param;
        this.mFlashLocation = param.getFlashLocation();
        this.enterType = this.mFlashLocation.getEnterType();
        this.mGiftHandler = giftHandler;
        this.mHandlerCallback = handlerCallback;
        this.mFlashGap = ResolutionUtils.dip2Px((float)60.0f);
        this.screenHeight = ResolutionUtils.getScreenHeight((Context)rootView2.getContext());
        this.maxMarginBottom = ResolutionUtils.dip2Px((float)140.0f);
        int top = this.mFlashLocation.getMarginTop();
        this.maxMarginTop = this.screenHeight - this.maxMarginBottom - this.mFlashGap;
        int topMargin = this.topMargin(top);
        this.mGiftAnimator1 = new GiftAnimatorPresent(rootView2, this.leftMargin(this.mFlashLocation), this.getTop(topMargin, true), this, true);
        this.mGiftAnimator2 = new GiftAnimatorPresent(rootView2, this.leftMargin(this.mFlashLocation), this.getTop(topMargin, false), this, false);
        Kvo.autoBindingTo((KvoSource)this.mFlashLocation, (Object)this);
    }

    private int getTop(int topMargin, boolean firstFlash) {
        if (this.enterType == 0) {
            return firstFlash ? topMargin : topMargin - this.mFlashGap;
        }
        if (this.enterType == 1) {
            return firstFlash ? topMargin : topMargin + this.mFlashGap;
        }
        return 0;
    }

    @Override
    public synchronized void addGiftEffect(@NonNull GiftBroResult result) {
        if (!MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"addGiftEffect result: %s", (Object[])new Object[]{result});
        }
        if (result.getGiftComboInfo() == null) {
            MLog.error((Object)TAG, (String)"addGiftEffect combo info is null: %s", (Object[])new Object[]{result});
            return;
        }
        if (result.isFinish()) {
            MLog.info((Object)TAG, (String)"addGiftEffect is finish: %d", (Object[])new Object[]{result.getPropsId()});
            return;
        }
        this.getLimiter().addItem((Object)result, this.mGiftQueue.size());
    }

    private void appendGiftEffect(@NonNull GiftBroResult result) {
        GiftComboInfo comboInfo = result.getGiftComboInfo();
        if (result.isMyself()) {
            this.mSelfSendGiftQueue.offer(result);
        } else if (this.mGiftQueue.isEmpty()) {
            this.mGiftQueue.offer(result);
        } else if (comboInfo != null && comboInfo.getComboHits() == 1) {
            this.mGiftQueue.offer(result);
        } else {
            this.crossGift(result);
        }
        this.next();
    }

    @Override
    public void destroy() {
        if (this.mFlashLocation != null) {
            Kvo.autoUnbindingFrom((KvoSource)this.mFlashLocation, (Object)this);
        }
        if (this.mGiftAnimator1 != null) {
            this.mGiftAnimator1.destroy();
        }
        if (this.mGiftAnimator2 != null) {
            this.mGiftAnimator2.destroy();
        }
        if (this.mSceneOptLimiter != null) {
            this.mSceneOptLimiter.destroy();
        }
        this.mSelfSendGiftQueue.clear();
        this.mGiftQueue.clear();
    }

    @KvoMethodAnnotation(sourceClass=GiftFlashLocation.class, name="updateFlag", thread=1)
    public void onFlashLocationChanged(KvoEventIntent event) {
        MLog.info((Object)TAG, (String)"onFlashLocationChanged mFlashLocation: %s", (Object[])new Object[]{this.mFlashLocation});
        int top = this.mFlashLocation.getMarginTop();
        top = this.topMargin(top);
        this.enterType = this.mFlashLocation.getEnterType();
        if (this.mGiftAnimator1 != null) {
            this.mGiftAnimator1.onFlashLocationChanged(this.leftMargin(this.mFlashLocation), this.getTop(top, true));
        }
        if (this.mGiftAnimator2 != null) {
            this.mGiftAnimator2.onFlashLocationChanged(this.leftMargin(this.mFlashLocation), this.getTop(top, false));
        }
    }

    private void crossGift(@NonNull GiftBroResult result) {
        GiftBroResult head;
        MLog.info((Object)TAG, (String)"crossGift result: %s", (Object[])new Object[]{result});
        GiftBroResult foot = head = this.mGiftQueue.peek();
        GiftBroResult before = null;
        GiftBroResult after = null;
        GiftBroResult sameBaseStart = null;
        GiftBroResult sameBaseEnd = null;
        if (!MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"crossGift head: %s", (Object[])new Object[]{head});
        }
        if (head == null || head.getBasePriority() > result.getBasePriority()) {
            MLog.debug((Object)TAG, (String)"crossGift no more higher level priority in queue", (Object[])new Object[0]);
            this.mGiftQueue.offer(result);
            return;
        }
        int comboHit = result.getGiftComboInfo().getComboHits();
        int basePriority = result.getBasePriority();
        int beforeCombo = 0;
        int afterCombo = Integer.MAX_VALUE;
        for (GiftBroResult r : this.mGiftQueue) {
            int base;
            if (foot.compareTo(r) < 0) {
                foot = r;
            }
            if ((base = r.getBasePriority()) == basePriority) {
                if (sameBaseStart == null) {
                    sameBaseStart = r;
                }
                if (sameBaseEnd == null) {
                    sameBaseEnd = r;
                }
                if (sameBaseStart.compareTo(r) > 0) {
                    sameBaseStart = r;
                } else if (sameBaseEnd.compareTo(r) <= 0) {
                    sameBaseEnd = r;
                }
            }
            if (!result.equals((Object)r)) continue;
            int rCombo = r.getGiftComboInfo().getComboHits();
            if (rCombo < comboHit && rCombo > beforeCombo) {
                beforeCombo = rCombo;
                before = r;
                continue;
            }
            if (rCombo <= comboHit || rCombo >= afterCombo) continue;
            afterCombo = rCombo;
            after = r;
        }
        if (foot.getBasePriority() < result.getBasePriority()) {
            MLog.info((Object)TAG, (String)"crossGift no more lower level priority in queue", (Object[])new Object[0]);
            this.mGiftQueue.offer(result);
            return;
        }
        int randomPriority = 0;
        if (after != null) {
            randomPriority = after.getRandomPriority() - 5 * (afterCombo - comboHit);
            if (beforeCombo > 0 && randomPriority < before.getRandomPriority()) {
                randomPriority = before.getRandomPriority() + comboHit - beforeCombo;
            }
        } else if (before != null) {
            if (sameBaseEnd != null) {
                int range = sameBaseEnd.getRandomPriority() - before.getRandomPriority();
                if (range < 20) {
                    randomPriority = sameBaseEnd.getRandomPriority() + 5 * (comboHit - beforeCombo);
                } else {
                    if (this.mRandom == null) {
                        this.mRandom = new Random();
                    }
                    randomPriority = before.getRandomPriority() + this.mRandom.nextInt(range);
                }
            } else {
                randomPriority = before.getRandomPriority() + 5 * (comboHit - beforeCombo);
            }
        }
        result.setRandomPriority(randomPriority);
        this.mGiftQueue.offer(result);
    }

    private void printQueue(String tag) {
    }

    private int randomPriority(GiftBroResult[] arr, int startIndex, int lastIndex, int endIndex) {
        int randomPriority = 0;
        if (endIndex - lastIndex <= 5) {
            randomPriority = arr[endIndex].getRandomPriority() + 5;
        } else {
            GiftBroResult last = arr[lastIndex];
            GiftBroResult lastNext5 = arr[lastIndex + 5];
            int lastRandom = last.getRandomPriority();
            int range = lastNext5.getRandomPriority() - lastRandom;
            if (range <= 0) {
                MLog.error((Object)TAG, (String)"randomPriority startIndex: %d, endIndex: %d, lastIndex: %d, lastRandom: %d, range: %d, last: %s, lastNext5: %s", (Object[])new Object[]{startIndex, endIndex, lastIndex, lastRandom, range, last, lastNext5});
                if (RuntimeContext.sIsDebuggable) {
                    int i = 0;
                    for (GiftBroResult g : arr) {
                        MLog.error((Object)TAG, (String)"%d, %d, %d, %s, hit: %d, firstTime: %d", (Object[])new Object[]{i++, g.getBasePriority(), g.getRandomPriority(), g.getGiftInfo() == null ? "" : g.getGiftInfo().getName(), g.getGiftComboInfo() == null ? 0 : g.getGiftComboInfo().getComboHits(), g.getGiftComboInfo() == null ? 0L : g.getGiftComboInfo().getFirstSendTime()});
                    }
                }
                range = 5;
            }
            if (this.mRandom == null) {
                this.mRandom = new Random();
            }
            randomPriority = lastRandom + this.mRandom.nextInt(range);
        }
        return randomPriority;
    }

    private Point findSameBasePriority(@NonNull GiftBroResult result, GiftBroResult[] arr) {
        int basePriority = result.getBasePriority();
        int startIndex = -1;
        int endIndex = -1;
        int s = 0;
        for (int e = arr.length - 1; s < e && (startIndex == -1 || endIndex == -1); ++s, --e) {
            if (startIndex == -1) {
                if (arr[s].getBasePriority() == basePriority) {
                    startIndex = s;
                }
            } else if (arr[s].getBasePriority() > basePriority) {
                endIndex = s - 1;
            }
            if (endIndex == -1) {
                if (arr[e].getBasePriority() != basePriority) continue;
                endIndex = e;
                continue;
            }
            if (arr[e].getBasePriority() >= basePriority) continue;
            startIndex = e + 1;
        }
        return new Point(startIndex, endIndex);
    }

    private void next() {
        this.nextAnimator(this.mGiftAnimator1);
        this.nextAnimator(this.mGiftAnimator2);
    }

    private void nextAnimator(GiftAnimatorPresent animator) {
        if (!this.canAnimate) {
            MLog.info((Object)TAG, (String)"nextAnimator canAnimate: false, size: %d", (Object[])new Object[]{this.mGiftQueue.size()});
            return;
        }
        if (animator == null) {
            return;
        }
        if (!this.mSelfSendGiftQueue.isEmpty()) {
            if (this.mComboModeAnimator == null && animator.isIdle()) {
                this.mComboModeAnimator = animator;
                this.realStartAnim(this.mSelfSendGiftQueue.poll(), animator);
                return;
            }
            if (this.mComboModeAnimator != null && this.mComboModeAnimator == animator && (animator.isCombo() || animator.isIdle())) {
                this.realStartAnim(this.mSelfSendGiftQueue.poll(), animator);
                return;
            }
        }
        if (!this.mGiftQueue.isEmpty() && this.mComboModeAnimator != animator && animator.isIdle()) {
            this.realStartAnim(this.mGiftQueue.poll(), animator);
            return;
        }
        MLog.info((Object)TAG, (String)"nextAnimator isIdle %s", (Object[])new Object[]{animator.isIdle()});
    }

    private void realStartAnim(@Nullable GiftBroResult next, GiftAnimatorPresent comboModeAnimator) {
        if (next == null) {
            return;
        }
        MLog.debug((Object)TAG, (String)"realStartAnim %s", (Object[])new Object[]{next.getGiftComboInfo() != null ? Integer.valueOf(next.getGiftComboInfo().getComboHits()) : ""});
        if (next.getExpand() != null && next.getExpand().boxPropId > 0) {
            GiftItemInfo itemInfo = this.mHandlerCallback.findGiftById(next.getExpand().boxPropId, this.mGiftHandlerParam.getChannelId());
            comboModeAnimator.addGiftEffect(next, itemInfo);
        } else {
            comboModeAnimator.addGiftEffect(next);
            if (this.mGiftHandler != null && !this.isCloseFlyMic()) {
                this.mGiftHandler.addFlyMicView(next, comboModeAnimator.getMarginTop());
            }
        }
    }

    private int leftMargin(GiftFlashLocation location) {
        if (this.mFlashLeftMargin == 0) {
            this.mFlashLeftMargin = ResolutionUtils.dip2Px((float)10.0f);
        }
        return this.mFlashLeftMargin;
    }

    private int topMargin(int top) {
        if (top > this.maxMarginTop) {
            top = this.maxMarginTop;
        }
        return top;
    }

    @Override
    public void finishCombo(GiftAnimatorPresent animator) {
        if (animator == this.mComboModeAnimator) {
            this.mComboModeAnimator = null;
        }
        this.next();
    }

    @Override
    public void finish(GiftAnimatorPresent animator) {
        if (!MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"finisn", (Object[])new Object[0]);
        }
        this.nextAnimator(animator);
    }

    @Override
    public void addFlyMicView(GiftBroResult giftBroResult, int marginTop) {
        if (this.mGiftHandler != null && !this.isCloseFlyMic()) {
            this.mGiftHandler.addFlyMicView(giftBroResult, marginTop);
        }
    }

    @Override
    public void addBigEffectView(GiftBroResult giftBroResult) {
        if (this.mGiftHandler != null) {
            this.mGiftHandler.addBigEffectView(giftBroResult);
        }
    }

    @Override
    @NonNull
    public GiftFlashAnimHelper getAnimHelper() {
        if (this.mGiftFlashAnimHelper == null) {
            this.mGiftFlashAnimHelper = new GiftFlashAnimHelper();
        }
        return this.mGiftFlashAnimHelper;
    }

    private boolean isCloseFlyMic() {
        SceneOptConfigItem config;
        ISceneDegradedService sceneDegradedService = (ISceneDegradedService)ServiceManagerProxy.getService(ISceneDegradedService.class);
        if (sceneDegradedService != null && (config = sceneDegradedService.getConfigItem("gift_flash")) != null) {
            return sceneDegradedService.isInHighPerfScene() && config.isCloseFlyMic;
        }
        return false;
    }
}

