/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.gift.ui.combo;

import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.text.Spanned;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ProgressBar;
import android.widget.TextView;
import androidx.constraintlayout.widget.ConstraintLayout;
import com.opensource.svgaplayer.hago.SVGADrawable;
import com.opensource.svgaplayer.hago.SVGAImageView;
import com.opensource.svgaplayer.hago.SVGAVideoEntity;
import com.yy.appbase.ui.widget.CircleProgressView;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FontUtils;
import com.yy.framework.core.ui.svga.ISvgaLoadCallback;
import com.yy.hiyo.dyres.api.DyResLoader;
import com.yy.hiyo.wallet.DR;
import com.yy.hiyo.wallet.R;
import com.yy.hiyo.wallet.gift.ui.combo.IComboBtnCallback;

public class ComboBtnView
extends YYFrameLayout {
    private static final long COUNT_DOWN_INTERVAL = 5000L;
    private static final long PROGRESS_TIME = 4500L;
    private SVGAImageView mComboBtn;
    private IComboBtnCallback mCallback;
    private SVGADrawable mNormalSvga;
    private SVGADrawable mPressSvga;
    private CircleProgressView circleProgress;
    private long mLastSendStamp;
    private boolean isPress = false;
    private boolean isDestroy = false;
    private YYTextView mComboTipsTv;
    private ConstraintLayout mNewComboContainer;
    private ProgressBar mComboProgress;
    private YYTextView mProgressTv;
    private ValueAnimator alphaAnim;
    private Runnable mFinishTask = new Runnable(){

        @Override
        public void run() {
            if (!ComboBtnView.this.isDestroy && ComboBtnView.this.mCallback != null) {
                ComboBtnView.this.mCallback.onFinish();
            }
        }
    };
    private Runnable mComboUp = new Runnable(){

        @Override
        public void run() {
            if (ComboBtnView.this.mNormalSvga != null) {
                ComboBtnView.this.mComboBtn.setImageDrawable((Drawable)ComboBtnView.this.mNormalSvga);
                ComboBtnView.this.mComboBtn.startAnimation();
                ComboBtnView.this.circleProgress.setVisibility(0);
                ComboBtnView.this.circleProgress.runProgressAnim(4500L);
            }
        }
    };
    private Runnable mComboTipsOut = new Runnable(){

        @Override
        public void run() {
            ComboBtnView.this.mComboTipsTv.setVisibility(4);
            ComboBtnView.this.mNewComboContainer.setVisibility(4);
        }
    };
    private ValueAnimator.AnimatorUpdateListener alphaAnimation = animation -> {
        Float value = (Float)animation.getAnimatedValue();
        this.mComboBtn.setScaleX(value.floatValue());
        this.mComboBtn.setScaleY(value.floatValue());
        this.circleProgress.setScaleX(value.floatValue());
        this.circleProgress.setScaleY(value.floatValue());
    };

    public ComboBtnView(Context context) {
        super(context);
        this.create(context);
    }

    public ComboBtnView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.create(context);
    }

    public ComboBtnView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.create(context);
    }

    private void create(Context context) {
        LayoutInflater.from((Context)context).inflate(R.layout.layout_combo_btn, (ViewGroup)this);
        this.mComboBtn = (SVGAImageView)this.findViewById(R.id.combo_btn);
        this.mNewComboContainer = (ConstraintLayout)this.findViewById(R.id.ll_new_combo_tips);
        this.mComboProgress = (ProgressBar)this.findViewById(R.id.progressBar);
        this.mProgressTv = (YYTextView)this.findViewById(R.id.tv_progress);
        this.circleProgress = (CircleProgressView)this.findViewById(R.id.circle_progress_fill_in);
        this.mComboTipsTv = (YYTextView)this.findViewById(R.id.combo_tips_tv);
        FontUtils.setFontType((TextView)this.mProgressTv, (Typeface)FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.HagoNumber));
        this.viewEvent();
        DyResLoader.INSTANCE.loadSvga(context, DR.combo_normal, new ISvgaLoadCallback(){

            public void onFinished(SVGAVideoEntity svgaVideoEntity) {
                ComboBtnView.this.mNormalSvga = new SVGADrawable(svgaVideoEntity);
                if (!ComboBtnView.this.isPress && ComboBtnView.this.mComboBtn != null) {
                    ComboBtnView.this.mComboBtn.setImageDrawable((Drawable)ComboBtnView.this.mNormalSvga);
                    ComboBtnView.this.mComboBtn.startAnimation();
                    ComboBtnView.this.circleProgress.runProgressAnim(4500L);
                }
            }

            public void onFailed(Exception e) {
            }
        });
        DyResLoader.INSTANCE.loadSvga(context, DR.combo_press, new ISvgaLoadCallback(){

            public void onFinished(SVGAVideoEntity svgaVideoEntity) {
                ComboBtnView.this.mPressSvga = new SVGADrawable(svgaVideoEntity);
                if (ComboBtnView.this.isPress && ComboBtnView.this.mComboBtn != null) {
                    ComboBtnView.this.mComboBtn.setImageDrawable((Drawable)ComboBtnView.this.mPressSvga);
                    ComboBtnView.this.mComboBtn.startAnimation();
                }
            }

            public void onFailed(Exception e) {
            }
        });
        this.start();
    }

    private void viewEvent() {
        this.mComboBtn.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                switch (event.getAction()) {
                    case 0: {
                        ComboBtnView.this.animationDown(v);
                        break;
                    }
                    case 1: 
                    case 3: {
                        ComboBtnView.this.animationUp(v);
                        break;
                    }
                }
                return true;
            }
        });
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.mComboTipsTv.getVisibility() == 0) {
            this.mComboTipsTv.setVisibility(4);
            YYTaskExecutor.removeTask((Runnable)this.mComboTipsOut);
        }
        return false;
    }

    private void animationUp(View view) {
        this.isPress = false;
        if (this.mNormalSvga != null) {
            YYTaskExecutor.removeTask((Runnable)this.mComboUp);
            YYTaskExecutor.postToMainThread((Runnable)this.mComboUp, (long)200L);
        }
        if (!this.isDestroy && this.mCallback != null) {
            this.start();
            this.post(new Runnable(){

                @Override
                public void run() {
                    ComboBtnView.this.mCallback.onClick();
                }
            });
        }
    }

    private void animationDown(View view) {
        this.isPress = true;
        YYTaskExecutor.removeTask((Runnable)this.mComboTipsOut);
        this.mComboTipsTv.setVisibility(4);
        if (this.circleProgress.getVisibility() == 0) {
            this.circleProgress.setVisibility(8);
        }
        this.circleProgress.endProgressAnim();
        if (this.mPressSvga != null) {
            this.mComboBtn.setImageDrawable((Drawable)this.mPressSvga);
            this.mComboBtn.startAnimation();
        }
        if (this.alphaAnim != null) {
            this.alphaAnim.end();
        }
        this.alphaAnim = ValueAnimator.ofFloat((float[])new float[]{1.0f, 1.5f, 1.0f});
        this.alphaAnim.addUpdateListener(this.alphaAnimation);
        this.alphaAnim.setDuration(200L);
        this.alphaAnim.start();
    }

    private void start() {
        YYTaskExecutor.removeTask((Runnable)this.mFinishTask);
        YYTaskExecutor.postToMainThread((Runnable)this.mFinishTask, (long)5000L);
    }

    public void setCallback(IComboBtnCallback mCallback) {
        this.mCallback = mCallback;
    }

    public void destroy() {
        this.isDestroy = true;
        YYTaskExecutor.removeTask((Runnable)this.mFinishTask);
        if (this.mComboBtn != null) {
            this.mComboBtn.stopAnimation();
            if (this.alphaAnim != null) {
                this.alphaAnim.end();
            }
        }
        this.mComboBtn = null;
        this.mPressSvga = null;
        this.mNormalSvga = null;
    }

    public void showComboTips(Spanned tips) {
        if (TextUtils.isEmpty((CharSequence)tips)) {
            this.mComboTipsTv.setVisibility(4);
            return;
        }
        this.mNewComboContainer.setVisibility(4);
        this.mComboTipsTv.setVisibility(0);
        this.mComboTipsTv.setText((CharSequence)tips);
        YYTaskExecutor.removeTask((Runnable)this.mComboTipsOut);
        YYTaskExecutor.postToMainThread((Runnable)this.mComboTipsOut, (long)5000L);
    }

    public void showNewComboTips(String progressText, int progress) {
        this.mComboTipsTv.setVisibility(4);
        this.mNewComboContainer.setVisibility(0);
        this.mProgressTv.setText((CharSequence)progressText);
        this.mComboProgress.setProgress(progress);
    }

    public void hideAllTips() {
        this.mComboTipsTv.setVisibility(4);
        this.mNewComboContainer.setVisibility(4);
    }
}

