/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.gift.ui.combo;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import android.os.VibrationEffect;
import android.os.Vibrator;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.ScreenUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.SystemServiceUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.hiyo.wallet.R;
import com.yy.hiyo.wallet.base.revenue.gift.bean.GiftBroResult;
import com.yy.hiyo.wallet.base.revenue.gift.bean.GiftComboEffectLevel;
import com.yy.hiyo.wallet.base.revenue.gift.bean.GiftComboInfo;
import com.yy.hiyo.wallet.base.revenue.gift.bean.GiftItemInfo;
import com.yy.hiyo.wallet.base.revenue.gift.param.GiftUserInfo;
import com.yy.hiyo.wallet.gift.statis.GiftHiidoReport;
import com.yy.hiyo.wallet.gift.ui.combo.ComboBtnView;
import com.yy.hiyo.wallet.gift.ui.combo.IComboBtnCallback;
import com.yy.hiyo.wallet.gift.ui.combo.IComboSendCallback;
import com.yy.hiyo.wallet.notify.IRevenueComNotifyService;
import java.util.List;

public class ComboBtnPresenter
implements IComboBtnCallback {
    private static final String TAG = "ComboBtnPresenter";
    private static boolean isBottomGameMode = false;
    private ViewGroup mContainer;
    private ComboBtnView mComboBtn;
    private List<GiftUserInfo> mReceiverUseInfo;
    private GiftItemInfo mSendGiftInfo;
    private int mSendCount;
    private int mFrom;
    private String mGiftSlogan;
    private final IComboSendCallback mCallback;

    public ComboBtnPresenter(ViewGroup giftLayout, IComboSendCallback callback) {
        this.mContainer = giftLayout;
        this.mCallback = callback;
    }

    public void showCombo(String roomId, List<GiftUserInfo> receiver, GiftItemInfo giftInfo, int gitNumber, String giftSlogan, int from) {
        if (this.mComboBtn != null || this.mContainer == null) {
            return;
        }
        this.mFrom = from;
        this.mReceiverUseInfo = receiver;
        this.mSendGiftInfo = giftInfo;
        this.mSendCount = gitNumber;
        this.mGiftSlogan = giftSlogan;
        this.mComboBtn = new ComboBtnView(this.mContainer.getContext());
        this.mComboBtn.setCallback(this);
        ViewGroup.LayoutParams lp = new ViewGroup.LayoutParams(-1, -1);
        if (isBottomGameMode) {
            this.mComboBtn.setPadding(0, 0, 0, ScreenUtils.getInstance().getWidthPixels() * 16 / 24);
        }
        this.mContainer.addView((View)this.mComboBtn, lp);
        this.mCallback.onComboShow();
        ((IRevenueComNotifyService)ServiceManagerProxy.getServiceManager().getService(IRevenueComNotifyService.class)).onPauseOPenWeb();
        GiftHiidoReport.onComboShow(from, roomId);
    }

    @Override
    public void onClick() {
        GiftHiidoReport.reportAfClickGift();
        if (!NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext)) {
            ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)ResourceUtils.getString((int)R.string.check_network_and_retry), (int)0);
            return;
        }
        if (this.mReceiverUseInfo != null && this.mSendGiftInfo != null) {
            this.mCallback.sendCombo(this.mReceiverUseInfo, this.mSendGiftInfo, this.mSendCount, this.mGiftSlogan, this.mFrom);
        } else {
            MLog.error((Object)TAG, (String)"combo send gift param is null, can not send gift", (Object[])new Object[0]);
            this.finishCombo();
        }
    }

    @Override
    public void onFinish() {
        MLog.info((Object)TAG, (String)"finishCombo onFinish", (Object[])new Object[0]);
        this.finishCombo();
    }

    public void destroy() {
        this.finishCombo();
        this.mContainer = null;
    }

    public void finishCombo() {
        ComboBtnView comboView = this.mComboBtn;
        this.mComboBtn = null;
        this.mReceiverUseInfo = null;
        this.mSendGiftInfo = null;
        this.mSendCount = 0;
        this.mGiftSlogan = "";
        MLog.info((Object)TAG, (String)"finishCombo mComboBtn: %b", (Object[])new Object[]{comboView == null});
        if (comboView != null) {
            comboView.destroy();
            if (comboView.getParent() instanceof ViewGroup) {
                ((ViewGroup)comboView.getParent()).removeView((View)comboView);
            }
            this.mCallback.onComboHide();
            ((IRevenueComNotifyService)ServiceManagerProxy.getServiceManager().getService(IRevenueComNotifyService.class)).onResumeOPenWeb();
        }
    }

    public static void setBottomGameMode(boolean bottomGameMode) {
        isBottomGameMode = bottomGameMode;
    }

    @SuppressLint(value={"MissingPermission"})
    private void startVibrate() {
        try {
            Vibrator vibrator = SystemServiceUtils.getVibrator((Context)RuntimeContext.sApplicationContext);
            int duration = 200;
            if (vibrator != null) {
                if (Build.VERSION.SDK_INT >= 26) {
                    vibrator.vibrate(VibrationEffect.createOneShot((long)duration, (int)-1));
                } else {
                    vibrator.vibrate((long)duration);
                }
            }
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (Throwable)e);
        }
    }

    public void showComboTips(@NonNull GiftBroResult result, boolean showComboSvga) {
        if (showComboSvga && result.isMyself()) {
            this.startVibrate();
        }
        GiftComboEffectLevel giftComboExpand = result.getGiftComboExpand();
        GiftComboInfo giftComboInfo = result.getGiftComboInfo();
        if (giftComboExpand == null || result.getGiftBroInfo().getUid() != AccountUtil.getUid() || this.mComboBtn == null) {
            if (this.mComboBtn != null) {
                this.mComboBtn.hideAllTips();
            }
            return;
        }
        MLog.info((Object)TAG, (String)"showComboTips giftComboExpand = %s ,giftComboExpand.isComboProgressNotice", (Object[])new Object[]{giftComboExpand.toString(), giftComboExpand.isComboProgressNotice()});
        if (giftComboInfo != null && giftComboExpand.isComboProgressNotice()) {
            int count = giftComboExpand.getLackComboCount() + giftComboInfo.getComboHits();
            String progressText = giftComboInfo.getComboHits() + " / " + count;
            int progress = giftComboInfo.getComboHits() * 100 / count;
            this.mComboBtn.showNewComboTips(progressText, progress);
        } else if (giftComboExpand.getLackComboCount() > 0 && !TextUtils.isEmpty((CharSequence)giftComboExpand.getTargetEffectLevel())) {
            this.mComboBtn.showComboTips(StringUtils.getHtmlText((int)R.string.tips_gift_combo_tips, (Object[])new Object[]{giftComboExpand.getLackComboCount(), giftComboExpand.getTargetEffectLevel()}));
        } else {
            this.mComboBtn.hideAllTips();
        }
    }
}

