/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.gift.ui.activitygift.greetingcard;

import android.app.Dialog;
import android.content.Context;
import android.graphics.Color;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.annotation.NonNull;
import com.yy.base.memoryrecycle.views.YYButton;
import com.yy.base.memoryrecycle.views.YYEditText;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.ImeUtil;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.framework.core.ui.dialog.frame.YYDialog.YYDialog;
import com.yy.hiyo.wallet.R;
import com.yy.hiyo.wallet.base.revenue.gift.GiftUtils;
import com.yy.hiyo.wallet.base.revenue.gift.bean.GiftItemInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class GreetingCardEditDialog
extends YYDialog
implements View.OnClickListener {
    private static final int MAX_LENGTH = 70;
    private Context mContext;
    private View mView;
    private YYEditText mInputEt;
    private YYButton mSendBtn;
    private YYTextView mMaxTv;
    private YYTextView mTvTittle;
    private CardInfoCallback mCallback;
    private String tittle;
    private String content;
    private List<String> greetingList = new ArrayList<String>();
    private int currentIndex = -1;

    public GreetingCardEditDialog(@NonNull Context context, GiftItemInfo gift, CardInfoCallback callback) {
        super(context, R.style.cTransparentDialog);
        this.tittle = GiftUtils.getGreetTitle((GiftItemInfo)gift);
        this.content = GiftUtils.getGreetText((GiftItemInfo)gift);
        this.mContext = context;
        this.mCallback = callback;
        this.initData();
        this.initView();
    }

    private void initData() {
        String[] strArr = ResourceUtils.getStringArray((int)R.array.zhaiyueheka_default_1);
        if (strArr.length > 0) {
            this.greetingList.addAll(Arrays.asList(strArr));
        }
    }

    private void initView() {
        this.mView = View.inflate((Context)this.mContext, (int)R.layout.layout_greeting_card_dialog, null);
        ViewGroup.LayoutParams contentLp = new ViewGroup.LayoutParams(ResolutionUtils.getScreenWidth((Context)this.mContext) - ResolutionUtils.dip2Px((float)50.0f), -2);
        this.setContentView(this.mView, contentLp);
        this.getWindow().clearFlags(131072);
        this.getWindow().setSoftInputMode(4);
        this.mTvTittle = (YYTextView)this.mView.findViewById(R.id.tv_title);
        this.mInputEt = (YYEditText)this.mView.findViewById(R.id.et_input);
        this.mSendBtn = (YYButton)this.mView.findViewById(R.id.btn_send);
        this.mMaxTv = (YYTextView)this.mView.findViewById(R.id.tv_max_tips);
        this.mView.findViewById(R.id.iv_close).setOnClickListener((View.OnClickListener)this);
        this.mView.findViewById(R.id.btn_send).setOnClickListener((View.OnClickListener)this);
        this.mView.findViewById(R.id.iv_random).setOnClickListener((View.OnClickListener)this);
        if (!TextUtils.isEmpty((CharSequence)this.tittle)) {
            this.mTvTittle.setText((CharSequence)this.tittle);
        }
        this.mMaxTv.setText((CharSequence)ResourceUtils.getString((int)R.string.tips_greeting_card_edit_count, (Object[])new Object[]{0, 70}));
        this.mInputEt.addTextChangedListener(new TextWatcher(){
            String beforeStr = "";

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
                this.beforeStr = s.toString();
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                if (null == s) {
                    return;
                }
                if (StringUtils.getStringLength((String)this.beforeStr) == 70 && StringUtils.getStringLength((String)s.toString()) > 70) {
                    GreetingCardEditDialog.this.mInputEt.setText((CharSequence)this.beforeStr);
                    GreetingCardEditDialog.this.mInputEt.setSelection(GreetingCardEditDialog.this.mInputEt.getText().length());
                    return;
                }
                if (s.toString().trim().isEmpty()) {
                    GreetingCardEditDialog.this.mSendBtn.setEnabled(false);
                    GreetingCardEditDialog.this.mMaxTv.setTextColor(Color.parseColor((String)"#999999"));
                } else {
                    StringBuilder sb = new StringBuilder(s.toString());
                    if (StringUtils.getStringLength((String)sb.toString()) >= 70) {
                        if (StringUtils.getStringLength((String)sb.toString()) > 70) {
                            while (StringUtils.getStringLength((String)sb.toString()) > 70) {
                                sb = sb.deleteCharAt(sb.length() - 1);
                            }
                            GreetingCardEditDialog.this.mInputEt.setText((CharSequence)sb.toString());
                            GreetingCardEditDialog.this.mInputEt.setSelection(GreetingCardEditDialog.this.mInputEt.getText().length());
                        }
                        GreetingCardEditDialog.this.mSendBtn.setEnabled(true);
                        GreetingCardEditDialog.this.mMaxTv.setTextColor(Color.parseColor((String)"#FF001F"));
                    } else if (StringUtils.getStringLength((String)sb.toString()) > 0) {
                        GreetingCardEditDialog.this.mSendBtn.setEnabled(true);
                        GreetingCardEditDialog.this.mMaxTv.setTextColor(Color.parseColor((String)"#999999"));
                    } else {
                        GreetingCardEditDialog.this.mSendBtn.setEnabled(false);
                        GreetingCardEditDialog.this.mMaxTv.setTextColor(Color.parseColor((String)"#999999"));
                    }
                }
                GreetingCardEditDialog.this.mMaxTv.setText((CharSequence)ResourceUtils.getString((int)R.string.tips_greeting_card_edit_count, (Object[])new Object[]{StringUtils.getStringLength((String)GreetingCardEditDialog.this.mInputEt.getText().toString()), 70}));
            }
        });
        this.randomGreeting();
    }

    private void randomGreeting() {
        if (this.greetingList.isEmpty()) {
            this.mInputEt.setText((CharSequence)"");
            return;
        }
        this.currentIndex = this.currentIndex < this.greetingList.size() - 1 ? ++this.currentIndex : 0;
        if (!TextUtils.isEmpty((CharSequence)this.content)) {
            this.mInputEt.setText((CharSequence)this.content);
        }
        this.mInputEt.setSelection(this.mInputEt.getText().length());
    }

    public void dismiss() {
        View view = this.getCurrentFocus();
        if (view instanceof TextView) {
            ImeUtil.hideIME((Context)this.mContext, (View)view);
        }
        super.dismiss();
    }

    public void onClick(View v) {
        if (v.getId() == R.id.iv_close) {
            this.dismiss();
        } else if (v.getId() == R.id.btn_send) {
            String info = this.mInputEt.getText().toString();
            if (!StringUtils.isEmpty((String)info) && null != this.mCallback) {
                this.mCallback.send((Dialog)this, info);
            }
        } else if (v.getId() == R.id.iv_random) {
            this.randomGreeting();
        }
    }

    public static interface CardInfoCallback {
        public void send(Dialog var1, String var2);
    }
}

