/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.gift.statis;

import com.yy.appbase.appsflyer.AppsFlyerEvent;
import com.yy.appbase.appsflyer.AppsFlyerHelper;
import com.yy.appbase.appsflyer.ThirdTrackEvent;
import com.yy.appbase.appsflyer.ThirdTrackHelper;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.utils.SettingFlags;
import com.yy.hiyo.wallet.base.revenue.gift.bean.GiftItemInfo;
import com.yy.hiyo.wallet.base.revenue.gift.param.GiftUserInfo;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.util.List;

public class GiftHiidoReport {
    private static final String TAG = "GiftHiidoReport";
    private static long lastReportClickGift = 0L;
    private static long reportClickGiftInterval = SettingFlags.getLongValue((String)"report_af_click_gift_interval", (long)10000L);
    private static IGiftStatListener sStatListener;

    public static void reportAfClickGift() {
        if (reportClickGiftInterval <= 0L) {
            ThirdTrackHelper.INSTANCE.reportEvent(new ThirdTrackEvent().eventId(ThirdTrackEvent.CLICK_GIFTS));
        } else {
            long cur = System.currentTimeMillis();
            if (cur - lastReportClickGift > reportClickGiftInterval) {
                ThirdTrackHelper.INSTANCE.reportEvent(new ThirdTrackEvent().eventId(ThirdTrackEvent.CLICK_GIFTS));
                lastReportClickGift = cur;
            }
        }
    }

    private static HiidoEvent event(String eventId) {
        return HiidoEvent.obtain().eventId(eventId);
    }

    public static final void entryGiftPanel(String roomId, int from, boolean giftCarouselShowing) {
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20028823").put("function_id", "gift_button_click").put("room_id", roomId).put("if_reach", giftCarouselShowing ? "1" : "0").put("gift_panel_enter_type", "" + from).put("mode_key", RuntimeContext.useOldRoom() ? "1" : "2").put("gid", GiftHiidoReport.getPluginId(roomId)));
    }

    public static final void giftPanelShow(String roomId, int from, boolean showAction) {
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20028823").put("function_id", "gift_panel_show").put("room_id", roomId).put("gift_panel_enter_type", String.valueOf(from)).put("if_first_rech", String.valueOf(showAction ? 1 : 0)).put("mode_key", RuntimeContext.useOldRoom() ? "1" : "2").put("gid", GiftHiidoReport.getPluginId(roomId)));
        AppsFlyerHelper.INSTANCE.reportEvent(new AppsFlyerEvent().eventId("gift_panel_show").put("room_id", (Object)roomId).put("gift_panel_enter_type", (Object)String.valueOf(from)).put("if_first_rech", (Object)String.valueOf(showAction ? 1 : 0)).put("mode_key", (Object)(RuntimeContext.useOldRoom() ? "1" : "2")).put("gid", (Object)GiftHiidoReport.getPluginId(roomId)));
    }

    public static final void giftClick(String roomId, String giftId) {
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20028823").put("gift_uid", giftId).put("function_id", "gift_click").put("room_id", roomId).put("radio_model", GiftHiidoReport.isVideoModel(roomId)).put("gid", GiftHiidoReport.getPluginId(roomId)));
    }

    public static final void giftDesClick(String roomId, String giftId, String jumpUrl, int from, long roomAnchorUid, String curGameId) {
        if (from == 1) {
            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20028823").put("function_id", "weekly_giftpannel_enter_click").put("room_id", roomId).put("gift_id", "" + giftId).put("owner_id", "" + roomAnchorUid).put("gid", curGameId));
        } else {
            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20028823").put("gift_uid", giftId).put("function_id", "gift_describe_click").put("room_id", roomId).put("act_url", jumpUrl).put("radio_model", GiftHiidoReport.isVideoModel(roomId)).put("gid", GiftHiidoReport.getPluginId(roomId)));
        }
    }

    public static final void giftDesShow(String roomId, String giftId, String jumpUrl, int from, long roomAnchorUid, String curGameId) {
        if (from == 1) {
            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20028823").put("function_id", "weekly_giftpannel_enter_show").put("room_id", roomId).put("gift_id", "" + giftId).put("owner_id", "" + roomAnchorUid).put("gid", curGameId));
        } else {
            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20028823").put("gift_uid", giftId).put("function_id", "gift_describe_show").put("room_id", roomId).put("act_url", jumpUrl).put("radio_model", GiftHiidoReport.isVideoModel(roomId)).put("gid", GiftHiidoReport.getPluginId(roomId)));
        }
    }

    public static final void sendGift(String roomId, int from, List<GiftUserInfo> receiverList, GiftItemInfo giftInfo, int count, int type) {
        int giftId;
        String functionId = "";
        int n = giftId = giftInfo == null ? 0 : giftInfo.getPropsId();
        if (type == 1) {
            functionId = "gift_donate_click";
        } else if (type == 2) {
            functionId = "cont_gift_but_click";
        }
        HiidoEvent event = HiidoEvent.obtain().eventId("20028823").put("function_id", functionId).put("room_id", roomId).put("gift_panel_enter_type", "" + from).put("gift_uid", String.valueOf(giftId)).put("group_count", String.valueOf(count)).put("mode_key", RuntimeContext.useOldRoom() ? "1" : "2").put("gid", GiftHiidoReport.getPluginId(roomId));
        event = GiftHiidoReport.appendUidsAndUserType(receiverList, event);
        HiidoStatis.reportEvent((HiidoEvent)event);
    }

    public static final void sendGiftGuideClickReport(int entryType) {
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("60022478").put("function_id", "gift_guide_click").put("entry_type", String.valueOf(entryType)));
    }

    public static final void consumeGuideIconClickReport() {
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("60022478").put("function_id", "gift_bar_icon_click"));
    }

    public static final void consumeGuidePopShowReport() {
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("60022478").put("function_id", "gift_bubble_show"));
    }

    public static final void consumeGuideSendClickReport(int hasPop) {
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("60022478").put("function_id", "gift_btn_click").put("entry_type", String.valueOf(hasPop)));
    }

    public static final HiidoEvent appendUidsAndUserType(List<GiftUserInfo> receiverList, HiidoEvent event) {
        String receiverUid = "0";
        StringBuilder uidsBuilder = new StringBuilder();
        StringBuilder typeBuilder = new StringBuilder();
        String receiverType = "2";
        if (receiverList != null) {
            int size = receiverList.size();
            for (int i = 0; i < size; ++i) {
                GiftUserInfo receiver = receiverList.get(i);
                if (receiver != null) {
                    uidsBuilder.append(receiver.uid());
                    int reType = receiver.getUserType() == 1 ? 1 : 2;
                    typeBuilder.append(reType);
                }
                if (i >= size - 1) continue;
                uidsBuilder.append("#");
                typeBuilder.append("#");
            }
            receiverUid = uidsBuilder.toString();
            receiverType = typeBuilder.toString();
        }
        return event.put("recipient_uid", receiverUid).put("recipient_type", receiverType);
    }

    public static final void sendGiftReturn(String roomId, int from, List<GiftUserInfo> receiverList, GiftItemInfo giftInfo, int count, int code, int type) {
        int giftId;
        String functionId = "";
        int n = giftId = giftInfo == null ? 0 : giftInfo.getPropsId();
        if (type == 1) {
            functionId = "gift_donate_back";
        } else if (type == 2) {
            functionId = "cont_gift_back";
        }
        int ifSuccess = 1;
        if (code != 0) {
            ifSuccess = 2;
        }
        HiidoEvent event = HiidoEvent.obtain().eventId("20028823").put("function_id", functionId).put("room_id", roomId).put("gift_panel_enter_type", "" + from).put("gift_uid", String.valueOf(giftId)).put("group_count", String.valueOf(count)).put("if_recipient_success", String.valueOf(ifSuccess)).put("gift_error_code", String.valueOf(GiftHiidoReport.sendGiftCode(code))).put("user_role", String.valueOf(GiftHiidoReport.getUserRole(roomId))).put("gid", GiftHiidoReport.getPluginId(roomId)).put("mode_key", RuntimeContext.useOldRoom() ? "1" : "2");
        event = GiftHiidoReport.appendUidsAndUserType(receiverList, event);
        HiidoStatis.reportEvent((HiidoEvent)event);
    }

    public static final void noEnoughBalanceDialogShow(String roomId, int from, int giftId) {
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20028823").put("function_id", "gold_lack_show").put("room_id", roomId).put("gift_panel_enter_type", "" + from).put("gift_uid", String.valueOf(giftId)).put("mode_key", RuntimeContext.useOldRoom() ? "1" : "2"));
    }

    public static final void noEnoughBalanceDialogCancel(String roomId, int from) {
        GiftHiidoReport.reportEvent("gold_lack_cancel_click", roomId, from);
    }

    public static final void noEnoughBalanceDialogOk(String roomId, int from) {
        GiftHiidoReport.reportEvent("gold_lack_ok_click", roomId, from);
    }

    private static void reportEvent(String functionId, String roomId, int from) {
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20028823").put("function_id", functionId).put("room_id", roomId).put("gift_panel_enter_type", "" + from));
    }

    private static int sendGiftCode(int code) {
        if (code == 0) {
            return code;
        }
        if (code == 20994) {
            return 1;
        }
        if (code == 20992) {
            return 2;
        }
        if (code == 20989) {
            return 3;
        }
        if (code == 20988) {
            return 4;
        }
        if (code == 20499) {
            return 5;
        }
        if (code == 20987) {
            return 6;
        }
        if (code == 20984) {
            return 7;
        }
        if (code == 20495) {
            return 8;
        }
        if (code == 20492) {
            return 9;
        }
        return code;
    }

    public static void giftPanelActShow(String roomId, long activityId, String actUrl) {
        if (!MLog.isLogLevelAboveDebug() && !MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"giftPanelActShow %s, %s", (Object[])new Object[]{roomId, activityId});
        }
        HiidoStatis.reportEvent((HiidoEvent)GiftHiidoReport.event("20028823").put("function_id", "gift_panel_act_show").put("room_id", roomId).put("act_url", actUrl).put("active_id", "" + activityId).put("mode_key", RuntimeContext.useOldRoom() ? "1" : "2"));
    }

    public static void giftPanelActClick(String roomId, long activityId, String actUrl) {
        if (!MLog.isLogLevelAboveDebug() && !MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"giftPanelActClick %s, %s", (Object[])new Object[]{roomId, activityId});
        }
        HiidoStatis.reportEvent((HiidoEvent)GiftHiidoReport.event("20028823").put("function_id", "gift_panel_act_click").put("room_id", roomId).put("act_url", actUrl).put("active_id", "" + activityId).put("mode_key", RuntimeContext.useOldRoom() ? "1" : "2"));
    }

    public static void sendGiftGuideShow(GiftItemInfo giftItemInfo, String roomId) {
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20028823").put("function_id", "gift_send_guide_show").put("gift_uid", giftItemInfo == null ? "" : String.valueOf(giftItemInfo.getPropsId())).put("room_id", roomId == null ? "" : roomId).put("mode_key", RuntimeContext.useOldRoom() ? "1" : "2"));
    }

    public static void giftPanelAboveActShow(String roomId, long activityId, String actUrl) {
        if (!MLog.isLogLevelAboveDebug() && !MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"giftPanelAboveActShow %s, %s", (Object[])new Object[]{roomId, activityId});
        }
        HiidoStatis.reportEvent((HiidoEvent)GiftHiidoReport.event("20028823").put("function_id", "gift_panel_left_act_show").put("room_id", roomId).put("active_id", "" + activityId).put("act_url", actUrl).put("mode_key", RuntimeContext.useOldRoom() ? "1" : "2"));
    }

    public static void giftPanelAboveActClick(String roomId, long activityId, String actUrl) {
        if (!MLog.isLogLevelAboveDebug() && !MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"gift_panel_left_act_click %s, %s", (Object[])new Object[]{roomId, activityId});
        }
        HiidoStatis.reportEvent((HiidoEvent)GiftHiidoReport.event("20028823").put("function_id", "gift_panel_left_act_click").put("room_id", roomId).put("active_id", "" + activityId).put("act_url", actUrl).put("mode_key", RuntimeContext.useOldRoom() ? "1" : "2"));
    }

    public static void redPacketShow(String mRoomId) {
        HiidoStatis.reportEvent((HiidoEvent)GiftHiidoReport.event("20032603").put("mode_key", RuntimeContext.useOldRoom() ? "1" : "2").put("function_id", "packet_enter_show").put("room_id", mRoomId));
    }

    public static void redPacketClick(String mRoomId) {
        HiidoStatis.reportEvent((HiidoEvent)GiftHiidoReport.event("20032603").put("mode_key", RuntimeContext.useOldRoom() ? "1" : "2").put("function_id", "packet_enter_click").put("room_id", mRoomId));
    }

    public static void redPacketExplainShow(String mRoomId) {
        HiidoStatis.reportEvent((HiidoEvent)GiftHiidoReport.event("20032603").put("mode_key", RuntimeContext.useOldRoom() ? "1" : "2").put("function_id", "bless_exp_show").put("room_id", mRoomId));
    }

    public static void redPacketExplainClick(String mRoomId) {
        HiidoStatis.reportEvent((HiidoEvent)GiftHiidoReport.event("20032603").put("mode_key", RuntimeContext.useOldRoom() ? "1" : "2").put("function_id", "bless_exp_click").put("room_id", mRoomId));
    }

    public static void packetGuideShow(String mRoomId) {
        HiidoStatis.reportEvent((HiidoEvent)GiftHiidoReport.event("20032603").put("mode_key", RuntimeContext.useOldRoom() ? "1" : "2").put("function_id", "new_guide_show").put("room_id", mRoomId));
    }

    public static void packetGuideClick(String mRoomId) {
        HiidoStatis.reportEvent((HiidoEvent)GiftHiidoReport.event("20032603").put("mode_key", RuntimeContext.useOldRoom() ? "1" : "2").put("function_id", "new_guide_send_click").put("room_id", mRoomId));
    }

    public static void sendPacketShow(String mRoomId) {
        HiidoStatis.reportEvent((HiidoEvent)GiftHiidoReport.event("20032603").put("mode_key", RuntimeContext.useOldRoom() ? "1" : "2").put("function_id", "bless_pop_show").put("room_id", mRoomId));
    }

    public static void packetSendClick(String roomId, int diamond) {
        HiidoStatis.reportEvent((HiidoEvent)GiftHiidoReport.event("20032603").put("mode_key", RuntimeContext.useOldRoom() ? "1" : "2").put("function_id", "bless_pop_send_click").put("amount", String.valueOf(diamond)).put("room_id", roomId));
    }

    public static void redPacketFloatViewShow(int diamonds, String roomId) {
        HiidoStatis.reportEvent((HiidoEvent)GiftHiidoReport.event("20032603").put("mode_key", RuntimeContext.useOldRoom() ? "1" : "2").put("room_id", roomId).put("amount", String.valueOf(diamonds)).put("function_id", "get_packet_show"));
    }

    public static void redPacketFloatViewClick(String roomId) {
        HiidoStatis.reportEvent((HiidoEvent)GiftHiidoReport.event("20032603").put("mode_key", RuntimeContext.useOldRoom() ? "1" : "2").put("room_id", roomId).put("function_id", "get_packet_click"));
    }

    public static void showQuestionDialog(String roomId) {
        HiidoStatis.reportEvent((HiidoEvent)GiftHiidoReport.event("20032603").put("mode_key", RuntimeContext.useOldRoom() ? "1" : "2").put("room_id", roomId).put("function_id", "rule_but_click"));
        HiidoStatis.reportEvent((HiidoEvent)GiftHiidoReport.event("20032603").put("mode_key", RuntimeContext.useOldRoom() ? "1" : "2").put("room_id", roomId).put("function_id", "rule_pg_show"));
    }

    public static void redPacketSuccess(int winDiamond, String roomId) {
        HiidoStatis.reportEvent((HiidoEvent)GiftHiidoReport.event("20032603").put("mode_key", RuntimeContext.useOldRoom() ? "1" : "2").put("amount", String.valueOf(winDiamond)).put("room_id", roomId).put("function_id", "get_packet_succ_show"));
    }

    public static void redPacketSuccessShare(String roomId) {
        HiidoStatis.reportEvent((HiidoEvent)GiftHiidoReport.event("20032603").put("mode_key", RuntimeContext.useOldRoom() ? "1" : "2").put("room_id", roomId).put("function_id", "get_packet_share_but_click"));
    }

    public static void redPacketShareShow(String roomId) {
        HiidoStatis.reportEvent((HiidoEvent)GiftHiidoReport.event("20032603").put("mode_key", RuntimeContext.useOldRoom() ? "1" : "2").put("room_id", roomId).put("function_id", "get_packet_share_pg_show"));
    }

    public static void redPacketFail(String roomId) {
        HiidoStatis.reportEvent((HiidoEvent)GiftHiidoReport.event("20032603").put("mode_key", RuntimeContext.useOldRoom() ? "1" : "2").put("room_id", roomId).put("function_id", "get_packet_no_show"));
    }

    public static void redPacketPublicClick(int type, String roomId) {
        String functionId = "";
        if (type == 1) {
            functionId = "scr_get_dia_over_click";
        } else if (type == 2) {
            functionId = "scr_get_dia_succ_click";
        } else if (type == 3) {
            functionId = "scr_get_dia_click";
        } else if (type == 4) {
            functionId = "scr_get_dia_list_click";
        }
        HiidoStatis.reportEvent((HiidoEvent)GiftHiidoReport.event("20032603").put("mode_key", RuntimeContext.useOldRoom() ? "1" : "2").put("room_id", roomId).put("function_id", functionId));
    }

    public static void packetFinishMsg(String roomId) {
        HiidoStatis.reportEvent((HiidoEvent)GiftHiidoReport.event("20032603").put("mode_key", RuntimeContext.useOldRoom() ? "1" : "2").put("room_id", roomId).put("function_id", "scr_get_dia_over_show"));
    }

    public static void packetGetSuccessMsg(String roomId) {
        HiidoStatis.reportEvent((HiidoEvent)GiftHiidoReport.event("20032603").put("mode_key", RuntimeContext.useOldRoom() ? "1" : "2").put("room_id", roomId).put("function_id", "scr_get_dia_succ_show"));
    }

    public static void packetGetMsg(String roomId) {
        HiidoStatis.reportEvent((HiidoEvent)GiftHiidoReport.event("20032603").put("mode_key", RuntimeContext.useOldRoom() ? "1" : "2").put("room_id", roomId).put("function_id", "scr_get_dia_list_show"));
    }

    public static void packetSendingMsg(String roomId) {
        HiidoStatis.reportEvent((HiidoEvent)GiftHiidoReport.event("20032603").put("mode_key", RuntimeContext.useOldRoom() ? "1" : "2").put("room_id", roomId).put("function_id", "scr_get_dia_show"));
    }

    public static void redPacketOver(String roomId) {
        HiidoStatis.reportEvent((HiidoEvent)GiftHiidoReport.event("20032603").put("mode_key", RuntimeContext.useOldRoom() ? "1" : "2").put("room_id", roomId).put("function_id", "packet_expire_pop_show"));
    }

    public static void redPacketNoEnoughDialogShow(String roomId) {
        HiidoStatis.reportEvent((HiidoEvent)GiftHiidoReport.event("20032603").put("mode_key", RuntimeContext.useOldRoom() ? "1" : "2").put("room_id", roomId).put("function_id", "dia_no_pop_show"));
    }

    public static void redPacketQueueDialogShow(String roomId) {
        HiidoStatis.reportEvent((HiidoEvent)GiftHiidoReport.event("20032603").put("mode_key", RuntimeContext.useOldRoom() ? "1" : "2").put("room_id", roomId).put("function_id", "line_pg_show"));
    }

    public static void redPacketNoEnoughDialogClick(String roomId) {
        HiidoStatis.reportEvent((HiidoEvent)GiftHiidoReport.event("20032603").put("mode_key", RuntimeContext.useOldRoom() ? "1" : "2").put("room_id", roomId).put("function_id", "dia_no_but_click"));
    }

    public static void redPacketShareClick(String roomId, int channelId) {
        HiidoStatis.reportEvent((HiidoEvent)GiftHiidoReport.event("20032603").put("mode_key", RuntimeContext.useOldRoom() ? "1" : "2").put("room_id", roomId).put("app_type", " " + GiftHiidoReport.transAppTypeFromChannel(channelId)).put("function_id", "share_app_click"));
    }

    public static void redPacketQueueDialogFail(String roomId) {
        HiidoStatis.reportEvent((HiidoEvent)GiftHiidoReport.event("20032603").put("mode_key", RuntimeContext.useOldRoom() ? "1" : "2").put("room_id", roomId).put("function_id", "fai_send_pg_show"));
    }

    public static void onComboShow(int from, String roomId) {
        HiidoStatis.reportEvent((HiidoEvent)GiftHiidoReport.event("20028823").put("mode_key", RuntimeContext.useOldRoom() ? "1" : "2").put("gid", GiftHiidoReport.getPluginId(roomId)).put("gift_panel_enter_type", "" + from).put("function_id", "cont_gift_but_show"));
    }

    public static int transAppTypeFromChannel(int channelId) {
        int appType;
        switch (channelId) {
            case 2: {
                appType = 2;
                break;
            }
            case 5: {
                appType = 3;
                break;
            }
            case 3: {
                appType = 4;
                break;
            }
            case 9: {
                appType = 5;
                break;
            }
            case 1: {
                appType = 1;
                break;
            }
            default: {
                appType = 6;
            }
        }
        return appType;
    }

    public static String getPluginId(String channelid) {
        return sStatListener != null ? sStatListener.getPluginId(channelid) : "";
    }

    public static int getUserRole(String channelId) {
        return sStatListener != null ? sStatListener.getUserRole(channelId) : -1;
    }

    public static String isVideoModel(String channelid) {
        return sStatListener != null ? (sStatListener.isVideoMode(channelid) ? "1" : "2") : "0";
    }

    public static void setStatListener(IGiftStatListener listener) {
        sStatListener = listener;
    }

    public static interface IGiftStatListener {
        public int getUserRole(String var1);

        public String getPluginId(String var1);

        public boolean isVideoMode(String var1);
    }
}

