/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.gift.sdk;

import android.content.Context;
import android.text.TextUtils;
import android.util.SparseArray;
import androidx.annotation.NonNull;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.data.JsonStringBuilder;
import com.yy.appbase.http.BaseResponseBean;
import com.yy.appbase.http.CommonHttpHeader;
import com.yy.appbase.http.HttpUtil;
import com.yy.appbase.http.INetOriginRespByteArrayCallback;
import com.yy.appbase.http.INetRespCallback;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.MD5Utils;
import com.yy.base.utils.ReflectionUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.VersionUtil;
import com.yy.base.utils.json.JsonParser;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.hiyo.wallet.base.GiftChannel;
import com.yy.hiyo.wallet.base.revenue.proto.RevenueProto;
import com.yy.hiyo.wallet.base.revenue.proto.RevenueProtoRes;
import com.yy.hiyo.wallet.gift.data.BuiltinGiftData;
import com.yy.hiyo.wallet.gift.sdk.GiftSdkLog;
import com.yy.hiyo.wallet.gift.sdk.GiftSdkWrapper;
import com.yy.hiyo.wallet.gift.sdk.RevenueReportConfig;
import com.yy.hiyo.wallet.gift.statis.GiftMonitor;
import com.yy.mobile.framework.revenuesdk.IRevenue;
import com.yy.mobile.framework.revenuesdk.RevenueConfig;
import com.yy.mobile.framework.revenuesdk.RevenueSdk;
import com.yy.mobile.framework.revenuesdk.baseapi.data.IRevenueDataSender;
import com.yy.mobile.framework.revenuesdk.baseapi.data.RevenueDataParser;
import com.yy.mobile.framework.revenuesdk.baseapi.log.IRLogDelegate;
import com.yy.mobile.framework.revenuesdk.baseapi.reporter.ReportConfig;
import com.yy.mobile.framework.revenuesdk.gift.CallbackMode;
import com.yy.mobile.framework.revenuesdk.gift.GiftCache;
import com.yy.mobile.framework.revenuesdk.gift.GiftCacheInfo;
import com.yy.mobile.framework.revenuesdk.gift.IGiftRequestCallback;
import com.yy.mobile.framework.revenuesdk.gift.IGiftService;
import com.yy.mobile.framework.revenuesdk.gift.callbackresult.LoadAllGiftResult;
import com.yy.mobile.framework.revenuesdk.gift.requestparam.LoadAllGiftJsonParam;
import com.yy.mobile.framework.revenuesdk.gift.requestparam.LoadAllGiftParam;
import com.yy.yylite.commonbase.hiido.HiidoUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import okhttp3.Call;
import org.json.JSONException;
import org.json.JSONObject;

public class RevenueSdkProxy
implements IRevenueDataSender {
    private static final String TAG = "FTGiftRevenueSdkProxy";
    private RevenueConfig config;
    private IGiftService mRevenueGift;
    private IRevenue mRevenue;

    public static RevenueSdkProxy getInstance() {
        return Holder.INSTANCE;
    }

    private RevenueSdkProxy() {
        long delay = RuntimeContext.sIsAppStartFinishAfterThreeSecond ? 0L : 5000L;
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                RevenueSdkProxy.this.ensureInit();
            }
        }, (long)delay);
    }

    public void loadAllGift(@NonNull LoadAllGiftParam param, @NonNull IGiftRequestCallback<LoadAllGiftResult> callback, boolean forceUpdate) {
        this.ensureInit();
        this.mRevenueGift.loadAllGift(param, callback, forceUpdate);
    }

    public void loadAllGiftJsonData(@NonNull LoadAllGiftJsonParam param, @NonNull IGiftRequestCallback<String> callback, boolean forceUpdate) {
        this.ensureInit();
        this.mRevenueGift.loadAllGiftJsonData(param, callback, forceUpdate);
    }

    public void sendData(final int appId, final String seq, ArrayList<Integer> retry, final Map<String, String> header, final byte[] data) {
        if (data == null) {
            MLog.error((Object)TAG, (String)"sendData data is null", (Object[])new Object[0]);
            return;
        }
        this.ensureInit();
        if (YYTaskExecutor.isMainThread()) {
            YYTaskExecutor.execute((Runnable)new Runnable(){

                @Override
                public void run() {
                    RevenueSdkProxy.this.sendDataAsync(appId, seq, header, data);
                }
            });
        } else {
            this.sendDataAsync(appId, seq, header, data);
        }
    }

    private void sendDataAsync(final int appId, final String seq, Map<String, String> header, byte[] data) {
        String dataStr = StringUtils.byteToStringUtf8((byte[])data);
        int cmd = -1;
        long anchorUid = 0L;
        int usedChannel = 0;
        try {
            JSONObject jo = JsonParser.obtainJSONObject((String)dataStr);
            cmd = jo.optInt("cmd");
            String jsonMsg = jo.optString("jsonMsg", "");
            if (!TextUtils.isEmpty((CharSequence)jsonMsg)) {
                JSONObject jsonMsgJo = JsonParser.obtainJSONObject((String)jsonMsg);
                if (cmd == 1010) {
                    usedChannel = jsonMsgJo.optInt("usedChannel", GiftChannel.VOICE_ROOM_USED_CHANNEL.getChannel());
                    anchorUid = jsonMsgJo.optLong("recvUid", 0L);
                }
                this.appExpand(cmd, jsonMsgJo);
                jo.put("jsonMsg", (Object)jsonMsgJo);
            }
            dataStr = jo.toString();
        }
        catch (JSONException e) {
            MLog.error((Object)TAG, (Throwable)e);
            e.printStackTrace();
        }
        if (cmd <= 0) {
            return;
        }
        String sign = MD5Utils.getMd5StringNew((String)("turnover" + dataStr));
        HashMap<String, String> params = new HashMap<String, String>(2);
        params.put("sign", sign);
        params.put("data", dataStr);
        String code = AccountUtil.registerCountry();
        String url = RevenueProto.getUrl((String)"api", (int)cmd);
        Map cHeader = CommonHttpHeader.getRevenueHeaderMap((String)code);
        if (header != null && !header.isEmpty()) {
            cHeader.putAll(header);
        }
        if (RuntimeContext.sIsDebuggable) {
            if (!MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)TAG, (String)"sendDataAsync code: %s, seq: %s, url: %s, cHeader: %s", (Object[])new Object[]{code, seq, url, cHeader});
            }
            if (!MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)TAG, (String)"sendDataAsync sign: %s, data: %s", (Object[])new Object[]{sign, dataStr});
            }
        } else {
            MLog.info((Object)TAG, (String)"sendDataAsync code: %s, seq: %s, url: %s", (Object[])new Object[]{code, seq, url});
        }
        HttpUtil.httpReq((String)url, params, (int)2, (INetRespCallback)new INetOriginRespByteArrayCallback(){

            public void onError(Call call, Exception e, int id2) {
                MLog.error((Object)RevenueSdkProxy.TAG, (String)"sendDataAsync onError", (Throwable)e, (Object[])new Object[0]);
                int code = NetworkUtils.getErrorCodeByExc((Throwable)e);
                GiftMonitor.reportMetr(seq, String.valueOf(code));
                RevenueDataParser.INSTANCE.onRequestError(appId, seq, 10002, code, e.getMessage());
                GiftMonitor.resGiftList(seq, code, e.getMessage());
            }

            public void onResponse(String response, BaseResponseBean<byte[]> res, int id2) {
                if (RuntimeContext.isInGray()) {
                    MLog.info((Object)RevenueSdkProxy.TAG, (String)("sendDataAsync onResponse size = " + (res.data == null ? -1 : ((byte[])res.data).length) + "  response = " + response), (Object[])new Object[0]);
                }
                GiftMonitor.reportMetr(seq, "0");
                YYTaskExecutor.execute(() -> RevenueSdkProxy.this.handleRes(seq, (byte[])res.data));
            }
        }, (Map)cHeader);
        GiftMonitor.reqGiftList(seq, cmd, usedChannel, anchorUid);
    }

    private void appExpand(int cmd, JSONObject jsonMsg) {
        if (cmd == 1010) {
            JsonStringBuilder expand = JsonStringBuilder.newBuilder();
            expand.put("userRC", (Object)AccountUtil.realCountry().toUpperCase());
            String expandStr = jsonMsg.optString("expand");
            if (!TextUtils.isEmpty((CharSequence)expandStr)) {
                expand.merge(expandStr);
            }
            try {
                jsonMsg.put("expand", (Object)expand.buildJson());
            }
            catch (JSONException e) {
                MLog.error((Object)TAG, (Throwable)e);
            }
        }
    }

    private void handleRes(String seq, byte[] response) {
        if (!this.handleError(seq, response)) {
            RevenueDataParser.INSTANCE.parserRevenueResponseData(response);
            GiftMonitor.resGiftList(seq, 1, "success");
        }
    }

    private boolean handleError(String seq, byte[] response) {
        String str = StringUtils.byteToStringUtf8((byte[])response);
        if (RuntimeContext.sIsDebuggable && !MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"sendDataAsync response: %s", (Object[])new Object[]{str});
        }
        try {
            RevenueProtoRes res = (RevenueProtoRes)JsonParser.parseJsonObject((String)str, RevenueProtoRes.class);
            if (res.appId != 1802) {
                String msg = StringUtils.formatWitUSLocal((String)"response with error appId: %d, result: %d", (Object[])new Object[]{res.appId, res.result});
                MLog.error((Object)TAG, (String)msg, (Object[])new Object[0]);
                CallbackMode.getInstance().onCallbackFail(seq, 21000 + res.result, msg);
                GiftMonitor.resGiftList(seq, 21000 + res.result, msg);
                return true;
            }
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (Throwable)e);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void ensureInit() {
        if (this.mRevenueGift != null) return;
        Class<GiftSdkWrapper> clazz = GiftSdkWrapper.class;
        synchronized (GiftSdkWrapper.class) {
            if (this.mRevenueGift != null) return;
            MLog.info((Object)TAG, (String)"init gift sdk start", (Object[])new Object[0]);
            int appId = 1802;
            String appName = RuntimeContext.sPackageName;
            RevenueConfig.RevenueConfigBuilder config = RevenueConfig.RevenueConfigBuilder.aRevenueConfig();
            config.setUid(AccountUtil.getUid());
            config.setHdid(HiidoUtils.getHdid());
            config.setContext(RuntimeContext.sApplicationContext);
            config.setCountryCode(AccountUtil.realCountry());
            config.setCurrencyType(1805);
            config.setUsedChannel(GiftChannel.VOICE_ROOM_USED_CHANNEL.getChannel());
            config.setDataSender((IRevenueDataSender)this);
            config.setClientVersion(VersionUtil.getLocalName((Context)RuntimeContext.sApplicationContext));
            config.setReportConfig((ReportConfig)new RevenueReportConfig("" + appId, appName));
            this.config = config.build();
            RevenueSdk.initRevenue((int)appId, (RevenueConfig)this.config);
            RevenueSdk.addLogDelegate((IRLogDelegate)new GiftSdkLog());
            this.mRevenue = RevenueSdk.getRevenue((int)1802);
            this.mRevenueGift = this.mRevenue.getGiftService();
            MLog.info((Object)TAG, (String)"init gift sdk finish", (Object[])new Object[0]);
            this.checkDefaultGift();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public IRevenue getRevenue() {
        this.ensureInit();
        return this.mRevenue;
    }

    public void clearSdkCache() {
        if (this.mRevenueGift == null) {
            return;
        }
        try {
            this.clearSafe();
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (String)"clearSekCache", (Throwable)e, (Object[])new Object[0]);
        }
    }

    private void clearSafe() throws Exception {
        Class<?> cls = this.mRevenueGift.getClass();
        GiftCache giftCache = (GiftCache)ReflectionUtils.getFieldValue((Object)this.mRevenueGift, (String)"mGiftCache");
        Map cacheGiftMap = (Map)ReflectionUtils.getFieldValue((Object)giftCache, (String)"cacheGiftMap");
        MLog.debug((Object)TAG, (String)"clearSafe cacheGiftMap: %d", (Object[])new Object[]{FP.size((Map)cacheGiftMap)});
        if (cacheGiftMap != null) {
            cacheGiftMap.clear();
        }
        SparseArray allGiftInfos = (SparseArray)ReflectionUtils.getFieldValue((Object)giftCache, (String)"allGiftInfos");
        MLog.debug((Object)TAG, (String)"clearSafe allGiftInfos: %d", (Object[])new Object[]{FP.size((SparseArray)allGiftInfos)});
        if (allGiftInfos != null) {
            allGiftInfos.clear();
        }
        SparseArray giftInfoMap = (SparseArray)ReflectionUtils.getFieldValue((Object)giftCache, (String)"giftInfoMap");
        MLog.debug((Object)TAG, (String)"clearSafe giftInfoMap: %d", (Object[])new Object[]{FP.size((SparseArray)allGiftInfos)});
        if (giftInfoMap != null) {
            giftInfoMap.clear();
        }
        Map giftCacheInfoMap = (Map)ReflectionUtils.getFieldValue((Object)giftCache, (String)"giftCacheInfoMap");
        MLog.debug((Object)TAG, (String)"clearSafe giftCacheInfoMap: %d", (Object[])new Object[]{FP.size((Map)giftCacheInfoMap)});
        if (!FP.empty((Map)giftCacheInfoMap)) {
            for (GiftCacheInfo info : giftCacheInfoMap.values()) {
                ReflectionUtils.setReflectField((Object)info, (String)"compressData", (Object)"");
            }
        }
    }

    private boolean checkDefaultGift() {
        byte[] data;
        if (FP.empty((Collection)this.mRevenueGift.getAllGift(GiftChannel.VOICE_ROOM_USED_CHANNEL.getChannel())) && (data = BuiltinGiftData.getDefaultData(AccountUtil.registerCountry())) != null) {
            RevenueDataParser.INSTANCE.parserRevenueResponseData(data);
            return true;
        }
        return false;
    }

    public RevenueConfig getConfig() {
        return this.config;
    }

    private static final class Holder {
        public static final RevenueSdkProxy INSTANCE = new RevenueSdkProxy();

        private Holder() {
        }
    }
}

