/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.gift.sdk;

import androidx.annotation.NonNull;
import com.yy.appbase.unifyconfig.config.ScenePerfOptSceneDef;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.IQueueTaskExecutor;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.SystemUtils;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.thirdnotify.IThirdNotify;
import com.yy.hiyo.proto.thirdnotify.ThirdNotifyUri;
import com.yy.hiyo.wallet.base.revenue.gift.bean.GiftBroResult;
import com.yy.hiyo.wallet.base.revenue.gift.bean.GiftBroadcastMessage;
import com.yy.hiyo.wallet.base.revenue.gift.bean.GiftMulBroadcastMessage;
import com.yy.hiyo.wallet.base.revenue.gift.bean.GiftPushBroMessage;
import com.yy.hiyo.wallet.gift.sdk.GiftBroadcastParse;
import com.yy.hiyo.wallet.gift.sdk.IGiftBroListener;
import com.yy.hiyo.wallet.gift.sdk.IGiftBroadcast;
import com.yy.hiyo.wallet.gift.sdk.IGiftPushBroListener;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

class GiftBroadcast
implements IGiftBroadcast {
    private static final String TAG = "FTGiftBroadcast";
    private GiftBroadcastParse mBroParse;
    private List<IGiftBroListener<GiftBroResult>> mBroadcastListeners = new CopyOnWriteArrayList<IGiftBroListener<GiftBroResult>>();
    private List<IGiftPushBroListener<GiftPushBroMessage>> mPushListeners = new CopyOnWriteArrayList<IGiftPushBroListener<GiftPushBroMessage>>();
    private IQueueTaskExecutor mQueueTaskExecutor = YYTaskExecutor.createAQueueExcuter();
    private IThirdNotify<GiftBroadcastMessage> mSendGiftBro = new IThirdNotify<GiftBroadcastMessage>(){

        public ThirdNotifyUri.Uri uri() {
            return ThirdNotifyUri.GIFT_BROADCAST;
        }

        public void onNotify(@NonNull GiftBroadcastMessage notify) {
            MLog.info((Object)GiftBroadcast.TAG, (String)"mSendGiftBro notify: %d", (Object[])new Object[]{notify.getPropsId()});
            GiftBroadcast.this.handleGiftBro(notify);
        }
    };
    private IThirdNotify<GiftMulBroadcastMessage> mSendMultipleGifttBro = new IThirdNotify<GiftMulBroadcastMessage>(){

        public ThirdNotifyUri.Uri uri() {
            return ThirdNotifyUri.GIFT_MULTIPLE_BROADCAST;
        }

        public void onNotify(@NonNull GiftMulBroadcastMessage notify) {
            MLog.info((Object)GiftBroadcast.TAG, (String)"mSendMulGiftBro notify: %d", (Object[])new Object[]{notify.getPropsId()});
            GiftBroadcast.this.handleGiftMulBro(notify);
        }
    };
    private IThirdNotify<GiftPushBroMessage> mSendGiftPush = new IThirdNotify<GiftPushBroMessage>(){

        public ThirdNotifyUri.Uri uri() {
            return ThirdNotifyUri.GIFT_PUSH;
        }

        public void onNotify(@NonNull GiftPushBroMessage notify) {
            MLog.info((Object)GiftBroadcast.TAG, (String)"mSendGiftPush notify: %d", (Object[])new Object[]{notify.getPropsId()});
            GiftBroadcast.this.execute(() -> GiftBroadcast.this.handleGiftPushBro(notify));
        }
    };
    private IThirdNotify<GiftBroadcastMessage> mComboGiftBro = new IThirdNotify<GiftBroadcastMessage>(){

        public ThirdNotifyUri.Uri uri() {
            return ThirdNotifyUri.GIFT_COMBO_FINISH_BBROADCAST;
        }

        public void onNotify(@NonNull GiftBroadcastMessage notify) {
            MLog.info((Object)GiftBroadcast.TAG, (String)"mComboGiftBro notify: %d", (Object[])new Object[]{notify.getPropsId()});
            GiftBroadcast.this.handleGiftBro(notify);
        }
    };

    public GiftBroadcast() {
        this.mBroParse = new GiftBroadcastParse();
        ProtoManager.getInstance().registerThirdNotify(GiftBroadcastMessage.class, this.mSendGiftBro);
        ProtoManager.getInstance().registerThirdNotify(GiftPushBroMessage.class, this.mSendGiftPush);
        ProtoManager.getInstance().registerThirdNotify(GiftBroadcastMessage.class, this.mComboGiftBro);
        ProtoManager.getInstance().registerThirdNotify(GiftMulBroadcastMessage.class, this.mSendMultipleGifttBro);
    }

    @Override
    public void registerBroadcast(IGiftBroListener<GiftBroResult> bro) {
        if (bro == null) {
            return;
        }
        if (!this.mBroadcastListeners.contains(bro)) {
            this.mBroadcastListeners.add(bro);
        }
    }

    @Override
    public void unregisterBroadcast(IGiftBroListener<GiftBroResult> bro) {
        if (bro == null) {
            return;
        }
        if (this.mBroadcastListeners.contains(bro)) {
            this.mBroadcastListeners.remove(bro);
        }
    }

    @Override
    public void registerPush(IGiftPushBroListener<GiftPushBroMessage> bro) {
        if (bro == null) {
            return;
        }
        if (!this.mPushListeners.contains(bro)) {
            this.mPushListeners.add(bro);
        }
    }

    @Override
    public void unregisterPush(IGiftPushBroListener<GiftPushBroMessage> bro) {
        if (bro == null) {
            return;
        }
        if (this.mPushListeners.contains(bro)) {
            this.mPushListeners.remove(bro);
        }
    }

    private void handleGiftMulBro(GiftMulBroadcastMessage notify) {
        this.execute(() -> this.handleGiftMulBroAsync(notify));
    }

    private void handleGiftBro(@NonNull GiftBroadcastMessage notify) {
        this.execute(() -> this.handleGiftBroAsync(notify));
    }

    private void handleGiftBroAsync(GiftBroadcastMessage notify) {
        GiftBroResult result = this.mBroParse.handleGiftBro(notify);
        if (result != null && result.getGiftInfo() != null) {
            this.notifyResult(notify.getBusinessType(), result);
            this.pressureTestGift(notify);
        } else {
            MLog.error((Object)TAG, (String)"handleGiftBroAsync result or giftInfo is null", (Object[])new Object[0]);
        }
    }

    private void execute(Runnable runnable2) {
        this.mQueueTaskExecutor.execute(runnable2, 0L);
    }

    private void pressureTestGift(GiftBroadcastMessage notify) {
        if (ScenePerfOptSceneDef.isScenePressure((String)"gift") || SystemUtils.isShowEnvSetting() && SettingFlags.getIntValue((String)"env_svga_gift_ani_test", (int)-1) == 1) {
            for (int i = 1; i < 100; ++i) {
                int add = i;
                YYTaskExecutor.postToMainThread(() -> {
                    GiftBroResult result = this.mBroParse.handleGiftBro(notify);
                    if (result != null && result.getGiftInfo() != null) {
                        result.getGiftComboInfo().increaseCombo(add);
                        this.notifyResult(notify.getBusinessType(), result);
                    }
                }, (long)(1000 * i));
            }
        }
    }

    private void pressureTestMultiGift(GiftMulBroadcastMessage notify) {
        if (ScenePerfOptSceneDef.isScenePressure((String)"gift") || SystemUtils.isShowEnvSetting() && SettingFlags.getIntValue((String)"env_svga_gift_ani_test", (int)-1) == 1) {
            for (int i = 1; i < 100; ++i) {
                int add = i;
                YYTaskExecutor.postToMainThread(() -> {
                    GiftBroResult result = this.mBroParse.handleGiftBro(notify);
                    if (result != null && result.getGiftInfo() != null) {
                        result.getGiftComboInfo().increaseCombo(add);
                        this.notifyResult(notify.getBusinessType(), result);
                    }
                }, (long)(1000 * i));
            }
        }
    }

    private void handleGiftMulBroAsync(GiftMulBroadcastMessage notify) {
        GiftBroResult result = this.mBroParse.handleGiftBro(notify);
        if (result != null && result.getGiftInfo() != null) {
            this.notifyResult(notify.getBusinessType(), result);
            this.pressureTestMultiGift(notify);
        } else {
            MLog.error((Object)TAG, (String)"handleGiftMulBroAsync result or giftInfo is null", (Object[])new Object[0]);
        }
    }

    private void handleGiftPushBro(GiftPushBroMessage notify) {
        if (FP.empty(this.mPushListeners) || notify == null) {
            MLog.info((Object)TAG, (String)"notifyResult mPushListeners.size = 0", (Object[])new Object[0]);
            return;
        }
        this.mBroParse.handleParseGiftItemInfo(notify);
        for (IGiftPushBroListener<GiftPushBroMessage> callback : this.mPushListeners) {
            if (callback == null) continue;
            callback.onPushBroadcast(notify);
        }
    }

    private void notifyResult(int bussiness, @NonNull GiftBroResult result) {
        if (FP.empty(this.mBroadcastListeners)) {
            MLog.info((Object)TAG, (String)"notifyResult mBroadcastListeners.size = 0", (Object[])new Object[0]);
            return;
        }
        for (IGiftBroListener<GiftBroResult> callback : this.mBroadcastListeners) {
            this.callbackSucceed(callback, result, bussiness);
        }
    }

    private <T> void callbackSucceed(IGiftBroListener<T> callback, @NonNull T res, int bussinessType) {
        if (callback == null) {
            return;
        }
        if (YYTaskExecutor.isMainThread()) {
            callback.onBroadcast(res);
        } else {
            YYTaskExecutor.postToMainThread(() -> callback.onBroadcast(res));
        }
    }
}

