/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.gift.pack;

import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.data.JsonStringBuilder;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.json.JsonParser;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.hiyo.wallet.base.revenue.gift.GiftUtils;
import com.yy.hiyo.wallet.base.revenue.gift.event.IGiftCallback;
import com.yy.hiyo.wallet.base.revenue.proto.RevenueProto;
import com.yy.hiyo.wallet.base.revenue.proto.RevenueProtoReq;
import com.yy.hiyo.wallet.base.revenue.proto.RevenueProtoRes;
import com.yy.hiyo.wallet.gift.data.param.LoadPackageArgv;
import com.yy.hiyo.wallet.gift.pack.PackageGiftRequest;
import com.yy.hiyo.wallet.gift.pack.PackageGiftRes;
import com.yy.hiyo.wallet.gift.pack.PropsItem;
import com.yy.hiyo.wallet.gift.statis.GiftMonitor;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Call;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0014\u0010\u0007\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t\u0018\u00010\bH\u0002J$\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0014\u0010\u0007\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t\u0018\u00010\bJ&\u0010\u000e\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0014\u0010\u0007\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t\u0018\u00010\bH\u0002\u00a8\u0006\u000f"}, d2={"Lcom/yy/hiyo/wallet/gift/pack/PackageGiftRequest;", "", "()V", "handleRes", "", "response", "Lcom/yy/hiyo/wallet/base/revenue/proto/RevenueProtoRes;", "callback", "Lcom/yy/hiyo/wallet/base/revenue/gift/event/IGiftCallback;", "", "Lcom/yy/hiyo/wallet/gift/pack/PropsItem;", "request", "argv", "Lcom/yy/hiyo/wallet/gift/data/param/LoadPackageArgv;", "requestAsync", "wallet_billDebug"})
public final class PackageGiftRequest {
    public final void request(@NotNull LoadPackageArgv argv, @Nullable IGiftCallback<List<PropsItem>> callback) {
        Intrinsics.checkParameterIsNotNull((Object)argv, (String)"argv");
        boolean $i$f$onWork = false;
        if (YYTaskExecutor.isMainThread()) {
            YYTaskExecutor.execute((Runnable)new Runnable(this, argv, callback){
                final /* synthetic */ PackageGiftRequest this$0;
                final /* synthetic */ LoadPackageArgv $argv$inlined;
                final /* synthetic */ IGiftCallback $callback$inlined;
                {
                    this.this$0 = packageGiftRequest;
                    this.$argv$inlined = loadPackageArgv;
                    this.$callback$inlined = iGiftCallback;
                }

                public final void run() {
                    boolean bl = false;
                    PackageGiftRequest.access$requestAsync(this.this$0, this.$argv$inlined, this.$callback$inlined);
                }
            });
        } else {
            boolean bl = false;
            this.requestAsync(argv, (IGiftCallback<List<PropsItem>>)callback);
        }
    }

    private final void requestAsync(LoadPackageArgv argv, IGiftCallback<List<PropsItem>> callback) {
        RevenueProtoReq req;
        int cmd = 1012;
        RevenueProtoReq.Builder builder = RevenueProtoReq.newBuilder();
        builder.appId(1802);
        builder.version(0);
        builder.cmd(cmd);
        builder.countryCode(AccountUtil.realCountry());
        String seq = RevenueProto.uniqueSeq();
        JsonStringBuilder param = RevenueProto.getCommonParam();
        param.put("cmd", (Object)cmd);
        param.put("seq", (Object)seq);
        param.put("uid", (Object)AccountUtil.getUid());
        param.put("appId", (Object)1802);
        param.put("usedChannel", (Object)argv.channelId);
        builder.jsonMsg(param.jsonObject());
        RevenueProtoReq revenueProtoReq = req = builder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)revenueProtoReq, (String)"req");
        String url = RevenueProto.getUrl((String)"query", (int)revenueProtoReq.getCmd());
        GiftMonitor.reqGiftList(seq, cmd, argv.channelId, 0L);
        RevenueProto.sendHttp((String)url, (RevenueProtoReq)req, (RevenueProto.RevenueProtoCallback)new RevenueProto.RevenueProtoCallback(this, callback, seq){
            final /* synthetic */ PackageGiftRequest this$0;
            final /* synthetic */ IGiftCallback $callback;
            final /* synthetic */ String $seq;

            public void onError(@NotNull Call call, @NotNull Exception e, int id2) {
                Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                MLog.error((Object)"PackageGiftRequest", (String)"requestAsync onError", (Throwable)e, (Object[])new Object[0]);
                String msg = e.getMessage();
                int code = NetworkUtils.getErrorCodeByExc((Throwable)e);
                GiftUtils.callbackFailed((IGiftCallback)this.$callback, (int)10002, (String)msg);
                GiftMonitor.reportMetr(this.$seq, String.valueOf(code));
                GiftMonitor.resGiftList(this.$seq, code, msg);
            }

            public void onResponse(@NotNull RevenueProtoRes response, int id2) {
                Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
                GiftMonitor.reportMetr(this.$seq, "0");
                GiftMonitor.resGiftList(this.$seq, 1, "success");
                if (YYTaskExecutor.isMainThread()) {
                    YYTaskExecutor.execute((Runnable)new Runnable(this, response){
                        final /* synthetic */ requestAsync.1 this$0;
                        final /* synthetic */ RevenueProtoRes $response;

                        public final void run() {
                            PackageGiftRequest.access$handleRes(this.this$0.this$0, this.$response, this.this$0.$callback);
                        }
                        {
                            this.this$0 = var1_1;
                            this.$response = revenueProtoRes;
                        }
                    });
                } else {
                    PackageGiftRequest.access$handleRes(this.this$0, response, this.$callback);
                }
            }
            {
                this.this$0 = $outer;
                this.$callback = $captured_local_variable$1;
                this.$seq = $captured_local_variable$2;
            }
        });
    }

    private final void handleRes(RevenueProtoRes response, IGiftCallback<List<PropsItem>> callback) {
        PackageGiftRes res = (PackageGiftRes)JsonParser.parseJsonObject((String)response.jsonMsg, PackageGiftRes.class);
        if (res == null) {
            MLog.error((Object)"PackageGiftRequest", (String)"parse jsonMsg is null", (Object[])new Object[0]);
            GiftUtils.callbackFailed(callback, (int)10003, (String)"parse jsonMsg is null");
            return;
        }
        IGiftCallback<List<PropsItem>> iGiftCallback = callback;
        List list = res.getPropsList();
        if (list == null) {
            IGiftCallback<List<PropsItem>> iGiftCallback2 = iGiftCallback;
            boolean bl = false;
            List list2 = new ArrayList();
            iGiftCallback = iGiftCallback2;
            list = list2;
        }
        GiftUtils.callbackSucceed(iGiftCallback, list);
    }

    public static final /* synthetic */ void access$handleRes(PackageGiftRequest $this, RevenueProtoRes response, IGiftCallback callback) {
        $this.handleRes(response, (IGiftCallback<List<PropsItem>>)callback);
    }
}

