/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.gift.model;

import android.util.LongSparseArray;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.squareup.wire.AndroidMessage;
import com.yy.appbase.account.AccountUtil;
import com.yy.base.logger.MLog;
import com.yy.base.utils.DateUtils;
import com.yy.base.utils.FP;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.IProtoCallback;
import com.yy.hiyo.proto.callback.SimpleProtoCallback;
import com.yy.hiyo.wallet.base.revenue.gift.bean.ActivityPropertyInfo;
import com.yy.hiyo.wallet.base.revenue.gift.bean.SendGiftGuideInfo;
import com.yy.hiyo.wallet.base.revenue.gift.event.IGiftCallback;
import com.yy.hiyo.wallet.gift.data.bean.ArGiftInfo;
import com.yy.hiyo.wallet.gift.data.bean.CheckGiftInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.ihago.act.api.luckygift.GetPeriodPoolInfoReq;
import net.ihago.act.api.luckygift.GetPeriodPoolInfoRes;
import net.ihago.active.api.activity.ActItemGetReq;
import net.ihago.active.api.activity.ActItemGetRes;
import net.ihago.active.api.activity.FreeGiftGetLimitReq;
import net.ihago.active.api.activity.FreeGiftGetLimitRes;
import net.ihago.active.api.activity.FreeGiftGetReq;
import net.ihago.active.api.activity.FreeGiftGetRes;
import net.ihago.active.api.activity.GiftType;
import net.ihago.active.api.activity.SendGiftNotifyGetReq;
import net.ihago.active.api.activity.SendGiftNotifyGetRes;
import net.ihago.argift.srv.upgrade.ARGift;
import net.ihago.argift.srv.upgrade.GetARGiftReq;
import net.ihago.argift.srv.upgrade.GetARGiftsRes;
import net.ihago.money.api.firstrechargeac.GetGiftInfosReq;
import net.ihago.money.api.firstrechargeac.GetGiftInfosRes;
import net.ihago.money.api.firstrechargeac.GiftInfo;
import net.ihago.money.api.giftpanel.GetGiftDescriptionReq;
import net.ihago.money.api.giftpanel.GetGiftDescriptionRes;
import net.ihago.money.api.weekgift.GiftPanelReq;
import net.ihago.money.api.weekgift.GiftPanelRes;

public class GiftOperationModel {
    public static final String TAG = "GiftOperationModel";

    public void addGiftFloatTime(int id2) {
        long lastTime = SettingFlags.getLongValue((String)(AccountUtil.getUid() + "key_last_gift_float_time" + id2));
        if (lastTime != -1L) {
            MLog.info((Object)TAG, (String)"addGiftFloatTime, float gift ever : %s", (Object[])new Object[]{id2});
            if (DateUtils.isOverZeroPoint((long)lastTime)) {
                MLog.info((Object)TAG, (String)"addGiftFloatTime, over zero point : %s", (Object[])new Object[]{id2});
                SettingFlags.setIntValue((String)(AccountUtil.getUid() + "key_gift_float_times" + id2), (int)1);
            } else {
                int times = SettingFlags.getIntValue((String)(AccountUtil.getUid() + "key_gift_float_times" + id2), (int)0);
                SettingFlags.setIntValue((String)(AccountUtil.getUid() + "key_gift_float_times" + id2), (int)(++times));
                MLog.info((Object)TAG, (String)"addGiftFloatTime, float at same day, id = %s, float times = %s", (Object[])new Object[]{id2, times});
            }
        } else {
            MLog.info((Object)TAG, (String)"addGiftFloatTime, never float gift : %s", (Object[])new Object[]{id2});
            SettingFlags.setIntValue((String)(AccountUtil.getUid() + "key_gift_float_times" + id2), (int)1);
        }
        SettingFlags.setLongValue((String)(AccountUtil.getUid() + "key_last_gift_float_time" + id2), (long)System.currentTimeMillis());
    }

    public void addGiftTotalCount(int id2, int addCount) {
        if (addCount <= 0) {
            return;
        }
        int count = SettingFlags.getIntValue((String)(AccountUtil.getUid() + "key_gift_count_total" + id2), (int)0);
        MLog.info((Object)TAG, (String)"addGiftTotalCount, never float gift : id = %s, addCount = %s, old count = %s", (Object[])new Object[]{id2, addCount, count});
        SettingFlags.setIntValue((String)(AccountUtil.getUid() + "key_gift_count_total" + id2), (int)(count += addCount));
    }

    public void addCollectCountDaily(int id2, int addCount) {
        if (addCount <= 0) {
            return;
        }
        long lastTime = SettingFlags.getLongValue((String)(AccountUtil.getUid() + "key_last_collect_time" + id2));
        if (lastTime != -1L) {
            MLog.info((Object)TAG, (String)"addCollectCountDaily, collect gift ever : id = %s", (Object[])new Object[]{id2});
            if (DateUtils.isOverZeroPoint((long)lastTime)) {
                MLog.info((Object)TAG, (String)"addCollectCountDaily, over zero point : id = %s, addcount = %s", (Object[])new Object[]{id2, addCount});
                SettingFlags.setIntValue((String)(AccountUtil.getUid() + "key_gift_collect_count_daily" + id2), (int)addCount);
            } else {
                int count = SettingFlags.getIntValue((String)(AccountUtil.getUid() + "key_gift_collect_count_daily" + id2), (int)0);
                MLog.info((Object)TAG, (String)"addCollectCountDaily, collect at same day, id = %s, addCount = %s, old count = %s", (Object[])new Object[]{id2, addCount, count});
                SettingFlags.setIntValue((String)(AccountUtil.getUid() + "key_gift_collect_count_daily" + id2), (int)(count += addCount));
            }
        } else {
            SettingFlags.setIntValue((String)(AccountUtil.getUid() + "key_gift_collect_count_daily" + id2), (int)addCount);
        }
        SettingFlags.setLongValue((String)(AccountUtil.getUid() + "key_last_collect_time" + id2), (long)System.currentTimeMillis());
    }

    public void reduceTotalCount(int id2, int reduceCount) {
        if (reduceCount <= 0) {
            return;
        }
        int count = SettingFlags.getIntValue((String)(AccountUtil.getUid() + "key_gift_count_total" + id2), (int)0);
        if (reduceCount >= count) {
            SettingFlags.setIntValue((String)(AccountUtil.getUid() + "key_gift_count_total" + id2), (int)0);
        } else if (reduceCount <= count) {
            SettingFlags.setIntValue((String)(AccountUtil.getUid() + "key_gift_count_total" + id2), (int)(count -= reduceCount));
        } else {
            SettingFlags.setIntValue((String)(AccountUtil.getUid() + "key_gift_count_total" + id2), (int)0);
        }
    }

    public int getFloatTimes(int propsId) {
        long lastTime = SettingFlags.getLongValue((String)(AccountUtil.getUid() + "key_last_gift_float_time" + propsId));
        if (lastTime == -1L) {
            return 0;
        }
        if (DateUtils.isOverZeroPoint((long)lastTime)) {
            return 0;
        }
        return SettingFlags.getIntValue((String)(AccountUtil.getUid() + "key_gift_float_times" + propsId));
    }

    public void addSendGiftTime() {
        SettingFlags.setLongValue((String)(AccountUtil.getUid() + "key_last_send_gift_time"), (long)System.currentTimeMillis());
    }

    public long getLastSendGiftTime() {
        return SettingFlags.getLongValue((String)(AccountUtil.getUid() + "key_last_send_gift_time"));
    }

    public int getTotalCount(int propsId) {
        return SettingFlags.getIntValue((String)(AccountUtil.getUid() + "key_gift_count_total" + propsId));
    }

    public int getCollectCountPerDay(int propsId) {
        long lastTime = SettingFlags.getLongValue((String)(AccountUtil.getUid() + "key_last_collect_time" + propsId));
        if (lastTime == -1L) {
            return 0;
        }
        if (DateUtils.isOverZeroPoint((long)lastTime)) {
            return 0;
        }
        return SettingFlags.getIntValue((String)(AccountUtil.getUid() + "key_gift_collect_count_daily" + propsId));
    }

    public void requestFreeGiftLimit(String roomId, final SimpleProtoCallback<FreeGiftGetLimitRes> callback) {
        if (roomId == null) {
            roomId = "";
        }
        FreeGiftGetLimitReq req = new FreeGiftGetLimitReq.Builder().build();
        ProtoManager.getInstance().sendRpc(roomId, (AndroidMessage)req, (IProtoCallback)new SimpleProtoCallback<FreeGiftGetLimitRes>(){

            public void onResponse(@Nullable FreeGiftGetLimitRes message) {
                if (callback != null) {
                    callback.onResponse((AndroidMessage)message);
                }
            }

            public void onError(String reason, int code) {
                if (callback != null) {
                    callback.onError(reason, code);
                }
            }
        });
    }

    public void requestCollectFreeGift(String propsId, final SimpleProtoCallback<FreeGiftGetRes> callback) {
        FreeGiftGetReq req = new FreeGiftGetReq.Builder().prop_id(Long.valueOf(StringUtils.parseLong((String)propsId))).build();
        ProtoManager.getInstance().sendRpc((AndroidMessage)req, (IProtoCallback)new SimpleProtoCallback<FreeGiftGetRes>(){

            public void onResponse(@Nullable FreeGiftGetRes message) {
                if (callback != null) {
                    callback.onResponse((AndroidMessage)message);
                }
            }

            public void onError(String reason, int code) {
                if (callback != null) {
                    callback.onError(reason, code);
                }
            }
        });
    }

    public void requestCollectActivityProperty(ActivityPropertyInfo info, final SimpleProtoCallback<ActItemGetRes> callback) {
        if (info == null) {
            return;
        }
        ActItemGetReq req = new ActItemGetReq.Builder().item_id(Long.valueOf(info.getItemId())).type(Integer.valueOf(info.getType())).token(info.getToken()).build();
        ProtoManager.getInstance().sendRpc((AndroidMessage)req, (IProtoCallback)new SimpleProtoCallback<ActItemGetRes>(){

            public void onResponse(@Nullable ActItemGetRes message) {
                super.onResponse((AndroidMessage)message);
                if (callback != null) {
                    callback.onResponse((AndroidMessage)message);
                }
            }

            public void onError(String reason, int code) {
                super.onError(reason, code);
                if (callback != null) {
                    callback.onError(reason, code);
                }
            }
        });
    }

    public void reportSendGiftGuideShow(SendGiftGuideInfo info, final SimpleProtoCallback<SendGiftNotifyGetRes> callback) {
        if (info == null) {
            return;
        }
        SendGiftNotifyGetReq req = new SendGiftNotifyGetReq.Builder().token(info.getToken()).type(GiftType.fromValue((int)info.getGiftType())).build();
        ProtoManager.getInstance().sendRpc((AndroidMessage)req, (IProtoCallback)new SimpleProtoCallback<SendGiftNotifyGetRes>(){

            public void onResponse(@Nullable SendGiftNotifyGetRes message) {
                super.onResponse((AndroidMessage)message);
                if (callback != null) {
                    callback.onResponse((AndroidMessage)message);
                }
            }

            public void onError(String reason, int code) {
                super.onError(reason, code);
                if (callback != null) {
                    callback.onError(reason, code);
                }
            }
        });
    }

    public void requestPrizePoolInfo(int propId, final SimpleProtoCallback<GetPeriodPoolInfoRes> callback) {
        GetPeriodPoolInfoReq req = new GetPeriodPoolInfoReq.Builder().prop_id(Integer.valueOf(propId)).build();
        ProtoManager.getInstance().sendRpc((AndroidMessage)req, (IProtoCallback)new SimpleProtoCallback<GetPeriodPoolInfoRes>(){

            public void onResponse(@NonNull GetPeriodPoolInfoRes message, long code, String msg) {
                super.onResponse((AndroidMessage)message, code, msg);
                if (callback != null) {
                    callback.onResponse((AndroidMessage)message, code, msg);
                }
            }

            public void onError(String reason, int code) {
                super.onError(reason, code);
                if (callback != null) {
                    callback.onError(reason, code);
                }
            }
        });
    }

    public void reqWeekGiftDecs(long propId, final SimpleProtoCallback<GiftPanelRes> callback) {
        GiftPanelReq req = new GiftPanelReq.Builder().gift_id(Long.valueOf(propId)).sequence(Long.valueOf(System.currentTimeMillis())).build();
        ProtoManager.getInstance().sendHttp((AndroidMessage)req, (IProtoCallback)new SimpleProtoCallback<GiftPanelRes>(){

            public void onResponse(@NonNull GiftPanelRes message, long code, String msg) {
                super.onResponse((AndroidMessage)message, code, msg);
                if (callback != null) {
                    callback.onResponse((AndroidMessage)message, code, msg);
                }
            }

            public void onError(String reason, int code) {
                super.onError(reason, code);
                if (callback != null) {
                    callback.onError(reason, code);
                }
            }
        });
    }

    public void requestGiftDescription(int propId, final SimpleProtoCallback<GetGiftDescriptionRes> callback) {
        GetGiftDescriptionReq req = new GetGiftDescriptionReq.Builder().gift_id(Integer.valueOf(propId)).build();
        ProtoManager.getInstance().sendRpc((AndroidMessage)req, (IProtoCallback)new SimpleProtoCallback<GetGiftDescriptionRes>(){

            public void onResponse(@NonNull GetGiftDescriptionRes message, long code, String msg) {
                super.onResponse((AndroidMessage)message, code, msg);
                if (callback != null) {
                    callback.onResponse((AndroidMessage)message, code, msg);
                }
            }

            public void onError(String reason, int code) {
                super.onError(reason, code);
                if (callback != null) {
                    callback.onError(reason, code);
                }
            }
        });
    }

    public void reqUpgradeArGiftList(final IGiftCallback<List<ArGiftInfo>> arGiftCallback) {
        GetARGiftReq req = new GetARGiftReq.Builder().uid(Long.valueOf(AccountUtil.getUid())).build();
        ProtoManager.getInstance().sendRpc((AndroidMessage)req, (IProtoCallback)new SimpleProtoCallback<GetARGiftsRes>(){

            public void onResponse(@NonNull GetARGiftsRes res, long code, String msgTip) {
                super.onResponse((AndroidMessage)res, code, msgTip);
                ArrayList<ArGiftInfo> mArGiftInfoList = new ArrayList<ArGiftInfo>();
                if (ProtoManager.isSuccessCode((long)code)) {
                    for (ARGift arGift : res.ar_gifts) {
                        mArGiftInfoList.add(new ArGiftInfo(arGift.level, arGift.gift_id, arGift.status));
                    }
                    if (arGiftCallback != null) {
                        arGiftCallback.onSucceed(mArGiftInfoList);
                    }
                }
            }

            public void onError(String reason, int code) {
                super.onError(reason, code);
                if (arGiftCallback != null) {
                    arGiftCallback.onFailed(code, reason);
                }
            }
        });
    }

    public void requestCheckGiftInfo(final List<Long> giftIds, final IGiftCallback<LongSparseArray<CheckGiftInfo>> callback) {
        MLog.info((Object)TAG, (String)"requestCheckGiftInfo, giftIds=%s", (Object[])new Object[]{giftIds});
        if (FP.empty(giftIds)) {
            if (callback != null) {
                callback.onFailed(-1, "giftIds is empty");
            }
            return;
        }
        GetGiftInfosReq req = new GetGiftInfosReq.Builder().gift_ids(giftIds).uid(Long.valueOf(AccountUtil.getUid())).build();
        ProtoManager.getInstance().sendRpc((AndroidMessage)req, (IProtoCallback)new SimpleProtoCallback<GetGiftInfosRes>(){

            public void onResponse(@NonNull GetGiftInfosRes res, long code, String msgTip) {
                MLog.info((Object)GiftOperationModel.TAG, (String)"requestCheckGiftInfo, onResponse,code=%s, msg=%s", (Object[])new Object[]{code, msgTip});
                if (ProtoManager.isSuccessCode((long)code)) {
                    LongSparseArray map = new LongSparseArray();
                    if (!FP.empty((Map)res.gift_infos)) {
                        for (Long id2 : giftIds) {
                            GiftInfo info = (GiftInfo)res.gift_infos.get(id2);
                            if (info == null) continue;
                            CheckGiftInfo checkGiftInfo = new CheckGiftInfo(id2, info.visible, StringUtils.safeParseInt((String)info.position.toString()));
                            map.put(id2.longValue(), (Object)checkGiftInfo);
                        }
                    }
                    if (callback != null) {
                        callback.onSucceed((Object)map);
                    }
                } else if (callback != null) {
                    callback.onFailed((int)code, msgTip);
                }
            }

            public void onError(String reason, int code) {
                MLog.info((Object)GiftOperationModel.TAG, (String)"requestCheckGiftInfo, onError,code=%s, msg=%s", (Object[])new Object[]{code, reason});
                if (callback != null) {
                    callback.onFailed(code, reason);
                }
            }
        });
    }
}

