/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.gift.handler;

import android.content.Context;
import android.text.TextUtils;
import android.util.Pair;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.appsflyer.ThirdTrackEvent;
import com.yy.appbase.appsflyer.ThirdTrackHelper;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.service.IServiceManager;
import com.yy.appbase.service.IUserInfoService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.env.RuntimeContext;
import com.yy.base.event.kvo.KvoEventIntent;
import com.yy.base.event.kvo.KvoMethodAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.event.kvo.helper.KvoBinder;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.hiyo.channel.base.IChannelCenterService;
import com.yy.hiyo.channel.base.bean.ChannelDetailInfo;
import com.yy.hiyo.login.base.utils.GuestLoginUtils;
import com.yy.hiyo.wallet.R;
import com.yy.hiyo.wallet.base.GiftChannel;
import com.yy.hiyo.wallet.base.IPayService;
import com.yy.hiyo.wallet.base.bean.FamilyInfo;
import com.yy.hiyo.wallet.base.bean.KtvSongInfo;
import com.yy.hiyo.wallet.base.revenue.gift.GiftPanelInfo;
import com.yy.hiyo.wallet.base.revenue.gift.GiftUtils;
import com.yy.hiyo.wallet.base.revenue.gift.IGiftHandler;
import com.yy.hiyo.wallet.base.revenue.gift.bean.GiftBroResult;
import com.yy.hiyo.wallet.base.revenue.gift.bean.GiftItemInfo;
import com.yy.hiyo.wallet.base.revenue.gift.bean.GiftPushBroMessage;
import com.yy.hiyo.wallet.base.revenue.gift.bean.LoadGiftResult;
import com.yy.hiyo.wallet.base.revenue.gift.bean.SendGiftExpand;
import com.yy.hiyo.wallet.base.revenue.gift.event.IGiftCallback;
import com.yy.hiyo.wallet.base.revenue.gift.event.IGiftLifecycle;
import com.yy.hiyo.wallet.base.revenue.gift.param.GiftHandlerParam;
import com.yy.hiyo.wallet.base.revenue.gift.param.GiftUserInfo;
import com.yy.hiyo.wallet.base.revenue.gift.param.ShowGiftPanelParam;
import com.yy.hiyo.wallet.gift.data.bean.ConsumeGuideNotifyInfo;
import com.yy.hiyo.wallet.gift.data.bean.GiftPanelIconMsgInfo;
import com.yy.hiyo.wallet.gift.data.bean.GiftPanelShowNotifyInfo;
import com.yy.hiyo.wallet.gift.data.bean.ReceiverUserInfo;
import com.yy.hiyo.wallet.gift.data.param.SendGiftArgv;
import com.yy.hiyo.wallet.gift.data.result.GiftOperationNotifyResult;
import com.yy.hiyo.wallet.gift.data.result.SendGiftRes;
import com.yy.hiyo.wallet.gift.handler.HandlerState;
import com.yy.hiyo.wallet.gift.handler.IGiftHandlerCallback;
import com.yy.hiyo.wallet.gift.handler.IGiftHandlerInner;
import com.yy.hiyo.wallet.gift.handler.SendGiftFailHandle;
import com.yy.hiyo.wallet.gift.statis.GiftHiidoReport;
import com.yy.hiyo.wallet.gift.ui.bigeffect.BigEffectPresenter;
import com.yy.hiyo.wallet.gift.ui.combo.ComboBtnPresenter;
import com.yy.hiyo.wallet.gift.ui.combo.IComboSendCallback;
import com.yy.hiyo.wallet.gift.ui.flash.GiftFlashPresenter;
import com.yy.hiyo.wallet.gift.ui.flymic.GiftFlyMicPresent;
import com.yy.hiyo.wallet.gift.ui.freegift.FloatingPropertyOperator;
import com.yy.hiyo.wallet.gift.ui.freegift.FloatingPropertyPresenter;
import com.yy.hiyo.wallet.gift.ui.giftlevel.GiftLevelOperator;
import com.yy.hiyo.wallet.gift.ui.giftlevel.GiftLevelPresenter;
import com.yy.hiyo.wallet.gift.ui.luckygift.LuckyGiftOperator;
import com.yy.hiyo.wallet.gift.ui.luckygift.LuckyGiftPresenter;
import com.yy.hiyo.wallet.gift.ui.mood.MoodEffectPresenter;
import com.yy.hiyo.wallet.gift.ui.newcomerguide.INewComerGuideCallback;
import com.yy.hiyo.wallet.gift.ui.newcomerguide.NewComerGuideOperator;
import com.yy.hiyo.wallet.gift.ui.newcomerguide.NewComerGuidePresenter;
import com.yy.hiyo.wallet.gift.ui.pannel.GiftPanelPresenter;
import com.yy.hiyo.wallet.gift.ui.pannel.IGiftPanelCallback;
import com.yy.hiyo.wallet.gift.ui.pannel.IGiftPanelOperator;
import com.yy.hiyo.wallet.gift.ui.pannel.ui.GiftPanel;
import com.yy.hiyo.wallet.gift.ui.publicscreen.GiftPublicScreenPresenter;
import com.yy.hiyo.wallet.gift.ui.sendgiftguide.SendGiftGuideOperator;
import com.yy.hiyo.wallet.gift.ui.sendgiftguide.SendGiftGuidePresenter;
import java.util.ArrayList;
import java.util.List;
import net.ihago.active.api.activity.PropOneLimit;

class GiftHandler
implements IGiftHandlerInner,
IGiftPanelCallback,
IComboSendCallback,
INewComerGuideCallback {
    private static final String TAG = "FTGiftHandler";
    private static final int MAX_AVATAR_NUM = 3;
    private IGiftPanelOperator mGiftPanelOperator;
    private final GiftHandlerParam mHandlerParam;
    private final IGiftHandlerCallback mHandlerCallback;
    private HandlerState mState = HandlerState.none;
    private FloatingPropertyOperator mFpOperator;
    private GiftFlashPresenter mGiftFlash;
    private GiftFlyMicPresent mGiftFlyMic;
    private GiftLevelOperator mGiftLevelOperator;
    private NewComerGuideOperator mNewComerGuideOperator;
    private BigEffectPresenter mBigEffect;
    private MoodEffectPresenter mMoodEffect;
    private GiftPublicScreenPresenter mGiftPublicScreen;
    private SendGiftFailHandle mFailHandle;
    private ComboBtnPresenter mComboPresenter;
    private SendGiftGuideOperator mSendGiftGuideOperator;
    private LuckyGiftOperator mLuckyGiftOperator;
    private ViewGroup mGiftLayer;
    private ViewGroup mGiftPanelLayout;
    private ViewGroup mFlashLayer;
    private ViewGroup mMicFlyLayer;
    private ViewGroup mBigLayer;
    private ViewGroup mComboLayer;
    private ViewGroup mFloatLayer;
    private ViewGroup mMoodLayer;
    private ViewGroup mSendGiftGuideLayer;
    private ViewGroup mLuckyGiftLayer;
    private ViewGroup mNewComerGuideLayer;
    private List<GiftUserInfo> mSendGiftSuccessUserInfo;
    private long mLastSendSeq;
    private int mPanelFrom = 0;
    private GiftPanelPresenter mPanelPresenter;
    private final KvoBinder mBinder = new KvoBinder((Object)this);

    GiftHandler(@NonNull GiftHandlerParam param, @NonNull IGiftHandlerCallback callback) {
        MLog.info((Object)TAG, (String)"new GiftHandler roomId: %s, mState: %s", (Object[])new Object[]{param.getRoomId(), this.mState});
        this.mHandlerParam = param;
        this.mHandlerCallback = callback;
        this.onCreate();
    }

    public void showGiftPanel(ShowGiftPanelParam param) {
        MLog.info((Object)TAG, (String)"showGiftPanel roomId: %s, mState: %s, from: %d", (Object[])new Object[]{this.roomId(), this.mState, param.getFrom()});
        GiftHiidoReport.entryGiftPanel(this.roomId(), param.getFrom(), param.isGiftCarouselAnim());
        if (!NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext)) {
            ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)ResourceUtils.getString((int)R.string.check_network_and_retry), (int)0);
            return;
        }
        if (!this.checkResumeState()) {
            return;
        }
        if (param == null) {
            MLog.error((Object)TAG, (String)"showGiftPanel but param is null", (Object[])new Object[0]);
            return;
        }
        if (this.mNewComerGuideOperator != null) {
            if (this.mNewComerGuideOperator.needShowSendGiftGuide()) {
                this.mNewComerGuideOperator.showSendGiftGuidePanel();
                return;
            }
            if (this.mNewComerGuideOperator.isEffectShowing()) {
                return;
            }
        }
        this.mPanelFrom = param.getFrom();
        if (this.mComboPresenter != null) {
            this.mComboPresenter.finishCombo();
        }
        if ((param.getSelectedUid().size() <= 0 || (Long)param.getSelectedUid().get(0) <= 0L) && this.mSendGiftSuccessUserInfo != null && this.mSendGiftSuccessUserInfo.size() > 0 && param.getFrom() != 19 && param.getFrom() != 18) {
            ArrayList<Long> selectedUids = new ArrayList<Long>();
            for (GiftUserInfo giftUserInfo : this.mSendGiftSuccessUserInfo) {
                selectedUids.add(giftUserInfo.uid());
            }
            param.setSelectedUid(selectedUids);
        }
        if (this.mGiftPanelOperator == null) {
            GiftPanel giftPanel = new GiftPanel(this.getGiftPanelLayout(), this);
            this.mPanelPresenter = new GiftPanelPresenter(giftPanel, this, this.mHandlerParam.getShowInterceptor(), this.mHandlerParam.getBehavior().getMode());
            giftPanel.setPresenter(this.mPanelPresenter);
            this.mGiftPanelOperator = this.mPanelPresenter.getOperator();
        }
        this.mPanelPresenter.setPanelFromType(this.mPanelFrom);
        this.mPanelPresenter.setRoomInfo(this.mHandlerParam);
        this.mGiftPanelOperator.showGiftPanel(param, this.mHandlerParam.getGameId());
        final IGiftCallback<List<GiftItemInfo>> packCallback = this.mGiftPanelOperator.getLoadPackageCallback();
        this.mHandlerCallback.loadGiftList(this, new IGiftCallback<LoadGiftResult>(){

            public void onSucceed(LoadGiftResult result) {
                if (GiftHandler.this.mGiftPanelOperator != null && GiftHandler.this.mGiftPanelOperator.getLoadGiftCallbak() != null) {
                    GiftHandler.this.mGiftPanelOperator.getLoadGiftCallbak().onSucceed((Object)result);
                }
                GiftHandler.this.mHandlerCallback.loadPackageList(GiftHandler.this, (IGiftCallback<List<GiftItemInfo>>)packCallback);
            }

            public void onFailed(int code, String msg) {
                if (GiftHandler.this.mGiftPanelOperator != null && GiftHandler.this.mGiftPanelOperator.getLoadGiftCallbak() != null) {
                    GiftHandler.this.mGiftPanelOperator.getLoadGiftCallbak().onFailed(code, msg);
                }
            }
        });
        this.mFpOperator.hideRedDot();
        this.checkAbnormal();
        ComboBtnPresenter.setBottomGameMode(param.getUseChannel() == GiftChannel.CHESS_GAME_ROOM_USED_CHANNEL.getChannel());
        this.requestLevelConfig();
        if (this.mNewComerGuideOperator != null) {
            this.mNewComerGuideOperator.onGiftPanelShow();
        }
    }

    @Override
    public void showConsumeGuidePop(@org.jetbrains.annotations.Nullable ConsumeGuideNotifyInfo data) {
        if (this.mGiftPanelOperator != null) {
            this.mGiftPanelOperator.showConsumeGuidePop(data);
        }
    }

    private void requestLevelConfig() {
        if (this.mGiftLevelOperator != null) {
            this.mGiftLevelOperator.requestGiftLevelConfig();
        }
    }

    public void sendGift(List<GiftUserInfo> receiver, int from, GiftItemInfo giftInfo, int gitNumber) {
        this.sendGift(receiver, from, giftInfo, gitNumber, null);
    }

    @Override
    public void sendGift(List<GiftUserInfo> receiver, int from, GiftItemInfo giftInfo, int gitNumber, IGiftCallback<SendGiftRes> callback) {
        this.sendGift(receiver, from, giftInfo, gitNumber, "", callback);
    }

    @Override
    public void sendGift(List<GiftUserInfo> receiver, int from, GiftItemInfo giftInfo, int gitNumber, String giftSlogan, IGiftCallback<SendGiftRes> callback) {
        if (receiver == null || receiver.isEmpty() || receiver.get(0) == null || receiver.get(0).getUserInfo() == null || giftInfo == null) {
            String msg = "illegal argument";
            MLog.error((Object)TAG, (String)"sendGift %s", (Object[])new Object[]{msg});
            if (RuntimeContext.sIsDebuggable) {
                throw new IllegalArgumentException(msg);
            }
            if (callback != null) {
                callback.onFailed(10001, msg);
            }
            return;
        }
        this.mLastSendSeq = System.currentTimeMillis();
        boolean isSend = this.sendGift(receiver, giftInfo, from, gitNumber, this.mLastSendSeq, 1, giftSlogan, callback);
        if (isSend) {
            if (this.mGiftPanelOperator != null) {
                this.mGiftPanelOperator.hideGiftPanel();
            }
            if (this.mComboPresenter != null && giftInfo.isShowCombo()) {
                this.mComboPresenter.showCombo(this.roomId(), receiver, giftInfo, gitNumber, giftSlogan, from);
            }
            GiftHiidoReport.sendGift(this.roomId(), from, receiver, giftInfo, gitNumber, 1);
        } else if (this.mComboPresenter != null) {
            this.mComboPresenter.finishCombo();
        }
    }

    @Override
    public void sendCombo(List<GiftUserInfo> receiver, GiftItemInfo giftInfo, int gitNumber, String giftSlogan, int from) {
        this.mLastSendSeq = System.currentTimeMillis();
        boolean isSend = this.sendGift(receiver, giftInfo, from, gitNumber, this.mLastSendSeq, 2, giftSlogan, null);
        if (isSend) {
            GiftHiidoReport.sendGift(this.roomId(), from, receiver, giftInfo, gitNumber, 2);
        } else if (this.mComboPresenter != null) {
            this.mComboPresenter.finishCombo();
        }
    }

    @Override
    public void onComboShow() {
        if (this.mHandlerParam.getGiftListener() != null && !this.isFinish()) {
            this.mHandlerParam.getGiftListener().onComboShow((IGiftHandler)this);
        }
    }

    @Override
    public void onComboHide() {
        if (this.mHandlerParam.getGiftListener() != null && !this.isFinish()) {
            this.mHandlerParam.getGiftListener().onComboHide((IGiftHandler)this);
        }
    }

    @Override
    public PropOneLimit getGiftLimit(int giftId) {
        if (this.mFpOperator != null) {
            return this.mFpOperator.getGiftLimit(giftId);
        }
        return null;
    }

    @Override
    public List<GiftItemInfo> getAllGift() {
        return this.mHandlerCallback.getAllGift(this.mHandlerParam.getChannelId());
    }

    @Override
    public void onGiftPanelShown(boolean showAction) {
        GiftHiidoReport.giftPanelShow(this.roomId(), this.mPanelFrom, showAction);
        if (this.mHandlerParam.getGiftListener() != null && !this.isFinish()) {
            this.mHandlerParam.getGiftListener().onGiftPanelShown((IGiftHandler)this);
        }
    }

    @Override
    public void onPanelHidden() {
        if (this.mHandlerParam.getGiftListener() != null && !this.isFinish()) {
            this.mHandlerParam.getGiftListener().onGiftPanelHidden((IGiftHandler)this);
        }
    }

    @Override
    public FamilyInfo getMyFamilyInfo() {
        if (null != this.mHandlerParam) {
            return this.mHandlerParam.getBehavior().getMyFamilyInfo();
        }
        return null;
    }

    public boolean isResume() {
        return this.mState == HandlerState.start;
    }

    public boolean isFinish() {
        return this.mState == HandlerState.finish;
    }

    public boolean isBigEffectSvgaFinish() {
        if (this.mBigEffect != null) {
            return this.mBigEffect.isPlayFinish();
        }
        return true;
    }

    public String roomId() {
        return this.mHandlerParam.getRoomId();
    }

    @NonNull
    public GiftHandlerParam getGiftHandlerParam() {
        return this.mHandlerParam;
    }

    @Override
    public void showGiftPanel(int giftId) {
        ShowGiftPanelParam param = new ShowGiftPanelParam(13);
        param.setPropId(giftId);
        param.setSelectPropPacketTab(true);
        this.mHandlerParam.getBehavior().showGiftPanel(param);
    }

    public void addFlyMicView(GiftBroResult giftBroResult, int marginTop) {
        if (this.mGiftFlyMic != null) {
            this.mGiftFlyMic.addFlyMicView(giftBroResult, marginTop);
        }
    }

    public void addBigEffectView(GiftBroResult giftBroResult) {
        if (this.mBigEffect != null) {
            this.mBigEffect.addGiftEffect(giftBroResult);
        }
    }

    @Override
    public void resumeHandler() {
        MLog.info((Object)TAG, (String)"resumeHandler roomId: %s, mState: %s", (Object[])new Object[]{this.roomId(), this.mState});
        this.onStart(this.mGiftLayer);
    }

    @Override
    public void pauseHandler() {
        MLog.info((Object)TAG, (String)"pauseHandler roomId: %s, mState: %s", (Object[])new Object[]{this.roomId(), this.mState});
        this.onPause();
    }

    public void finish() {
        MLog.info((Object)TAG, (String)"finish roomId: %s, mState: %s", (Object[])new Object[]{this.roomId(), this.mState});
        this.mHandlerCallback.destroyHandler(this);
        this.onDestroy();
    }

    public void start(@NonNull ViewGroup giftLayer) {
        MLog.info((Object)TAG, (String)"start roomId: %s, mState: %s", (Object[])new Object[]{this.roomId(), this.mState});
        if (giftLayer == null) {
            String msg = "GiftHandlerParam with giftLayer container can not be null";
            MLog.error((Object)TAG, (String)msg, (Object[])new Object[0]);
            throw new IllegalArgumentException(msg);
        }
        this.onStart(giftLayer);
        this.requestLevelConfig();
    }

    public void pause() {
        MLog.info((Object)TAG, (String)"pause roomId: %s, mState: %s", (Object[])new Object[]{this.roomId(), this.mState});
        if (!this.checkResumeState()) {
            return;
        }
        this.onPause();
        this.clear();
    }

    public void preloadGiftList() {
        IGiftCallback<LoadGiftResult> giftCallback = null;
        if (this.mGiftPanelOperator != null) {
            giftCallback = this.mGiftPanelOperator.getLoadGiftCallbak();
        }
        this.mHandlerCallback.loadGiftList(this, giftCallback, false);
    }

    public void pauseBigEffectSvga() {
        if (this.mBigEffect != null) {
            this.mBigEffect.pauseSvgaQueue();
        }
    }

    public void resumeBigEffectSvga() {
        if (this.mBigEffect != null) {
            this.mBigEffect.resumeSvgaQueue();
        }
    }

    public GiftPanelInfo getGiftPanelInfo() {
        if (this.mGiftPanelOperator != null) {
            GiftPanelInfo info = new GiftPanelInfo();
            ArrayList<Long> uids = new ArrayList<Long>(8);
            if (this.mGiftPanelOperator.getSelectedReceiver() != null) {
                for (GiftUserInfo giftUserInfo : this.mGiftPanelOperator.getSelectedReceiver()) {
                    uids.add(giftUserInfo.uid());
                }
                info.setSelectedUids(uids);
            }
            if (this.mGiftPanelOperator.getSelectedGift() != null) {
                info.setPropId((long)this.mGiftPanelOperator.getSelectedGift().getPropsId());
            }
            return info;
        }
        return null;
    }

    private void onPause() {
        MLog.info((Object)TAG, (String)"onPause roomId: %s, mState: %s", (Object[])new Object[]{this.roomId(), this.mState});
        this.mState = HandlerState.pause;
        final IGiftLifecycle lifecycle = this.mHandlerParam.getLifecycle();
        if (lifecycle != null) {
            if (YYTaskExecutor.isMainThread()) {
                lifecycle.onPause((IGiftHandler)this);
            } else {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        lifecycle.onPause((IGiftHandler)GiftHandler.this);
                    }
                });
            }
        }
        if (this.mFpOperator != null) {
            this.mFpOperator.onPause();
        }
        if (this.mLuckyGiftOperator != null) {
            this.mLuckyGiftOperator.onPause();
        }
    }

    private void onCreate() {
        this.mState = HandlerState.create;
        this.mBinder.singleBindSourceTo((KvoSource)this.mHandlerParam);
        if (this.mHandlerParam.getLifecycle() != null) {
            if (YYTaskExecutor.isMainThread()) {
                this.mHandlerParam.getLifecycle().onCreate((IGiftHandler)this);
            } else {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        GiftHandler.this.mHandlerParam.getLifecycle().onCreate((IGiftHandler)GiftHandler.this);
                    }
                });
            }
        }
    }

    private void onStart(@NonNull ViewGroup giftLayer) {
        this.mState = HandlerState.start;
        if (this.mHandlerParam.getLifecycle() != null) {
            if (YYTaskExecutor.isMainThread()) {
                this.mHandlerParam.getLifecycle().onStart((IGiftHandler)this);
            } else {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        GiftHandler.this.mHandlerParam.getLifecycle().onStart((IGiftHandler)GiftHandler.this);
                    }
                });
            }
        }
        if (this.mGiftPublicScreen == null) {
            this.mGiftPublicScreen = new GiftPublicScreenPresenter(this);
        }
        if (giftLayer != this.mGiftLayer) {
            this.removeGiftView();
            this.mGiftLayer = giftLayer;
            this.mMicFlyLayer = this.createGiftEffectLayout(0);
            this.mFlashLayer = this.createGiftEffectLayout(1);
            this.mLuckyGiftLayer = this.createGiftEffectLayout(2);
            this.mBigLayer = this.createGiftEffectLayout(3);
            this.mFloatLayer = this.createGiftEffectLayout(4);
            this.mMoodLayer = this.createGiftEffectLayout(5);
            this.mComboLayer = this.createGiftEffectLayout(6);
            this.mSendGiftGuideLayer = this.createGiftEffectLayout(7);
            this.mNewComerGuideLayer = this.createGiftEffectLayout(8);
            this.mGiftLevelOperator = new GiftLevelPresenter(this.mHandlerCallback);
            this.mBigEffect = new BigEffectPresenter(this.mBigLayer, this.mHandlerParam.getBehavior(), this.mHandlerParam.getBigEffectGiftListener());
            this.mMoodEffect = new MoodEffectPresenter(this.mMoodLayer, this.mHandlerParam.getBehavior(), this.mHandlerParam.getRoomId());
            this.mGiftFlyMic = new GiftFlyMicPresent(this.mMicFlyLayer, this.mLuckyGiftLayer, this.mHandlerParam.getBehavior(), this.mHandlerParam.getRoomId(), this);
            this.mGiftFlash = new GiftFlashPresenter(this.mFlashLayer, this.mHandlerParam, this, this.mHandlerCallback);
            this.mFpOperator = new FloatingPropertyPresenter(this.mFloatLayer, this.mHandlerParam, this.mHandlerCallback, this);
            this.mComboPresenter = new ComboBtnPresenter(this.mComboLayer, this);
            this.mSendGiftGuideOperator = new SendGiftGuidePresenter(this.mSendGiftGuideLayer, this.mHandlerCallback, this.mHandlerParam, this);
            this.mLuckyGiftOperator = new LuckyGiftPresenter(this.mLuckyGiftLayer, this.mHandlerCallback, this.mHandlerParam);
            this.mNewComerGuideOperator = new NewComerGuidePresenter(this.mNewComerGuideLayer, this.mHandlerCallback, this.mHandlerParam, this);
        }
        this.mFpOperator.onStart(this.mFloatLayer);
    }

    private void preLoadGifts() {
        this.mHandlerCallback.loadGiftList(this, null, true);
        this.mHandlerCallback.loadPackageList(this, null);
    }

    private void checkAbnormal() {
        if (ServiceManagerProxy.getServiceManager() != null && ServiceManagerProxy.getServiceManager().getService(IPayService.class) != null) {
            ((IPayService)ServiceManagerProxy.getServiceManager().getService(IPayService.class)).checkAbnormalOrder();
        }
    }

    private void onDestroy() {
        this.mState = HandlerState.finish;
        this.mBinder.clearKvoConnection(this.mHandlerParam.getClass().getName());
        if (this.mHandlerParam.getLifecycle() != null) {
            if (YYTaskExecutor.isMainThread()) {
                this.mHandlerParam.getLifecycle().onDestroy((IGiftHandler)this);
            } else {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        GiftHandler.this.mHandlerParam.getLifecycle().onDestroy((IGiftHandler)GiftHandler.this);
                    }
                });
            }
        }
        if (this.mGiftPublicScreen != null) {
            this.mGiftPublicScreen.destroy();
            this.mGiftPublicScreen = null;
        }
        if (this.mFpOperator != null) {
            this.mFpOperator.onDestroy();
        }
        if (this.mNewComerGuideOperator != null) {
            this.mNewComerGuideOperator.onDestroy();
        }
        this.clear();
    }

    private void clear() {
        YYTaskExecutor.postToMainThread(() -> {
            this.removeGiftView();
            this.clearEffect();
        });
        this.mSendGiftSuccessUserInfo = null;
        this.mLastSendSeq = 0L;
        this.mPanelFrom = 0;
    }

    private void clearEffect() {
        if (this.mGiftPanelOperator != null) {
            this.mGiftPanelOperator.destroy();
            this.mGiftPanelOperator = null;
        }
        if (this.mGiftFlash != null) {
            this.mGiftFlash.destroy();
            this.mGiftFlash = null;
        }
        if (this.mGiftFlyMic != null) {
            this.mGiftFlyMic.destroy();
            this.mGiftFlyMic = null;
        }
        if (this.mBigEffect != null) {
            this.mBigEffect.destroy();
            this.mBigEffect = null;
        }
        if (this.mMoodEffect != null) {
            this.mMoodEffect.destroy();
            this.mMoodEffect = null;
        }
        if (this.mFailHandle != null) {
            this.mFailHandle.destroy();
            this.mFailHandle = null;
        }
        if (this.mComboPresenter != null) {
            this.mComboPresenter.destroy();
            this.mComboPresenter = null;
        }
        if (this.mSendGiftGuideOperator != null) {
            this.mSendGiftGuideOperator.destroy();
            this.mSendGiftGuideOperator = null;
        }
        if (this.mLuckyGiftOperator != null) {
            this.mLuckyGiftOperator.onDestroy();
            this.mLuckyGiftOperator = null;
        }
    }

    private void removeGiftView() {
        this.removeLayer(this.mFlashLayer);
        this.mFlashLayer = null;
        this.removeLayer(this.mMicFlyLayer);
        this.mMicFlyLayer = null;
        this.removeLayer(this.mBigLayer);
        this.mBigLayer = null;
        this.removeLayer(this.mMoodLayer);
        this.mMoodLayer = null;
        this.removeLayer(this.mGiftPanelLayout);
        this.mGiftPanelLayout = null;
        this.removeLayer(this.mComboLayer);
        this.mComboLayer = null;
        this.removeLayer(this.mFloatLayer);
        this.mFloatLayer = null;
        this.mGiftLayer = null;
        this.removeLayer(this.mSendGiftGuideLayer);
        this.mSendGiftGuideLayer = null;
        this.removeLayer(this.mLuckyGiftLayer);
        this.mLuckyGiftLayer = null;
    }

    @KvoMethodAnnotation(name="mChannelId", sourceClass=GiftHandlerParam.class)
    public void onChannelIdChanged(KvoEventIntent event) {
        if (event.isStickyNotify()) {
            return;
        }
        MLog.info((Object)TAG, (String)"onChannelIdChanged new: %d, old: %d", (Object[])new Object[]{event.newValue(), event.oldValue()});
        if (((GiftHandlerParam)event.source()).getChannelId() > 0) {
            IGiftCallback<LoadGiftResult> giftCallback = null;
            if (this.mGiftPanelOperator != null) {
                giftCallback = this.mGiftPanelOperator.getLoadGiftCallbak();
            }
            this.mHandlerCallback.loadGiftList(this, giftCallback, true);
        }
    }

    @Override
    public void onGiftBroadcast(@NonNull GiftBroResult result) {
        boolean showComboSvga;
        if (this.mHandlerParam.getGiftListener() != null && !this.isFinish()) {
            this.mHandlerParam.getGiftListener().onGiftBroadcast((IGiftHandler)this, result);
        }
        if (result.needShow(1) && this.mGiftPublicScreen != null) {
            this.mGiftPublicScreen.addGiftEffect(result);
        }
        if (result.needShow(2) && (result.getExpand() == null || result.getExpand().boxPropId <= 0) && this.mGiftFlyMic != null && this.mHandlerParam.getBehavior().getMode() != 15) {
            this.mGiftFlyMic.addGiftEffect(result);
        }
        if ((result.needShow(4) || (result.needShow(8) || result.needShow(2)) && result.getExpand() != null && result.getExpand().boxPropId > 0) && this.mGiftFlash != null) {
            this.mGiftFlash.addGiftEffect(result);
        }
        boolean bl = showComboSvga = result.getGiftComboExpand() != null && !TextUtils.isEmpty((CharSequence)result.getGiftComboExpand().getTriggerEffectLevel());
        if ((result.needShow(8) || showComboSvga) && (result.getExpand() == null || result.getExpand().boxPropId <= 0) && this.mBigEffect != null) {
            if (showComboSvga) {
                // empty if block
            }
            this.mBigEffect.addGiftEffect(result);
        }
        if (result.needShow(16) && this.mMoodEffect != null) {
            this.mMoodEffect.addGiftEffect(result);
        }
        if (this.mComboPresenter != null) {
            this.mComboPresenter.showComboTips(result, showComboSvga);
        }
        if (this.mSendGiftGuideOperator != null) {
            this.mSendGiftGuideOperator.onReceivedGift(result.getGiftBroInfo());
        }
    }

    @Override
    public void onGiftPush(@NonNull GiftPushBroMessage result) {
        this.mHandlerParam.getBehavior().addRoomPush(result);
    }

    @Override
    @Nullable
    public List<GiftItemInfo> getPackageList(long uid) {
        return this.mHandlerCallback.getAllPackage(AccountUtil.getUid());
    }

    @Override
    public void onGiftOperationNotify(@NonNull GiftOperationNotifyResult result) {
        FeatureLog.e((String)"FTLuckyGift", (String)"onGiftOperationNotify : %s", (Object[])new Object[]{result.getUri()});
        if (result.getUri() == 7) {
            if (this.mGiftLevelOperator != null) {
                this.mGiftLevelOperator.updateGiftLevel(result.getPropLevelGiftInfo());
            }
        } else if (result.getUri() == 1) {
            if (this.mGiftPanelOperator != null) {
                this.mGiftPanelOperator.notifyReceivedGift(result);
            }
            if (this.mFpOperator != null) {
                this.mFpOperator.notifyReceivedGift(result);
            }
        } else if (result.getUri() == 8) {
            this.handleGiftPanelIconNotify(result);
        } else if (result.getUri() == 9) {
            this.handleNewComerSendGiftGuideNotify(result);
        } else if (result.getUri() == 10) {
            this.handleNewComerConsumeGuideNotify(result);
        } else if (result.getUri() == 11) {
            this.handleGiftPanelShowNotify(result);
        } else if (StringUtils.equal((String)result.getRoomId(), (String)this.mHandlerParam.getRoomId())) {
            if (result.getUri() == 2) {
                if (this.isAmongUs(result.getRoomId())) {
                    return;
                }
                if (this.mFpOperator != null) {
                    this.mFpOperator.notifyFloatGift(result);
                }
            } else if (result.getUri() == 3) {
                if (this.isAmongUs(result.getRoomId())) {
                    return;
                }
                if (this.mFpOperator != null) {
                    this.mFpOperator.notifyFloatActivityProperty(result);
                }
            } else if (result.getUri() == 4) {
                if (this.mSendGiftGuideOperator != null) {
                    this.mSendGiftGuideOperator.setSendGiftGuideInfo(result);
                }
            } else if (result.getUri() == 5) {
                if (this.mLuckyGiftOperator != null) {
                    this.mLuckyGiftOperator.setLuckyGiftCurrentWinInfo(result.getLuckyGiftUnicastInfo());
                } else {
                    FeatureLog.e((String)"FTLuckyGift", (String)"luck gift does not init", (Object[])new Object[0]);
                }
            } else if (result.getUri() == 6) {
                if (this.mLuckyGiftOperator != null) {
                    this.mLuckyGiftOperator.setLuckyGiftRoomWinInfo(result.getLuckyGiftBroadcastInfo());
                } else {
                    FeatureLog.e((String)"FTLuckyGift", (String)"luck gift does not init", (Object[])new Object[0]);
                }
            }
        }
    }

    private void handleGiftPanelIconNotify(GiftOperationNotifyResult result) {
        if (this.mNewComerGuideOperator != null && result.getNotifyInfo() instanceof GiftPanelIconMsgInfo) {
            GiftPanelIconMsgInfo msgInfo = (GiftPanelIconMsgInfo)result.getNotifyInfo();
            this.mNewComerGuideOperator.showObtainAnim(msgInfo);
        }
    }

    private void handleNewComerSendGiftGuideNotify(GiftOperationNotifyResult result) {
        if (this.mNewComerGuideOperator != null && result.getNotifyInfo() instanceof GiftPanelIconMsgInfo) {
            GiftPanelIconMsgInfo msgInfo = (GiftPanelIconMsgInfo)result.getNotifyInfo();
            this.mNewComerGuideOperator.startSendGiftGuide(msgInfo);
        }
    }

    private void handleNewComerConsumeGuideNotify(GiftOperationNotifyResult result) {
        if (this.mNewComerGuideOperator != null && result.getNotifyInfo() instanceof ConsumeGuideNotifyInfo) {
            ConsumeGuideNotifyInfo msgInfo = (ConsumeGuideNotifyInfo)result.getNotifyInfo();
            this.mNewComerGuideOperator.showConsumeGuide(msgInfo);
        }
    }

    private void handleGiftPanelShowNotify(GiftOperationNotifyResult result) {
        if (this.mNewComerGuideOperator != null && result.getNotifyInfo() instanceof GiftPanelShowNotifyInfo) {
            this.mNewComerGuideOperator.showGiftPanel(((GiftPanelShowNotifyInfo)result.getNotifyInfo()).getGiftId());
        }
    }

    private boolean checkResumeState() {
        if (this.mState != HandlerState.start) {
            MLog.error((Object)TAG, (String)"checkResumeState illegal state mState: %s", (Object[])new Object[]{this.mState});
            if (RuntimeContext.sIsDebuggable) {
                ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)"\u8c03\u8bd5: \u793c\u7269\u72b6\u6001\u4e0d\u5bf9", (int)0);
            }
            return false;
        }
        return true;
    }

    private boolean sendGift(final List<GiftUserInfo> receiver, final GiftItemInfo giftInfo, final int from, final int gitNumber, final long seq, final int type, String giftSlogan, final IGiftCallback<SendGiftRes> callback) {
        List<ReceiverUserInfo> userInfosList = this.getReceiverUserInfos(receiver);
        if (userInfosList.isEmpty() || giftInfo == null) {
            String msg = "illegal argument";
            MLog.error((Object)TAG, (String)"sendGift %s", (Object[])new Object[]{msg});
            if (RuntimeContext.sIsDebuggable) {
                throw new IllegalArgumentException(msg);
            }
            if (callback != null) {
                callback.onFailed(10001, msg);
            }
            return false;
        }
        if (this.checkGuest()) {
            return false;
        }
        String recvAvatar = "";
        if (receiver.size() == 1) {
            recvAvatar = this.getAvatar(receiver.get(0));
        }
        if (!GiftUtils.canBuy((GiftItemInfo)giftInfo)) {
            MLog.info((Object)TAG, (String)"sendGift gift can not buy, id: %d, name: %s", (Object[])new Object[]{giftInfo.getPropsId(), giftInfo.getName()});
            this.getFailHandle().sendGiftFail(this.roomId(), from, 20994, "client judge can not buy", this.mHandlerParam.getGameId(), recvAvatar);
            if (callback != null) {
                callback.onFailed(10008, String.format("gift can not be bought, id: %d, name: %s", giftInfo.getPropsId(), giftInfo.getName()));
            }
            return false;
        }
        final int giftCount = gitNumber <= 0 ? 1 : gitNumber;
        IServiceManager serviceManager = ServiceManagerProxy.getServiceManager();
        if (serviceManager == null || serviceManager.getService(IUserInfoService.class) == null) {
            MLog.error((Object)TAG, (String)"service is null maybe not init finish", (Object[])new Object[0]);
            if (callback != null) {
                callback.onFailed(10009, "service is null maybe not init finish");
            }
            return false;
        }
        UserInfoKS sender = ((IUserInfoService)serviceManager.getService(IUserInfoService.class)).getUserInfo(AccountUtil.getUid());
        if (sender == null) {
            MLog.error((Object)TAG, (String)"myself user info is null", (Object[])new Object[0]);
            if (callback != null) {
                callback.onFailed(10010, "myself user info is null");
            }
            return false;
        }
        GiftItemInfo info = this.mHandlerCallback.findGiftById(giftInfo.getPropsId(), this.mHandlerParam.getChannelId());
        int giftLevel = 0;
        if (info != null) {
            giftLevel = info.getGiftLevel();
        }
        FamilyInfo myFamilyInfo = this.mHandlerParam.getBehavior().getMyFamilyInfo();
        KtvSongInfo curSongInfo = this.mHandlerParam.getBehavior().getCurSongInfo();
        MLog.debug((Object)TAG, (String)"pkId =%s, videoPkFinishTime =%s", (Object[])new Object[]{this.mHandlerParam.getBehavior().getPkId(), this.mHandlerParam.getBehavior().videoPkFinishTime()});
        SendGiftExpand expand = SendGiftExpand.newBuilder().roomId(this.mHandlerParam.getRoomId()).roomOwnerUid(this.mHandlerParam.getAnchorUid()).senderHeaderUrl(StringUtils.notNull((String)sender.avatar)).receiverHeaderUrl(recvAvatar).gameId(this.mHandlerParam.getBehavior().getGameId()).giftSlogan(giftSlogan).giftLevel(giftLevel).vcid(this.mHandlerParam.getCvid()).topId(this.mHandlerParam.getTopId()).subId(this.mHandlerParam.getSubId()).mode(this.mHandlerParam.getBehavior().getMode()).videoPkFinishTime(this.mHandlerParam.getBehavior().videoPkFinishTime()).pkId(this.mHandlerParam.getBehavior().getPkId()).subModel(this.mHandlerParam.getBehavior().getSubMode()).videoMode(this.mHandlerParam.getBehavior().getVideoMode()).recommendToken(this.mHandlerParam.getRecommendToken()).playType(this.playType()).modePlay(this.modePlay()).minCharm(this.getGiftHandlerParam().getBehavior().minCharm()).roundId(this.getGiftHandlerParam().getBehavior().getVideoRoundId()).familyName(null == myFamilyInfo ? "" : myFamilyInfo.getName()).familyLvIcon(null == myFamilyInfo ? "" : myFamilyInfo.getLvIcon()).songId(curSongInfo == null ? "" : curSongInfo.getSongId()).songName(curSongInfo == null ? "" : curSongInfo.getSongName()).build();
        SendGiftArgv argv = SendGiftArgv.newBuilder().anchorUid(this.mHandlerParam.getAnchorUid()).channelId(this.mHandlerParam.getChannelId()).count(giftCount).isAutoBuy(true).senderUid(AccountUtil.getUid()).senderNickname(StringUtils.notNull((String)sender.nick)).receiverUserInfos(userInfosList).propsId(giftInfo.getPropsId()).roomId(this.mHandlerParam.getRoomId()).expand(expand).build();
        this.mHandlerCallback.sendGift(argv, new IGiftCallback<SendGiftRes>(){

            public void onSucceed(SendGiftRes result) {
                MLog.info((Object)GiftHandler.TAG, (String)"sendGift onSucceed result: %s", (Object[])new Object[]{result});
                if (result != null) {
                    long price = GiftUtils.giftPrice((GiftItemInfo)giftInfo);
                    ThirdTrackHelper.INSTANCE.reportEvent(new ThirdTrackEvent().eventId("Complete_Send_Gifts").put("af_revenue", (Object)Float.valueOf((float)((long)result.count * price) / 100.0f)));
                }
                if (GiftHandler.this.mState != HandlerState.start) {
                    return;
                }
                if (GiftHandler.this.mFpOperator != null) {
                    GiftHandler.this.mFpOperator.onSendGift(giftInfo, giftCount);
                }
                if (GiftHandler.this.mGiftPanelOperator != null) {
                    GiftHandler.this.mGiftPanelOperator.onConsumeGift(giftInfo, giftCount);
                }
                if (GiftHandler.this.mSendGiftGuideOperator != null && receiver.size() == 1) {
                    GiftHandler.this.mSendGiftGuideOperator.onSendGift((GiftUserInfo)receiver.get(0), giftInfo);
                }
                if (callback != null) {
                    callback.onSucceed((Object)result);
                }
                GiftHandler.this.mSendGiftSuccessUserInfo = receiver;
                GiftHiidoReport.sendGiftReturn(GiftHandler.this.roomId(), from, receiver, giftInfo, gitNumber, 0, type);
            }

            public void onFailed(int code, String msg) {
                boolean serviceMsg;
                MLog.error((Object)GiftHandler.TAG, (String)"sendGift onFailed code: %d, msg: %s", (Object[])new Object[]{code, msg});
                if (GiftHandler.this.mLastSendSeq == seq && GiftHandler.this.mComboPresenter != null && code != 20495) {
                    GiftHandler.this.mComboPresenter.finishCombo();
                }
                boolean bl = serviceMsg = code == 20928;
                if (GiftHandler.this.mState == HandlerState.start) {
                    if (code == 20988 && giftInfo.getPayLevel() != 0) {
                        GiftHandler.this.getFailHandle().onPayLevelNotReached(giftInfo.getPayLevel());
                    } else {
                        String avatar = "";
                        if (receiver.size() == 1) {
                            avatar = GiftHandler.this.getAvatar((GiftUserInfo)receiver.get(0));
                        }
                        if (!serviceMsg) {
                            GiftHandler.this.getFailHandle().sendGiftFail(GiftHandler.this.roomId(), from, code, msg, GiftHandler.this.mHandlerParam.getGameId(), avatar);
                        }
                    }
                }
                if (serviceMsg) {
                    ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)(!TextUtils.isEmpty((CharSequence)msg) ? msg : ResourceUtils.getString((int)R.string.tips_service_default_error)), (int)0);
                }
                if (callback != null) {
                    callback.onFailed(code, msg);
                }
                GiftHiidoReport.sendGiftReturn(GiftHandler.this.roomId(), from, receiver, giftInfo, gitNumber, code, type);
                if (code == 20997) {
                    GiftHiidoReport.noEnoughBalanceDialogShow(GiftHandler.this.roomId(), from, giftInfo.getPropsId());
                }
            }
        });
        return true;
    }

    private int playType() {
        return this.getGiftHandlerParam().getBehavior().playType();
    }

    private int modePlay() {
        return this.getGiftHandlerParam().getBehavior().modePlay();
    }

    @NonNull
    private List<ReceiverUserInfo> getReceiverUserInfos(List<GiftUserInfo> receiver) {
        ArrayList<ReceiverUserInfo> userInfosList = new ArrayList<ReceiverUserInfo>();
        if (receiver != null) {
            Pair innerPkSeatTeams = this.mHandlerParam.getBehavior().getInnerPkSeatTeams();
            for (GiftUserInfo giftUserInfo : receiver) {
                UserInfoKS userInfoKS = giftUserInfo.getUserInfo();
                if (userInfoKS == null) continue;
                ReceiverUserInfo receiverUserInfo = new ReceiverUserInfo(userInfoKS.uid, userInfoKS.nick);
                this.appendUserType((Pair<List<Long>, List<Long>>)innerPkSeatTeams, userInfoKS, receiverUserInfo);
                userInfosList.add(receiverUserInfo);
            }
        }
        return userInfosList;
    }

    private boolean checkGuest() {
        if (AccountUtil.isLoginByGuest()) {
            this.showLoginGuide();
            return true;
        }
        return false;
    }

    private void appendUserType(Pair<List<Long>, List<Long>> innerPkSeatTeams, UserInfoKS userInfoKS, ReceiverUserInfo receiverUserInfo) {
        if (this.mHandlerParam.getBehavior().getInnerPkSeatTeams() != null && innerPkSeatTeams != null) {
            if (((List)innerPkSeatTeams.first).contains(userInfoKS.uid)) {
                receiverUserInfo.setUserType(1);
            } else if (((List)innerPkSeatTeams.second).contains(userInfoKS.uid)) {
                receiverUserInfo.setUserType(2);
            }
        }
    }

    private void showLoginGuide() {
        GuestLoginUtils.showLoginGuide((int)8);
    }

    private String getAvatar(GiftUserInfo receiver) {
        String avatar = "";
        if (receiver != null && receiver.getUserInfo() != null && receiver.getUserInfo().uid != AccountUtil.getUid()) {
            avatar = receiver.getUserInfo().avatar;
        }
        return avatar;
    }

    private void removeLayer(ViewGroup layer) {
        if (layer == null) {
            return;
        }
        ViewParent parent = layer.getParent();
        if (parent instanceof ViewGroup) {
            ((ViewGroup)parent).removeView((View)layer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private SendGiftFailHandle getFailHandle() {
        if (this.mFailHandle != null) return this.mFailHandle;
        Class<GiftHandler> clazz = GiftHandler.class;
        synchronized (GiftHandler.class) {
            if (this.mFailHandle != null) return this.mFailHandle;
            this.mFailHandle = new SendGiftFailHandle(this.mGiftLayer == null ? null : this.mGiftLayer.getContext(), this.mGiftPanelOperator);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.mFailHandle;
        }
    }

    private ViewGroup createGiftEffectLayout(int index) {
        YYFrameLayout effectLayer = new YYFrameLayout(this.mGiftLayer.getContext());
        ViewGroup.LayoutParams lp = new ViewGroup.LayoutParams(-1, -1);
        this.mGiftLayer.addView((View)effectLayer, index, lp);
        return effectLayer;
    }

    private ViewGroup getGiftPanelLayout() {
        if (this.mGiftPanelLayout == null) {
            this.mGiftPanelLayout = new YYFrameLayout(this.mGiftLayer.getContext());
            ViewGroup.LayoutParams lp = new ViewGroup.LayoutParams(-1, -1);
            this.mGiftLayer.addView((View)this.mGiftPanelLayout, -1, lp);
        }
        return this.mGiftPanelLayout;
    }

    public String toString() {
        return "GiftHandler{mHandlerParam=" + this.mHandlerParam + ", mState=" + (Object)((Object)this.mState) + '}';
    }

    public boolean isAmongUs(String roomId) {
        IServiceManager serviceManager = ServiceManagerProxy.getServiceManager();
        if (serviceManager != null) {
            IChannelCenterService centerService = (IChannelCenterService)serviceManager.getService(IChannelCenterService.class);
            ChannelDetailInfo channelDetailInfo = centerService.getChannel(roomId).getDataService().getCacheDetail();
            if (channelDetailInfo != null) {
                return channelDetailInfo.baseInfo.isAmongUs() || channelDetailInfo.baseInfo.isAmongUsUser();
            }
            MLog.error((Object)TAG, (String)"isAmongUs channelDetailInfo is null", (Object[])new Object[0]);
        } else {
            MLog.error((Object)TAG, (String)"isAmongUs serviceManager is null", (Object[])new Object[0]);
        }
        return false;
    }

    public ViewGroup getFloatLayer() {
        return this.mFloatLayer;
    }

    public boolean arGiftUpgrade(GiftItemInfo info) {
        return this.mPanelPresenter != null && this.mPanelPresenter.arGiftUpgrade(info);
    }
}

