/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.gift;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.hiyo.wallet.base.IGiftService;
import com.yy.hiyo.wallet.base.revenue.gift.IGiftHandler;
import com.yy.hiyo.wallet.base.revenue.gift.bean.GiftBroResult;
import com.yy.hiyo.wallet.base.revenue.gift.bean.GiftItemInfo;
import com.yy.hiyo.wallet.base.revenue.gift.bean.IGiftListIntercept;
import com.yy.hiyo.wallet.base.revenue.gift.bean.LoadGiftResult;
import com.yy.hiyo.wallet.base.revenue.gift.event.IGiftCallback;
import com.yy.hiyo.wallet.base.revenue.gift.param.GiftHandlerParam;
import com.yy.hiyo.wallet.gift.LoadGiftManager;
import com.yy.hiyo.wallet.gift.handler.GiftHandlerManager;
import com.yy.hiyo.wallet.gift.sdk.GiftBroadcastParse;
import com.yy.hiyo.wallet.gift.sdk.GiftSdkWrapper;
import com.yy.hiyo.wallet.gift.sdk.IGiftSdk;
import com.yy.hiyo.wallet.gift.statis.GiftHiidoReport;
import java.util.List;

public class GiftServiceImp
implements IGiftService {
    private static final String TAG = "GiftServiceImp";
    private final IGiftSdk mGiftSdkWrapper = new GiftSdkWrapper();
    private GiftHandlerManager mHandlerManager;
    private LoadGiftManager mLoadGiftManager;
    private GiftBroadcastParse mGiftBroParse;

    @NonNull
    public IGiftHandler createGiftHandler(@NonNull GiftHandlerParam param) {
        return this.getHandlerManager().createHandler(param);
    }

    @Nullable
    public IGiftHandler getGiftHandler(String roomId) {
        if (this.mHandlerManager == null) {
            return null;
        }
        return this.mHandlerManager.findGiftHandler(roomId);
    }

    public void finishGiftHandler(String roomId) {
        if (this.mHandlerManager == null) {
            return;
        }
        this.mHandlerManager.finishGiftHandler(roomId);
    }

    public void loadGiftList(String roomId, long anchorUid, int channelId, boolean forceUpdate, IGiftCallback<LoadGiftResult> callback) {
        this.getLoadGiftManager().loadGiftList(roomId, anchorUid, channelId, forceUpdate, callback);
    }

    public List<GiftItemInfo> getGiftList(int channelId) {
        return this.getLoadGiftManager().getGiftList(channelId);
    }

    public void loadPackageList(int channelId, long uid, IGiftCallback<List<GiftItemInfo>> callback) {
        this.getLoadGiftManager().loadPackageList(channelId, uid, callback);
    }

    public List<GiftItemInfo> getPackageList(long uid) {
        return this.getLoadGiftManager().getPackageList(uid);
    }

    public GiftBroResult parseGiftBroMsg(String giftMsg) {
        return this.getGiftBroParse().parseGiftBro(giftMsg);
    }

    public void addGiftBro(final GiftBroResult result) {
        if (YYTaskExecutor.isMainThread()) {
            this.getHandlerManager().onBroadcast(result);
        } else {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    GiftServiceImp.this.getHandlerManager().onBroadcast(result);
                }
            });
        }
    }

    public void setGiftListIntercept(IGiftListIntercept intercept2) {
        this.getLoadGiftManager().setGiftListIntercept(intercept2);
    }

    public GiftItemInfo getGift(int propId) {
        return this.getLoadGiftManager().getGift(propId);
    }

    public GiftItemInfo getGift(int channelId, int propId) {
        return this.getLoadGiftManager().getGift(channelId, propId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private GiftHandlerManager getHandlerManager() {
        if (this.mHandlerManager != null) return this.mHandlerManager;
        Class<GiftServiceImp> clazz = GiftServiceImp.class;
        synchronized (GiftServiceImp.class) {
            if (this.mHandlerManager != null) return this.mHandlerManager;
            this.mHandlerManager = new GiftHandlerManager(this.mGiftSdkWrapper, this);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.mHandlerManager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private LoadGiftManager getLoadGiftManager() {
        if (this.mLoadGiftManager != null) return this.mLoadGiftManager;
        Class<GiftServiceImp> clazz = GiftServiceImp.class;
        synchronized (GiftServiceImp.class) {
            if (this.mLoadGiftManager != null) return this.mLoadGiftManager;
            this.mLoadGiftManager = new LoadGiftManager(this.mGiftSdkWrapper);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.mLoadGiftManager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private GiftBroadcastParse getGiftBroParse() {
        if (this.mGiftBroParse != null) return this.mGiftBroParse;
        Class<GiftServiceImp> clazz = GiftServiceImp.class;
        synchronized (GiftServiceImp.class) {
            if (this.mGiftBroParse != null) return this.mGiftBroParse;
            this.mGiftBroParse = new GiftBroadcastParse();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.mGiftBroParse;
        }
    }

    public void preloadImChannelGiftList() {
    }

    public void statGiftGuideShow(GiftItemInfo giftItemInfo, String roomId) {
        GiftHiidoReport.sendGiftGuideShow(giftItemInfo, roomId);
    }
}

