/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.coupon.ui.popupwindow;

import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.text.SpannableString;
import android.text.Spanned;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.PopupWindow;
import android.widget.TextView;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.yy.appbase.AppbaseMsgDef;
import com.yy.appbase.ui.widget.status.CommonStatusLayout;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ResourceUtils;
import com.yy.framework.core.MsgDispatcher;
import com.yy.hiyo.wallet.R;
import com.yy.hiyo.wallet.base.pay.bean.CouponBean;
import com.yy.hiyo.wallet.base.pay.bean.NoCouponBean;
import com.yy.hiyo.wallet.coupon.ui.tab.CouponListItenDecoration;
import com.yy.hiyo.wallet.coupon.ui.tab.CouponTabAdapter;
import java.util.List;

public class CouponListPopupWindow
extends PopupWindow {
    private Context mContext;
    private View mContentView;
    private RecyclerView mCouponRv;
    private View mShadowView;
    private TextView mTvConfirm;
    private CommonStatusLayout mStatusLayout;
    private CouponTabAdapter mCouponAdapter;

    public CouponListPopupWindow(Context context) {
        this.mContext = context;
        this.init();
    }

    private void init() {
        LayoutInflater inflater = (LayoutInflater)this.mContext.getSystemService("layout_inflater");
        this.mContentView = inflater.inflate(R.layout.layout_coupon_list_pop, null);
        this.setContentView(this.mContentView);
        this.setWidth(-1);
        this.setHeight(-1);
        this.setFocusable(true);
        this.setOutsideTouchable(true);
        this.update();
        ColorDrawable dw = new ColorDrawable(0);
        this.setBackgroundDrawable((Drawable)dw);
        this.setAnimationStyle(R.style.popWindowAnimation);
        this.mCouponRv = (RecyclerView)this.mContentView.findViewById(R.id.coupon_dialog_rv);
        this.mShadowView = this.mContentView.findViewById(R.id.view_pop_shadow);
        this.mTvConfirm = (TextView)this.mContentView.findViewById(R.id.tv_confirm);
        this.mStatusLayout = (CommonStatusLayout)this.mContentView.findViewById(R.id.status_layout);
        this.initRv();
        this.mShadowView.setOnClickListener(v -> this.dismiss());
        this.setOnDismissListener(() -> this.mShadowView.setAlpha(0.0f));
        this.mTvConfirm.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (CouponListPopupWindow.this.mCouponAdapter == null || CouponListPopupWindow.this.mCouponAdapter.getCheckItem() == null) {
                    return;
                }
                MsgDispatcher.getInstance().sendMessage(AppbaseMsgDef.UPDATE_COUPON_DISCOUNT_POP, -1, -1, (Object)CouponListPopupWindow.this.mCouponAdapter.getCheckItem());
                CouponListPopupWindow.this.dismiss();
            }
        });
    }

    private void initRv() {
        this.mCouponAdapter = new CouponTabAdapter(true);
        LinearLayoutManager linearLayoutManager = new LinearLayoutManager(this.mContext);
        linearLayoutManager.setOrientation(1);
        this.mCouponRv.setLayoutManager((RecyclerView.LayoutManager)linearLayoutManager);
        this.mCouponRv.addItemDecoration((RecyclerView.ItemDecoration)new CouponListItenDecoration(Color.parseColor((String)"#f3f3f3")));
        this.mCouponRv.setAdapter((RecyclerView.Adapter)this.mCouponAdapter);
    }

    public void showCouponListPop(View view) {
        this.mShadowView.setAlpha(0.0f);
        this.setBackgroundAlpha();
        this.showAtLocation(view, 49, 0, 0);
    }

    private void setBackgroundAlpha() {
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                ValueAnimator valueAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
                valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                    public void onAnimationUpdate(ValueAnimator animation) {
                        if (CouponListPopupWindow.this.mShadowView != null) {
                            CouponListPopupWindow.this.mShadowView.setAlpha(((Float)animation.getAnimatedValue()).floatValue());
                        }
                    }
                });
                valueAnimator.setDuration(100L);
                valueAnimator.start();
            }
        }, (long)500L);
    }

    public void setListData(List<CouponBean> data, long couponId) {
        if (data != null && !data.isEmpty()) {
            data.add((CouponBean)new NoCouponBean());
        }
        this.mCouponAdapter.setDatas(data, couponId);
        this.mCouponRv.scrollToPosition(this.mCouponAdapter.getCheckPosition());
        this.hideLoading();
        if (this.mCouponAdapter.isDataEmpty()) {
            this.mStatusLayout.showNoData(R.drawable.default_no_data, (Spanned)new SpannableString((CharSequence)ResourceUtils.getString((int)R.string.tips_available_coupons_empty)));
        }
    }

    public void hideLoading() {
        this.mStatusLayout.hideLoading();
    }

    public void showLoading() {
        this.mStatusLayout.showLoading();
    }

    public void processFailed() {
        this.hideLoading();
        if (this.mCouponAdapter != null && this.mCouponAdapter.isDataEmpty()) {
            this.mStatusLayout.showNoData(R.drawable.default_no_data, (Spanned)new SpannableString((CharSequence)ResourceUtils.getString((int)R.string.tips_available_coupons_empty)));
        }
    }
}

