/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.coupon.net;

import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.data.JsonStringBuilder;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.hiyo.wallet.base.pay.bean.CouponBean;
import com.yy.hiyo.wallet.base.pay.bean.CouponDiscountBean;
import com.yy.hiyo.wallet.base.pay.callback.IPayCallback;
import com.yy.hiyo.wallet.base.revenue.proto.RevenueProto;
import com.yy.hiyo.wallet.base.revenue.proto.RevenueProtoReq;
import com.yy.hiyo.wallet.base.revenue.proto.RevenueProtoRes;
import com.yy.hiyo.wallet.coupon.bean.CouponDiscountResponse;
import com.yy.hiyo.wallet.coupon.bean.CouponListResponse;
import com.yy.hiyo.wallet.pay.PayUtils;
import com.yy.hiyo.wallet.pay.monitor.PayMonitor;
import com.yy.hiyo.wallet.pay.request.PayRequestUtils;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import okhttp3.Call;
import org.json.JSONArray;

public class CouponRequest {
    private static final String TAG = "CouponRequest";
    private final Map<Long, CouponDiscountResponse> mCouponCache = new ConcurrentHashMap<Long, CouponDiscountResponse>();

    public void queryCouponListAsync(boolean isUsed, final IPayCallback<List<CouponBean>> callback) {
        RevenueProtoReq.Builder builder = RevenueProtoReq.newBuilder();
        builder.appId(1802);
        builder.version(0);
        builder.cmd(1047);
        builder.countryCode(AccountUtil.realCountry());
        final String seq = RevenueProto.uniqueSeq();
        JsonStringBuilder param = RevenueProto.getCommonParam();
        param.put("cmd", (Object)1047);
        param.put("seq", (Object)seq);
        param.put("uid", (Object)AccountUtil.getUid());
        param.put("appId", (Object)1802);
        param.put("usedChannel", (Object)PayUtils.getPayUseChannel());
        param.put("hasUsed", (Object)isUsed);
        builder.jsonMsg(param.jsonObject());
        RevenueProtoReq req = builder.build();
        String url = RevenueProto.getUrl((String)"query", (int)req.getCmd());
        FeatureLog.i((String)"FTPayCouponCouponRequest", (String)"queryCouponListAsync url: %s", (Object[])new Object[]{url});
        RevenueProto.sendHttp((String)url, (RevenueProtoReq)req, (RevenueProto.RevenueProtoCallback)new RevenueProto.RevenueProtoCallback(){

            public void onError(Call call, Exception e, int id2) {
                FeatureLog.e((String)"FTPayCouponCouponRequest", (String)"queryCouponListAsync onError", (Object[])new Object[]{e});
                String msg = e.getMessage();
                PayUtils.callbackFailed(callback, 30002, msg);
                int code = NetworkUtils.getErrorCodeByExc((Throwable)e);
                PayMonitor.reportRequestMetri(seq, String.valueOf(code));
                PayMonitor.monitorRequestFailed(seq, code, msg);
            }

            public void onResponse(RevenueProtoRes response, int id2) {
                FeatureLog.i((String)"FTPayCouponCouponRequest", (String)"queryCouponListAsync onResponse: %s", (Object[])new Object[]{response});
                if (YYTaskExecutor.isMainThread()) {
                    YYTaskExecutor.execute(() -> CouponRequest.this.handleCouponListRes(response, (IPayCallback<List<CouponBean>>)callback));
                } else {
                    CouponRequest.this.handleCouponListRes(response, (IPayCallback<List<CouponBean>>)callback);
                }
            }
        });
    }

    @WorkerThread
    private void handleCouponListRes(RevenueProtoRes response, IPayCallback<List<CouponBean>> callback) {
        CouponListResponse res = PayRequestUtils.parseResponse(response, CouponListResponse.class);
        if (res == null) {
            PayUtils.callbackFailed(callback, 30001, "maybe parse response json error");
            return;
        }
        if (res.result != 1) {
            FeatureLog.i((String)"FTPayCouponCouponRequest", (String)"queryCouponListAsync error code: %d", (Object[])new Object[]{res.result});
            PayUtils.callbackFailed(callback, res.result, res.message);
            return;
        }
        List<CouponBean> userCouponList = res.userCouponList;
        if (!FP.empty(userCouponList)) {
            long currentTimeSeconds = System.currentTimeMillis();
            for (CouponBean bean : userCouponList) {
                bean.serverCurrentTime = res.serverCurrentTime;
                bean.localCurrentTime = currentTimeSeconds;
            }
        }
        PayUtils.callbackSucceed(callback, userCouponList);
    }

    public void queryCouponDiscountAsync(final long userCouponId, List<Integer> chargeConfigIds, final IPayCallback<List<CouponDiscountBean>> callback) {
        if (FP.empty(chargeConfigIds)) {
            MLog.error((Object)TAG, (String)"queryCouponDiscountAsync chargeConfigIds is empty", (Object[])new Object[0]);
            PayUtils.callbackFailed(callback, 30002, "chargeConfigIds is empty");
            return;
        }
        if (this.mCouponCache.containsKey(userCouponId)) {
            CouponDiscountResponse response = this.mCouponCache.get(userCouponId);
            if (response != null) {
                MLog.info((Object)TAG, (String)"queryCouponDiscountAsync return from cache", (Object[])new Object[0]);
                this.handleCouponDiscountRes(null, response, "", userCouponId, callback);
                return;
            }
            this.mCouponCache.remove(userCouponId);
        }
        RevenueProtoReq.Builder builder = RevenueProtoReq.newBuilder();
        builder.appId(1802);
        builder.version(0);
        builder.cmd(1052);
        builder.countryCode(AccountUtil.realCountry());
        final String seq = RevenueProto.uniqueSeq();
        JsonStringBuilder param = RevenueProto.getCommonParam();
        param.put("cmd", (Object)1052);
        param.put("seq", (Object)seq);
        param.put("uid", (Object)AccountUtil.getUid());
        param.put("appId", (Object)1802);
        param.put("userCouponId", (Object)userCouponId);
        param.put("usedChannel", (Object)PayUtils.getPayUseChannel());
        JSONArray jsonArray = new JSONArray();
        for (Integer chargeConfigId : chargeConfigIds) {
            jsonArray.put((Object)chargeConfigId);
        }
        param.put("chargeConfigIds", (Object)jsonArray);
        builder.jsonMsg(param.jsonObject());
        RevenueProtoReq req = builder.build();
        final String url = RevenueProto.getUrl((String)"query", (int)req.getCmd());
        FeatureLog.i((String)"FTPayCouponCouponRequest", (String)"queryCouponDiscountAsync userCouponId\uff1a%s ,url: %s", (Object[])new Object[]{userCouponId + "", url});
        RevenueProto.sendHttp((String)url, (RevenueProtoReq)req, (RevenueProto.RevenueProtoCallback)new RevenueProto.RevenueProtoCallback(){

            public void onError(Call call, Exception e, int id2) {
                FeatureLog.i((String)"FTPayCouponCouponRequest", (String)"queryCouponDiscountAsync onError", (Object[])new Object[]{url});
                String msg = e.getMessage();
                PayUtils.callbackFailed(callback, 30002, msg);
                int code = NetworkUtils.getErrorCodeByExc((Throwable)e);
                PayMonitor.reportRequestMetri(seq, String.valueOf(code));
                PayMonitor.monitorRequestFailed(seq, code, msg);
            }

            public void onResponse(RevenueProtoRes response, int id2) {
                FeatureLog.i((String)"FTPayCouponCouponRequest", (String)"queryCouponDiscountAsync onResponse: %s", (Object[])new Object[]{response});
                if (YYTaskExecutor.isMainThread()) {
                    YYTaskExecutor.execute(() -> {
                        CouponDiscountResponse res = PayRequestUtils.parseResponse(response, CouponDiscountResponse.class);
                        CouponRequest.this.handleCouponDiscountRes(response, res, seq, userCouponId, (IPayCallback<List<CouponDiscountBean>>)callback);
                    });
                } else {
                    CouponDiscountResponse res = PayRequestUtils.parseResponse(response, CouponDiscountResponse.class);
                    CouponRequest.this.handleCouponDiscountRes(response, res, seq, userCouponId, (IPayCallback<List<CouponDiscountBean>>)callback);
                }
            }
        });
    }

    @WorkerThread
    private void handleCouponDiscountRes(@Nullable RevenueProtoRes response, CouponDiscountResponse res, String seq, long userCouponId, IPayCallback<List<CouponDiscountBean>> callback) {
        if (res == null) {
            PayUtils.callbackFailed(callback, 30001, "maybe parse response json error");
            if (response != null) {
                PayMonitor.monitorRequestFailed(seq, 30001, "maybe parse response json error");
            }
            return;
        }
        if (response != null) {
            PayMonitor.monitorResponse(res.seq, response.result, res.result, new String[0]);
        }
        if (res.result != 1) {
            FeatureLog.i((String)"FTPayCouponCouponRequest", (String)"queryCouponDiscountAsync error code: %d", (Object[])new Object[]{res.result});
            PayUtils.callbackFailed(callback, res.result, res.message);
            return;
        }
        this.mCouponCache.put(userCouponId, res);
        PayUtils.callbackSucceed(callback, res.discountList);
    }
}

