/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.consume;

import android.app.Activity;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.squareup.wire.AndroidMessage;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.data.JsonStringBuilder;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.IProtoCallback;
import com.yy.hiyo.proto.callback.IProtoNotify;
import com.yy.hiyo.wallet.base.IPayService;
import com.yy.hiyo.wallet.base.pay.bean.ProductItemInfo;
import com.yy.hiyo.wallet.base.pay.bean.RechargeInfo;
import com.yy.hiyo.wallet.base.pay.bean.RechargeParam;
import com.yy.hiyo.wallet.base.pay.callback.IPayCallback;
import com.yy.hiyo.wallet.base.pay.callback.IRechargeCallback;
import com.yy.hiyo.wallet.base.pay.callback.SimpleRechargeCallback;
import com.yy.hiyo.wallet.base.revenue.consume.ConsumeParam;
import com.yy.hiyo.wallet.base.revenue.consume.ConsumeResult;
import com.yy.hiyo.wallet.base.revenue.consume.IConsumeCallback;
import com.yy.hiyo.wallet.base.revenue.consume.IConsumeHandler;
import com.yy.hiyo.wallet.base.revenue.pay.IRechargeHandler;
import com.yy.hiyo.wallet.base.revenue.proto.RevenueProto;
import com.yy.hiyo.wallet.consume.IHandlerCallback;
import com.yy.hiyo.wallet.pay.PayUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.ihago.money.api.pay.ConsumeProductRequest;
import net.ihago.money.api.pay.ConsumeProductResponse;
import net.ihago.money.api.pay.DeductionNotify;
import net.ihago.money.api.pay.MoneyPayPush;
import net.ihago.money.api.pay.Uri;

class ConsumeHandler
implements IConsumeHandler,
IProtoNotify<MoneyPayPush> {
    private static final String TAG = "ConsumeHandler";
    private IHandlerCallback mHandlerCallback;
    private IConsumeCallback<ConsumeResult> mConsumeCallback;
    private ConsumeParam mConsumeParam;
    private IRechargeHandler mRechargeHandler;
    private Runnable mTimeoutTask = new Runnable(){

        @Override
        public void run() {
            MLog.info((Object)ConsumeHandler.TAG, (String)"timeout wait for consume notify", (Object[])new Object[0]);
            ConsumeHandler.this.callbackFail(2000, "timeout wait for consume notify");
        }
    };

    public ConsumeHandler(IHandlerCallback callback) {
        this.mHandlerCallback = callback;
    }

    public void consumeDiamond(final Activity activity, final ConsumeParam param, IConsumeCallback<ConsumeResult> callback) {
        this.mConsumeCallback = callback;
        this.mConsumeParam = param;
        ConsumeProductRequest request = new ConsumeProductRequest.Builder().uid(Long.valueOf(AccountUtil.getUid())).amount(Long.valueOf(param.getDiamondAmount())).currencyType(Integer.valueOf(1805)).seqId(RevenueProto.uniqueSeq()).expand(this.getConsumeExpand(param)).build();
        ProtoManager.getInstance().sendHttp((AndroidMessage)request, (IProtoCallback)new IProtoCallback<ConsumeProductResponse>(){

            public void onResponse(@Nullable ConsumeProductResponse message) {
                if (!MLog.isLogLevelAboveDebug()) {
                    MLog.debug((Object)ConsumeHandler.TAG, (String)"consumeDiamond onResponse message: %s", (Object[])new Object[]{message});
                }
                if (message != null && message.ret == 0) {
                    int code = message.code;
                    if (code == 1) {
                        ConsumeHandler.this.callbackSuccess(ConsumeHandler.this.getConsumeResult());
                    } else if (code == 8) {
                        ConsumeHandler.this.fetchRechargeList(activity, param);
                    } else {
                        ConsumeHandler.this.callbackFail(code, "service error " + code);
                    }
                } else {
                    ConsumeHandler.this.callbackFail(-1, "parse Moneyapipay.ConsumeProductResponse proto error");
                }
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                MLog.error((Object)ConsumeHandler.TAG, (String)"consumeDiamond retryWhenTimeout canRetry: %b", (Object[])new Object[]{canRetry});
                ConsumeHandler.this.callbackFail(-1, "request consume timeout");
                return false;
            }

            public boolean retryWhenError(boolean canRetry, String reason, int code) {
                MLog.error((Object)ConsumeHandler.TAG, (String)"consumeDiamond retryWhenError canRetry: %b, code: %d, reason: %s", (Object[])new Object[]{canRetry, code, reason});
                ConsumeHandler.this.callbackFail(-1, reason);
                return false;
            }
        });
    }

    public void rechargeDirect(Activity activity, ConsumeParam param, IConsumeCallback<ConsumeResult> callback) {
        this.mConsumeCallback = callback;
        this.mConsumeParam = param;
        this.fetchRechargeList(activity, param);
    }

    public void cancel() {
        this.callbackFail(2001, "cancel");
        if (this.mRechargeHandler != null) {
            this.mRechargeHandler.cancelRecharge();
        }
    }

    public void test(Activity activity, ConsumeParam param) {
    }

    public String serviceName() {
        return "net.ihago.money.api.pay";
    }

    public void onNotify(@NonNull MoneyPayPush notify) {
        if (notify.uri == Uri.kUriDeductionNotify) {
            YYTaskExecutor.removeTask((Runnable)this.mTimeoutTask);
            DeductionNotify deduction = notify.deduction_notify;
            MLog.info((Object)TAG, (String)" consume notify: %s", (Object[])new Object[]{deduction});
            this.callbackSuccess(this.getConsumeResult());
        }
    }

    private void fetchRechargeList(final Activity activity, final ConsumeParam param) {
        HashMap<String, String> expand = new HashMap<String, String>(1);
        expand.put("gameId", param.getGameId());
        final IPayService payService = (IPayService)ServiceManagerProxy.getServiceManager().getService(IPayService.class);
        payService.fetchRechargeList(102, expand, (IPayCallback)new IPayCallback<List<ProductItemInfo>>(){

            public void onSucceed(@Nullable List<ProductItemInfo> data) {
                if (ConsumeHandler.this.mRechargeHandler != null) {
                    MLog.info((Object)ConsumeHandler.TAG, (String)"is recharging", (Object[])new Object[0]);
                    return;
                }
                ConsumeHandler.this.handleRechargeList(data, param, activity);
            }

            public void onFailed(int code, String msg) {
                MLog.error((Object)ConsumeHandler.TAG, (String)"fetchRechargeList onFailed code: %d, msg: %s", (Object[])new Object[]{code, msg});
                ConsumeHandler.this.handleRechargeList(payService.fetchRechargeList(), param, activity);
            }
        });
    }

    private void handleRechargeList(@Nullable List<ProductItemInfo> data, ConsumeParam param, Activity activity) {
        if (!FP.empty(data)) {
            for (ProductItemInfo info : data) {
                if (info == null || info.cid != param.getItemId()) continue;
                RechargeParam rechargeParam = this.getRechargeParam(info, param.getGameId(), param.getPageId());
                Map map = param.toMap();
                map.put("goodsName", info.name);
                rechargeParam.addExpand(map);
                this.recharge(activity, rechargeParam);
                return;
            }
        }
        this.callbackFail(102, "can not found product to recharge");
    }

    protected RechargeParam getRechargeParam(ProductItemInfo info, String gameId, String pageId) {
        RechargeParam param = RechargeParam.newBuilder().productId(info.getProductId()).chargeConfigId(info.cid).quantity(1).unitPrice(info.getSrcAmount()).srcCurrencySymbol(info.getSrcCurrencySymbol()).useChannel(PayUtils.getPayUseChannel()).diamond(info.destAmount).isCurrencyCodeEnable(info.isCurrencyCodeEnable()).productType(info.productType).pageId(pageId).build();
        param.setFrom(102);
        if (!TextUtils.isEmpty((CharSequence)gameId)) {
            param.addExpand("gameId", (Object)gameId);
        }
        return param;
    }

    private void recharge(Activity activity, RechargeParam param) {
        ProtoManager.getInstance().registerNotify((IProtoNotify)this);
        this.mRechargeHandler = ((IPayService)ServiceManagerProxy.getServiceManager().getService(IPayService.class)).recharge(PayUtils.getPayPlatform(), activity, param, (IRechargeCallback)new SimpleRechargeCallback(){

            public void onSucceed(@Nullable RechargeInfo data) {
                MLog.info((Object)ConsumeHandler.TAG, (String)"recharge onSucceed data: %s", (Object[])new Object[]{data});
                YYTaskExecutor.execute((Runnable)ConsumeHandler.this.mTimeoutTask, (long)5000L);
            }

            public void onFailed(int code, String msg) {
                super.onFailed(code, msg);
                MLog.info((Object)ConsumeHandler.TAG, (String)"recharge onFailed code: %d, msg: %s", (Object[])new Object[]{code, msg});
                ConsumeHandler.this.callbackFail(code, msg);
            }
        });
    }

    private String getConsumeExpand(ConsumeParam param) {
        String json = JsonStringBuilder.newBuilder().putAll(param.toMap()).buildJson();
        return json;
    }

    private void callbackSuccess(final ConsumeResult result) {
        this.onFinished();
        final IConsumeCallback<ConsumeResult> callback = this.mConsumeCallback;
        this.mConsumeCallback = null;
        if (callback == null) {
            return;
        }
        if (YYTaskExecutor.isMainThread()) {
            callback.onSucceed((Object)result);
        } else {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    callback.onSucceed((Object)result);
                }
            });
        }
    }

    private void callbackFail(final int code, final String msg) {
        this.onFinished();
        final IConsumeCallback<ConsumeResult> callback = this.mConsumeCallback;
        this.mConsumeCallback = null;
        if (callback == null) {
            return;
        }
        if (YYTaskExecutor.isMainThread()) {
            callback.onFailed(code, msg);
        } else {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    callback.onFailed(code, msg);
                }
            });
        }
    }

    private void onFinished() {
        if (this.mHandlerCallback != null) {
            this.mHandlerCallback.onFinished(this);
        }
        ProtoManager.getInstance().unregisterNotify((IProtoNotify)this);
        this.mRechargeHandler = null;
    }

    private ConsumeResult getConsumeResult() {
        ConsumeResult result = ConsumeResult.newBuilder().openId(this.mConsumeParam.getOpenId()).companyId(this.mConsumeParam.getCompanyId()).companyOrderId(this.mConsumeParam.getCompanyOrderId()).diamondAmount(this.mConsumeParam.getDiamondAmount()).itemId(this.mConsumeParam.getItemId()).build();
        return result;
    }
}

