/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.ad.config;

import androidx.annotation.Nullable;
import com.yy.base.utils.FP;
import com.yy.hiyo.wallet.ad.AdConfigureManager;
import com.yy.hiyo.wallet.ad.config.AdLocalConfigUtils;
import com.yy.hiyo.wallet.ad.config.AdvertiseConfigInfo;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class AdLocalConfigModel {
    private static final String TAG = "AdLocalConfigModel";
    private final Map<Integer, AdvertiseConfigInfo> mAdConfigs = new ConcurrentHashMap<Integer, AdvertiseConfigInfo>();

    public static AdLocalConfigModel getInstance() {
        return Instance.instance;
    }

    private AdLocalConfigModel() {
    }

    public void addAdConfig(int localId, AdvertiseConfigInfo info) {
        this.mAdConfigs.put(localId, info);
    }

    public void clear() {
        this.mAdConfigs.clear();
    }

    @Nullable
    public AdvertiseConfigInfo getAdConfig(int localAdId) {
        if (localAdId == 0) {
            return null;
        }
        return this.mAdConfigs.get(localAdId);
    }

    public Map<Integer, AdvertiseConfigInfo> getAdConfigs() {
        return this.mAdConfigs;
    }

    public void addLocalAdConfig(int localId, int advertiseType) {
        AdvertiseConfigInfo info = AdLocalConfigUtils.createAdConfigInfo(localId, advertiseType);
        if (!FP.empty(info.getAdDetails())) {
            this.mAdConfigs.put(localId, info);
            AdConfigureManager.INSTANCE.updateConfigBean();
        }
    }

    private static class Instance {
        static AdLocalConfigModel instance = new AdLocalConfigModel();

        private Instance() {
        }
    }
}

