/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.ad;

import android.content.Context;
import android.os.Build;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.base.memoryrecycle.views.YYImageView;
import com.yy.base.memoryrecycle.views.YYRelativeLayout;
import com.yy.base.utils.ResolutionUtils;
import com.yy.hiyo.wallet.R;
import com.yy.hiyo.wallet.ad.AdConfigureManager;
import com.yy.hiyo.wallet.ad.data.AdConfigBean;
import com.yy.socialplatformbase.AbsPlatformAdapter;
import com.yy.socialplatformbase.R;
import com.yy.socialplatformbase.ThirdPartyPlatformHelper;
import com.yy.socialplatformbase.callback.IAdCallback;
import com.yy.socialplatformbase.data.AdEntity;
import java.util.ArrayList;

public class AdViewProvider {
    private Context mContext;

    public AdViewProvider(Context context) {
        this.mContext = context;
    }

    public void inflateNativeView(int localAdId, int adUiType, AdEntity adEntity, ViewGroup adContainer, boolean showCloseBtn, IAdCallback callback, View.OnClickListener listener) {
        if (AdConfigureManager.INSTANCE.isNativeFullScreenAd(localAdId)) {
            this.inflateNativeAdView(localAdId, adEntity, adContainer, showCloseBtn, callback, listener);
        } else if (adUiType == 1) {
            this.inflateNativeBannerAdView(localAdId, adEntity, adContainer, showCloseBtn, callback, listener);
        } else if (adUiType == 2) {
            this.inflateTopNativeBannerAdView(localAdId, adEntity, adContainer, showCloseBtn, callback, listener);
        } else if (adUiType == 3) {
            this.inflateBottomNativeBannerAdView(localAdId, adEntity, adContainer, showCloseBtn, callback, listener);
        }
    }

    private void inflateNativeBannerAdView(int localAdId, AdEntity adEntity, ViewGroup adContainer, boolean showCloseBtn, IAdCallback callback, View.OnClickListener listener) {
        if (adContainer == null) {
            return;
        }
        adContainer.setVisibility(8);
        adContainer.removeAllViews();
        View adView = LayoutInflater.from((Context)this.mContext).inflate(R.layout.native_banner_ad_unit, adContainer, false);
        adContainer.addView(adView);
        adContainer.setVisibility(0);
        LinearLayout adChoicesContainerRoot = (LinearLayout)adView.findViewById(R.id.ad_choices_container_root);
        RelativeLayout adChoicesContainer = (RelativeLayout)adView.findViewById(R.id.ad_choices_container);
        LinearLayout adContent = (LinearLayout)adView.findViewById(R.id.llyt_ad_content);
        if (4 == localAdId) {
            RelativeLayout.LayoutParams adChoicesContainerRootLayoutParams;
            RelativeLayout.LayoutParams adContentLayoutParams = (RelativeLayout.LayoutParams)adContent.getLayoutParams();
            if (adContentLayoutParams != null) {
                if (Build.VERSION.SDK_INT >= 17) {
                    adContentLayoutParams.setMarginStart(ResolutionUtils.dip2Px((float)16.0f));
                    adContentLayoutParams.setMarginEnd(ResolutionUtils.dip2Px((float)16.0f));
                }
                adContentLayoutParams.setMargins(ResolutionUtils.dip2Px((float)16.0f), adContentLayoutParams.topMargin, ResolutionUtils.dip2Px((float)16.0f), 0);
                adContent.setLayoutParams((ViewGroup.LayoutParams)adContentLayoutParams);
            }
            if ((adChoicesContainerRootLayoutParams = (RelativeLayout.LayoutParams)adChoicesContainerRoot.getLayoutParams()) != null) {
                if (Build.VERSION.SDK_INT >= 17) {
                    adChoicesContainerRootLayoutParams.setMarginStart(ResolutionUtils.dip2Px((float)14.0f));
                }
                adChoicesContainerRootLayoutParams.setMargins(ResolutionUtils.dip2Px((float)14.0f), adChoicesContainerRootLayoutParams.topMargin, 0, 0);
                adChoicesContainerRoot.setLayoutParams((ViewGroup.LayoutParams)adChoicesContainerRootLayoutParams);
            }
        }
        TextView nativeAdTitle = (TextView)adView.findViewById(R.id.native_ad_title);
        TextView nativeAdSocialContext = (TextView)adView.findViewById(R.id.native_ad_social_context);
        TextView sponsoredLabel = (TextView)adView.findViewById(R.id.native_ad_sponsored_label);
        YYRelativeLayout adIconContainer = (YYRelativeLayout)adView.findViewById(R.id.native_ad_icon_container);
        Button nativeAdCallToAction = (Button)adView.findViewById(R.id.native_ad_call_to_action);
        YYImageView ivClose = (YYImageView)adView.findViewById(R.id.iv_ad_close);
        if (showCloseBtn) {
            ivClose.setVisibility(0);
            ivClose.setOnClickListener(listener);
        } else {
            ivClose.setVisibility(8);
        }
        nativeAdCallToAction.setText((CharSequence)adEntity.adCallToActionText);
        nativeAdCallToAction.setVisibility(adEntity.hasCallToAction ? 0 : 4);
        nativeAdTitle.setText((CharSequence)adEntity.advertiserName);
        nativeAdSocialContext.setText((CharSequence)adEntity.adSocialContext);
        sponsoredLabel.setText((CharSequence)adEntity.sponsoredTranslationText);
        ArrayList<Object> clickableViews = new ArrayList<Object>();
        clickableViews.add(nativeAdCallToAction);
        clickableViews.add(adIconContainer);
        clickableViews.add(nativeAdTitle);
        clickableViews.add(nativeAdSocialContext);
        AdConfigBean adConfigBean = AdConfigureManager.INSTANCE.getLocalAdPlacementMap().get(localAdId);
        if (adConfigBean != null) {
            AbsPlatformAdapter platformAdapter = ThirdPartyPlatformHelper.getInstance().getPlatform(adConfigBean.getAdPlatformId());
            platformAdapter.registerViewForAd(adEntity, adView, adChoicesContainer, null, (RelativeLayout)adIconContainer, clickableViews, callback);
        }
    }

    private void inflateTopNativeBannerAdView(int localAdId, AdEntity adEntity, ViewGroup adContainer, boolean showCloseBtn, IAdCallback callback, View.OnClickListener listener) {
        if (adContainer == null) {
            return;
        }
        adContainer.setVisibility(8);
        adContainer.removeAllViews();
        View adView = LayoutInflater.from((Context)this.mContext).inflate(R.layout.dark_native_banner_ad_unit, adContainer, false);
        adContainer.addView(adView);
        adContainer.setVisibility(0);
        RelativeLayout adChoicesContainer = (RelativeLayout)adView.findViewById(R.id.ad_choices_container);
        LinearLayout adContent = (LinearLayout)adView.findViewById(R.id.llyt_ad_content);
        TextView nativeAdTitle = (TextView)adView.findViewById(R.id.native_ad_title);
        TextView nativeAdSocialContext = (TextView)adView.findViewById(R.id.native_ad_social_context);
        YYRelativeLayout adIconContainer = (YYRelativeLayout)adView.findViewById(R.id.native_ad_icon_container);
        Button nativeAdCallToAction = (Button)adView.findViewById(R.id.native_ad_call_to_action);
        YYImageView ivAdIcon = (YYImageView)adView.findViewById(R.id.iv_top_ad_icon);
        ivAdIcon.setVisibility(0);
        YYImageView ivClose = (YYImageView)adView.findViewById(R.id.iv_top_ad_close);
        if (showCloseBtn) {
            ivClose.setVisibility(0);
            ivClose.setOnClickListener(listener);
        } else {
            ivClose.setVisibility(8);
        }
        nativeAdCallToAction.setText((CharSequence)adEntity.adCallToActionText);
        nativeAdCallToAction.setVisibility(adEntity.hasCallToAction ? 0 : 4);
        nativeAdTitle.setText((CharSequence)adEntity.advertiserName);
        nativeAdSocialContext.setText((CharSequence)adEntity.adSocialContext);
        ArrayList<Object> clickableViews = new ArrayList<Object>();
        clickableViews.add(nativeAdCallToAction);
        clickableViews.add(adIconContainer);
        clickableViews.add(nativeAdTitle);
        clickableViews.add(nativeAdSocialContext);
        AdConfigBean adConfigBean = AdConfigureManager.INSTANCE.getLocalAdPlacementMap().get(localAdId);
        if (adConfigBean != null) {
            AbsPlatformAdapter platformAdapter = ThirdPartyPlatformHelper.getInstance().getPlatform(adConfigBean.getAdPlatformId());
            platformAdapter.registerViewForAd(adEntity, adView, adChoicesContainer, null, (RelativeLayout)adIconContainer, clickableViews, callback);
        }
    }

    private void inflateBottomNativeBannerAdView(int localAdId, AdEntity adEntity, ViewGroup adContainer, boolean showCloseBtn, IAdCallback callback, View.OnClickListener listener) {
        if (adContainer == null) {
            return;
        }
        adContainer.setVisibility(8);
        adContainer.removeAllViews();
        View adView = LayoutInflater.from((Context)this.mContext).inflate(R.layout.dark_native_banner_ad_unit, adContainer, false);
        adContainer.addView(adView);
        adContainer.setVisibility(0);
        RelativeLayout adChoicesContainer = (RelativeLayout)adView.findViewById(R.id.ad_choices_container);
        LinearLayout adContent = (LinearLayout)adView.findViewById(R.id.llyt_ad_content);
        TextView nativeAdTitle = (TextView)adView.findViewById(R.id.native_ad_title);
        TextView nativeAdSocialContext = (TextView)adView.findViewById(R.id.native_ad_social_context);
        YYRelativeLayout adIconContainer = (YYRelativeLayout)adView.findViewById(R.id.native_ad_icon_container);
        Button nativeAdCallToAction = (Button)adView.findViewById(R.id.native_ad_call_to_action);
        YYImageView ivAdIcon = (YYImageView)adView.findViewById(R.id.iv_bottom_ad_icon);
        ivAdIcon.setVisibility(0);
        YYImageView ivClose = (YYImageView)adView.findViewById(R.id.iv_bottom_ad_close);
        if (showCloseBtn) {
            ivClose.setVisibility(0);
            ivClose.setOnClickListener(listener);
        } else {
            ivClose.setVisibility(8);
        }
        nativeAdCallToAction.setText((CharSequence)adEntity.adCallToActionText);
        nativeAdCallToAction.setVisibility(adEntity.hasCallToAction ? 0 : 4);
        nativeAdTitle.setText((CharSequence)adEntity.advertiserName);
        nativeAdSocialContext.setText((CharSequence)adEntity.adSocialContext);
        ArrayList<Object> clickableViews = new ArrayList<Object>();
        clickableViews.add(nativeAdCallToAction);
        clickableViews.add(adIconContainer);
        clickableViews.add(nativeAdTitle);
        clickableViews.add(nativeAdSocialContext);
        AdConfigBean adConfigBean = AdConfigureManager.INSTANCE.getLocalAdPlacementMap().get(localAdId);
        if (adConfigBean != null) {
            AbsPlatformAdapter platformAdapter = ThirdPartyPlatformHelper.getInstance().getPlatform(adConfigBean.getAdPlatformId());
            platformAdapter.registerViewForAd(adEntity, adView, adChoicesContainer, null, (RelativeLayout)adIconContainer, clickableViews, callback);
        }
    }

    private void inflateNativeAdView(int localAdId, AdEntity adEntity, ViewGroup adContainer, boolean showCloseBtn, IAdCallback callback, View.OnClickListener listener) {
        if (adContainer == null) {
            return;
        }
        adContainer.setVisibility(8);
        adContainer.removeAllViews();
        View adView = LayoutInflater.from((Context)this.mContext).inflate(R.layout.native_ad_unit, adContainer, false);
        adContainer.addView(adView);
        adContainer.setVisibility(0);
        RelativeLayout adChoicesContainer = (RelativeLayout)adView.findViewById(R.id.ad_choices_container);
        YYFrameLayout mediaContainer = (YYFrameLayout)adView.findViewById(R.id.native_ad_media_container);
        TextView nativeAdTitle = (TextView)adView.findViewById(R.id.native_ad_title);
        TextView nativeAdSocialContext = (TextView)adView.findViewById(R.id.native_ad_social_context);
        YYRelativeLayout adIconContainer = (YYRelativeLayout)adView.findViewById(R.id.native_ad_icon_container);
        Button nativeAdCallToAction = (Button)adView.findViewById(R.id.native_ad_call_to_action);
        YYImageView ivClose = (YYImageView)adView.findViewById(R.id.iv_ad_close);
        ivClose.setOnClickListener(listener);
        nativeAdCallToAction.setText((CharSequence)adEntity.adCallToActionText);
        nativeAdCallToAction.setVisibility(adEntity.hasCallToAction ? 0 : 4);
        nativeAdTitle.setText((CharSequence)adEntity.advertiserName);
        nativeAdSocialContext.setText((CharSequence)adEntity.adSocialContext);
        ArrayList<Object> clickableViews = new ArrayList<Object>();
        clickableViews.add(nativeAdCallToAction);
        clickableViews.add(adIconContainer);
        clickableViews.add(nativeAdTitle);
        clickableViews.add(nativeAdSocialContext);
        clickableViews.add(mediaContainer);
        AdConfigBean adConfigBean = AdConfigureManager.INSTANCE.getLocalAdPlacementMap().get(localAdId);
        if (adConfigBean != null) {
            AbsPlatformAdapter platformAdapter = ThirdPartyPlatformHelper.getInstance().getPlatform(adConfigBean.getAdPlatformId());
            platformAdapter.registerViewForAd(adEntity, adView, adChoicesContainer, (FrameLayout)mediaContainer, (RelativeLayout)adIconContainer, clickableViews, callback);
        }
    }
}

