/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.ad;

import android.content.SharedPreferences;
import android.os.Build;
import android.os.SystemClock;
import androidx.annotation.NonNull;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.service.IUserInfoService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.env.RuntimeContext;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.DateUtils;
import com.yy.base.utils.SharedPreferencesUtils;
import com.yy.base.utils.StringUtils;
import com.yy.hiyo.wallet.ad.AdConfigAllModel;
import com.yy.hiyo.wallet.ad.AdStatisHelper;
import com.yy.hiyo.wallet.ad.config.AdvertiseConfigInfo;
import com.yy.hiyo.wallet.ad.config.AdvertiseDetail;
import com.yy.hiyo.wallet.ad.data.AdConfigBean;
import com.yy.socialplatformbase.data.AdPlatform;
import com.yy.socialplatformbase.data.AdvertiseType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;

public enum AdConfigureManager {
    INSTANCE;

    private static final String TAG = "FTAdv_AdConfigureManager";
    private static final int AD_CACHE_EXPIRED_TIME = 3600000;
    private static final int AD_TIME_BACKGROUND = 40000;
    private static final int AD_TIME_INTERSTITIAL_INTERVAL = 3000;
    private static final int AD_TIME_PK_GAME_CONSUMED_LIMIT = 6000000;
    private static final String TIME_PK_GAME_CONSUME = "pk_game_time";
    private final Map<Integer, AdConfigBean> mLocalAdPlacementMap = new ConcurrentHashMap<Integer, AdConfigBean>();
    private final Map<Integer, AdConfigBean> mOriginLocalAdPlacementMap = new ConcurrentHashMap<Integer, AdConfigBean>();
    private Map<Integer, Long> mRequestTimestampMap = new HashMap<Integer, Long>();
    private final Map<Integer, Long> mAdCacheTimestampMap = new HashMap<Integer, Long>();
    private long mGameStartTime = 0L;
    private long mGameEndTime = 0L;
    private long mBackgroundTime = 0L;
    private long mInterstitialAdDismissTimeStamp = 0L;
    private boolean isBackToFrontInterstitialAdShow = false;
    private boolean isBackFromImAndGamePage = false;
    private int mGameWinStreakTime = 0;
    private long mPkGameConsumedTotalTime = 0L;
    private SharedPreferences mSharedPreferences;
    private Set<AdPlatform> mInitAdPlatformList = new CopyOnWriteArraySet<AdPlatform>();
    private List<AdPlatform> mAllowedAdPlatformConfigList = new CopyOnWriteArrayList<AdPlatform>();

    public void updateConfigBean() {
        if (RuntimeContext.sIsDebuggable) {
            FeatureLog.i((String)"FTAdv", (String)"updateConfigBean mAllowedAdPlatformConfigList=%s", (Object[])new Object[]{this.mAllowedAdPlatformConfigList});
        }
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                UserInfoKS userInfoKS = ((IUserInfoService)ServiceManagerProxy.getService(IUserInfoService.class)).getUserInfo(AccountUtil.getUid());
                Map<Integer, AdvertiseConfigInfo> adConfigMap = AdConfigAllModel.getInstance().getAdConfigs();
                AdConfigureManager.this.mLocalAdPlacementMap.clear();
                for (Map.Entry<Integer, AdvertiseConfigInfo> entry : adConfigMap.entrySet()) {
                    AdvertiseConfigInfo info = entry.getValue();
                    List<AdvertiseDetail> advertiseDetailList = info.getAdDetails();
                    if (advertiseDetailList == null || advertiseDetailList.size() <= 0) continue;
                    for (int i = 0; i < advertiseDetailList.size(); ++i) {
                        AdvertiseDetail advertiseDetail = advertiseDetailList.get(i);
                        AdConfigureManager.this.mInitAdPlatformList.add(advertiseDetail.getPlatform());
                        if (AdConfigureManager.this.mLocalAdPlacementMap.containsKey(entry.getKey()) || !AdConfigureManager.this.mAllowedAdPlatformConfigList.contains(advertiseDetail.getPlatform()) || AdConfigureManager.this.isLimitFbAd(advertiseDetail.getPlatform(), advertiseDetail.getAdType(), userInfoKS)) continue;
                        if (RuntimeContext.isInGray()) {
                            FeatureLog.i((String)"FTAdv", (String)"updateConfigBean localId=%d, %s, %s, %s", (Object[])new Object[]{entry.getKey(), advertiseDetail.getAdId(), advertiseDetail.getAdType(), advertiseDetail.getPlatform()});
                        }
                        AdConfigureManager.this.mLocalAdPlacementMap.put(entry.getKey(), new AdConfigBean(advertiseDetail.getAdId(), advertiseDetail.getAdType().getValue(), AdConfigureManager.this.getConstDefPlatformId(advertiseDetail.getPlatform())));
                    }
                }
                AdConfigureManager.this.mOriginLocalAdPlacementMap.clear();
                for (Map.Entry<Integer, AdvertiseConfigInfo> entry : AdConfigureManager.this.mLocalAdPlacementMap.entrySet()) {
                    entry.getKey();
                    entry.getValue();
                    AdConfigureManager.this.mOriginLocalAdPlacementMap.put(entry.getKey(), AdConfigBean.copy((AdConfigBean)((Object)entry.getValue())));
                }
            }
        });
    }

    public boolean updateAdIdConfig(int localAdId, int errorCode) {
        if (this.mLocalAdPlacementMap.containsKey(localAdId)) {
            List<AdvertiseDetail> advertiseDetailList;
            AdConfigBean adConfigBean = this.mLocalAdPlacementMap.get(localAdId);
            if (adConfigBean == null) {
                return false;
            }
            AdvertiseConfigInfo info = AdConfigAllModel.getInstance().getAdConfig(localAdId);
            if (info != null && (advertiseDetailList = info.getAdDetails()) != null) {
                int index = -1;
                UserInfoKS userInfoKS = ((IUserInfoService)ServiceManagerProxy.getService(IUserInfoService.class)).getUserInfo(AccountUtil.getUid());
                for (int i = 0; i < advertiseDetailList.size(); ++i) {
                    if (!adConfigBean.getPlacementId().equals(advertiseDetailList.get(i).getAdId())) continue;
                    index = i;
                    break;
                }
                if (index >= 0) {
                    FeatureLog.i((String)"FTAdv", (String)"AdConfigureManager updateAdIdConfig index=%d,localAdId=%d", (Object[])new Object[]{++index, localAdId});
                    while (index < advertiseDetailList.size()) {
                        AdvertiseDetail advertiseDetail = advertiseDetailList.get(index);
                        if (this.mAllowedAdPlatformConfigList.contains(advertiseDetail.getPlatform()) && !this.isLimitFbAd(advertiseDetail.getPlatform(), advertiseDetail.getAdType(), userInfoKS)) {
                            FeatureLog.i((String)"FTAdv", (String)"AdConfigureManager updateAdIdConfig index=%d", (Object[])new Object[]{index});
                            AdStatisHelper.monitorChangedId(localAdId, adConfigBean, advertiseDetail, errorCode);
                            adConfigBean.setPlacementId(advertiseDetail.getAdId());
                            adConfigBean.setAdContentType(advertiseDetail.getAdType().getValue());
                            adConfigBean.setAdPlatformId(this.getConstDefPlatformId(advertiseDetail.getPlatform()));
                            return true;
                        }
                        ++index;
                    }
                }
            }
        }
        return false;
    }

    public void refreshAdConfig(int localAdId) {
        FeatureLog.i((String)"FTAdv", (String)"AdConfigureManager refreshAdConfig localAdId=%s", (Object[])new Object[]{localAdId});
        AdConfigBean localAdConfigBean = this.mLocalAdPlacementMap.get(localAdId);
        AdConfigBean originAdConfigBean = this.mOriginLocalAdPlacementMap.get(localAdId);
        if (!(localAdConfigBean == null || originAdConfigBean == null || StringUtils.isEmpty((String)localAdConfigBean.getPlacementId()) || StringUtils.isEmpty((String)originAdConfigBean.getPlacementId()) || localAdConfigBean.getPlacementId().equals(originAdConfigBean.getPlacementId()))) {
            FeatureLog.i((String)"FTAdv", (String)"AdConfigureManager refreshAdConfig originAdConfigBean.getPlacementId()=%s", (Object[])new Object[]{originAdConfigBean.getPlacementId()});
            AdConfigBean adConfigBean = AdConfigBean.copy(originAdConfigBean);
            this.mLocalAdPlacementMap.put(localAdId, adConfigBean);
        }
    }

    public void setAllowedAdPlatformConfigList(List<AdPlatform> list) {
        this.mAllowedAdPlatformConfigList.clear();
        this.mAllowedAdPlatformConfigList.addAll(list);
    }

    public List<AdPlatform> getAllowedAdPlatformConfigList() {
        return this.mAllowedAdPlatformConfigList;
    }

    public void setAdCacheTimestamp(int localAdId, long timeStamp) {
        this.mAdCacheTimestampMap.put(localAdId, timeStamp);
    }

    public long getAdCacheTimestamp(int localAdId) {
        Long stamp = this.mAdCacheTimestampMap.get(localAdId);
        return stamp == null ? 0L : stamp;
    }

    public long removeCacheTimestamp(int localAdId) {
        if (this.mAdCacheTimestampMap.containsKey(localAdId)) {
            return this.mAdCacheTimestampMap.remove(localAdId);
        }
        return 0L;
    }

    public boolean isAdCacheExpired(int localAdId) {
        if (this.mAdCacheTimestampMap.containsKey(localAdId)) {
            long passedTime = SystemClock.elapsedRealtime() - this.mAdCacheTimestampMap.get(localAdId);
            if (passedTime > 3600000L) {
                FeatureLog.i((String)"FTAdv", (String)"AdConfigureManager isAdCacheExpired %d=yes", (Object[])new Object[]{localAdId});
                return true;
            }
            FeatureLog.i((String)"FTAdv", (String)"AdConfigureManager isAdCacheExpired %d=no", (Object[])new Object[]{localAdId});
            return false;
        }
        MLog.info((Object)TAG, (String)"isAdCacheExpired %d=false, no cache", (Object[])new Object[]{localAdId});
        return true;
    }

    public void clearAdCacheTimestampMap() {
        this.mAdCacheTimestampMap.clear();
    }

    public boolean needCacheAfterShowAd(int localAdId) {
        if (!this.isRewardVideoAd(localAdId)) {
            return false;
        }
        return localAdId != 100 && localAdId != 201 && localAdId != 300;
    }

    public boolean canRequestAd(int localAdId) {
        AdvertiseConfigInfo info = AdConfigAllModel.getInstance().getAdConfig(localAdId);
        if (info == null) {
            FeatureLog.i((String)"FTAdv", (String)"AdConfigureManager canRequestAd AdvertiseConfigInfo=null, localAdId=%d", (Object[])new Object[]{localAdId});
            return false;
        }
        if (this.canShowAdAfterInstalled(info.getFirstReq()) && this.canRequestAdByInterval(localAdId, info.getReqInterval())) {
            FeatureLog.i((String)"FTAdv", (String)"AdConfigureManager canRequestAd %d", (Object[])new Object[]{localAdId});
            return true;
        }
        return false;
    }

    public boolean canShowAdByGameConsumedTime(int localAdId) {
        AdvertiseConfigInfo info = AdConfigAllModel.getInstance().getAdConfig(localAdId);
        if (info == null) {
            return false;
        }
        FeatureLog.i((String)"FTAdv", (String)"AdConfigureManager canShowAdByGameConsumedTime localAdId=%d, info.getGameMins()=%d, mGameEndTime - mGameStartTime=%d", (Object[])new Object[]{localAdId, info.getGameMins(), this.mGameEndTime - this.mGameStartTime});
        return this.mGameEndTime - this.mGameStartTime > (long)(info.getGameMins() * 60 * 1000);
    }

    public boolean canShowAdByPKGameWinStreakTime(int localAdId) {
        AdvertiseConfigInfo info = AdConfigAllModel.getInstance().getAdConfig(localAdId);
        if (info == null) {
            return false;
        }
        FeatureLog.i((String)"FTAdv", (String)"AdConfigureManager canShowAdByPKGameWinStreakTime localAdId=%s, info.getWinStreakTime()=%d, mGameWinStreakTime=%d", (Object[])new Object[]{localAdId, info.getWinStreakTime(), this.mGameWinStreakTime});
        return this.mGameWinStreakTime >= info.getWinStreakTime();
    }

    public boolean canShowAdByPkGameConsumedTime(int localAdId) {
        AdvertiseConfigInfo info = AdConfigAllModel.getInstance().getAdConfig(localAdId);
        if (info == null) {
            return false;
        }
        FeatureLog.i((String)"FTAdv", (String)"AdConfigureManager canShowAdByGameConsumedTime localAdId=%d, info.getGameMins()=%d, mPkGameConsumedTotalTime=%d", (Object[])new Object[]{localAdId, info.getGameMins() * 60 * 1000, this.mPkGameConsumedTotalTime});
        return this.mPkGameConsumedTotalTime > (long)(info.getGameMins() * 60 * 1000);
    }

    public boolean isShowPkGameAd(int localAdId) {
        return localAdId == 300;
    }

    public boolean canShowGameAd(int localAdId) {
        return this.canShowAdByPkGameConsumedTime(localAdId) && this.canShowAdByPKGameWinStreakTime(localAdId);
    }

    public boolean canAdClose(int localAdId) {
        AdvertiseConfigInfo info = AdConfigAllModel.getInstance().getAdConfig(localAdId);
        if (info == null) {
            return false;
        }
        boolean canClose = info.isCanClose();
        FeatureLog.i((String)"FTAdv", (String)("AdConfigureManager canAdClose\uff1a" + localAdId + "  canAdClose\uff1a" + canClose), (Object[])new Object[0]);
        return canClose;
    }

    public int getAdUiType(int localAdId) {
        AdvertiseConfigInfo info = AdConfigAllModel.getInstance().getAdConfig(localAdId);
        if (info == null) {
            return 1;
        }
        return StringUtils.parseInt((String)info.getUiSchema());
    }

    public boolean canShowAdAfterInstalled(long timeInterval) {
        FeatureLog.i((String)"FTAdv", (String)"AdConfigureManager canShowAdAfterInstalled timeInterval=%d\uff0c%d", (Object[])new Object[]{timeInterval, RuntimeContext.sStartAtFirstInstalledTime});
        if (RuntimeContext.sStartAtFirstInstalledTime == 0L) {
            return true;
        }
        return System.currentTimeMillis() - RuntimeContext.sStartAtFirstInstalledTime > timeInterval * 60L * 1000L;
    }

    public void setRequestTimestamp(int localAdId, long timeStamp) {
        this.mRequestTimestampMap.put(localAdId, timeStamp);
    }

    public boolean canRequestAdByInterval(int localAdId, long timeInterval) {
        if (this.mRequestTimestampMap.containsKey(localAdId)) {
            FeatureLog.i((String)"FTAdv", (String)"AdConfigureManager canRequestAdByInterval mRequestTimestampMap.get(localAdId)=%d", (Object[])new Object[]{this.mRequestTimestampMap.get(localAdId)});
            if (System.currentTimeMillis() - this.mRequestTimestampMap.get(localAdId) > timeInterval * 60L * 1000L) {
                if (RuntimeContext.sIsDebuggable) {
                    FeatureLog.i((String)"FTAdv", (String)"canRequestAdByInterval >timeInterval", (Object[])new Object[0]);
                }
                return true;
            }
            if (RuntimeContext.sIsDebuggable) {
                FeatureLog.i((String)"FTAdv", (String)"canRequestAdByInterval <timeInterval", (Object[])new Object[0]);
            }
            return false;
        }
        if (RuntimeContext.sIsDebuggable) {
            FeatureLog.i((String)"FTAdv", (String)"canRequestAdByInterval no", (Object[])new Object[0]);
        }
        return true;
    }

    public int getAdLineNumber(int localAdId) {
        AdvertiseConfigInfo info = AdConfigAllModel.getInstance().getAdConfig(localAdId);
        if (info == null) {
            return -1;
        }
        return info.getLineNo();
    }

    public boolean canAdvertiseTypeCache(int localAdId) {
        AdConfigBean bean;
        if (this.mLocalAdPlacementMap.containsKey(localAdId) && (bean = this.mLocalAdPlacementMap.get(localAdId)) != null) {
            return bean.getAdContentType() != AdvertiseType.smallBanner.getValue() && bean.getAdContentType() != AdvertiseType.bigBanner.getValue();
        }
        return false;
    }

    public boolean canNativeInflate(int localAdId) {
        AdConfigBean bean;
        if (this.mLocalAdPlacementMap.containsKey(localAdId) && (bean = this.mLocalAdPlacementMap.get(localAdId)) != null) {
            return bean.getAdContentType() == AdvertiseType.nativeAd.getValue() || bean.getAdContentType() == AdvertiseType.nativeBanner.getValue();
        }
        return false;
    }

    public boolean isNativeFullScreenAd(int localAdId) {
        AdConfigBean bean;
        if (this.mLocalAdPlacementMap.containsKey(localAdId) && (bean = this.mLocalAdPlacementMap.get(localAdId)) != null) {
            return (localAdId == 100 || localAdId == 201 || localAdId == 300) && bean.getAdContentType() == AdvertiseType.nativeAd.getValue();
        }
        return false;
    }

    public int dealWithGoogleRewardVideoAd(int localAdId) {
        if (localAdId == 103 && INSTANCE.isGoogleRewardVideoAd(localAdId) && INSTANCE.isGoogleRewardVideoAd(102)) {
            FeatureLog.i((String)"FTAdv", (String)"AdManager dealWithGoogleRewardVideoAd=%s", (Object[])new Object[]{localAdId});
            return 102;
        }
        return localAdId;
    }

    public void setBackFromImAndGamePage(boolean backFromImAndGamePage) {
        FeatureLog.i((String)"FTAdv", (String)"AdConfigureManager backFromImAndGamePage=%b", (Object[])new Object[]{backFromImAndGamePage});
        this.isBackFromImAndGamePage = backFromImAndGamePage;
    }

    public boolean isBackFromImAndGamePage() {
        return this.isBackFromImAndGamePage;
    }

    public void setGameWinStreakTime(int gameWinStreakTime) {
        FeatureLog.i((String)"FTAdv", (String)"AdConfigureManager gameWinStreakTime=%d", (Object[])new Object[]{gameWinStreakTime});
        this.mGameWinStreakTime = gameWinStreakTime;
    }

    public int getAdContentTypeByLocalId(int localAdId) {
        AdConfigBean bean;
        if (this.mLocalAdPlacementMap.containsKey(localAdId) && (bean = this.mLocalAdPlacementMap.get(localAdId)) != null) {
            return bean.getAdContentType();
        }
        return -1;
    }

    public void setGameStartTime(long singleGameStartTime) {
        this.mGameStartTime = singleGameStartTime;
    }

    public void setGameEndTime(long singleGameEndTime) {
        this.mGameEndTime = singleGameEndTime;
    }

    public boolean isBackToFrontInterstitialAdShow() {
        return this.isBackToFrontInterstitialAdShow;
    }

    public void setBackToFrontInterstitialAdShow(boolean backToFrontInterstitialAdShow) {
        this.isBackToFrontInterstitialAdShow = backToFrontInterstitialAdShow;
    }

    public void setAppBackgroundTime(long time) {
        this.mBackgroundTime = time;
    }

    public long getPkGameConsumedTotalTime() {
        return this.mPkGameConsumedTotalTime;
    }

    public void setPkGameConsumedTotalTime(int pkGameConsumedTotalTime) {
        FeatureLog.i((String)TAG, (String)"setPkGameConsumedTotalTime pkGameConsumedTotalTime=%d", (Object[])new Object[]{pkGameConsumedTotalTime});
        this.mPkGameConsumedTotalTime = pkGameConsumedTotalTime;
        this.savePkGameConsumedTotalTime(this.mPkGameConsumedTotalTime);
    }

    public void addPkGameConsumedTotalTime() {
        this.mPkGameConsumedTotalTime = this.mPkGameConsumedTotalTime + this.mGameEndTime - this.mGameStartTime;
        FeatureLog.i((String)TAG, (String)"addPkGameConsumedTotalTime=%d", (Object[])new Object[]{this.mPkGameConsumedTotalTime});
        if (this.mPkGameConsumedTotalTime > 6000000L) {
            this.mPkGameConsumedTotalTime = 6000000L;
        }
        this.savePkGameConsumedTotalTime(this.mPkGameConsumedTotalTime);
    }

    private void savePkGameConsumedTotalTime(long pkGameConsumedTotalTime) {
        if (this.mSharedPreferences == null) {
            this.mSharedPreferences = SharedPreferencesUtils.INSTANCE.getSharedPreferences(RuntimeContext.sApplicationContext, TIME_PK_GAME_CONSUME, 0);
        }
        SharedPreferences.Editor edit = this.mSharedPreferences.edit();
        edit.putLong(TIME_PK_GAME_CONSUME + AccountUtil.getUid(), pkGameConsumedTotalTime);
        edit.apply();
    }

    public void getPkGameConsumedTotalTimeFromPref() {
        if (this.mSharedPreferences == null) {
            this.mSharedPreferences = SharedPreferencesUtils.INSTANCE.getSharedPreferences(RuntimeContext.sApplicationContext, TIME_PK_GAME_CONSUME, 0);
        }
        this.mPkGameConsumedTotalTime = this.mSharedPreferences.getLong(TIME_PK_GAME_CONSUME + AccountUtil.getUid(), 0L);
        FeatureLog.i((String)TAG, (String)"getPkGameConsumedTotalTimeFromPref AccountUtil.getUid()=%d, mPkGameConsumedTotalTime=%d", (Object[])new Object[]{AccountUtil.getUid(), this.mPkGameConsumedTotalTime});
    }

    public boolean canShowBackToFrontInterstitialAd() {
        if (RuntimeContext.sIsDebuggable) {
            FeatureLog.i((String)"FTAdv", (String)"canShowBackToFrontInterstitialAd %d, %d", (Object[])new Object[]{SystemClock.elapsedRealtime() - this.mBackgroundTime, SystemClock.elapsedRealtime() - this.mInterstitialAdDismissTimeStamp});
        }
        return SystemClock.elapsedRealtime() - this.mBackgroundTime > 40000L && SystemClock.elapsedRealtime() - this.mInterstitialAdDismissTimeStamp > 3000L;
    }

    public boolean isGoogleRewardVideoAd(int localAdId) {
        AdConfigBean bean;
        if (this.mLocalAdPlacementMap.containsKey(localAdId) && (bean = this.mLocalAdPlacementMap.get(localAdId)) != null) {
            return bean.getAdContentType() == AdvertiseType.motivation.getValue() && bean.getAdPlatformId() == 6;
        }
        return false;
    }

    public boolean isUnityRewardVideoAd(int localAdId) {
        AdConfigBean bean;
        if (this.mLocalAdPlacementMap.containsKey(localAdId) && (bean = this.mLocalAdPlacementMap.get(localAdId)) != null) {
            return bean.getAdContentType() == AdvertiseType.motivation.getValue() && bean.getAdPlatformId() == 102;
        }
        return false;
    }

    public boolean isVungleRewardVideoAd(int localAdId) {
        AdConfigBean bean;
        if (this.mLocalAdPlacementMap.containsKey(localAdId) && (bean = this.mLocalAdPlacementMap.get(localAdId)) != null) {
            return bean.getAdContentType() == AdvertiseType.motivation.getValue() && bean.getAdPlatformId() == 101;
        }
        return false;
    }

    public boolean isRewardVideoAd(int localAdId) {
        AdConfigBean bean;
        if (this.mLocalAdPlacementMap.containsKey(localAdId) && (bean = this.mLocalAdPlacementMap.get(localAdId)) != null) {
            return bean.getAdContentType() == AdvertiseType.motivation.getValue();
        }
        return false;
    }

    public void setInterstitialAdDismissTimeStamp(long interstitialAdDismissTimeStamp) {
        this.mInterstitialAdDismissTimeStamp = interstitialAdDismissTimeStamp;
    }

    public Set<AdPlatform> getInitAdPlatformList() {
        return this.mInitAdPlatformList;
    }

    public boolean canShowToast(int localAdId) {
        return localAdId != 1 && localAdId != 2 && localAdId != 3 && localAdId != 4 && localAdId != 5 && localAdId != 101;
    }

    private boolean isLimitFbAd(AdPlatform adPlatformId, AdvertiseType advertiseType, UserInfoKS userInfoKS) {
        if (adPlatformId == AdPlatform.facebook && Build.VERSION.SDK_INT < 21 && advertiseType == AdvertiseType.motivation) {
            return true;
        }
        if (userInfoKS != null) {
            int age = DateUtils.getAge((String)userInfoKS.birthday);
            return adPlatformId == AdPlatform.facebook && age < 18;
        }
        return false;
    }

    @NonNull
    public Map<Integer, AdConfigBean> getLocalAdPlacementMap() {
        return this.mLocalAdPlacementMap;
    }

    public int getConstDefPlatformId(AdPlatform originPlatformId) {
        switch (originPlatformId) {
            case facebook: {
                return 5;
            }
            case google: {
                return 6;
            }
            case vungle: {
                return 101;
            }
            case unity: {
                return 102;
            }
        }
        return 0;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AdUiType {
        public static final int AD_UI_TYPE_FIRST = 1;
        public static final int AD_UI_TYPE_SECOND = 2;
        public static final int AD_UI_TYPE_THIRD = 3;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AdPlatformId {
        public static final int FACEBOOK = 5;
        public static final int GOOGLE = 6;
        public static final int VUNGLE = 101;
        public static final int UNITY = 102;
    }
}

