/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.activity;

import android.text.TextUtils;
import android.util.LruCache;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.squareup.wire.AndroidMessage;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.common.Callback;
import com.yy.base.env.TargetBuildConstant;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.SettingFlags;
import com.yy.framework.core.Environment;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.IProtoCallback;
import com.yy.hiyo.proto.callback.IProtoNotify;
import com.yy.hiyo.proto.callback.SimpleProtoCallback;
import com.yy.hiyo.wallet.activity.IActivityModel;
import com.yy.hiyo.wallet.activity.SeqCallback;
import com.yy.hiyo.wallet.base.IActivityService;
import com.yy.hiyo.wallet.base.action.ActivityAction;
import com.yy.hiyo.wallet.base.action.ActivityActionList;
import com.yy.hiyo.wallet.base.action.ActivityActionWrapper;
import com.yy.hiyo.wallet.base.action.ActivityTagInfo;
import com.yy.hiyo.wallet.base.action.GiftPanelAction;
import com.yy.hiyo.wallet.base.action.RoomActivityAction;
import com.yy.hiyo.wallet.base.action.RoomActivityActionList;
import com.yy.hiyo.wallet.base.action.RoomRightBannerNotify;
import com.yy.hiyo.wallet.base.action.WalletBannerAction;
import com.yy.hiyo.wallet.js.RevenueJsEventModule;
import com.yy.webservice.event.JsEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nonnull;
import net.ihago.money.api.appconfigcenter.ActivityBannerNotify;
import net.ihago.money.api.appconfigcenter.ActivityConfigPush;
import net.ihago.money.api.appconfigcenter.BannerNotifyCmd;
import net.ihago.money.api.appconfigcenter.BubbleNotify;
import net.ihago.money.api.appconfigcenter.GetActivityBannerInfoReq;
import net.ihago.money.api.appconfigcenter.GetActivityBannerInfoRsp;
import net.ihago.money.api.appconfigcenter.GetGiftPanelBannerInfoReq;
import net.ihago.money.api.appconfigcenter.GetGiftPanelBannerInfoRsp;
import net.ihago.money.api.appconfigcenter.GetRoomRightBannerInfoReq;
import net.ihago.money.api.appconfigcenter.GetRoomRightBannerInfoRsp;
import net.ihago.money.api.appconfigcenter.GetSpinachListBannersReq;
import net.ihago.money.api.appconfigcenter.GetSpinachListBannersRsp;
import net.ihago.money.api.appconfigcenter.GetWalletBannerInfoReq;
import net.ihago.money.api.appconfigcenter.GetWalletBannerInfoRsp;
import net.ihago.money.api.appconfigcenter.GiftPanelBannerInfo;
import net.ihago.money.api.appconfigcenter.InfoCode;
import net.ihago.money.api.appconfigcenter.PushUri;
import net.ihago.money.api.appconfigcenter.RetCode;
import net.ihago.money.api.appconfigcenter.RoomDynamicBannerShake;
import net.ihago.money.api.appconfigcenter.RoomRightBannerNotify;
import net.ihago.money.api.appconfigcenter.WalletBannerInfo;
import org.jetbrains.annotations.NotNull;

public class ActivityModel
implements IActivityModel {
    private static final String TAG = "ActivityModel";
    private static final int MAX_CACHE_SIZE = 16;
    private LruCache<String, ActivityActionWrapper<GiftPanelAction>> mGiftPanelActionCache;
    private LruCache<String, ActivityActionWrapper<WalletBannerAction>> mWalletBannerActionCache;
    private LruCache<String, ActivityActionWrapper<RoomActivityActionList>> mRoomActivityActionCache;
    private LruCache<String, ActivityActionWrapper<ActivityActionList>> mActivityBannerActionCache;
    private Set<IActivityService.OnActivityUpdateListener> mUpdateListeners;
    private IActivityService.OnRightBannerPushListener mRightBannerPushListener;
    private IActivityService.OnDynamicActListener mOnDynamicActListener;
    private static int sIndex = 0;
    private IProtoNotify mActivityConfigPush = new IProtoNotify<ActivityConfigPush>(){

        public String serviceName() {
            return "net.ihago.money.api.appconfigcenter";
        }

        public void onNotify(@NonNull ActivityConfigPush notify) {
            RoomRightBannerNotify roomRightBannerNotify;
            MLog.info((Object)ActivityModel.TAG, (String)"mActivityConfigPush onNotify", (Object[])new Object[0]);
            if (notify != null) {
                MLog.info((Object)ActivityModel.TAG, (String)("mActivityConfigPush onNotify " + notify.getUriValue()), (Object[])new Object[0]);
                if (notify.getUriValue() == PushUri.UriRoomDynamicBannerNotify.getValue()) {
                    ActivityBannerNotify bannerNotify = notify.room_dynamic_notify;
                    if (bannerNotify != null) {
                        ActivityModel.this.handleDynamicBannerNotify(bannerNotify, notify.header.roomid);
                    }
                    return;
                }
                if (notify.getUriValue() == PushUri.UriRoomDynamicBannerShake.getValue()) {
                    ActivityModel.this.handleDynamicBannerShake(notify.room_dynamic_shake);
                    return;
                }
                if (notify.getUriValue() == PushUri.UriRoomDynamicBannerBubble.getValue()) {
                    ActivityModel.this.handleDynamicBannerBubble(notify.bubble_notify);
                    return;
                }
            }
            if (TargetBuildConstant.channelCloseRightBottomActivity || SettingFlags.getBoolean((String)"debug_channel_bottom_activity", (boolean)false) || SettingFlags.getBoolean((String)"close_channel_bottom_activity", (boolean)false)) {
                return;
            }
            if (notify != null && notify.getUriValue() == PushUri.UriRoomRightBannerNotify.getValue() && (roomRightBannerNotify = notify.room_right_notify) != null) {
                com.yy.hiyo.wallet.base.action.RoomRightBannerNotify bannerNotify = com.yy.hiyo.wallet.base.action.RoomRightBannerNotify.from((RoomRightBannerNotify)roomRightBannerNotify);
                ActivityModel.this.handleRoomRightBannerNotify(bannerNotify);
            }
        }
    };

    ActivityModel() {
        this.mGiftPanelActionCache = new LruCache(16);
        this.mWalletBannerActionCache = new LruCache(16);
        this.mRoomActivityActionCache = new LruCache(16);
        this.mActivityBannerActionCache = new LruCache(16);
        ProtoManager.getInstance().registerNotify(this.mActivityConfigPush);
    }

    public void fetchGiftActivities(final String roomId, final ActivityTagInfo roomTag, final @Nullable Callback<GiftPanelAction> callback, boolean force) {
        final String cacheKey = roomId + roomTag.getPluginType() + AccountUtil.getUid();
        GiftPanelAction action = this.getAction(this.mGiftPanelActionCache, cacheKey);
        MLog.info((Object)TAG, (String)"fetchGiftActivities roomId %s, tag %s, \u662f\u5426\u6709\u7f13\u5b58 cache %b, \u5f3a\u5236\u8bf7\u6c42 force %b, %s, %s", (Object[])new Object[]{roomId, roomTag, action != null && !action.isExpire(), force, action, cacheKey});
        if (action == null || action.isExpire() || force) {
            long seq = System.currentTimeMillis();
            GetGiftPanelBannerInfoReq req = new GetGiftPanelBannerInfoReq.Builder().sequence(Long.valueOf(seq)).room_tag_id(null == roomTag.getRoomTagId() ? "" : roomTag.getRoomTagId()).room_tag(null == roomTag.getRoomTag() ? "" : roomTag.getRoomTag()).plugin_type(Integer.valueOf(roomTag.getPluginType())).plugin_sub_type(Integer.valueOf(roomTag.getPluginSubType())).channel_role(Integer.valueOf(roomTag.getChannelRole())).build();
            ProtoManager.getInstance().sendRpc(roomId, (AndroidMessage)req, (IProtoCallback)new SeqCallback<GetGiftPanelBannerInfoRsp>("ActivityModel fetchGiftActivities", seq){

                @Override
                protected void onSuccess(@NotNull GetGiftPanelBannerInfoRsp message) {
                    this.updateData(GiftPanelAction.from((GiftPanelBannerInfo)message.info));
                }

                private void updateData(GiftPanelAction action) {
                    MLog.info((Object)ActivityModel.TAG, (String)"fetchGiftActivities updateData %s", (Object[])new Object[]{action});
                    if (action != null) {
                        ActivityActionWrapper item = new ActivityActionWrapper();
                        item.action = action;
                        item.roomId = roomId;
                        item.roomTag = roomTag;
                        ActivityModel.this.mGiftPanelActionCache.put((Object)cacheKey, (Object)item);
                    } else {
                        ActivityModel.this.mGiftPanelActionCache.remove((Object)cacheKey);
                    }
                    ActivityModel.this.notifyGiftActivity();
                    if (callback != null) {
                        callback.onResponse((Object)action);
                    }
                }

                public void onError(String reason, int code) {
                    super.onError(reason, code);
                    this.updateData(null);
                }

                @Override
                protected boolean isValid(@Nonnull GetGiftPanelBannerInfoRsp response, long seq) {
                    return response.sequence == seq && response.ret_code.intValue() == RetCode.Ok.getValue() && response.info_code.intValue() == InfoCode.Has.getValue() && !response.info.__isDefaultInstance();
                }
            });
        } else if (callback != null) {
            MLog.info((Object)TAG, (String)"fetchGiftActivities user cache", (Object[])new Object[0]);
            callback.onResponse((Object)action);
        }
    }

    public JsEvent[] getRevenueJsEvent(Environment env) {
        return new RevenueJsEventModule(env).allJsEvent();
    }

    public void fetchGiftActivities(String roomId, ActivityTagInfo roomTag, @Nullable Callback<GiftPanelAction> callback) {
        this.fetchGiftActivities(roomId, roomTag, callback, false);
    }

    private void fetchWalletActivities(final @Nullable Callback<WalletBannerAction> callback, boolean force) {
        WalletBannerAction action = this.getAction(this.mWalletBannerActionCache, AccountUtil.getUid() + "");
        MLog.info((Object)TAG, (String)"fetchWalletActivities , \u662f\u5426\u6709\u7f13\u5b58 cache %b, \u5f3a\u5236\u8bf7\u6c42 force %b, action %s", (Object[])new Object[]{action != null && !action.isExpire(), force, action});
        if (action == null || action.isExpire() || force) {
            long seq = System.currentTimeMillis();
            GetWalletBannerInfoReq req = new GetWalletBannerInfoReq.Builder().sequence(Long.valueOf(seq)).build();
            ProtoManager.getInstance().sendRpc((AndroidMessage)req, (IProtoCallback)new SeqCallback<GetWalletBannerInfoRsp>("ActivityModel fetchWalletActivities", seq){

                @Override
                protected void onSuccess(@Nonnull GetWalletBannerInfoRsp message) {
                    WalletBannerAction action = WalletBannerAction.from((WalletBannerInfo)message.info);
                    this.updateData(action);
                }

                private void updateData(WalletBannerAction action) {
                    MLog.info((Object)ActivityModel.TAG, (String)"fetchWalletActivities updateData %s", (Object[])new Object[]{action});
                    if (action != null) {
                        ActivityActionWrapper item = new ActivityActionWrapper();
                        item.action = action;
                        ActivityModel.this.mWalletBannerActionCache.put((Object)(AccountUtil.getUid() + ""), (Object)item);
                    } else {
                        ActivityModel.this.mWalletBannerActionCache.remove((Object)(AccountUtil.getUid() + ""));
                    }
                    ActivityModel.this.notifyWalletActivity();
                    if (callback != null) {
                        callback.onResponse((Object)action);
                    }
                }

                public void onError(String reason, int code) {
                    super.onError(reason, code);
                    this.updateData(null);
                }

                @Override
                protected boolean isValid(@NonNull GetWalletBannerInfoRsp response, long seq) {
                    return response.sequence == seq && response.ret_code.intValue() == RetCode.Ok.getValue() && response.info_code.intValue() == InfoCode.Has.getValue() && !response.info.__isDefaultInstance();
                }
            });
        } else if (callback != null) {
            MLog.info((Object)TAG, (String)"fetchWalletActivities user cache", (Object[])new Object[0]);
            callback.onResponse((Object)action);
        }
    }

    public void fetchWalletActivities(@Nullable Callback<WalletBannerAction> callback) {
        this.fetchWalletActivities(callback, false);
    }

    public void fetchRoomActivities(final String roomId, final ActivityTagInfo roomTag, final @Nullable Callback<RoomActivityActionList> callback, boolean force) {
        final String cacheKey = roomId + roomTag.getPluginType() + AccountUtil.getUid();
        RoomActivityActionList action = this.getAction(this.mRoomActivityActionCache, cacheKey);
        MLog.info((Object)TAG, (String)"fetchRoomActivities roomId %s, tag %s, \u662f\u5426\u6709\u7f13\u5b58 cache %b, \u5f3a\u5236\u8bf7\u6c42 force %b, action %s, %s", (Object[])new Object[]{roomId, roomTag, action != null && !action.isExpire(), force, action, cacheKey});
        if (action == null || action.isExpire() || force) {
            long seq = System.currentTimeMillis();
            GetRoomRightBannerInfoReq req = new GetRoomRightBannerInfoReq.Builder().room_tag_id(null == roomTag.getRoomTagId() ? "" : roomTag.getRoomTagId()).room_tag(null == roomTag.getRoomTag() ? "" : roomTag.getRoomTag()).sequence(Long.valueOf(seq)).multi_infos(Boolean.valueOf(true)).app_filter_time(Boolean.valueOf(true)).channel_role(Integer.valueOf(roomTag.getChannelRole())).plugin_sub_type(Integer.valueOf(roomTag.getPluginSubType())).plugin_type(Integer.valueOf(roomTag.getPluginType())).build();
            ProtoManager.getInstance().sendRpc(roomId, (AndroidMessage)req, (IProtoCallback)new SeqCallback<GetRoomRightBannerInfoRsp>("ActivityModel fetchRoomActivities", seq){

                @Override
                protected void onSuccess(@Nonnull GetRoomRightBannerInfoRsp message) {
                    MLog.info((Object)ActivityModel.TAG, (String)"fetchRoomActivities onSuccess", (Object[])new Object[0]);
                    RoomActivityActionList actionList = RoomActivityActionList.from((GetRoomRightBannerInfoRsp)message);
                    this.updateData(actionList);
                }

                private void updateData(RoomActivityActionList actionList) {
                    MLog.info((Object)ActivityModel.TAG, (String)"fetchRoomActivities updateData %s", (Object[])new Object[]{actionList});
                    if (actionList != null && !FP.empty((Collection)actionList.list)) {
                        ActivityActionWrapper item = new ActivityActionWrapper();
                        item.action = actionList;
                        item.roomId = roomId;
                        item.roomTag = roomTag;
                        ActivityModel.this.mRoomActivityActionCache.put((Object)cacheKey, (Object)item);
                    } else {
                        ActivityModel.this.mRoomActivityActionCache.remove((Object)cacheKey);
                    }
                    ActivityModel.this.notifyRoomActivity();
                    if (callback != null) {
                        callback.onResponse((Object)actionList);
                    }
                }

                public void onError(String reason, int code) {
                    super.onError(reason, code);
                    MLog.info((Object)ActivityModel.TAG, (String)"fetchRoomActivities onError reason=%s, code=%d", (Object[])new Object[]{reason, code});
                    this.updateData(null);
                }

                @Override
                protected boolean isValid(@NonNull GetRoomRightBannerInfoRsp response, long seq) {
                    return response.ret_code.intValue() == RetCode.Ok.getValue();
                }
            });
        } else if (callback != null) {
            MLog.info((Object)TAG, (String)"fetchRoomActivities user cache", (Object[])new Object[0]);
            callback.onResponse((Object)action);
        }
    }

    public void fetchRoomActivities(String roomId, ActivityTagInfo roomTag, @Nullable Callback<RoomActivityActionList> callback) {
        this.fetchRoomActivities(roomId, roomTag, callback, false);
    }

    public void fetchActivityBannerInfo(String roomId, ActivityTagInfo roomTag, int location, @Nullable Callback<ActivityActionList> callback) {
        this.fetchActivityBannerInfo(roomId, roomTag, location, callback, false);
    }

    public void fetchActivityBannerInfo(final String roomId, final ActivityTagInfo roomTag, final int location, final @Nullable Callback<ActivityActionList> callback, boolean force) {
        final String cacheKey = roomId + roomTag.getPluginType() + AccountUtil.getUid() + location;
        ActivityActionList action = this.getAction(this.mActivityBannerActionCache, cacheKey);
        MLog.info((Object)TAG, (String)"fetchActivityBannerInfo, location %d, \u662f\u5426\u6709\u7f13\u5b58 cache %b, \u5f3a\u5236\u8bf7\u6c42 force %b, action %s, %s", (Object[])new Object[]{location, action != null && !action.isExpire(), force, action, cacheKey});
        if (action == null || action.isExpire() || force) {
            long seq = System.currentTimeMillis();
            GetActivityBannerInfoReq req = new GetActivityBannerInfoReq.Builder().room_tag_id(null == roomTag.getRoomTagId() ? "" : roomTag.getRoomTagId()).room_tag(null == roomTag.getRoomTag() ? "" : roomTag.getRoomTag()).seat(Integer.valueOf(roomTag.getSeatIndex() - 1)).sequence(Long.valueOf(seq)).room_role(Integer.valueOf(roomTag.getRoomRole())).channel_role(Integer.valueOf(roomTag.getChannelRole())).location(Integer.valueOf(location)).plugin_type(Integer.valueOf(roomTag.getPluginType())).plugin_sub_type(Integer.valueOf(roomTag.getPluginSubType())).multi_infos(Boolean.valueOf(true)).app_filter_time(Boolean.valueOf(true)).build();
            ProtoManager.getInstance().sendHttp(roomId, (AndroidMessage)req, (IProtoCallback)new SeqCallback<GetActivityBannerInfoRsp>("ActivityModel fetchActivityBannerInfo", seq){

                @Override
                protected void onSuccess(@Nonnull GetActivityBannerInfoRsp message) {
                    ActivityActionList actionList = ActivityActionList.from((GetActivityBannerInfoRsp)message);
                    this.updateData(actionList, location);
                }

                private void updateData(ActivityActionList actionList, int location2) {
                    if (actionList != null && !FP.empty((Collection)actionList.list)) {
                        ActivityActionWrapper item = new ActivityActionWrapper();
                        item.action = actionList;
                        item.location = location2;
                        item.roomId = roomId;
                        item.roomTag = roomTag;
                        ActivityModel.this.mActivityBannerActionCache.put((Object)cacheKey, (Object)item);
                        MLog.info((Object)ActivityModel.TAG, (String)"fetchActivityBannerInfo, updateData cacheKey:%s", (Object[])new Object[]{cacheKey});
                    } else {
                        MLog.info((Object)ActivityModel.TAG, (String)"fetchActivityBannerInfo, remove cacheKey:%s", (Object[])new Object[]{cacheKey});
                        ActivityModel.this.mActivityBannerActionCache.remove((Object)cacheKey);
                    }
                    ActivityModel.this.notifyActivityBanner();
                    if (callback != null) {
                        callback.onResponse((Object)actionList);
                    }
                }

                public void onError(String reason, int code) {
                    super.onError(reason, code);
                    this.updateData(null, location);
                }

                @Override
                protected boolean isValid(@NonNull GetActivityBannerInfoRsp response, long seq) {
                    return response.ret_code.intValue() == RetCode.Ok.getValue() && !FP.empty((Collection)response.infos);
                }
            });
        } else if (callback != null) {
            MLog.info((Object)TAG, (String)"fetchActivityBannerInfo user cache location: %d", (Object[])new Object[]{location});
            callback.onResponse((Object)action);
        }
    }

    public void fetchActivityBannerInfo(int location, @javax.annotation.Nullable Callback<ActivityActionList> callback, boolean force) {
        ActivityTagInfo tagInfo = new ActivityTagInfo(0);
        this.fetchActivityBannerInfo("", tagInfo, location, callback, force);
    }

    public ActivityActionList getActivityBannerInfoFromCache(String roomId, ActivityTagInfo roomTag, int location) {
        if (roomTag == null) {
            roomTag = new ActivityTagInfo(0);
        }
        String cacheKey = roomId + roomTag.getPluginType() + AccountUtil.getUid() + location;
        return this.getAction(this.mActivityBannerActionCache, cacheKey);
    }

    public void clearActivities(String roomId, ActivityTagInfo roomTag) {
        MLog.info((Object)TAG, (String)"clearActivities roomId %s, roomTag %s, uid %s", (Object[])new Object[]{roomId, roomTag, AccountUtil.getUid()});
        this.mGiftPanelActionCache.remove((Object)(roomId + roomTag.getPluginType() + AccountUtil.getUid()));
    }

    public void clearRoomActivities(String roomId, ActivityTagInfo roomTag) {
        MLog.info((Object)TAG, (String)"clearRoomActivities roomId %s, roomTag %s, uid %s", (Object[])new Object[]{roomId, roomTag, AccountUtil.getUid()});
        this.mRoomActivityActionCache.remove((Object)(roomId + roomTag.getPluginType() + AccountUtil.getUid()));
    }

    public void addOnActivityUpdateListener(IActivityService.OnActivityUpdateListener listener) {
        if (this.mUpdateListeners == null) {
            this.mUpdateListeners = new HashSet<IActivityService.OnActivityUpdateListener>();
        }
        MLog.info((Object)TAG, (String)"addUpdateListener:%d", (Object[])new Object[]{++sIndex});
        if (listener != null) {
            this.mUpdateListeners.add(listener);
            this.notifyListener(listener);
        }
    }

    public void requestSpinachList(int roomRole, final Callback<ActivityActionList> callback) {
        GetSpinachListBannersReq seq = new GetSpinachListBannersReq.Builder().sequence(Long.valueOf(System.currentTimeMillis())).channel_role(Integer.valueOf(roomRole)).build();
        ProtoManager.getInstance().sendHttp((AndroidMessage)seq, (IProtoCallback)new SimpleProtoCallback<GetSpinachListBannersRsp>(TAG){

            public void onResponse(@Nullable GetSpinachListBannersRsp message) {
                super.onResponse((AndroidMessage)message);
                ActivityActionList actionList = ActivityActionList.from((GetSpinachListBannersRsp)message);
                if (callback != null) {
                    callback.onResponse((Object)actionList);
                }
            }

            public void onResponse(@NonNull GetSpinachListBannersRsp message, long code, String msg) {
                super.onResponse((AndroidMessage)message, code, msg);
                ActivityActionList actionList = ActivityActionList.from((GetSpinachListBannersRsp)message);
                if (callback != null) {
                    callback.onResponse((Object)actionList);
                }
            }

            public void onError(String reason, int code) {
                super.onError(reason, code);
            }
        });
    }

    private void notifyListener(IActivityService.OnActivityUpdateListener listener) {
        List<ActivityActionWrapper<GiftPanelAction>> gift = this.cacheToList(this.mGiftPanelActionCache);
        List<ActivityActionWrapper<WalletBannerAction>> wallet = this.cacheToList(this.mWalletBannerActionCache);
        List<ActivityActionWrapper<RoomActivityActionList>> room = this.cacheToList(this.mRoomActivityActionCache);
        List<ActivityActionWrapper<ActivityActionList>> action = this.cacheToList(this.mActivityBannerActionCache);
        listener.onGiftActivityUpdate(gift);
        listener.onWalletActivityUpdate(wallet);
        listener.onRoomActivityUpdate(room);
        listener.onActivityBannerUpdate(action);
    }

    public void removeOnActivityUpdateListener(IActivityService.OnActivityUpdateListener listener) {
        if (this.mUpdateListeners != null) {
            this.mUpdateListeners.remove(listener);
        }
        MLog.info((Object)TAG, (String)"removeUpdateListener:%d", (Object[])new Object[]{--sIndex});
    }

    public void setOnRightBannerPushListener(IActivityService.OnRightBannerPushListener listener) {
        this.mRightBannerPushListener = listener;
    }

    public void setOnDynamicActListener(IActivityService.OnDynamicActListener onDynamicActListener) {
        this.mOnDynamicActListener = onDynamicActListener;
    }

    public void updateActivity(String roomId, ActivityTagInfo roomTag, boolean forceUpdate) {
        MLog.info((Object)TAG, (String)"updateActivity roomId %s, roomTag %s, \u5f3a\u5236\u8bf7\u6c42 forceUpdate %b", (Object[])new Object[]{roomId, roomTag, forceUpdate});
        this.fetchGiftActivities(roomId, roomTag, null, true);
        this.fetchWalletActivities(null, true);
        this.fetchRoomActivities(roomId, roomTag, null, true);
    }

    public void clearAllRoomActivities() {
        MLog.info((Object)TAG, (String)"clearAllRoomActivities \u6e05\u9664\u5168\u90e8\u623f\u95f4\u6d3b\u52a8\u914d\u7f6e", (Object[])new Object[0]);
        this.mGiftPanelActionCache.evictAll();
        this.mRoomActivityActionCache.evictAll();
        this.clearBannerActionCacheExceptNotEnough();
    }

    private void clearBannerActionCacheExceptNotEnough() {
        ActivityTagInfo tagInfo = new ActivityTagInfo(0);
        String cacheKey = "" + tagInfo.getPluginType() + AccountUtil.getUid() + 6;
        ActivityActionList actionList = this.getAction(this.mActivityBannerActionCache, cacheKey);
        ActivityActionWrapper item = new ActivityActionWrapper();
        item.action = actionList;
        item.roomId = "";
        item.roomTag = tagInfo;
        this.mActivityBannerActionCache.evictAll();
        this.mActivityBannerActionCache.put((Object)cacheKey, (Object)item);
    }

    private void notifyGiftActivity() {
        List<ActivityActionWrapper<GiftPanelAction>> list = this.cacheToList(this.mGiftPanelActionCache);
        if (this.mUpdateListeners != null) {
            for (IActivityService.OnActivityUpdateListener item : this.mUpdateListeners) {
                item.onGiftActivityUpdate(list);
            }
        }
    }

    private void notifyWalletActivity() {
        List<ActivityActionWrapper<WalletBannerAction>> list = this.cacheToList(this.mWalletBannerActionCache);
        if (this.mUpdateListeners != null) {
            for (IActivityService.OnActivityUpdateListener item : this.mUpdateListeners) {
                item.onWalletActivityUpdate(list);
            }
        }
    }

    private void notifyRoomActivity() {
        List<ActivityActionWrapper<RoomActivityActionList>> list = this.cacheToList(this.mRoomActivityActionCache);
        if (this.mUpdateListeners != null) {
            for (IActivityService.OnActivityUpdateListener item : this.mUpdateListeners) {
                item.onRoomActivityUpdate(list);
            }
        }
    }

    private void notifyActivityBanner() {
        List<ActivityActionWrapper<ActivityActionList>> list = this.cacheToList(this.mActivityBannerActionCache);
        if (this.mUpdateListeners != null) {
            for (IActivityService.OnActivityUpdateListener item : this.mUpdateListeners) {
                item.onActivityBannerUpdate(list);
            }
        }
    }

    private <T extends ActivityAction> T getAction(LruCache<String, ActivityActionWrapper<T>> cache, String key) {
        ActivityActionWrapper container = (ActivityActionWrapper)cache.get((Object)key);
        return (T)(container != null ? container.action : null);
    }

    private <T extends ActivityAction> List<ActivityActionWrapper<T>> cacheToList(LruCache<String, ActivityActionWrapper<T>> cache) {
        ArrayList<ActivityActionWrapper<T>> list = new ArrayList<ActivityActionWrapper<T>>();
        Map map = cache.snapshot();
        for (String key : map.keySet()) {
            ActivityActionWrapper value = (ActivityActionWrapper)map.get(key);
            list.add(value);
        }
        return list;
    }

    private void handleRoomRightBannerNotify(final com.yy.hiyo.wallet.base.action.RoomRightBannerNotify roomRightBannerNotify) {
        if (this.mRightBannerPushListener != null) {
            ActivityTagInfo tagInfo;
            if (TextUtils.isEmpty((CharSequence)roomRightBannerNotify.roomId)) {
                roomRightBannerNotify.roomId = this.mRightBannerPushListener.roomId();
            }
            if ((tagInfo = this.mRightBannerPushListener.getRoomTagId(roomRightBannerNotify.roomId)) == null) {
                MLog.info((Object)TAG, (String)"handleRoomRightBannerNotify tagInfo is null", (Object[])new Object[0]);
                return;
            }
            MLog.info((Object)TAG, (String)"handleRoomRightBannerNotify PluginType=%s, roomId=%s", (Object[])new Object[]{tagInfo.getPluginType(), roomRightBannerNotify.roomId == null ? "" : ""});
            String roomId = roomRightBannerNotify.roomId;
            RoomActivityActionList action = this.getAction(this.mRoomActivityActionCache, "" + roomId + tagInfo.getPluginType() + AccountUtil.getUid());
            if (action != null && action.version >= roomRightBannerNotify.version) {
                MLog.info((Object)TAG, (String)"handleRoomRightBannerNotify action.version=%s, roomRightBannerNotify.version=%s", (Object[])new Object[]{action.version, roomRightBannerNotify.version});
                return;
            }
            if (roomRightBannerNotify.bannerNotifyCmd == RoomRightBannerNotify.BannerNotifyCmd.OPEN) {
                this.updateData(roomRightBannerNotify.roomActivityActionList, roomRightBannerNotify.roomId, tagInfo);
            } else if (roomRightBannerNotify.bannerNotifyCmd == RoomRightBannerNotify.BannerNotifyCmd.CLOSEBANNER) {
                this.updateData(null, roomRightBannerNotify.roomId, tagInfo);
            } else if (roomRightBannerNotify.bannerNotifyCmd == RoomRightBannerNotify.BannerNotifyCmd.CLOSEACTTYPE) {
                if (roomRightBannerNotify.roomActivityActionList != null && !FP.empty((Collection)roomRightBannerNotify.roomActivityActionList.list) && action != null && !FP.empty((Collection)action.list)) {
                    ArrayList<RoomActivityAction> closeList = new ArrayList<RoomActivityAction>(4);
                    for (RoomActivityAction roomActivityAction : action.list) {
                        for (RoomActivityAction closeRoomActivityAction : roomRightBannerNotify.roomActivityActionList.list) {
                            if (roomActivityAction.activityType != closeRoomActivityAction.activityType) continue;
                            closeList.add(roomActivityAction);
                        }
                    }
                    action.list.removeAll(closeList);
                    this.updateData(action, roomRightBannerNotify.roomId, tagInfo);
                }
            } else if (roomRightBannerNotify.bannerNotifyCmd == RoomRightBannerNotify.BannerNotifyCmd.ADDACT) {
                if (roomRightBannerNotify.roomActivityActionList != null && !FP.empty((Collection)roomRightBannerNotify.roomActivityActionList.list)) {
                    ArrayList<RoomActivityAction> addList = new ArrayList<RoomActivityAction>(4);
                    if (action != null && !FP.empty((Collection)action.list)) {
                        for (RoomActivityAction addRoomActivityAction : roomRightBannerNotify.roomActivityActionList.list) {
                            boolean hasAct = false;
                            for (RoomActivityAction roomActivityAction : action.list) {
                                if (roomActivityAction.activityType != addRoomActivityAction.activityType) continue;
                                hasAct = true;
                                break;
                            }
                            if (hasAct) continue;
                            addList.add(addRoomActivityAction);
                        }
                        action.list.addAll(addList);
                        this.updateData(action, roomRightBannerNotify.roomId, tagInfo);
                    } else {
                        this.updateData(roomRightBannerNotify.roomActivityActionList, roomRightBannerNotify.roomId, tagInfo);
                    }
                }
            } else if (roomRightBannerNotify.bannerNotifyCmd == RoomRightBannerNotify.BannerNotifyCmd.CLOSEACTID) {
                if (roomRightBannerNotify.roomActivityActionList != null && !FP.empty((Collection)roomRightBannerNotify.roomActivityActionList.list) && action != null && !FP.empty((Collection)action.list)) {
                    ArrayList<RoomActivityAction> closeList = new ArrayList<RoomActivityAction>(4);
                    for (RoomActivityAction roomActivityAction : action.list) {
                        for (RoomActivityAction closeRoomActivityAction : roomRightBannerNotify.roomActivityActionList.list) {
                            if (roomActivityAction.id != closeRoomActivityAction.id) continue;
                            closeList.add(roomActivityAction);
                        }
                    }
                    action.list.removeAll(closeList);
                    this.updateData(action, roomRightBannerNotify.roomId, tagInfo);
                }
            } else if (roomRightBannerNotify.bannerNotifyCmd == RoomRightBannerNotify.BannerNotifyCmd.REFRESH && roomRightBannerNotify.refreshRandSecond > 0) {
                Random rand = new Random();
                int time = rand.nextInt(roomRightBannerNotify.refreshRandSecond) + 1;
                MLog.info((Object)TAG, (String)"time=%d", (Object[])new Object[]{time});
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ActivityModel.this.fetchRoomActivities(roomRightBannerNotify.roomId, tagInfo, null, true);
                    }
                }, (long)(time * 1000));
            }
        }
    }

    private void updateData(RoomActivityActionList actionList, String roomId, ActivityTagInfo roomTag) {
        MLog.info((Object)TAG, (String)"fetchRoomActivities updateData %s\uff0c roomId=%s, roomTag=%s", (Object[])new Object[]{actionList, roomId, roomTag});
        if (actionList != null && !FP.empty((Collection)actionList.list)) {
            ActivityActionWrapper item = new ActivityActionWrapper();
            item.action = actionList;
            item.roomId = roomId;
            item.roomTag = roomTag;
            this.mRoomActivityActionCache.put((Object)("" + roomId + roomTag.getPluginType() + AccountUtil.getUid()), (Object)item);
        } else {
            this.mRoomActivityActionCache.remove((Object)("" + roomId + roomTag.getPluginType() + AccountUtil.getUid()));
        }
        this.notifyRoomActivity();
    }

    private void handleDynamicBannerBubble(BubbleNotify bubble) {
        if (bubble == null) {
            return;
        }
        if (this.mOnDynamicActListener != null) {
            this.mOnDynamicActListener.getDynamicBannerBubble(bubble);
        }
    }

    private void handleDynamicBannerShake(RoomDynamicBannerShake shake) {
        if (shake == null) {
            return;
        }
        if (this.mOnDynamicActListener != null) {
            this.mOnDynamicActListener.getDynamicBannerShake(shake);
        }
    }

    private void handleDynamicBannerNotify(ActivityBannerNotify bannerNotify, String roomId) {
        if (bannerNotify.cmd != null) {
            if (bannerNotify.cmd == BannerNotifyCmd.CmdRefreshNew) {
                long time = 0L;
                if (bannerNotify.refresh_rand_seond > 0) {
                    Random rand = new Random();
                    time = rand.nextInt(bannerNotify.refresh_rand_seond) + 1;
                    MLog.info((Object)TAG, (String)"time=%d", (Object[])new Object[]{time});
                }
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (ActivityModel.this.mOnDynamicActListener != null) {
                            ActivityModel.this.mOnDynamicActListener.refreshData();
                        }
                    }
                }, (long)time);
            } else if (bannerNotify.cmd == BannerNotifyCmd.CmdOpen) {
                if (this.mOnDynamicActListener != null) {
                    this.mOnDynamicActListener.getBannerNotify(true);
                }
            } else if (this.mOnDynamicActListener != null) {
                this.mOnDynamicActListener.getBannerNotify(false);
            }
        }
    }
}

