/*
 * Decompiled with CFR 0.152.
 */
package com.yy.voice.roomvoice;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Message;
import com.yy.appbase.AppbaseMsgDef;
import com.yy.appbase.R;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.core.DefaultController;
import com.yy.appbase.notify.NotificationIdDef;
import com.yy.appbase.permission.helper.PermissionHelper;
import com.yy.appbase.ui.toast.TopToastUtils;
import com.yy.base.R;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.SystemServiceUtils;
import com.yy.base.utils.TimeUtils;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.framework.core.BaseMsgDef;
import com.yy.framework.core.Environment;
import com.yy.framework.core.INotify;
import com.yy.framework.core.MsgDispatcher;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.NotificationDef;
import com.yy.hiidostatis.api.StatisContent;
import com.yy.hiyo.channel.secretcall.ISecretCallService;
import com.yy.hiyo.game.base.GameNotificationDef;
import com.yy.hiyo.voice.base.bean.UserSpeakStatus;
import com.yy.hiyo.voice.base.bean.event.VoiceCallBack;
import com.yy.hiyo.voice.base.channelvoice.IKtvLiveServiceExtend;
import com.yy.hiyo.voice.base.roomvoice.AbsVoiceRoom;
import com.yy.hiyo.voice.base.roomvoice.BaseVoiceRoom;
import com.yy.hiyo.voice.base.roomvoice.IRoomLifeCycleCallback;
import com.yy.hiyo.voice.base.roomvoice.IRoomManagerService;
import com.yy.hiyo.voice.base.roomvoice.ISingleRoomCallbackNew;
import com.yy.hiyo.voice.base.roomvoice.MultiplayerRoom;
import com.yy.hiyo.voice.base.roomvoice.RoomDataModel;
import com.yy.hiyo.voice.base.roomvoice.RoomDef;
import com.yy.hiyo.voice.base.roomvoice.RoomSlot;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;

public class RoomModleController
extends DefaultController
implements IRoomManagerService,
ISingleRoomCallbackNew {
    private static final String TAG = "RoomModleController";
    private static final boolean MIC_DEF_STATUS = true;
    private final ConcurrentHashMap<String, AbsVoiceRoom> mRooms;
    private final ConcurrentHashMap<Long, UserSpeakStatus> mSpeaks = new ConcurrentHashMap();
    private Stack<RoomSlot> mRoomStack = new Stack();
    private boolean mLastNetValid;
    private RoomDataModel mRoomDataModel;
    private long mMicInitTime = 0L;
    private VoiceCallBack mVoiceCallBack = new VoiceCallBack(){

        public void onSpeakingChanged(Map<Long, Integer> speakList, int streamType) {
            if (speakList != null && speakList.size() > 0) {
                for (long uid : speakList.keySet()) {
                    if (RoomModleController.this.mSpeaks.get(uid) == null) {
                        RoomModleController.this.mSpeaks.put(uid, new UserSpeakStatus(uid, speakList.get(uid).intValue()));
                    }
                    final UserSpeakStatus userSpeakBean = (UserSpeakStatus)RoomModleController.this.mSpeaks.get(uid);
                    userSpeakBean.setStatus(speakList.get(uid).intValue());
                    YYTaskExecutor.postToMainThread((Runnable)new YYTaskExecutor.RunnableEx(){

                        public void run() {
                            Notification notification = Notification.obtain((int)NotificationIdDef.SPEAK_VOLUME_INDICATION);
                            notification.extObj = userSpeakBean;
                            NotificationCenter.getGlobalInstance().notify(notification);
                        }
                    });
                }
            }
        }

        public void onJoinChannelSuccess(String channel, long uid, int elapsed) {
            if (RuntimeContext.sIsDebuggable) {
                MLog.debug((Object)RoomModleController.TAG, (String)"onJoinChannelSuccess ,channel=%s,uid=%s, elapsed=%s", (Object[])new Object[]{channel, uid, elapsed});
            }
            ((IKtvLiveServiceExtend)RoomModleController.this.getServiceManager().getService(IKtvLiveServiceExtend.class)).enablePublishAudio(1);
        }

        public void onAudioPlayData(String roomId, String uid, byte[] data, long duration) {
        }

        public void onAudioPlaySpectrumData(byte[] data) {
        }

        public void onAudioPlayTimestamp(int playTimestamp) {
        }

        public void onAudioPlayTimestamp(Map<Long, Integer> audioVolumeMap) {
        }

        public void onReceiveUserAppMsgData(byte[] data, String uid) {
        }

        public void onReceiveAppMsgDataFailedStatus(int status) {
        }

        public void onNetworkQuality(String uid, int txQuality, int rxQuality) {
            for (AbsVoiceRoom room : RoomModleController.this.mRooms.values()) {
                if (uid.equals("0")) {
                    room.mMyStatus.setTxQuality(txQuality);
                    room.mMyStatus.setTxQuality(-1);
                    continue;
                }
                if (!uid.equals(String.valueOf(room.mOtherStatus.getUid()))) continue;
                room.mOtherStatus.setTxQuality(txQuality);
                room.mOtherStatus.setTxQuality(-1);
            }
        }
    };

    public RoomModleController(Environment env) {
        super(env);
        this.mRooms = new ConcurrentHashMap();
        this.mLastNetValid = NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext);
        NotificationCenter.getGlobalInstance().register(NotificationDef.N_NETWORK_STATE_CHANGE, (INotify)this);
        NotificationCenter.getGlobalInstance().register(NotificationDef.N_FOREGROUND_CHANGE, (INotify)this);
        NotificationCenter.getGlobalInstance().register(NotificationDef.NOTIFICATION_DELETED, (INotify)this);
        NotificationCenter.getGlobalInstance().register(GameNotificationDef.TEAM_GAME_DESTORY, (INotify)this);
        NotificationCenter.getGlobalInstance().register(GameNotificationDef.TEAM_GAME_START, (INotify)this);
        this.mRoomDataModel = new RoomDataModel(this.mRooms);
    }

    public void notify(Notification notification) {
        super.notify(notification);
        int id2 = notification.id;
        if (id2 == NotificationDef.N_NETWORK_STATE_CHANGE) {
            boolean valid = NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext);
            if (valid != this.mLastNetValid) {
                this.onNetChanged(this.mLastNetValid, valid);
                this.mLastNetValid = valid;
            }
        } else if (notification.id == NotificationDef.N_FOREGROUND_CHANGE) {
            if (notification.extObj instanceof Boolean) {
                MLog.info((Object)TAG, (String)("N_FOREGROUND_CHANGE" + (Boolean)notification.extObj), (Object[])new Object[0]);
                this.onForegroundChanged((Boolean)notification.extObj);
            }
        } else if (notification.id == GameNotificationDef.TEAM_GAME_START) {
            MLog.info((Object)TAG, (String)"TEAM_GAME_START", (Object[])new Object[0]);
            this.teamGamePause(true);
        } else if (notification.id == GameNotificationDef.TEAM_GAME_DESTORY) {
            MLog.info((Object)TAG, (String)"TEAM_GAME_DESTORY", (Object[])new Object[0]);
            this.teamGamePause(false);
        } else if (notification.id == NotificationDef.NOTIFICATION_DELETED && notification.extObj instanceof Intent) {
            MLog.info((Object)TAG, (String)"NOTIFICATION_DELETED", (Object[])new Object[0]);
        }
    }

    private void onNetChanged(boolean lastStatus, boolean newStatus) {
        for (AbsVoiceRoom room : this.mRooms.values()) {
            room.onNetValidChanged(lastStatus, newStatus);
        }
    }

    private void onForegroundChanged(boolean foregroundStatus) {
        RoomSlot top = this.peek();
        if (top != null) {
            if (foregroundStatus) {
                top.room.changeToState(1, 0);
            } else {
                top.room.changeToState(3, 4);
            }
        }
    }

    private void teamGamePause(boolean foregroundStatus) {
        RoomSlot top = this.peek();
        if (top != null) {
            if (foregroundStatus) {
                top.room.changeToState(3, 0);
            } else {
                top.room.changeToState(1, 0);
            }
        }
    }

    RoomSlot peek() {
        if (this.mRoomStack.size() == 0) {
            return null;
        }
        return this.mRoomStack.peek();
    }

    public synchronized RoomSlot joinRoom(String sessionId, @RoomDef.RoomScene int type, IRoomLifeCycleCallback callback2) {
        MLog.info((Object)TAG, (String)"joinRoom sessionId: %s, type: %d", (Object[])new Object[]{sessionId, type});
        Object room = this.mRooms.get(sessionId);
        if (room == null) {
            room = type == 8 || type == 9 || type == 11 ? new MultiplayerRoom(sessionId, (ISingleRoomCallbackNew)this) : new BaseVoiceRoom(sessionId, (ISingleRoomCallbackNew)this);
            this.mRooms.put(sessionId, (AbsVoiceRoom)room);
        }
        room.roomSceneType = type;
        RoomSlot top = this.peek();
        RoomSlot slot = new RoomSlot(room, callback2);
        room.roomSlots.add(slot);
        this.mRoomStack.add(slot);
        ++slot.room.showWindow;
        if (top != null && top.room != room) {
            top.room.changeToState(3, type);
        }
        room.changeToState(1, type);
        return slot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void leaveRoom(RoomSlot roomSlot, @RoomDef.RoomScene int scenes) {
        MLog.info((Object)TAG, (String)"leaveRoom type: %d", (Object[])new Object[]{scenes});
        RoomModleController roomModleController = this;
        synchronized (roomModleController) {
            RoomSlot top;
            if (roomSlot == null || roomSlot.room == null) {
                MLog.error((Object)TAG, (String)"leaveRoom room null", (Object[])new Object[0]);
                return;
            }
            AbsVoiceRoom room = this.mRooms.get(roomSlot.room.mSessionId);
            if (room == null || room != roomSlot.room || room.showWindow <= 0) {
                MLog.error((Object)TAG, (String)"Room is already leave", (Object[])new Object[0]);
                return;
            }
            --room.showWindow;
            this.mRoomStack.remove(roomSlot);
            if (room.showWindow == 0) {
                this.mRooms.remove(room.mSessionId);
            }
            if ((top = this.peek()) != null && !top.room.equals(room)) {
                roomSlot.room.changeToState(2, scenes);
                top.room.changeToState(1, scenes);
            } else if (top == null || !room.equals(top.room)) {
                roomSlot.room.changeToState(2, scenes);
            }
            roomSlot.room = null;
        }
    }

    public void joinRoomReq(AbsVoiceRoom singleRoom, boolean micOpen) {
        if (this.mRoomDataModel != null) {
            this.mRoomDataModel.joinRoomReq(singleRoom, micOpen);
        }
    }

    public void leaveRoomReq(AbsVoiceRoom singleRoom) {
        if (this.mRoomDataModel != null) {
            this.mRoomDataModel.leaveRoomReq(singleRoom);
        }
    }

    public void micOperateReq(AbsVoiceRoom singleRoom, boolean micOpen) {
        if (this.mRoomDataModel != null) {
            this.mRoomDataModel.micOperateReq(singleRoom, micOpen);
        }
    }

    public void roomHeartbeatReq(AbsVoiceRoom singleRoom) {
        if (this.mRoomDataModel != null) {
            this.mRoomDataModel.roomHeartbeatReq(singleRoom);
        }
    }

    public synchronized int micOperate(String sessionId, final boolean micStatus, boolean isSave, IKtvLiveServiceExtend.VoiceType voiceType) {
        RoomSlot top = this.peek();
        if (micStatus) {
            if (!PermissionHelper.hasRecordAudioPermission((Activity)this.getActivity())) {
                TopToastUtils.showToast((CharSequence)ResourceUtils.getString((int)R.string.permission_record_audio_access_instructions), (int)0, (int)ResourceUtils.getColor((int)R.color.warn_toast_bg), (boolean)false);
                MLog.info((Object)TAG, (String)"no promsion for mic", (Object[])new Object[0]);
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        SettingFlags.setBoolean((String)"mic_status", (boolean)false);
                    }
                });
                return 1;
            }
            if (!NetworkUtils.isNetworkAvailable((Context)this.mContext)) {
                TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.network_error), (int)0);
                MLog.info((Object)TAG, (String)"net wrok disable", (Object[])new Object[0]);
                return 5;
            }
            if (PermissionHelper.checkNotificationPermission((Context)this.mContext)) {
                Message msg = Message.obtain();
                msg.what = BaseMsgDef.MIC_NOTIFYCATION_SHOW;
                msg.obj = sessionId;
                this.sendMessage(msg);
            } else {
                MLog.info((Object)TAG, (String)"no notify permission", (Object[])new Object[0]);
            }
            this.mMicInitTime = System.currentTimeMillis();
        } else {
            if (PermissionHelper.checkNotificationPermission((Context)this.mContext)) {
                SystemServiceUtils.getNotificationManager((Context)this.mContext).cancel(10000);
            } else {
                MLog.info((Object)TAG, (String)"no notify permission", (Object[])new Object[0]);
            }
            if (this.getCurrentWindow() != null) {
                int windowType = this.getCurrentWindow().getWindowType();
                if (this.mMicInitTime > 0L) {
                    RoomModleController.micTimeReport(sessionId, windowType, (int)((System.currentTimeMillis() - this.mMicInitTime) / 1000L), voiceType);
                }
                this.mMicInitTime = 0L;
            }
            if (voiceType != null) {
                ((IKtvLiveServiceExtend)this.getServiceManager().getService(IKtvLiveServiceExtend.class)).exitChannel(sessionId);
                ISecretCallService secretService = (ISecretCallService)this.getServiceManager().getService(ISecretCallService.class);
                if (secretService != null && secretService.isCalling()) {
                    MLog.info((Object)TAG, (String)("secret call status:" + secretService.isCalling()), (Object[])new Object[0]);
                    Message msg = Message.obtain();
                    msg.what = AppbaseMsgDef.SecretCallDef.EXIT_SECRET_CALL_PAGE;
                    MsgDispatcher.getInstance().sendMessage(msg);
                }
            }
        }
        if (isSave) {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    SettingFlags.setBoolean((String)"mic_status", (boolean)micStatus);
                }
            });
        }
        return 0;
    }

    public boolean getMicStatus(String sessionId) {
        MLog.info((Object)TAG, (String)"getMicStatus sessionId=%s,mic_status=%s", (Object[])new Object[]{sessionId, SettingFlags.getBoolean((String)"mic_status", (boolean)true)});
        return SettingFlags.getBoolean((String)"mic_status", (boolean)true);
    }

    public ConcurrentHashMap<Long, UserSpeakStatus> getSpeaks() {
        return this.mSpeaks;
    }

    public synchronized void initMicStatus() {
        MLog.info((Object)TAG, (String)"initMicStatus inittime = %s", (Object[])new Object[]{SettingFlags.getLongValue((String)"mic_status_init_time")});
        if (SettingFlags.getLongValue((String)"mic_status_init_time") < TimeUtils.getStartTimeOfDay()) {
            MLog.info((Object)TAG, (String)"initMicStatus getStartTimeOfDay = %s", (Object[])new Object[]{TimeUtils.getStartTimeOfDay()});
            SettingFlags.setLongValue((String)"mic_status_init_time", (long)System.currentTimeMillis());
            SettingFlags.setBoolean((String)"mic_status", (boolean)true);
        }
    }

    public boolean isNetworkAvailable() {
        return NetworkUtils.isNetworkAvailable((Context)this.mContext);
    }

    public void selectVoiceType(IKtvLiveServiceExtend.VoiceType voiceType) {
        if (!NetworkUtils.isNetworkAvailable((Context)this.mContext)) {
            TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.network_error), (int)0);
            MLog.info((Object)TAG, (String)"net wrok disable", (Object[])new Object[0]);
            return;
        }
        ((IKtvLiveServiceExtend)this.getServiceManager().getService(IKtvLiveServiceExtend.class)).joinNonMultiRoom(voiceType.mSessionId, Long.valueOf(voiceType.mSceneId), AccountUtil.getUid(), voiceType, this.mVoiceCallBack);
    }

    public static void micTimeReport(String sessionid, int scene, int linktime, IKtvLiveServiceExtend.VoiceType voiceType) {
        StatisContent statContent = new StatisContent();
        statContent.put("act", "hagoperf");
        statContent.put("perftype", "mic_failed");
        statContent.put("sfield", sessionid);
        statContent.put("ifield", scene);
        statContent.put("ifieldtwo", linktime);
        if (voiceType == IKtvLiveServiceExtend.VoiceType.YYVOICE) {
            statContent.put("sfieldtwo", "yyvoic");
        } else {
            statContent.put("sfieldtwo", "agora");
        }
        HiidoStatis.reportContent((StatisContent)statContent);
    }
}

