/*
 * Decompiled with CFR 0.152.
 */
package com.yy.voice.yyvoicemanager.yyvoicesdk;

import android.app.Activity;
import android.media.AudioManager;
import android.util.Base64;
import com.yy.base.logger.MLog;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J0\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00162\b\u0010\u0019\u001a\u0004\u0018\u00010\u0013J\u0010\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0018\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020\u0013H\u0002J\u000e\u0010 \u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006!"}, d2={"Lcom/yy/voice/yyvoicemanager/yyvoicesdk/VoiceUtils;", "", "()V", "HMAC_SHA1", "", "getHMAC_SHA1", "()Ljava/lang/String;", "TAG", "currentVolume", "", "getCurrentVolume", "()I", "setCurrentVolume", "(I)V", "closeSpeaker", "", "activity", "Landroid/app/Activity;", "generateTokenWithValidTime", "", "appSecret", "appId", "", "uid", "time", "extData", "getBufferData", "buffer", "Ljava/nio/ByteBuffer;", "hmacSha1Signature", "datas", "key", "openSpeaker", "voice_debug"})
public final class VoiceUtils {
    @NotNull
    public static final String TAG = "VoiceUtils";
    @NotNull
    private static final String HMAC_SHA1 = "HmacSHA1";
    private static int currentVolume;
    public static final VoiceUtils INSTANCE;

    @NotNull
    public final String getHMAC_SHA1() {
        return HMAC_SHA1;
    }

    public final int getCurrentVolume() {
        return currentVolume;
    }

    public final void setCurrentVolume(int n) {
        currentVolume = n;
    }

    private final byte[] hmacSha1Signature(byte[] datas, byte[] key) {
        String type = HMAC_SHA1;
        SecretKeySpec secret = new SecretKeySpec(key, type);
        Mac mac = Mac.getInstance(type);
        mac.init(secret);
        byte[] byArray = mac.doFinal(datas);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"mac.doFinal(datas)");
        return byArray;
    }

    private final byte[] getBufferData(ByteBuffer buffer) {
        int len = buffer.position();
        byte[] data = new byte[len];
        buffer.position(0);
        buffer.get(data);
        buffer.clear();
        buffer.put(data);
        return data;
    }

    @NotNull
    public final byte[] generateTokenWithValidTime(@NotNull String appSecret, long appId, long uid, long time, @Nullable byte[] extData) {
        Intrinsics.checkParameterIsNotNull((Object)appSecret, (String)"appSecret");
        String string2 = appSecret;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] key = byArray;
        ByteBuffer buffer = ByteBuffer.allocate(100);
        buffer.order(ByteOrder.BIG_ENDIAN);
        buffer.putShort((short)(48 + (extData != null ? extData.length : 0)));
        buffer.putLong(appId);
        buffer.putLong(uid);
        buffer.putLong(System.currentTimeMillis());
        buffer.putInt((int)time);
        if (extData != null) {
            buffer.putShort((short)extData.length);
            buffer.put(extData);
        } else {
            buffer.putShort((short)0);
        }
        try {
            ByteBuffer byteBuffer = buffer;
            Intrinsics.checkExpressionValueIsNotNull((Object)byteBuffer, (String)"buffer");
            buffer.put(this.hmacSha1Signature(this.getBufferData(byteBuffer), key));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ByteBuffer byteBuffer = buffer;
        Intrinsics.checkExpressionValueIsNotNull((Object)byteBuffer, (String)"buffer");
        byte[] byArray2 = Base64.encode((byte[])this.getBufferData(byteBuffer), (int)8);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray2, (String)"Base64.encode(\n         \u2026buffer), Base64.URL_SAFE)");
        return byArray2;
    }

    public final void openSpeaker(@NotNull Activity activity) {
        Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
        MLog.info((Object)TAG, (String)"openSpeaker", (Object[])new Object[0]);
        try {
            Object object = activity.getSystemService("audio");
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.media.AudioManager");
            }
            AudioManager audioManager = (AudioManager)object;
            if (!audioManager.isSpeakerphoneOn()) {
                currentVolume = audioManager.getStreamVolume(0);
                audioManager.setSpeakerphoneOn(true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            MLog.error((Object)TAG, (String)"openSpeaker exception", (Object[])new Object[0]);
        }
    }

    public final void closeSpeaker(@NotNull Activity activity) {
        Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
        MLog.info((Object)TAG, (String)"closeSpeaker", (Object[])new Object[0]);
        try {
            Object object = activity.getSystemService("audio");
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.media.AudioManager");
            }
            AudioManager audioManager = (AudioManager)object;
            if (audioManager.isSpeakerphoneOn()) {
                audioManager.setSpeakerphoneOn(false);
                if (currentVolume != -1) {
                    audioManager.setStreamVolume(0, currentVolume, 0);
                    currentVolume = -1;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            MLog.error((Object)TAG, (String)"closeSpeaker exception", (Object[])new Object[0]);
        }
    }

    private VoiceUtils() {
    }

    static {
        VoiceUtils voiceUtils;
        INSTANCE = voiceUtils = new VoiceUtils();
        HMAC_SHA1 = HMAC_SHA1;
        currentVolume = -1;
    }
}

