/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.voice.base.roomvoice;

import com.yy.appbase.service.model.RoomUserMicStatus;
import com.yy.base.event.kvo.KvoFieldAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.hiyo.voice.base.VoiceConstant;
import com.yy.hiyo.voice.base.channelvoice.IKtvLiveServiceExtend;
import com.yy.hiyo.voice.base.roomvoice.ISingleRoomCallbackNew;
import com.yy.hiyo.voice.base.roomvoice.RoomDef;
import com.yy.hiyo.voice.base.roomvoice.RoomSlot;
import com.yy.hiyo.voice.base.roomvoice.RoomUpdateTrace;
import ikxd.room.HeartbeatRes;
import ikxd.room.JoinRoomRes;
import ikxd.room.LeaveRoomRes;
import ikxd.room.MicOperateRes;
import ikxd.room.StatusNotify;
import ikxd.room.UserStatus;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public abstract class AbsVoiceRoom
extends KvoSource {
    private static final int ROOM_BEAT_DEFAULTTIME = 5000;
    private static final String TAG = "AbsVoiceRoom";
    public ISingleRoomCallbackNew mCallback;
    private volatile long mBeatTime = 5000L;
    public long mCurVersion = 0L;
    public ArrayList<RoomSlot> roomSlots = new ArrayList();
    public int showWindow = 0;
    public String mSessionId = "";
    @RoomDef.RoomScene
    public int roomSceneType = 0;
    public volatile int state = 0;
    public RoomUserMicStatus mMyStatus = new RoomUserMicStatus();
    public RoomUserMicStatus mOtherStatus = new RoomUserMicStatus();
    public static final String kvo_mRoomUserMicStatusList = "mRoomUserMicStatusList";
    @KvoFieldAnnotation(name="mRoomUserMicStatusList")
    private CopyOnWriteArrayList<RoomUserMicStatus> mRoomUserMicStatusList = new CopyOnWriteArrayList();
    protected RoomUpdateTrace mUpdateDataTrace = new RoomUpdateTrace();
    public static final int None = 0;
    public static final int Live = 1;
    public static final int Dead = 2;
    public static final int Pause = 3;
    protected IKtvLiveServiceExtend.VoiceType mCurVoiceType = null;
    Runnable backCloseMicRunnable = new Runnable(){

        @Override
        public void run() {
            FeatureLog.i((String)"FTVoice", (String)"App switch background onPause backCloseMicRunnable run", (Object[])new Object[0]);
            AbsVoiceRoom.this.pauseCloseMic();
        }
    };
    Runnable heartbeatRunnable = new Runnable(){

        @Override
        public void run() {
            AbsVoiceRoom.this.startHeartBeat();
            AbsVoiceRoom.this.mCallback.roomHeartbeatReq(AbsVoiceRoom.this);
        }
    };

    public AbsVoiceRoom(String mSessionId, ISingleRoomCallbackNew mCallback) {
        this.mSessionId = mSessionId;
        this.mCallback = mCallback;
    }

    public void onCreate(int scene) {
        this.startHeartBeat();
        for (RoomSlot roomSlot : this.roomSlots) {
            if (roomSlot == null || roomSlot.mCallBack == null) continue;
            roomSlot.mCallBack.onRoomCreate(roomSlot, scene, new Object[0]);
        }
    }

    public void onRestart(int scene) {
        for (RoomSlot roomSlot : this.roomSlots) {
            if (roomSlot == null || roomSlot.mCallBack == null) continue;
            roomSlot.mCallBack.onRoomRestart(roomSlot, scene);
        }
    }

    public void onPause(@RoomDef.RoomScene int scene) {
        for (RoomSlot roomSlot : this.roomSlots) {
            if (roomSlot == null || roomSlot.mCallBack == null) continue;
            roomSlot.mCallBack.onRoomPause(roomSlot, scene);
        }
    }

    protected synchronized void pauseCloseMic() {
        this.notifyMicStat(false, false);
    }

    protected void resumeMic() {
    }

    public void onResume(int scene) {
        for (RoomSlot roomSlot : this.roomSlots) {
            if (roomSlot == null || roomSlot.mCallBack == null) continue;
            roomSlot.mCallBack.onRoomResume(roomSlot, scene);
        }
    }

    public void onDestory(int scene) {
        MLog.info((Object)TAG, (String)(this.mSessionId + "onDestory"), (Object[])new Object[0]);
        this.stopHeartBeat();
        for (RoomSlot roomSlot : this.roomSlots) {
            if (roomSlot == null || roomSlot.mCallBack == null) continue;
            roomSlot.mCallBack.onRoomDestory(roomSlot, scene);
        }
    }

    private void startHeartBeat() {
        YYTaskExecutor.removeTask((Runnable)this.heartbeatRunnable);
        YYTaskExecutor.execute((Runnable)this.heartbeatRunnable, (long)this.mBeatTime);
    }

    private void stopHeartBeat() {
        YYTaskExecutor.removeTask((Runnable)this.heartbeatRunnable);
    }

    public abstract void onNetValidChanged(boolean var1, boolean var2);

    public void onJoinRoomRes(JoinRoomRes res, long version) {
        long nextSec;
        if (!MLog.isLogLevelAboveDebug() && !MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"onJoinRoomRes mSessionId: %s, res: %s, mCurVersion: %s, version: %s", (Object[])new Object[]{this.mSessionId, res, this.mCurVersion, version});
        }
        this.mBeatTime = (nextSec = res.next.longValue()) <= 0L ? 5000L : nextSec * 1000L;
        MLog.info((Object)TAG, (String)"onJoinRoomRes:%d", (Object[])new Object[]{(int)this.mBeatTime});
        this.mCurVersion = version;
        List<RoomUserMicStatus> list = this.convertStatus(res.status);
        this.updateUserStatus(list);
        this.handleVoiceType(res.voice_sdk, true);
    }

    protected void handleVoiceType(long type, boolean isJoinRoom) {
        IKtvLiveServiceExtend.VoiceType voiceType = type == 2L ? IKtvLiveServiceExtend.VoiceType.YYVOICE : IKtvLiveServiceExtend.VoiceType.AGORA;
        FeatureLog.i((String)"FTVoice", (String)("join room resp voice type = " + type), (Object[])new Object[0]);
        this.mCurVoiceType = voiceType;
        this.mCurVoiceType.setSessionId(this.mSessionId);
        if (this.roomSceneType == 13) {
            this.mCurVoiceType.setSceneId(VoiceConstant.SCENE_ID_SECRET_CALL);
        } else {
            this.mCurVoiceType.setSceneId(VoiceConstant.SCENE_ID_COMMUNICATION);
        }
        this.selectVoiceType(this.mCurVoiceType);
    }

    public boolean isInitVoiceType() {
        return this.mCurVoiceType != null;
    }

    public abstract void selectVoiceType(IKtvLiveServiceExtend.VoiceType var1);

    public void onRoomHeartbeatRes(HeartbeatRes res, long version) {
        long nextSec = res.next;
        this.mBeatTime = nextSec <= 0L ? 5000L : nextSec * 1000L;
        if (!this.checkVersionValid(this.mCurVersion, version)) {
            return;
        }
        this.mCurVersion = version;
        List<RoomUserMicStatus> list = this.convertStatus(res.status);
        this.updateUserStatus(list);
    }

    public void onLeaveRoomRes(LeaveRoomRes res, long version) {
    }

    public abstract void updateUserStatus(List<RoomUserMicStatus> var1);

    public abstract void onMicOperateRes(MicOperateRes var1, long var2);

    public int getShowWindow() {
        return this.showWindow;
    }

    public void setShowWindow(int showWindow) {
        this.showWindow = showWindow;
    }

    public void changeToState(int toState, @RoomDef.RoomScene int scene) {
        switch (this.state) {
            case 0: {
                this.noneTo(toState, scene);
                break;
            }
            case 1: {
                this.liveTo(toState, scene);
                break;
            }
            case 3: {
                this.pauseTo(toState, scene);
                break;
            }
        }
    }

    private void noneTo(int toState, int scene) {
        switch (toState) {
            case 1: {
                this.onCreate(scene);
                this.state = 1;
                break;
            }
        }
    }

    private void liveTo(int toState, int scene) {
        switch (toState) {
            case 1: {
                this.onRestart(scene);
                break;
            }
            case 2: {
                if (this.showWindow == 0) {
                    this.onDestory(scene);
                    this.state = 2;
                    break;
                }
                this.onPause(scene);
                this.state = 3;
                break;
            }
            case 3: {
                this.onPause(scene);
                this.state = 3;
                break;
            }
        }
    }

    private void pauseTo(int toState, int scene) {
        switch (toState) {
            case 1: {
                this.onResume(scene);
                this.state = 1;
                break;
            }
            case 3: {
                this.onPause(scene);
                this.state = 3;
                break;
            }
            case 2: {
                if (this.showWindow != 0) break;
                this.onDestory(scene);
                this.state = 2;
                break;
            }
        }
    }

    public int changeMicStatus(boolean micOpen) {
        return this.changeMicStatus(micOpen, true);
    }

    public int changeMicStatus(boolean micOpen, boolean isSave) {
        return this.notifyMicStat(micOpen, isSave);
    }

    private int notifyMicStat(boolean micOpen, boolean isSave) {
        MLog.info((Object)TAG, (String)"changeMicStatus%s,is_save %s", (Object[])new Object[]{micOpen, isSave});
        FeatureLog.i((String)"FTVoice", (String)"changeMicStatus%s,is_save %s", (Object[])new Object[]{micOpen, isSave});
        int res = 0;
        res = this.mCallback.micOperate(this.mSessionId, micOpen, isSave, this.mCurVoiceType);
        if (res == 0) {
            for (RoomUserMicStatus roomUserMicStatus : this.mRoomUserMicStatusList) {
                if (roomUserMicStatus.getUid() != this.mMyStatus.getUid()) continue;
                roomUserMicStatus.setMicOpen(micOpen);
            }
            this.mMyStatus.setMicOpen(micOpen);
            this.mCallback.micOperateReq(this, micOpen);
        }
        if (this.isInitVoiceType()) {
            FeatureLog.i((String)"FTVoice", (String)("isInitVoiceType is true, cur type Agora? = " + (this.mCurVoiceType == IKtvLiveServiceExtend.VoiceType.AGORA)), (Object[])new Object[0]);
            if (this.roomSceneType == 13) {
                this.mCurVoiceType.setSceneId(VoiceConstant.SCENE_ID_SECRET_CALL);
            } else {
                this.mCurVoiceType.setSceneId(VoiceConstant.SCENE_ID_COMMUNICATION);
            }
            this.mCurVoiceType.setSessionId(this.mSessionId);
            this.selectVoiceType(this.mCurVoiceType);
        }
        return res;
    }

    public List<RoomUserMicStatus> convertStatus(List<UserStatus> statusList) {
        if (FP.empty(statusList)) {
            return null;
        }
        ArrayList<RoomUserMicStatus> list = new ArrayList<RoomUserMicStatus>(statusList.size());
        for (UserStatus status : statusList) {
            list.add(new RoomUserMicStatus(status.uid.longValue(), status.mic.booleanValue()));
        }
        return list;
    }

    public boolean checkVersionValid(long oldVersion, long newVersion) {
        if (newVersion < oldVersion) {
            MLog.error((Object)TAG, (String)"checkVersionValid is oldVersion: %s, newVersion: %s", (Object[])new Object[]{oldVersion, newVersion});
            return false;
        }
        return true;
    }

    public RoomUserMicStatus getMyStatus() {
        return this.mMyStatus;
    }

    public RoomUserMicStatus getOtherStatus() {
        return this.mOtherStatus;
    }

    public void onRoomNotify(StatusNotify statusNotify, long version) {
        long voiceSdk = statusNotify.voice_sdk;
        FeatureLog.i((String)"FTVoice", (String)("onRoomNotify voiceSdk_ = " + voiceSdk), (Object[])new Object[0]);
        this.handleVoiceType(voiceSdk, false);
        if (!this.checkVersionValid(this.mCurVersion, version)) {
            return;
        }
        this.mCurVersion = version;
        List<RoomUserMicStatus> list = this.convertStatus(statusNotify.status);
        this.updateUserStatus(list);
    }

    public void setRoomUserMicStatusList(CopyOnWriteArrayList<RoomUserMicStatus> mRoomUserMicStatusList) {
        this.setValue(kvo_mRoomUserMicStatusList, mRoomUserMicStatusList);
    }

    public CopyOnWriteArrayList<RoomUserMicStatus> getRoomUserMicStatusList() {
        return this.mRoomUserMicStatusList;
    }

    public String toString() {
        return "AbsVoiceRoom{mCallback=" + this.mCallback + ", mBeatTime=" + this.mBeatTime + ", mCurVersion=" + this.mCurVersion + ", roomSlots=" + this.roomSlots + ", showWindow=" + this.showWindow + ", mSessionId='" + this.mSessionId + '\'' + ", state=" + this.state + ", mMyStatus=" + this.mMyStatus + ", mOtherStatus=" + this.mOtherStatus + ", mRoomUserMicStatusList=" + this.mRoomUserMicStatusList + ", mCurVoiceType=" + (Object)((Object)this.mCurVoiceType) + ", backCloseMicRunnable=" + this.backCloseMicRunnable + ", heartbeatRunnable=" + this.heartbeatRunnable + '}';
    }
}

