/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.voice.base.roomvoice;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.service.model.RoomUserMicStatus;
import com.yy.base.logger.MLog;
import com.yy.base.utils.FP;
import com.yy.hiyo.voice.base.roomvoice.BaseVoiceRoom;
import com.yy.hiyo.voice.base.roomvoice.ISingleRoomCallbackNew;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class MultiplayerRoom
extends BaseVoiceRoom {
    private static final String TAG = "MultiplayerRoom";
    private ConcurrentHashMap<Long, RoomUserMicStatus> micStatusConcurrentHashMap = new ConcurrentHashMap();

    public MultiplayerRoom(@Nullable String sessionId, @NonNull ISingleRoomCallbackNew callback) {
        super(sessionId, callback);
    }

    @Override
    public synchronized void updateUserStatus(List<RoomUserMicStatus> list) {
        if (this.state == 2) {
            return;
        }
        boolean needRejoin = false;
        if (FP.empty(list)) {
            needRejoin = true;
        }
        RoomUserMicStatus myStatus = null;
        boolean isContainsMe = false;
        if (!FP.empty(list)) {
            for (RoomUserMicStatus roomUserMicStatus : list) {
                if (roomUserMicStatus.getUid() != AccountUtil.getUid()) continue;
                myStatus = roomUserMicStatus;
                isContainsMe = true;
                break;
            }
        }
        if (isContainsMe) {
            if (myStatus == null) {
                needRejoin = true;
            } else if (myStatus.getUid() == AccountUtil.getUid() && myStatus.isMicOpen() == this.mMyStatus.isMicOpen()) {
                this.updateRoomUserMicList(list);
            } else {
                needRejoin = true;
            }
        } else {
            needRejoin = true;
        }
        this.mUpdateDataTrace.trace();
        boolean traceUnNormal = this.mUpdateDataTrace.isTraceUnNormal();
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"need rejoin room,need:%b, uid:%d, isNormal", (Object[])new Object[]{needRejoin, AccountUtil.getUid(), traceUnNormal});
        }
        if (needRejoin && AccountUtil.getUid() > 0L && this.mCallback != null && !traceUnNormal) {
            this.mCallback.joinRoomReq(this, this.mMyStatus.isMicOpen());
        }
    }

    synchronized void updateRoomUserMicList(List<RoomUserMicStatus> list) {
        boolean isNeedRefresh = false;
        for (RoomUserMicStatus roomUserMicStatus : list) {
            long currentUid = roomUserMicStatus.getUid();
            if (this.micStatusConcurrentHashMap.get(currentUid) == null) {
                isNeedRefresh = true;
            } else if (this.micStatusConcurrentHashMap.get(currentUid).isMicOpen() != roomUserMicStatus.isMicOpen()) {
                isNeedRefresh = true;
            }
            this.micStatusConcurrentHashMap.put(currentUid, roomUserMicStatus);
        }
        if (isNeedRefresh) {
            this.setRoomUserMicStatusList(new CopyOnWriteArrayList<RoomUserMicStatus>(list));
        }
    }

    public void setMicStatusConcurrentHashMap(ConcurrentHashMap<Long, RoomUserMicStatus> micStatusConcurrentHashMap) {
        this.micStatusConcurrentHashMap = micStatusConcurrentHashMap;
    }

    public ConcurrentHashMap<Long, RoomUserMicStatus> getMicStatusConcurrentHashMap() {
        return this.micStatusConcurrentHashMap;
    }
}

