/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.videoeffect.widget;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Region;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.widget.SeekBar;
import com.yy.base.logger.MLog;
import com.yy.hiyo.videoeffect.base.R;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007B!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010 \u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\b\u0010!\u001a\u00020\"H\u0016J\u001a\u0010#\u001a\u00020\u001d2\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002J\u0010\u0010$\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0014R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/yy/hiyo/videoeffect/widget/InheritedSeekBar;", "Landroid/widget/SeekBar;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attributeSet", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "drawAreaRect", "Landroid/graphics/Rect;", "getDrawAreaRect", "()Landroid/graphics/Rect;", "textColor", "textMarginBottom", "textPaint", "Landroid/graphics/Paint;", "textShadowColor", "textShadowOffsetX", "textShadowOffsetY", "textShadowRadius", "textSize", "", "withText", "", "withTextShadow", "compatibleWithPreMarshmallow", "", "canvas", "Landroid/graphics/Canvas;", "drawText", "getDrawText", "", "init", "onDraw", "videoeffect-base_debug"})
public class InheritedSeekBar
extends SeekBar {
    private final Paint textPaint;
    private boolean withText;
    private float textSize;
    private int textColor;
    private int textMarginBottom;
    private boolean withTextShadow;
    private int textShadowColor;
    private int textShadowRadius;
    private int textShadowOffsetX;
    private int textShadowOffsetY;
    @NotNull
    private final Rect drawAreaRect;
    private HashMap _$_findViewCache;

    @NotNull
    public final Rect getDrawAreaRect() {
        return this.drawAreaRect;
    }

    private final void init(Context context, AttributeSet attributeSet) {
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.InheritedSeekBar);
        Intrinsics.checkExpressionValueIsNotNull((Object)typedArray, (String)"context.obtainStyledAttr\u2026yleable.InheritedSeekBar)");
        TypedArray a = typedArray;
        this.withText = a.getBoolean(R.styleable.InheritedSeekBar_withText, false);
        if (this.withText) {
            Resources resources = context.getResources();
            Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"context.resources");
            this.textSize = a.getDimensionPixelSize(R.styleable.InheritedSeekBar_textSize, (int)TypedValue.applyDimension((int)2, (float)12.0f, (DisplayMetrics)resources.getDisplayMetrics()));
            this.textColor = a.getColor(R.styleable.InheritedSeekBar_textColor, this.textColor);
            this.textMarginBottom = a.getDimensionPixelSize(R.styleable.InheritedSeekBar_textMarginBottom, 0);
        }
        this.withTextShadow = a.getBoolean(R.styleable.InheritedSeekBar_withTextShadow, false);
        if (this.withTextShadow) {
            this.textShadowColor = a.getColor(R.styleable.InheritedSeekBar_textShadowColor, this.textShadowColor);
            this.textShadowRadius = a.getDimensionPixelSize(R.styleable.InheritedSeekBar_textShadowRadius, 0);
            this.textShadowOffsetX = a.getDimensionPixelOffset(R.styleable.InheritedSeekBar_textShadowOffsetX, 0);
            this.textShadowOffsetY = a.getDimensionPixelOffset(R.styleable.InheritedSeekBar_textShadowOffsetY, 0);
        }
        a.recycle();
        if (this.withText) {
            this.textPaint.setTextSize(this.textSize);
            this.textPaint.setColor(this.textColor);
            this.textPaint.setTextAlign(Paint.Align.CENTER);
            this.textPaint.setAntiAlias(true);
        }
        if (this.withTextShadow) {
            this.textPaint.setShadowLayer((float)this.textShadowRadius, (float)this.textShadowOffsetX, (float)this.textShadowOffsetY, this.textShadowColor);
        }
    }

    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        this.compatibleWithPreMarshmallow(canvas);
        super.onDraw(canvas);
        if (this.withText && Build.VERSION.SDK_INT > 22) {
            this.drawText(canvas);
        }
    }

    private final void drawText(Canvas canvas) {
        int saveCount = canvas.save();
        Drawable drawable2 = this.getThumb();
        Intrinsics.checkExpressionValueIsNotNull((Object)drawable2, (String)"thumb");
        int thumbTopY = drawable2.getBounds().top;
        float thumbCenterX = (float)this.getPaddingStart() + (float)this.getProgress() / (float)this.getMax() * (float)(this.getWidth() - this.getPaddingStart() - this.getPaddingEnd());
        canvas.drawText(this.getDrawText(), thumbCenterX, (float)thumbTopY - (float)this.textMarginBottom, this.textPaint);
        canvas.restoreToCount(saveCount);
    }

    @NotNull
    public String getDrawText() {
        return String.valueOf(this.getProgress());
    }

    private final void compatibleWithPreMarshmallow(Canvas canvas) {
        if (Build.VERSION.SDK_INT <= 22 && this.withText) {
            canvas.getClipBounds(this.drawAreaRect);
            MLog.debug((Object)"InheritedSeekBar", (String)("compatibleWithPreMarshmallow->rect before = " + this.drawAreaRect), (Object[])new Object[0]);
            this.drawAreaRect.inset(0, -((int)((double)this.textSize + 0.5)));
            MLog.debug((Object)"InheritedSeekBar", (String)("compatibleWithPreMarshmallow->rect after = " + this.drawAreaRect), (Object[])new Object[0]);
            canvas.clipRect(this.drawAreaRect, Region.Op.REPLACE);
        }
    }

    public InheritedSeekBar(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this(context, null);
    }

    public InheritedSeekBar(@NotNull Context context, @Nullable AttributeSet attributeSet) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this(context, attributeSet, 0);
    }

    public InheritedSeekBar(@NotNull Context context, @Nullable AttributeSet attributeSet, int defStyleAttr) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attributeSet, defStyleAttr);
        this.textPaint = new Paint();
        this.textColor = -16777216;
        this.textShadowColor = -16777216;
        this.drawAreaRect = new Rect();
        this.init(context, attributeSet);
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }
}

