/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.user.profile;

import android.content.Context;
import android.text.TextUtils;
import android.util.Pair;
import androidx.annotation.NonNull;
import androidx.lifecycle.LiveData;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.squareup.wire.AndroidMessage;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.callback.ICommonCallback;
import com.yy.appbase.core.DefaultController;
import com.yy.appbase.data.GameMasterBean;
import com.yy.appbase.data.UserExtraInfo;
import com.yy.appbase.data.UserInfoBean;
import com.yy.appbase.data.UserOnlineDBBean;
import com.yy.appbase.envsetting.uriprovider.UriProvider;
import com.yy.appbase.http.INetRespCallback;
import com.yy.appbase.service.IDBService;
import com.yy.appbase.service.IOOSService;
import com.yy.appbase.service.IUserInfoService;
import com.yy.appbase.service.OnGetInviteFriendStateCallback;
import com.yy.appbase.service.callback.IGetCharismaCallback;
import com.yy.appbase.service.callback.IGetMedalListCallback;
import com.yy.appbase.service.callback.IGetOnlineStatusCallback;
import com.yy.appbase.service.callback.IGetUserExtraInfoCallback;
import com.yy.appbase.service.callback.IProfileOperationCallback;
import com.yy.appbase.service.callback.IQueryOnlineCallBack;
import com.yy.appbase.service.callback.IQueryUserBy3rdAccountCallBack;
import com.yy.appbase.service.callback.IUserDistanceInfoCallback;
import com.yy.appbase.service.callback.OnAlbumCallback;
import com.yy.appbase.service.callback.OnGameHistoryCallback;
import com.yy.appbase.service.callback.OnGetAllHonorTitlesCallback;
import com.yy.appbase.service.callback.OnGetGuideTypeCallback;
import com.yy.appbase.service.callback.OnGetHomeGuideExperimentDataCallback;
import com.yy.appbase.service.callback.OnGetInsPhotosCallback;
import com.yy.appbase.service.callback.OnGetInsStatusCallback;
import com.yy.appbase.service.callback.OnGetLatestHonorCallback;
import com.yy.appbase.service.callback.OnGetShareForFriendCallback;
import com.yy.appbase.service.callback.OnLikeClickCallback;
import com.yy.appbase.service.callback.OnLikeListCallback;
import com.yy.appbase.service.callback.OnProfileListCallback;
import com.yy.appbase.service.callback.OnProfileSingleCallback;
import com.yy.appbase.service.callback.OnUpdateCallback;
import com.yy.appbase.service.oos.IUploadObjectCallBack;
import com.yy.base.event.core.EventIntent;
import com.yy.base.event.fw.FWEvent;
import com.yy.base.event.fw.FWEventActionKey;
import com.yy.base.event.fw.FWEventAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.event.kvo.list.KvoPageList;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.DontProguardClass;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.YYFileUtils;
import com.yy.framework.core.Environment;
import com.yy.framework.core.INotify;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.NotificationDef;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.IProtoCallback;
import com.yy.hiyo.relation.base.blacklist.IBlacklistService;
import com.yy.hiyo.user.base.data.MyLikeListRes;
import com.yy.hiyo.user.base.data.UserModuleData;
import com.yy.hiyo.user.profile.PhotoModel;
import com.yy.hiyo.user.profile.cx;
import com.yy.hiyo.user.profile.ex;
import com.yy.hiyo.user.profile.fj;
import com.yy.hiyo.user.profile.hb;
import com.yy.hiyo.user.profile.hc;
import com.yy.hiyo.user.profile.hd;
import com.yy.hiyo.user.profile.he;
import com.yy.hiyo.user.profile.hf;
import com.yy.hiyo.user.profile.hg;
import com.yy.hiyo.user.profile.hh;
import com.yy.hiyo.user.profile.hi;
import com.yy.hiyo.user.profile.hj;
import com.yy.hiyo.user.profile.k;
import com.yy.hiyo.user.profile.online.x;
import com.yy.hiyo.user.profile.profilecard.l;
import com.yy.hiyo.user.profile.sevice.c;
import common.Page;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.ihago.base.api.accessrecords.GetUserHomePageAccessRecordsReq;
import net.ihago.base.api.accessrecords.GetUserHomePageAccessRecordsRsp;
import net.ihago.medal.srv.mgr.BatchGetMedalReq;

@DontProguardClass
public class UserInfoService
extends DefaultController
implements IUserInfoService {
    public static final String TAG = "UserInfoService";
    private com.yy.hiyo.user.profile.sevice.a mAccountTransformService;
    private c mOnlineService;
    private fj mUserModel;
    private PhotoModel mPhotoModel;
    private ex mRequestManager;
    private cx mNewUserInfoModel;
    private k instagramPhotoModel;
    private com.yy.hiyo.user.profile.online.c mOnlineModel;
    private x mOnlineRequest;
    private long mLastRequestMyLikeListTime = 0L;
    private UserModuleData mData;
    private Set<Long> mToSendUids = new HashSet<Long>();
    private final Object mBatchGetUserBBSMedalLock = new byte[0];
    private Runnable mScheduleBathGetUserBBSTask = () -> {
        ArrayList<Long> arrayList;
        Object object = this.mBatchGetUserBBSMedalLock;
        synchronized (object) {
            arrayList = new ArrayList<Long>(this.mToSendUids);
            this.mToSendUids.clear();
        }
        int n2 = arrayList.size();
        if (n2 <= 100) {
            this.doBatchGet(arrayList);
        } else {
            for (int i2 = 0; i2 < n2; i2 += 100) {
                this.doBatchGet(arrayList.subList(i2, Math.min(i2 + 100, n2)));
            }
        }
    };

    public void getFirstPageMyLikeList(ICommonCallback iCommonCallback) {
        MyLikeListRes.Page page = new MyLikeListRes.Page();
        page.limit = 20L;
        page.offset = 0L;
        this.doGetMyLikeList(0L, page, iCommonCallback);
    }

    public void getNextPageMyLikeList(ICommonCallback iCommonCallback) {
        KvoPageList kvoPageList = this.mData.myLikeUserList;
        MyLikeListRes.Page page = new MyLikeListRes.Page();
        page.limit = 20L;
        page.offset = kvoPageList.offset;
        this.doGetMyLikeList(this.mLastRequestMyLikeListTime, page, iCommonCallback);
    }

    private void doGetMyLikeList(Long l2, MyLikeListRes.Page page, ICommonCallback iCommonCallback) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("offset", (Number)page.offset);
        jsonObject.addProperty("limit", (Number)page.limit);
        JsonObject jsonObject2 = new JsonObject();
        jsonObject2.add("page", (JsonElement)jsonObject);
        jsonObject2.addProperty("last_time", (Number)l2);
        fj.a(UriProvider.GET_MY_LIKE_LIST, jsonObject2, null, new hb(this, iCommonCallback, page), 1);
    }

    public KvoSource data() {
        return this.mData;
    }

    public void getFirstPageMyVisitList(IProtoCallback<GetUserHomePageAccessRecordsRsp> iProtoCallback) {
        this.doGetMyVisitList(1L, new Page.Builder().limit(Long.valueOf(20L)).offset(Long.valueOf(0L)).snap(Long.valueOf(0L)).total(Long.valueOf(0L)).build(), iProtoCallback);
    }

    public void getNextPageMyVisitList(IProtoCallback<GetUserHomePageAccessRecordsRsp> iProtoCallback) {
        KvoPageList kvoPageList = this.mData.myVisitUserList;
        this.doGetMyVisitList(1L, new Page.Builder().limit(Long.valueOf(20L)).offset(Long.valueOf(kvoPageList.offset)).snap(Long.valueOf(kvoPageList.snapshot)).total(Long.valueOf(kvoPageList.total)).build(), iProtoCallback);
    }

    private void doGetMyVisitList(long l2, Page page, IProtoCallback<GetUserHomePageAccessRecordsRsp> iProtoCallback) {
        GetUserHomePageAccessRecordsReq getUserHomePageAccessRecordsReq = new GetUserHomePageAccessRecordsReq.Builder().page(page).start_time(Long.valueOf(l2)).build();
        ProtoManager.getInstance().sendRpc((AndroidMessage)getUserHomePageAccessRecordsReq, (IProtoCallback)new hc(this, iProtoCallback, page));
    }

    public void onLeaveMyVisitPage() {
        String string2 = "my_visitors_unread_" + AccountUtil.getUid();
        this.mData.setValue("unreadCount", (Object)0);
        SettingFlags.setIntValue((String)string2, (int)0);
    }

    @FWEventAnnotation(name=FWEventActionKey.FWAction_On_Visitor_Add)
    public void onVisitorIncrease(EventIntent eventIntent) {
        String string2 = "my_visitors_unread_" + AccountUtil.getUid();
        this.mData.setValue("unreadCount", (Object)(SettingFlags.getIntValue((String)string2, (int)0) + (Integer)eventIntent.arg0()));
        SettingFlags.setIntValue((String)string2, (int)this.mData.unreadCount);
    }

    public UserInfoService(Environment environment) {
        super(environment);
        this.mData = new UserModuleData();
        FWEvent.bindMethodToEvent((Object)((Object)this), (String)"onVisitorIncrease");
        this.mAccountTransformService = new com.yy.hiyo.user.profile.sevice.a(environment);
        this.mOnlineService = new c(environment);
        this.mUserModel = new fj(this.mRequestManager, new hd(this));
        this.mPhotoModel = new PhotoModel(this.getEnvironment());
        this.mRequestManager = new ex();
        this.mNewUserInfoModel = new cx(this.mRequestManager, new he(this));
        this.instagramPhotoModel = new k();
        this.mOnlineModel = new com.yy.hiyo.user.profile.online.c();
        this.mOnlineRequest = new x();
        if (!YYTaskExecutor.isMainThread()) {
            YYTaskExecutor.postToMainThread(() -> NotificationCenter.getGlobalInstance().register(NotificationDef.N_LOGIN_LOGIN_OUT, (INotify)this));
        } else {
            NotificationCenter.getGlobalInstance().register(NotificationDef.N_LOGIN_LOGIN_OUT, (INotify)this);
        }
    }

    public void notify(Notification notification) {
        if (notification.id == NotificationDef.N_LOGIN_LOGIN_OUT) {
            this.clearData();
            this.mNewUserInfoModel.b();
        }
    }

    public void clearUserCache(List<Long> list) {
        YYTaskExecutor.execute(() -> {
            if (this.mNewUserInfoModel != null) {
                this.mNewUserInfoModel.a(list);
            }
        });
    }

    public void queryOnlineStatus(long l2, IGetOnlineStatusCallback iGetOnlineStatusCallback) {
        if (this.mUserModel != null) {
            this.mUserModel.a(l2, iGetOnlineStatusCallback);
        } else {
            YYTaskExecutor.postToMainThread(() -> {
                if (iGetOnlineStatusCallback != null) {
                    iGetOnlineStatusCallback.onError(-1, "servive null!");
                }
            });
        }
    }

    public List<UserInfoBean> getUserInfo(List<Long> list, OnProfileListCallback onProfileListCallback) {
        if (this.mNewUserInfoModel != null) {
            return this.mNewUserInfoModel.a(list, onProfileListCallback);
        }
        YYTaskExecutor.postToMainThread(() -> {
            if (onProfileListCallback != null) {
                onProfileListCallback.onError(null, (Exception)new RuntimeException("servive null!"), -1);
            }
        });
        return null;
    }

    public List<UserInfoBean> getUserInfo(boolean bl2, List<Long> list, OnProfileListCallback onProfileListCallback) {
        if (this.mNewUserInfoModel != null) {
            return this.mNewUserInfoModel.a(list, onProfileListCallback, bl2);
        }
        YYTaskExecutor.postToMainThread(() -> {
            if (onProfileListCallback != null) {
                onProfileListCallback.onError(null, (Exception)new RuntimeException("servive null!"), -1);
            }
        });
        return null;
    }

    public List<UserInfoBean> getUserInfo(List<Long> list, OnProfileListCallback onProfileListCallback, boolean bl2) {
        if (this.mNewUserInfoModel != null) {
            return this.mNewUserInfoModel.a(list, onProfileListCallback, bl2);
        }
        return null;
    }

    public UserInfoBean getUserInfo(long l2, OnProfileListCallback onProfileListCallback) {
        if (l2 <= 0L) {
            YYTaskExecutor.postToMainThread(() -> {
                if (onProfileListCallback != null) {
                    onProfileListCallback.onError(null, (Exception)new RuntimeException("Uid is invalid!"), -1);
                }
            });
            return null;
        }
        if (this.mNewUserInfoModel != null) {
            return this.mNewUserInfoModel.a(l2, onProfileListCallback);
        }
        return null;
    }

    public void uploadUserInfo(UserInfoBean userInfoBean, OnProfileSingleCallback onProfileSingleCallback) {
        if (this.mNewUserInfoModel != null) {
            this.mNewUserInfoModel.a(userInfoBean, onProfileSingleCallback);
        }
    }

    public void updateUserInfoLocal(UserInfoBean userInfoBean) {
        if (this.mNewUserInfoModel != null) {
            this.mNewUserInfoModel.a(userInfoBean, true);
        }
    }

    public void updateLikeInfo(long l2, OnLikeClickCallback onLikeClickCallback) {
        boolean bl2 = ((IBlacklistService)this.getServiceManager().getService(IBlacklistService.class)).isInBlacklist(l2).getInBlacklist();
        if (bl2) {
            onLikeClickCallback.onIsBlock();
        } else {
            this.mUserModel.a(l2, onLikeClickCallback);
        }
    }

    public void getLikeStatus(long l2, OnLikeListCallback onLikeListCallback) {
        ArrayList<Long> arrayList = new ArrayList<Long>();
        arrayList.add(l2);
        this.mUserModel.a(arrayList, onLikeListCallback);
    }

    public void getLikeCount(long l2, OnLikeListCallback onLikeListCallback) {
        ArrayList<Long> arrayList = new ArrayList<Long>();
        arrayList.add(l2);
        this.mUserModel.b(arrayList, onLikeListCallback);
    }

    public void updateAvatar(String string2, OnUpdateCallback onUpdateCallback) {
        if (this.mPhotoModel == null) {
            return;
        }
        this.mPhotoModel.putPhoto(string2, 2, onUpdateCallback);
    }

    public void updateAlbum(String string2, OnUpdateCallback onUpdateCallback) {
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            String string3 = YYFileUtils.getFileExtension((String)string2);
            if (TextUtils.isEmpty((CharSequence)string3)) {
                string3 = ".jpg";
            }
            String string4 = "album/" + AccountUtil.getUid() + "_" + System.currentTimeMillis() + string3;
            if (onUpdateCallback == null) {
                return;
            }
            ((IOOSService)this.getServiceManager().getService(IOOSService.class)).uploadFile(string4, string2, (IUploadObjectCallBack)new hf(this, onUpdateCallback));
        }
    }

    public void replaceAllAlbum(List<String> list, OnUpdateCallback onUpdateCallback) {
        if (!list.isEmpty()) {
            this.mPhotoModel.replaceAllAlbum(list, onUpdateCallback);
        }
    }

    public void replaceFromAlbum(String string2, String string3, int n2, OnUpdateCallback onUpdateCallback) {
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            String string4 = YYFileUtils.getFileExtension((String)string2);
            if (TextUtils.isEmpty((CharSequence)string4)) {
                string4 = ".jpg";
            }
            String string5 = "album/" + AccountUtil.getUid() + "_" + System.currentTimeMillis() + string4;
            if (onUpdateCallback == null) {
                return;
            }
            ((IOOSService)this.getServiceManager().getService(IOOSService.class)).uploadFile(string5, string2, (IUploadObjectCallBack)new hg(this, string3, n2, onUpdateCallback, string5));
        }
    }

    public void deletePhoto(String string2, OnUpdateCallback onUpdateCallback) {
        this.mPhotoModel.deletePhotoFromAlbum(string2, onUpdateCallback);
    }

    public List<String> getAlbum(long l2, OnAlbumCallback onAlbumCallback) {
        if (this.mPhotoModel == null) {
            return null;
        }
        List<String> list = this.mPhotoModel.getAlbumFromCache(l2);
        if (onAlbumCallback == null) {
            return list;
        }
        if (list != null && !list.isEmpty()) {
            onAlbumCallback.onUISuccess(list, l2);
        }
        this.mPhotoModel.getAlbumFromServer(l2, onAlbumCallback);
        return list;
    }

    private void getOwnerAlbum(long l2, OnAlbumCallback onAlbumCallback) {
        if (l2 == AccountUtil.getUid()) {
            this.mPhotoModel.getAlbumFromServer(l2, onAlbumCallback);
        }
    }

    public void getGameHistory(long l2, OnGameHistoryCallback onGameHistoryCallback) {
        this.mUserModel.a(l2, 0, onGameHistoryCallback);
    }

    public void getMineGameHistoryCacheFirst(OnGameHistoryCallback onGameHistoryCallback) {
        this.mUserModel.a(onGameHistoryCallback);
    }

    public void getGameHistoryWithLimit(long l2, int n2, OnGameHistoryCallback onGameHistoryCallback) {
        if (this.mUserModel != null) {
            this.mUserModel.a(l2, n2, onGameHistoryCallback);
        }
    }

    public void getShareForFriend(long l2, OnGetShareForFriendCallback onGetShareForFriendCallback) {
        if (this.mUserModel != null) {
            this.mUserModel.a(l2, onGetShareForFriendCallback);
        }
    }

    public void getFindFriendGuideType(long l2, OnGetGuideTypeCallback onGetGuideTypeCallback) {
        if (this.mUserModel != null) {
            this.mUserModel.a(l2, onGetGuideTypeCallback);
        }
    }

    public void getUserInfoByThirdPartyAccount(ArrayList<String> arrayList, IQueryUserBy3rdAccountCallBack iQueryUserBy3rdAccountCallBack) {
        YYTaskExecutor.execute((Runnable)new hh(this, arrayList, iQueryUserBy3rdAccountCallBack));
    }

    public HashMap<Long, Boolean> getOnlineStatus(ArrayList<Long> arrayList, IQueryOnlineCallBack iQueryOnlineCallBack) {
        return this.mOnlineService.a(arrayList, iQueryOnlineCallBack);
    }

    public void clearData() {
        if (this.mUserModel != null) {
            this.mUserModel.a();
        }
    }

    public void updateLocalUserProperty(long l2, String string2, String string3, int n2) {
        if (this.mNewUserInfoModel != null) {
            this.mNewUserInfoModel.a(l2, string2, string3, n2);
        }
    }

    public void getInstagramBindStatus(OnGetInsStatusCallback onGetInsStatusCallback) {
        if (this.instagramPhotoModel == null) {
            this.instagramPhotoModel = new k();
        }
        this.instagramPhotoModel.a(onGetInsStatusCallback);
    }

    public void getInstagramPhotos(long l2, OnGetInsPhotosCallback onGetInsPhotosCallback) {
        if (this.instagramPhotoModel == null) {
            this.instagramPhotoModel = new k();
        }
        this.instagramPhotoModel.a(l2, onGetInsPhotosCallback);
    }

    public void deleteInstagramPhotosFromCache(long l2) {
        if (this.instagramPhotoModel == null) {
            this.instagramPhotoModel = new k();
        }
        this.instagramPhotoModel.a(l2);
    }

    public void uploadInstagramPhotos(Object object, INetRespCallback iNetRespCallback) {
        if (this.instagramPhotoModel == null) {
            this.instagramPhotoModel = new k();
        }
        this.instagramPhotoModel.a((List)object, iNetRespCallback);
    }

    public void getLatestHonor(long l2, OnGetLatestHonorCallback onGetLatestHonorCallback) {
        if (this.mUserModel != null) {
            this.mUserModel.a(l2, onGetLatestHonorCallback);
        }
    }

    public void getMedalList(long l2, IGetMedalListCallback iGetMedalListCallback) {
        this.mUserModel.a(l2, iGetMedalListCallback);
    }

    public void getAllHonorTitles(long l2, OnGetAllHonorTitlesCallback onGetAllHonorTitlesCallback) {
        if (this.mUserModel != null) {
            this.mUserModel.a(l2, onGetAllHonorTitlesCallback);
        }
    }

    public void getHonorByTitleId(long l2, OnGetLatestHonorCallback onGetLatestHonorCallback) {
        if (this.mUserModel != null) {
            this.mUserModel.b(l2, onGetLatestHonorCallback);
        }
    }

    public void getInviteFriendState(OnGetInviteFriendStateCallback onGetInviteFriendStateCallback) {
        if (this.mUserModel != null) {
            this.mUserModel.a(onGetInviteFriendStateCallback);
        }
    }

    public int getInviteFriendIsActive() {
        if (this.mUserModel != null) {
            return this.mUserModel.b();
        }
        return 0;
    }

    public void showProfileCard(Context context, int n2, long l2, IProfileOperationCallback iProfileOperationCallback, boolean bl2) {
        l l3 = l.a();
        com.yy.hiyo.user.profile.profilecard.c c2 = l3.a(this.mContext, iProfileOperationCallback, n2, bl2);
        l3.a(l2);
        this.mDialogLinkManager.showDialog((BaseDialog)c2);
    }

    public void requestHomeGuideExperimentData(OnGetHomeGuideExperimentDataCallback onGetHomeGuideExperimentDataCallback) {
        if (this.mUserModel != null) {
            this.mUserModel.a(onGetHomeGuideExperimentDataCallback);
        }
    }

    public void getCharisma(long l2, long l3, int n2, IGetCharismaCallback iGetCharismaCallback) {
        if (this.mUserModel != null) {
            this.mUserModel.a(l2, l3, n2, iGetCharismaCallback);
        }
    }

    public void requesterIsMaster(long l2, ICommonCallback<GameMasterBean> iCommonCallback) {
        if (this.mUserModel != null) {
            this.mUserModel.a(l2, iCommonCallback);
        }
    }

    public List<UserInfoBean> getCacheList() {
        return this.mNewUserInfoModel.a();
    }

    public LiveData<UserOnlineDBBean> getOnlineStatus(long l2) {
        return this.mOnlineModel.a(l2);
    }

    public LiveData<UserOnlineDBBean> getOnlineStatus(long l2, boolean bl2) {
        return this.mOnlineModel.a(l2, bl2);
    }

    public LiveData<Map<Long, UserOnlineDBBean>> getOnlineStatus(@NonNull List<Long> list) {
        return this.mOnlineModel.b(list);
    }

    public LiveData<Map<Long, UserOnlineDBBean>> getOnlineStatus(@NonNull List<Long> list, boolean bl2) {
        return this.mOnlineModel.a(list, bl2);
    }

    public void getOnlineStatusWithCallback(@NonNull List<Long> list, ICommonCallback<Map<Long, UserOnlineDBBean>> iCommonCallback) {
        MLog.info((Object)TAG, (String)"requestOnlineStatus", (Object[])new Object[0]);
        this.mOnlineRequest.a(list, new hi(this, iCommonCallback));
    }

    public void requestOnlineStatus(@NonNull List<Long> list) {
        this.mOnlineModel.a(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void batchGetUserBBSMedals(Long ... longArray) {
        Object object = this.mBatchGetUserBBSMedalLock;
        synchronized (object) {
            boolean bl2 = this.mToSendUids.isEmpty();
            this.mToSendUids.addAll(Arrays.asList(longArray));
            if (bl2) {
                YYTaskExecutor.execute((Runnable)this.mScheduleBathGetUserBBSTask, (long)1000L);
            }
        }
    }

    private void doBatchGet(List<Long> list) {
        if (list.size() == 0) {
            return;
        }
        BatchGetMedalReq batchGetMedalReq = new BatchGetMedalReq.Builder().uids(list).build();
        ProtoManager.getInstance().sendRpc((AndroidMessage)batchGetMedalReq, (IProtoCallback)new hj(this));
    }

    public UserExtraInfo getUserExtraInfo(long l2, IGetUserExtraInfoCallback iGetUserExtraInfoCallback) {
        return this.mNewUserInfoModel.a(l2, iGetUserExtraInfoCallback);
    }

    public List<Pair<Long, Double>> getUserDistance(double d2, double d3, @NonNull List<Long> list, @NonNull IUserDistanceInfoCallback iUserDistanceInfoCallback) {
        return this.mNewUserInfoModel.a(d2, d3, list, iUserDistanceInfoCallback);
    }

    static /* synthetic */ long access$002(UserInfoService userInfoService, long l2) {
        userInfoService.mLastRequestMyLikeListTime = l2;
        return userInfoService.mLastRequestMyLikeListTime;
    }

    static /* synthetic */ UserModuleData access$100(UserInfoService userInfoService) {
        return userInfoService.mData;
    }

    static /* synthetic */ PhotoModel access$200(UserInfoService userInfoService) {
        return userInfoService.mPhotoModel;
    }

    static /* synthetic */ com.yy.hiyo.user.profile.sevice.a access$300(UserInfoService userInfoService) {
        return userInfoService.mAccountTransformService;
    }

    public static interface a {
        public IDBService a();
    }
}

