/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.user.base.honor;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.widget.PopupWindow;
import android.widget.TextView;
import com.yy.appbase.ui.widget.bubble.BubbleLinearLayout;
import com.yy.appbase.ui.widget.bubble.BubblePopupWindow;
import com.yy.appbase.ui.widget.bubble.BubbleStyle;
import com.yy.appbase.ui.widget.bubble.RelativePos;
import com.yy.base.utils.FontUtils;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ScreenUtils;
import com.yy.hiyo.user.base.R;

public class HonorIntroPopupwindow
extends PopupWindow
implements PopupWindow.OnDismissListener {
    private static final String TAG = "HonorIntroPopupwindow";
    private BubblePopupWindow mPopupWindow;
    private Context mContext;

    public HonorIntroPopupwindow(Context context) {
        this.mContext = context;
    }

    public void showHonorPopup(View view, String intro, String desc) {
        this.showHonorPopup(view, intro, desc, false);
    }

    public void setTouchInterceptor(View.OnTouchListener l) {
        super.setTouchInterceptor(l);
    }

    public void showHonorPopup(View view, String intro, String desc, boolean isScrollCancel) {
        View contentView = LayoutInflater.from((Context)this.mContext).inflate(R.layout.popup_honor_intro, null, false);
        BubbleLinearLayout llContent = (BubbleLinearLayout)contentView.findViewById(R.id.ll_honor);
        llContent.setFillColor(this.mContext.getResources().getColor(R.color.honor_pop_color));
        llContent.setCornerRadius((float)ResolutionUtils.dip2Px((float)3.0f));
        this.mPopupWindow = new BubblePopupWindow(contentView, (BubbleStyle)llContent);
        TextView tvIntro = (TextView)contentView.findViewById(R.id.tv_intro);
        TextView tvDesc = (TextView)contentView.findViewById(R.id.tv_honor_desc);
        tvIntro.setTypeface(FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.DINMittelschriftAlternate));
        tvDesc.setTypeface(FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.DINMittelschriftAlternate));
        this.setOnDismissListener(this);
        tvIntro.setText((CharSequence)intro);
        tvDesc.setText((CharSequence)desc);
        RelativePos relativePos = new RelativePos(0, 0);
        this.mPopupWindow.setCancelOnLater(7000L);
        int[] position = new int[2];
        view.getLocationOnScreen(position);
        if (ScreenUtils.getInstance().getHeightPixels() - position[1] < 300) {
            relativePos.setVerticalRelate(1);
            this.mPopupWindow.showArrowTo(view, relativePos, 0, 0);
        } else {
            relativePos.setVerticalRelate(2);
            this.mPopupWindow.showArrowTo(view, relativePos, 0, 10);
        }
        if (isScrollCancel) {
            this.setTouchInterceptor();
        }
    }

    private void setTouchInterceptor() {
        this.mPopupWindow.setTouchInterceptor(new View.OnTouchListener(){

            public boolean onTouch(View view, MotionEvent motionEvent) {
                if (motionEvent.getY() >= 0.0f && motionEvent.getY() <= (float)view.getMeasuredHeight()) {
                    return false;
                }
                HonorIntroPopupwindow.this.mPopupWindow.dismiss();
                return false;
            }
        });
    }

    public void onDismiss() {
    }
}

