/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.social.wemeet.banner;

import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.kvomodule.KvoModuleManager;
import com.yy.appbase.kvomodule.module.UserInfoModule;
import com.yy.appbase.service.callback.OnProfileCallback;
import com.yy.base.logger.MLog;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.social.wemeet.banner.INewMatchNoticeListener;
import common.Header;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public enum NewMatchNoticeBoard {
    INSTANCE;

    private ArrayList<Long> mMatchesUids = new ArrayList();
    private HashMap<Long, String> mMatchesIconUrls = new HashMap();
    private INewMatchNoticeListener mListener;
    private static final String TAG = "NewMatchNoticeBoard";
    private volatile long sUid = 0L;

    private NewMatchNoticeBoard() {
        this.prepareMatchesIds();
    }

    public synchronized void prepareMatchesIds() {
        if (this.sUid != AccountUtil.getUid()) {
            this.mMatchesUids.clear();
            this.mMatchesIconUrls.clear();
            this.fetchMatchesIds();
        }
    }

    public synchronized void onAccountLoginSuccess() {
        this.prepareMatchesIds();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyNewMatchReceived(long matchUid) {
        NewMatchNoticeBoard newMatchNoticeBoard = this;
        synchronized (newMatchNoticeBoard) {
            this.mMatchesUids.add(matchUid);
        }
        this.onNewMatchChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyNewMatchAllExpired() {
        NewMatchNoticeBoard newMatchNoticeBoard = this;
        synchronized (newMatchNoticeBoard) {
            this.mMatchesUids.clear();
            this.mMatchesIconUrls.clear();
        }
        this.onNewMatchChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyNewMatchRemove(long matchUid) {
        NewMatchNoticeBoard newMatchNoticeBoard = this;
        synchronized (newMatchNoticeBoard) {
            this.mMatchesUids.remove(matchUid);
            this.mMatchesIconUrls.remove(matchUid);
        }
        this.onNewMatchChanged();
    }

    public synchronized String getNewestMatchIconUrl() {
        if (this.mMatchesUids.size() <= 0) {
            return null;
        }
        Long uid = this.mMatchesUids.get(this.mMatchesUids.size() - 1);
        String iconUrl = this.mMatchesIconUrls.get(uid);
        if (StringUtils.isNotEmpty((String)iconUrl)) {
            return iconUrl;
        }
        ((UserInfoModule)KvoModuleManager.getModule(UserInfoModule.class)).getUserInfo(uid.longValue(), new OnProfileCallback(){

            public void onSuccess(int id, List<UserInfoKS> userInfoKSList) {
                if (userInfoKSList != null && !userInfoKSList.isEmpty()) {
                    UserInfoKS userInfoKS = userInfoKSList.get(0);
                    NewMatchNoticeBoard.this.mMatchesIconUrls.put(userInfoKS.getUid(), userInfoKS.getAvatar());
                    if (NewMatchNoticeBoard.this.mListener != null) {
                        NewMatchNoticeBoard.this.mListener.onNewMatchInfoChanged();
                    }
                }
            }

            public void onFail(int id, String msg, String response) {
                MLog.error((Object)NewMatchNoticeBoard.TAG, (String)("get wemeet newest match userInfo failed : " + msg), (Object[])new Object[0]);
            }

            public int id() {
                return 0;
            }
        });
        return null;
    }

    public int getNewMatchCount() {
        return this.mMatchesUids.size();
    }

    public void setListener(INewMatchNoticeListener listener) {
        this.mListener = listener;
    }

    private void fetchMatchesIds() {
        this.sUid = AccountUtil.getUid();
        long lastTime = SettingFlags.getLongValue((String)(this.sUid + "_wemeet_window_exit_time"));
        Header header = ProtoManager.getInstance().getHeader("ikxd_wemeet_d");
    }

    private void onNewMatchChanged() {
        if (this.mListener != null) {
            this.mListener.onNewMatchInfoChanged();
        }
    }
}

