/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.tools.revenue.redpacket;

import android.util.Pair;
import androidx.annotation.NonNull;
import com.yy.appbase.data.ImMessageDBBean;
import com.yy.appbase.invite.InviteFriendData;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.kvomodule.KvoModuleManager;
import com.yy.appbase.kvomodule.module.UserInfoModule;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.service.callback.OnProfileCallback;
import com.yy.base.env.RuntimeContext;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ResourceUtils;
import com.yy.hiyo.channel.component.invite.callback.IInviteFriendCallback;
import com.yy.hiyo.channel.component.invite.friend.behavior.AbsFriendInviteBehavior;
import com.yy.hiyo.channel.component.invite.friend.share.PlatformShareData;
import com.yy.hiyo.im.ImDataFactory;
import com.yy.hiyo.im.ImService;
import com.yy.hiyo.im.base.ImMsgReqParam;
import com.yy.hiyo.mvp.base.IMvpContext;
import com.yy.hiyo.share.base.IIntlShareService;
import com.yy.hiyo.share.base.dataprovider.ShareDataProvider;
import com.yy.hiyo.tools.revenue.R;
import com.yy.hiyo.tools.revenue.redpacket.RedPacketShareProvider;
import com.yy.hiyo.wallet.base.revenue.redpacket.room.bean.PacketShareInfo;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.util.List;

public class RedPacketInviteBehavior
extends AbsFriendInviteBehavior {
    private static final String TAG = "FTVoiceRoomRedPacketInviteBehavior";
    private PacketShareInfo mPacketShareInfo;
    private PlatformShareData mPlatformShareData;
    private RedPacketShareProvider mShareDataProvider;

    public RedPacketInviteBehavior(IMvpContext mvpContext2, @NonNull PacketShareInfo packetShareInfo) {
        super(mvpContext2);
        this.mPacketShareInfo = packetShareInfo;
    }

    public void onInviteFriend(final InviteFriendData data, final IInviteFriendCallback callback) {
        FeatureLog.i((String)TAG, (String)"onInviteFriend uid=%d", (Object[])new Object[]{data.mFriend.getUid()});
        if (this.getInviteData().inviteInterceptor != null && !this.getInviteData().inviteInterceptor.canInvite()) {
            if (callback != null) {
                callback.onFail(2);
            }
            return;
        }
        ((UserInfoModule)KvoModuleManager.getModule(UserInfoModule.class)).getUserInfo(this.mPlatformShareData.getInviteData().ownerUid, new OnProfileCallback(){

            public void onSuccess(int id2, List<UserInfoKS> userInfoKSList) {
                RedPacketInviteBehavior.this.getInviteData().tokenProvider.getToken(token -> {
                    YYTaskExecutor.execute(() -> {
                        Pair pair = ImDataFactory.INSTANCE.createRedPacketInviteMsg(data2.mFriend.getUid(), data2.mFriend.getAvatar(), data2.mFriend.getNick(), RedPacketInviteBehavior.this.getInviteData().channelId, RedPacketInviteBehavior.this.getInviteData().channelName, ((UserInfoKS)userInfoKSList.get((int)0)).avatar, token, RedPacketInviteBehavior.this.mPacketShareInfo == null ? "" : RedPacketInviteBehavior.this.mPacketShareInfo.getPacketId(), RedPacketInviteBehavior.this.mPacketShareInfo == null ? "" : RedPacketInviteBehavior.this.mPacketShareInfo.getImImg(), RedPacketInviteBehavior.this.getFamilyDetailUrl(RedPacketInviteBehavior.this.getInviteData().channelId), RedPacketInviteBehavior.this.getInviteData().pluginId);
                        if (ServiceManagerProxy.getServiceManager() != null) {
                            ((ImService)ServiceManagerProxy.getServiceManager().getService(ImService.class)).getSendService().sendOldIMToDbMsg((ImMsgReqParam)pair.first, (ImMessageDBBean)pair.second, null);
                        }
                    });
                    RedPacketInviteBehavior.redPacketShareClick(RedPacketInviteBehavior.this.getInviteData().channelId, 0);
                });
                if (callback != null) {
                    callback.onSuccess();
                }
            }

            public void onFail(int id2, String msg, String response) {
                MLog.error((Object)RedPacketInviteBehavior.TAG, (String)"onInviteFriend, uid=%d, getUserInfo error, %s", (Object[])new Object[]{id2, msg});
                if (callback != null) {
                    callback.onFail(3);
                }
            }

            public int id() {
                return 0;
            }
        });
    }

    public void onPlatformShare(int platformId) {
        super.onPlatformShare(platformId);
        RedPacketInviteBehavior.redPacketShareClick(this.getInviteData().channelId, platformId);
    }

    public String getInviteTitle() {
        return ResourceUtils.getString((int)R.string.short_title_share_red_packet_panel);
    }

    public ShareDataProvider getShareDataProvider() {
        if (this.mShareDataProvider == null) {
            this.mShareDataProvider = new RedPacketShareProvider();
            this.mShareDataProvider.setShareData(this.getPlatformShareData());
            this.mShareDataProvider.setImageUrl(this.mPacketShareInfo.getShareImg());
        }
        return this.mShareDataProvider;
    }

    public PlatformShareData getPlatformShareData() {
        if (this.mPlatformShareData == null) {
            this.mPlatformShareData = new PlatformShareData();
            this.mPlatformShareData.setInviteData(this.getInviteData());
            List channelList = ((IIntlShareService)ServiceManagerProxy.getServiceManager().getService(IIntlShareService.class)).getChannelsByPage(() -> "voice_room_packet_invite");
            this.mPlatformShareData.setChannelList(channelList);
        }
        return this.mPlatformShareData;
    }

    private static void redPacketShareClick(String channelId, int platformId) {
        HiidoStatis.reportEvent((HiidoEvent)RedPacketInviteBehavior.event("20032603").put("mode_key", RuntimeContext.useOldRoom() ? "1" : "2").put("room_id", channelId).put("app_type", " " + RedPacketInviteBehavior.transAppTypeFromChannel(platformId)).put("function_id", "share_app_click"));
    }

    private static HiidoEvent event(String eventId) {
        return HiidoEvent.obtain().eventId(eventId);
    }

    private static int transAppTypeFromChannel(int channelId) {
        int appType;
        switch (channelId) {
            case 2: {
                appType = 2;
                break;
            }
            case 5: {
                appType = 3;
                break;
            }
            case 3: {
                appType = 4;
                break;
            }
            case 9: {
                appType = 5;
                break;
            }
            case 1: {
                appType = 1;
                break;
            }
            default: {
                appType = 6;
            }
        }
        return appType;
    }
}

