/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.tools.revenue.mora;

import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import com.squareup.wire.AndroidMessage;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.kvomodule.KvoModuleManager;
import com.yy.appbase.kvomodule.module.UserInfoModule;
import com.yy.appbase.service.IServiceManager;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.service.callback.OnProfileCallback;
import com.yy.architecture.Resource;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.DateUtils;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.IProtoCallback;
import com.yy.hiyo.proto.callback.IProtoNotify;
import com.yy.hiyo.tools.revenue.mora.ChannelMoraDataService;
import com.yy.hiyo.tools.revenue.mora.data.ChannelMoraGiftConfigData;
import com.yy.hiyo.tools.revenue.mora.data.ChannelMoraInfoData;
import com.yy.hiyo.tools.revenue.mora.data.ChannelMoraResultInfoData;
import com.yy.hiyo.tools.revenue.mora.morarecord.data.ChannelMoraRecordData;
import com.yy.hiyo.wallet.base.GiftChannel;
import com.yy.hiyo.wallet.base.IGiftService;
import com.yy.hiyo.wallet.base.revenue.gift.bean.GiftItemInfo;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.ihago.money.api.mora.ChallengeReq;
import net.ihago.money.api.mora.ChallengeRes;
import net.ihago.money.api.mora.Conf;
import net.ihago.money.api.mora.ConfType;
import net.ihago.money.api.mora.ErrCode;
import net.ihago.money.api.mora.GetConfsReq;
import net.ihago.money.api.mora.GetConfsRes;
import net.ihago.money.api.mora.GetLatestRecordsReq;
import net.ihago.money.api.mora.GetLatestRecordsRes;
import net.ihago.money.api.mora.GetMyRecordsReq;
import net.ihago.money.api.mora.GetMyRecordsRes;
import net.ihago.money.api.mora.MoraNotify;
import net.ihago.money.api.mora.MoraResultInfo;
import net.ihago.money.api.mora.MoraType;
import net.ihago.money.api.mora.NewRecordInfo;
import net.ihago.money.api.mora.RecordInfo;
import net.ihago.money.api.mora.StartReq;
import net.ihago.money.api.mora.StartRes;
import net.ihago.money.api.mora.Uri;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000q\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006*\u0001\u001b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J;\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u00032\u0006\u0010%\u001a\u00020&2#\b\u0002\u0010'\u001a\u001d\u0012\u0013\u0012\u00110&\u00a2\u0006\f\b)\u0012\b\b*\u0012\u0004\b\b(+\u0012\u0004\u0012\u00020#0(J\u0006\u0010,\u001a\u00020#J\u0006\u0010-\u001a\u00020#J\u0006\u0010.\u001a\u00020#J=\u0010/\u001a\u00020#2\b\b\u0002\u00100\u001a\u00020\u00032\b\b\u0002\u00101\u001a\u00020&2!\u00102\u001a\u001d\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b)\u0012\b\b*\u0012\u0004\b\b(0\u0012\u0004\u0012\u00020#0(J\u0010\u00103\u001a\u00020#2\u0006\u00104\u001a\u000205H\u0002J\u0010\u00106\u001a\u00020#2\u0006\u00107\u001a\u000208H\u0002J\u0006\u00109\u001a\u00020#JC\u0010:\u001a\u00020#2\u0006\u0010;\u001a\u00020&2\u0006\u0010%\u001a\u00020&2\u0006\u0010<\u001a\u00020&2#\b\u0002\u0010'\u001a\u001d\u0012\u0013\u0012\u00110&\u00a2\u0006\f\b)\u0012\b\b*\u0012\u0004\b\b(+\u0012\u0004\u0012\u00020#0(J\u0006\u0010=\u001a\u00020#R \u0010\u0005\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\b0\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R#\u0010\u0014\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u00070\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u001d\u0010\u0018\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\b0\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0017R\u0010\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001cR\u0017\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\r0\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u0017R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u000e\u0010!\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Lcom/yy/hiyo/tools/revenue/mora/ChannelMoraDataService;", "", "roomId", "", "(Ljava/lang/String;)V", "_moraHistory", "Landroidx/lifecycle/MutableLiveData;", "Lcom/yy/architecture/Resource;", "", "Lcom/yy/hiyo/tools/revenue/mora/morarecord/data/ChannelMoraRecordData;", "_moraInfo", "Lcom/yy/hiyo/tools/revenue/mora/data/ChannelMoraInfoData;", "_moraResultInfo", "Lcom/yy/hiyo/tools/revenue/mora/data/ChannelMoraResultInfoData;", "moraGiftConfigList", "Lcom/yy/hiyo/tools/revenue/mora/data/ChannelMoraGiftConfigData;", "getMoraGiftConfigList", "()Landroidx/lifecycle/MutableLiveData;", "setMoraGiftConfigList", "(Landroidx/lifecycle/MutableLiveData;)V", "moraHistory", "Landroidx/lifecycle/LiveData;", "getMoraHistory", "()Landroidx/lifecycle/LiveData;", "moraInfo", "getMoraInfo", "moraNotify", "com/yy/hiyo/tools/revenue/mora/ChannelMoraDataService$moraNotify$1", "Lcom/yy/hiyo/tools/revenue/mora/ChannelMoraDataService$moraNotify$1;", "moraResultInfo", "getMoraResultInfo", "getRoomId", "()Ljava/lang/String;", "tag", "challengeMora", "", "recordId", "moraType", "", "onResponse", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "responseType", "clearHistory", "fetchConfigs", "fetchLatestRecords", "fetchMoraHistory", "cursor", "limit", "getCursor", "generateMoraInfo", "newRecordInfo", "Lnet/ihago/money/api/mora/NewRecordInfo;", "generateMoraResultInfo", "resultInfo", "Lnet/ihago/money/api/mora/MoraResultInfo;", "registerNotify", "startMora", "configId", "num", "unregisterNotify", "revenue_debug"})
public final class ChannelMoraDataService {
    private final String tag = "ChannelMoraDataService";
    @NotNull
    private MutableLiveData<List<ChannelMoraGiftConfigData>> moraGiftConfigList;
    private final MutableLiveData<List<ChannelMoraInfoData>> _moraInfo;
    private final MutableLiveData<ChannelMoraResultInfoData> _moraResultInfo;
    private final MutableLiveData<Resource<List<ChannelMoraRecordData>>> _moraHistory;
    private final moraNotify.1 moraNotify;
    @NotNull
    private final String roomId;

    @NotNull
    public final MutableLiveData<List<ChannelMoraGiftConfigData>> getMoraGiftConfigList() {
        return this.moraGiftConfigList;
    }

    public final void setMoraGiftConfigList(@NotNull MutableLiveData<List<ChannelMoraGiftConfigData>> mutableLiveData) {
        Intrinsics.checkParameterIsNotNull(mutableLiveData, (String)"<set-?>");
        this.moraGiftConfigList = mutableLiveData;
    }

    @NotNull
    public final LiveData<List<ChannelMoraInfoData>> getMoraInfo() {
        return (LiveData)this._moraInfo;
    }

    @NotNull
    public final LiveData<ChannelMoraResultInfoData> getMoraResultInfo() {
        return (LiveData)this._moraResultInfo;
    }

    @NotNull
    public final LiveData<Resource<List<ChannelMoraRecordData>>> getMoraHistory() {
        return (LiveData)this._moraHistory;
    }

    public final void registerNotify() {
        ProtoManager.getInstance().registerNotify((IProtoNotify)this.moraNotify);
    }

    public final void unregisterNotify() {
        ProtoManager.getInstance().unregisterNotify((IProtoNotify)this.moraNotify);
    }

    public final void fetchConfigs() {
        GetConfsReq req = new GetConfsReq.Builder().build();
        ProtoManager.getInstance().sendRpc(this.roomId, (AndroidMessage)req, (IProtoCallback)new IProtoCallback<GetConfsRes>(this){
            final /* synthetic */ ChannelMoraDataService this$0;

            /*
             * WARNING - void declaration
             */
            public void onResponse(@NotNull GetConfsRes message, long code, @Nullable String msg) {
                Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
                super.onResponse((AndroidMessage)message, code, msg);
                MLog.info((Object)ChannelMoraDataService.access$getTag$p(this.this$0), (String)("fetchConfigs code: " + code + " , msg: " + msg), (Object[])new Object[0]);
                if (ProtoManager.isSuccessCode((long)code)) {
                    List list;
                    MutableLiveData<List<ChannelMoraGiftConfigData>> mutableLiveData = this.this$0.getMoraGiftConfigList();
                    List list2 = message.confs;
                    if (list2 != null) {
                        Collection<ChannelMoraGiftConfigData> collection;
                        void $this$mapTo$iv$iv;
                        void $this$map$iv;
                        Iterable iterable = list2;
                        MutableLiveData<List<ChannelMoraGiftConfigData>> mutableLiveData2 = mutableLiveData;
                        boolean $i$f$map = false;
                        void var7_7 = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            void it;
                            Conf conf = (Conf)item$iv$iv;
                            collection = destination$iv$iv;
                            boolean bl = false;
                            Integer n = it.id;
                            Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"it.id");
                            int n2 = n;
                            Integer n3 = it.prop_id;
                            Intrinsics.checkExpressionValueIsNotNull((Object)n3, (String)"it.prop_id");
                            int n4 = n3;
                            Integer n5 = it.amount;
                            Intrinsics.checkExpressionValueIsNotNull((Object)n5, (String)"it.amount");
                            int n6 = n5;
                            Integer n7 = it.diamond;
                            Intrinsics.checkExpressionValueIsNotNull((Object)n7, (String)"it.diamond");
                            ChannelMoraGiftConfigData channelMoraGiftConfigData = new ChannelMoraGiftConfigData(n2, n4, n6, n7, null, null, false, 112, null);
                            collection.add(channelMoraGiftConfigData);
                        }
                        collection = (List)destination$iv$iv;
                        mutableLiveData = mutableLiveData2;
                        list = collection;
                    } else {
                        list = CollectionsKt.emptyList();
                    }
                    mutableLiveData.setValue((Object)list);
                    MLog.info((Object)ChannelMoraDataService.access$getTag$p(this.this$0), (String)("gift config: " + (List)this.this$0.getMoraGiftConfigList().getValue()), (Object[])new Object[0]);
                }
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                MLog.error((Object)ChannelMoraDataService.access$getTag$p(this.this$0), (String)"fetchConfigs retryWhenTimeout", (Object[])new Object[0]);
                return false;
            }

            public boolean retryWhenError(boolean canRetry, @Nullable String reason, int code) {
                MLog.error((Object)ChannelMoraDataService.access$getTag$p(this.this$0), (String)("fetchConfigs retryWhenError reason: " + reason + " , code: " + code), (Object[])new Object[0]);
                return false;
            }
            {
                this.this$0 = $outer;
            }
        });
    }

    public final void startMora(int configId, int moraType, int num, @NotNull Function1<? super Integer, Unit> onResponse2) {
        Intrinsics.checkParameterIsNotNull(onResponse2, (String)"onResponse");
        Conf conf = new Conf.Builder().amount(Integer.valueOf(num)).diamond(Integer.valueOf(num)).type(Integer.valueOf(ConfType.ConfTypeProp.getValue())).build();
        StartReq req = new StartReq.Builder().conf_id(Integer.valueOf(configId)).prize(conf).mora_type(MoraType.fromValue((int)moraType)).build();
        ProtoManager.getInstance().sendRpc(this.roomId, (AndroidMessage)req, (IProtoCallback)new IProtoCallback<StartRes>(this, onResponse2){
            final /* synthetic */ ChannelMoraDataService this$0;
            final /* synthetic */ Function1 $onResponse;

            public void onResponse(@NotNull StartRes message, long code, @Nullable String msg) {
                Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
                super.onResponse((AndroidMessage)message, code, msg);
                MLog.info((Object)ChannelMoraDataService.access$getTag$p(this.this$0), (String)("startMora onResponse code: " + code + " , msg: " + msg), (Object[])new Object[0]);
                if (ProtoManager.isSuccessCode((long)code)) {
                    MLog.info((Object)ChannelMoraDataService.access$getTag$p(this.this$0), (String)("startMora record id: " + message.record_id), (Object[])new Object[0]);
                    this.$onResponse.invoke((Object)4);
                } else {
                    int n = (int)code;
                    if (n == ErrCode.NoEnoughMoney.getValue()) {
                        this.$onResponse.invoke((Object)2);
                    } else if (n == ErrCode.PayFreeze.getValue()) {
                        this.$onResponse.invoke((Object)6);
                    } else if (n == ErrCode.IsNotLocalRegion.getValue()) {
                        this.$onResponse.invoke((Object)10001);
                    }
                    this.$onResponse.invoke((Object)5);
                }
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                MLog.error((Object)ChannelMoraDataService.access$getTag$p(this.this$0), (String)"startMora time out", (Object[])new Object[0]);
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(this){
                    final /* synthetic */ startMora.2 this$0;

                    public final void run() {
                        this.this$0.$onResponse.invoke((Object)5);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
                return false;
            }

            public boolean retryWhenError(boolean canRetry, @Nullable String reason, int code) {
                MLog.error((Object)ChannelMoraDataService.access$getTag$p(this.this$0), (String)("startMora error reason: " + reason + " , code: " + code), (Object[])new Object[0]);
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(this){
                    final /* synthetic */ startMora.2 this$0;

                    public final void run() {
                        this.this$0.$onResponse.invoke((Object)5);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
                return false;
            }
            {
                this.this$0 = $outer;
                this.$onResponse = $captured_local_variable$1;
            }
        });
    }

    public static /* synthetic */ void startMora$default(ChannelMoraDataService channelMoraDataService, int n, int n2, int n3, Function1 function1, int n4, Object object) {
        if ((n4 & 8) != 0) {
            function1 = startMora.1.INSTANCE;
        }
        channelMoraDataService.startMora(n, n2, n3, (Function1<? super Integer, Unit>)function1);
    }

    public final void challengeMora(@NotNull String recordId, int moraType, @NotNull Function1<? super Integer, Unit> onResponse2) {
        Intrinsics.checkParameterIsNotNull((Object)recordId, (String)"recordId");
        Intrinsics.checkParameterIsNotNull(onResponse2, (String)"onResponse");
        ChallengeReq req = new ChallengeReq.Builder().record_id(recordId).mora_type(MoraType.fromValue((int)moraType)).build();
        ProtoManager.getInstance().sendRpc(this.roomId, (AndroidMessage)req, (IProtoCallback)new IProtoCallback<ChallengeRes>(this, onResponse2){
            final /* synthetic */ ChannelMoraDataService this$0;
            final /* synthetic */ Function1 $onResponse;

            public void onResponse(@NotNull ChallengeRes message, long code, @Nullable String msg) {
                Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
                super.onResponse((AndroidMessage)message, code, msg);
                MLog.info((Object)ChannelMoraDataService.access$getTag$p(this.this$0), (String)("challengeMora response code: " + code + " , msg: " + msg), (Object[])new Object[0]);
                if (ProtoManager.isSuccessCode((long)code)) {
                    MLog.info((Object)ChannelMoraDataService.access$getTag$p(this.this$0), (String)("challengeMora onResponse result: " + message.mora_result.getValue()), (Object[])new Object[0]);
                    this.$onResponse.invoke((Object)4);
                } else {
                    int n = (int)code;
                    if (n == ErrCode.NoEnoughMoney.getValue()) {
                        this.$onResponse.invoke((Object)2);
                    } else if (n == ErrCode.AlreadyChallenged.getValue()) {
                        this.$onResponse.invoke((Object)1);
                    } else if (n == ErrCode.Expired.getValue()) {
                        this.$onResponse.invoke((Object)3);
                    } else if (n == ErrCode.PayFreeze.getValue()) {
                        this.$onResponse.invoke((Object)6);
                    } else if (n == ErrCode.IsNotLocalRegion.getValue()) {
                        this.$onResponse.invoke((Object)10001);
                    }
                    this.$onResponse.invoke((Object)5);
                }
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                MLog.error((Object)ChannelMoraDataService.access$getTag$p(this.this$0), (String)"challengeMora time out.", (Object[])new Object[0]);
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(this){
                    final /* synthetic */ challengeMora.2 this$0;

                    public final void run() {
                        this.this$0.$onResponse.invoke((Object)5);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
                return false;
            }

            public boolean retryWhenError(boolean canRetry, @Nullable String reason, int code) {
                MLog.error((Object)ChannelMoraDataService.access$getTag$p(this.this$0), (String)("challengeMora error reason: " + reason + " , code: " + code), (Object[])new Object[0]);
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(this){
                    final /* synthetic */ challengeMora.2 this$0;

                    public final void run() {
                        this.this$0.$onResponse.invoke((Object)5);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
                return false;
            }
            {
                this.this$0 = $outer;
                this.$onResponse = $captured_local_variable$1;
            }
        });
    }

    public static /* synthetic */ void challengeMora$default(ChannelMoraDataService channelMoraDataService, String string2, int n, Function1 function1, int n2, Object object) {
        if ((n2 & 4) != 0) {
            function1 = challengeMora.1.INSTANCE;
        }
        channelMoraDataService.challengeMora(string2, n, (Function1<? super Integer, Unit>)function1);
    }

    public final void fetchMoraHistory(@NotNull String cursor, int limit, @NotNull Function1<? super String, Unit> getCursor) {
        Intrinsics.checkParameterIsNotNull((Object)cursor, (String)"cursor");
        Intrinsics.checkParameterIsNotNull(getCursor, (String)"getCursor");
        GetMyRecordsReq req = new GetMyRecordsReq.Builder().limit(Integer.valueOf(limit)).cursor(cursor).build();
        ProtoManager.getInstance().sendRpc(this.roomId, (AndroidMessage)req, (IProtoCallback)new IProtoCallback<GetMyRecordsRes>(this, getCursor){
            final /* synthetic */ ChannelMoraDataService this$0;
            final /* synthetic */ Function1 $getCursor;

            /*
             * WARNING - void declaration
             */
            public void onResponse(@NotNull GetMyRecordsRes message, long code, @Nullable String msg) {
                Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
                super.onResponse((AndroidMessage)message, code, msg);
                MLog.info((Object)ChannelMoraDataService.access$getTag$p(this.this$0), (String)("fetchMoraHistory response code: " + code + " , msg: " + msg), (Object[])new Object[0]);
                ChannelMoraDataService.access$get_moraHistory$p(this.this$0).setValue((Object)Resource.loading(null));
                if (ProtoManager.isSuccessCode((long)code)) {
                    String string2 = message.cursor;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"message.cursor");
                    this.$getCursor.invoke((Object)string2);
                    List recordInfoList = message.record_infos;
                    MLog.info((Object)ChannelMoraDataService.access$getTag$p(this.this$0), (String)("fetch mora history recordInfoList size: " + recordInfoList.size()), (Object[])new Object[0]);
                    if (recordInfoList == null) {
                        ChannelMoraDataService.access$get_moraHistory$p(this.this$0).setValue((Object)Resource.error((String)"no response", null));
                    } else if (recordInfoList.isEmpty()) {
                        ChannelMoraDataService.access$get_moraHistory$p(this.this$0).setValue((Object)Resource.success((Object)CollectionsKt.emptyList()));
                    } else {
                        void $this$mapTo$iv$iv;
                        Object object;
                        Collection collection;
                        void $this$mapTo$iv$iv2;
                        Iterable $this$map$iv = recordInfoList;
                        boolean $i$f$map = false;
                        Iterable iterable = $this$map$iv;
                        Iterable<E> destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv2) {
                            GiftItemInfo giftItemInfo;
                            void recordInfo;
                            RecordInfo recordInfo2 = (RecordInfo)item$iv$iv;
                            collection = destination$iv$iv;
                            boolean bl = false;
                            IServiceManager iServiceManager = ServiceManagerProxy.getServiceManager();
                            if (iServiceManager != null && (iServiceManager = (IGiftService)iServiceManager.getService(IGiftService.class)) != null) {
                                int n = GiftChannel.USER_ALL_CHANNEL.getChannel();
                                Integer n2 = recordInfo.prop_id;
                                Intrinsics.checkExpressionValueIsNotNull((Object)n2, (String)"recordInfo.prop_id");
                                giftItemInfo = iServiceManager.getGift(n, n2.intValue());
                            } else {
                                giftItemInfo = null;
                            }
                            GiftItemInfo giftItemInfo2 = giftItemInfo;
                            long startTimeTs = recordInfo.start_time * (long)1000;
                            String startChallengeTime = !DateUtils.isToday((Calendar)Calendar.getInstance(Locale.getDefault()), (long)startTimeTs) ? DateUtils.dateToString((long)startTimeTs, (String)"yyyy-MM-dd HH:mm:ss") : DateUtils.dateToString((long)startTimeTs, (String)"HH:mm");
                            String string3 = recordInfo.record_id;
                            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"recordInfo.record_id");
                            Integer n = recordInfo.conf_id;
                            Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"recordInfo.conf_id");
                            int n3 = n;
                            Integer n4 = recordInfo.prop_id;
                            Intrinsics.checkExpressionValueIsNotNull((Object)n4, (String)"recordInfo.prop_id");
                            int n5 = n4;
                            Integer n6 = recordInfo.prop_amount;
                            Intrinsics.checkExpressionValueIsNotNull((Object)n6, (String)"recordInfo.prop_amount");
                            int n7 = n6;
                            Integer n8 = recordInfo.diamond;
                            Intrinsics.checkExpressionValueIsNotNull((Object)n8, (String)"recordInfo.diamond");
                            int n9 = n8;
                            int n10 = recordInfo.starter_mora_type.getValue();
                            String string4 = startChallengeTime;
                            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"startChallengeTime");
                            Long l = recordInfo.challenger;
                            Intrinsics.checkExpressionValueIsNotNull((Object)l, (String)"recordInfo.challenger");
                            long l2 = l;
                            int n11 = recordInfo.result.getValue();
                            Object object2 = giftItemInfo2;
                            if (object2 == null || (object2 = object2.getStaticIcon()) == null) {
                                object2 = "";
                            }
                            object = new ChannelMoraRecordData(string3, n3, n5, n7, n9, n10, string4, l2, n11, null, (String)object2, 512, null);
                            collection.add(object);
                        }
                        List recordList = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
                        Iterable $this$map$iv2 = recordInfoList;
                        boolean $i$f$map2 = false;
                        destination$iv$iv = $this$map$iv2;
                        Collection destination$iv$iv2 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                        boolean $i$f$mapTo2 = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            void recordInfo;
                            RecordInfo bl = (RecordInfo)item$iv$iv;
                            collection = destination$iv$iv2;
                            boolean bl2 = false;
                            object = recordInfo.challenger;
                            collection.add(object);
                        }
                        List uidList = CollectionsKt.distinct((Iterable)((List)destination$iv$iv2));
                        ((UserInfoModule)KvoModuleManager.getModule(UserInfoModule.class)).getUserInfos(uidList, new OnProfileCallback(this, recordList){
                            final /* synthetic */ fetchMoraHistory.1 this$0;
                            final /* synthetic */ List $recordList;

                            public void onSuccess(int id2, @Nullable List<UserInfoKS> userInfoKSList) {
                                Iterable $this$forEach$iv = this.$recordList;
                                boolean $i$f$forEach = false;
                                block0: for (T element$iv : $this$forEach$iv) {
                                    ChannelMoraRecordData recordInfo = (ChannelMoraRecordData)element$iv;
                                    boolean bl = false;
                                    List<UserInfoKS> list = userInfoKSList;
                                    if (list == null) continue;
                                    Iterable $this$forEach$iv2 = list;
                                    boolean $i$f$forEach2 = false;
                                    for (T element$iv2 : $this$forEach$iv2) {
                                        UserInfoKS userInfo = (UserInfoKS)element$iv2;
                                        boolean bl2 = false;
                                        if (recordInfo.getChallengerUid() != userInfo.uid) continue;
                                        recordInfo.setChallengerUserInfo(userInfo);
                                        continue block0;
                                    }
                                }
                                ChannelMoraDataService.access$get_moraHistory$p(this.this$0.this$0).setValue((Object)Resource.success((Object)this.$recordList));
                            }

                            public void onFail(int id2, @Nullable String msg, @Nullable String response) {
                                MLog.error((Object)ChannelMoraDataService.access$getTag$p(this.this$0.this$0), (String)("get userInfo onFail msg: " + msg + " ," + " response: " + response), (Object[])new Object[0]);
                                ChannelMoraDataService.access$get_moraHistory$p(this.this$0.this$0).setValue((Object)Resource.success((Object)this.$recordList));
                            }

                            public int id() {
                                return 0;
                            }
                            {
                                this.this$0 = $outer;
                                this.$recordList = $captured_local_variable$1;
                            }
                        });
                    }
                } else {
                    ChannelMoraDataService.access$get_moraHistory$p(this.this$0).setValue((Object)Resource.error((String)"no response", null));
                }
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                MLog.error((Object)ChannelMoraDataService.access$getTag$p(this.this$0), (String)"fetchMoraHistory time out.", (Object[])new Object[0]);
                ChannelMoraDataService.access$get_moraHistory$p(this.this$0).postValue((Object)Resource.error((String)"time out", null));
                return false;
            }

            public boolean retryWhenError(boolean canRetry, @Nullable String reason, int code) {
                MLog.error((Object)ChannelMoraDataService.access$getTag$p(this.this$0), (String)("fetchMoraHistory error reason: " + reason + " , code: " + code), (Object[])new Object[0]);
                ChannelMoraDataService.access$get_moraHistory$p(this.this$0).postValue((Object)Resource.error((String)reason, null));
                return false;
            }
            {
                this.this$0 = $outer;
                this.$getCursor = $captured_local_variable$1;
            }
        });
    }

    public static /* synthetic */ void fetchMoraHistory$default(ChannelMoraDataService channelMoraDataService, String string2, int n, Function1 function1, int n2, Object object) {
        if ((n2 & 1) != 0) {
            string2 = "";
        }
        if ((n2 & 2) != 0) {
            n = 20;
        }
        channelMoraDataService.fetchMoraHistory(string2, n, (Function1<? super String, Unit>)function1);
    }

    public final void clearHistory() {
        this._moraHistory.setValue((Object)Resource.loading(null));
    }

    public final void fetchLatestRecords() {
        GetLatestRecordsReq req = new GetLatestRecordsReq.Builder().build();
        ProtoManager.getInstance().sendRpc(this.roomId, (AndroidMessage)req, (IProtoCallback)new IProtoCallback<GetLatestRecordsRes>(this){
            final /* synthetic */ ChannelMoraDataService this$0;

            public void onResponse(@NotNull GetLatestRecordsRes message, long code, @Nullable String msg) {
                Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
                super.onResponse((AndroidMessage)message, code, msg);
                MLog.info((Object)ChannelMoraDataService.access$getTag$p(this.this$0), (String)("fetchLatestRecords response code: " + code + " , msg: " + msg), (Object[])new Object[0]);
                if (ProtoManager.isSuccessCode((long)code)) {
                    List infoList;
                    List list = infoList = message.infos;
                    if (list != null) {
                        Iterable $this$forEach$iv = list;
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            NewRecordInfo it = (NewRecordInfo)element$iv;
                            boolean bl = false;
                            ChannelMoraDataService.access$generateMoraInfo(this.this$0, it);
                        }
                    }
                } else {
                    MLog.error((Object)ChannelMoraDataService.access$getTag$p(this.this$0), (String)("onResponse code: " + code + " , msg: " + msg), (Object[])new Object[0]);
                }
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                MLog.error((Object)ChannelMoraDataService.access$getTag$p(this.this$0), (String)"fetchLatestRecords time out.", (Object[])new Object[0]);
                return false;
            }

            public boolean retryWhenError(boolean canRetry, @Nullable String reason, int code) {
                MLog.error((Object)ChannelMoraDataService.access$getTag$p(this.this$0), (String)("fetchLatestRecords error reason: " + reason + " , code: " + code), (Object[])new Object[0]);
                return false;
            }
            {
                this.this$0 = $outer;
            }
        });
    }

    private final void generateMoraInfo(NewRecordInfo newRecordInfo) {
        GiftItemInfo giftItemInfo;
        boolean bl = false;
        boolean bl2 = false;
        NewRecordInfo $this$with = newRecordInfo;
        boolean bl3 = false;
        IServiceManager iServiceManager = ServiceManagerProxy.getServiceManager();
        if (iServiceManager != null && (iServiceManager = (IGiftService)iServiceManager.getService(IGiftService.class)) != null) {
            int n = GiftChannel.USER_ALL_CHANNEL.getChannel();
            Integer n2 = $this$with.prop_id;
            Intrinsics.checkExpressionValueIsNotNull((Object)n2, (String)"prop_id");
            giftItemInfo = iServiceManager.getGift(n, n2.intValue());
        } else {
            giftItemInfo = null;
        }
        GiftItemInfo giftItemInfo2 = giftItemInfo;
        String string2 = $this$with.record_id;
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"record_id");
        Long l = $this$with.starter;
        Intrinsics.checkExpressionValueIsNotNull((Object)l, (String)"starter");
        long l2 = l;
        Integer n = $this$with.conf_id;
        Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"conf_id");
        int n3 = n;
        Integer n4 = $this$with.prop_id;
        Intrinsics.checkExpressionValueIsNotNull((Object)n4, (String)"prop_id");
        int n5 = n4;
        Integer n6 = $this$with.prop_amount;
        Intrinsics.checkExpressionValueIsNotNull((Object)n6, (String)"prop_amount");
        int n7 = n6;
        Integer n8 = $this$with.diamond;
        Intrinsics.checkExpressionValueIsNotNull((Object)n8, (String)"diamond");
        int n9 = n8;
        Long l3 = $this$with.time;
        Intrinsics.checkExpressionValueIsNotNull((Object)l3, (String)"time");
        long l4 = l3;
        Object object = giftItemInfo2;
        if (object == null || (object = object.getStaticIcon()) == null) {
            object = "";
        }
        this._moraInfo.setValue((Object)CollectionsKt.listOf((Object)new ChannelMoraInfoData(string2, l2, n3, n5, n7, n9, l4, (String)object)));
    }

    private final void generateMoraResultInfo(MoraResultInfo resultInfo) {
        GiftItemInfo giftItemInfo;
        boolean bl = false;
        boolean bl2 = false;
        MoraResultInfo $this$with = resultInfo;
        boolean bl3 = false;
        IServiceManager iServiceManager = ServiceManagerProxy.getServiceManager();
        if (iServiceManager != null && (iServiceManager = (IGiftService)iServiceManager.getService(IGiftService.class)) != null) {
            int n = GiftChannel.USER_ALL_CHANNEL.getChannel();
            Integer n2 = $this$with.prop_id;
            Intrinsics.checkExpressionValueIsNotNull((Object)n2, (String)"prop_id");
            giftItemInfo = iServiceManager.getGift(n, n2.intValue());
        } else {
            giftItemInfo = null;
        }
        GiftItemInfo giftItemInfo2 = giftItemInfo;
        List uidList = CollectionsKt.listOf((Object[])new Long[]{$this$with.starter, $this$with.challenger});
        ((UserInfoModule)KvoModuleManager.getModule(UserInfoModule.class)).getUserInfos(uidList, new OnProfileCallback($this$with, giftItemInfo2, this){
            final /* synthetic */ MoraResultInfo $this_with;
            final /* synthetic */ GiftItemInfo $giftItemInfo;
            final /* synthetic */ ChannelMoraDataService this$0;
            {
                this.$this_with = $receiver;
                this.$giftItemInfo = $captured_local_variable$2;
                this.this$0 = channelMoraDataService;
            }

            public void onSuccess(int id2, @Nullable List<UserInfoKS> userInfoKSList) {
                UserInfoKS starterUserInfo = null;
                UserInfoKS challengerUserInfo = null;
                List<UserInfoKS> list = userInfoKSList;
                if (list != null) {
                    Iterable $this$forEach$iv = list;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        UserInfoKS it = (UserInfoKS)element$iv;
                        boolean bl = false;
                        Long l = this.$this_with.starter;
                        long l2 = it.uid;
                        if (l != null && l == l2) {
                            starterUserInfo = it;
                            continue;
                        }
                        Long l3 = this.$this_with.challenger;
                        l2 = it.uid;
                        if (l3 == null || l3 != l2) continue;
                        challengerUserInfo = it;
                    }
                }
                MutableLiveData mutableLiveData = ChannelMoraDataService.access$get_moraResultInfo$p(this.this$0);
                String string2 = this.$this_with.record_id;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"record_id");
                Integer n = this.$this_with.conf_id;
                Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"conf_id");
                int n2 = n;
                Integer n3 = this.$this_with.prop_id;
                Intrinsics.checkExpressionValueIsNotNull((Object)n3, (String)"prop_id");
                int n4 = n3;
                Integer n5 = this.$this_with.prop_amount;
                Intrinsics.checkExpressionValueIsNotNull((Object)n5, (String)"prop_amount");
                int n6 = n5;
                Integer n7 = this.$this_with.diamond;
                Intrinsics.checkExpressionValueIsNotNull((Object)n7, (String)"diamond");
                int n8 = n7;
                Long l = this.$this_with.starter;
                Intrinsics.checkExpressionValueIsNotNull((Object)l, (String)"starter");
                long l4 = l;
                int n9 = this.$this_with.starter_mora_type.getValue();
                Long l5 = this.$this_with.challenger;
                Intrinsics.checkExpressionValueIsNotNull((Object)l5, (String)"challenger");
                long l6 = l5;
                int n10 = this.$this_with.challenger_mora_type.getValue();
                Long l7 = this.$this_with.challenge_time;
                Intrinsics.checkExpressionValueIsNotNull((Object)l7, (String)"challenge_time");
                long l8 = l7;
                Long l9 = this.$this_with.winner;
                Intrinsics.checkExpressionValueIsNotNull((Object)l9, (String)"winner");
                mutableLiveData.setValue((Object)new ChannelMoraResultInfoData(string2, n2, n4, n6, n8, l4, n9, l6, n10, l8, l9, starterUserInfo, challengerUserInfo, this.$giftItemInfo));
            }

            public void onFail(int id2, @Nullable String msg, @Nullable String response) {
                MLog.error((Object)ChannelMoraDataService.access$getTag$p(this.this$0), (String)("generateMoraResultInfo onFail msg: " + msg + " , response: " + response), (Object[])new Object[0]);
                MutableLiveData mutableLiveData = ChannelMoraDataService.access$get_moraResultInfo$p(this.this$0);
                String string2 = this.$this_with.record_id;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"record_id");
                Integer n = this.$this_with.conf_id;
                Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"conf_id");
                int n2 = n;
                Integer n3 = this.$this_with.prop_id;
                Intrinsics.checkExpressionValueIsNotNull((Object)n3, (String)"prop_id");
                int n4 = n3;
                Integer n5 = this.$this_with.prop_amount;
                Intrinsics.checkExpressionValueIsNotNull((Object)n5, (String)"prop_amount");
                int n6 = n5;
                Integer n7 = this.$this_with.diamond;
                Intrinsics.checkExpressionValueIsNotNull((Object)n7, (String)"diamond");
                int n8 = n7;
                Long l = this.$this_with.starter;
                Intrinsics.checkExpressionValueIsNotNull((Object)l, (String)"starter");
                long l2 = l;
                int n9 = this.$this_with.starter_mora_type.getValue();
                Long l3 = this.$this_with.challenger;
                Intrinsics.checkExpressionValueIsNotNull((Object)l3, (String)"challenger");
                long l4 = l3;
                int n10 = this.$this_with.challenger_mora_type.getValue();
                Long l5 = this.$this_with.challenge_time;
                Intrinsics.checkExpressionValueIsNotNull((Object)l5, (String)"challenge_time");
                long l6 = l5;
                Long l7 = this.$this_with.winner;
                Intrinsics.checkExpressionValueIsNotNull((Object)l7, (String)"winner");
                mutableLiveData.setValue((Object)new ChannelMoraResultInfoData(string2, n2, n4, n6, n8, l2, n9, l4, n10, l6, l7, null, null, this.$giftItemInfo, 6144, null));
            }

            public int id() {
                return 0;
            }
        });
    }

    @NotNull
    public final String getRoomId() {
        return this.roomId;
    }

    public ChannelMoraDataService(@NotNull String roomId) {
        Intrinsics.checkParameterIsNotNull((Object)roomId, (String)"roomId");
        this.roomId = roomId;
        this.tag = "ChannelMoraDataService";
        this.moraGiftConfigList = new MutableLiveData();
        this._moraInfo = new MutableLiveData();
        this._moraResultInfo = new MutableLiveData();
        this._moraHistory = new MutableLiveData();
        this.moraNotify = new IProtoNotify<MoraNotify>(this){
            final /* synthetic */ ChannelMoraDataService this$0;

            @NotNull
            public String serviceName() {
                return "net.ihago.money.api.mora";
            }

            public void onNotify(@NotNull MoraNotify notify2) {
                block1: {
                    int n;
                    Integer n2;
                    block0: {
                        Intrinsics.checkParameterIsNotNull((Object)notify2, (String)"notify");
                        MLog.info((Object)ChannelMoraDataService.access$getTag$p(this.this$0), (String)("onNotify: " + notify2.uri), (Object[])new Object[0]);
                        Uri uri = notify2.uri;
                        Integer n3 = n2 = uri != null ? Integer.valueOf(uri.getValue()) : null;
                        n = Uri.UriNewRecord.getValue();
                        if (n3 == null || n3 != n) break block0;
                        NewRecordInfo newRecordInfo = notify2.new_info;
                        Intrinsics.checkExpressionValueIsNotNull((Object)newRecordInfo, (String)"notify.new_info");
                        ChannelMoraDataService.access$generateMoraInfo(this.this$0, newRecordInfo);
                        break block1;
                    }
                    Integer n4 = n2;
                    n = Uri.UriChallengeResult.getValue();
                    if (n4 == null || n4 != n) break block1;
                    MoraResultInfo moraResultInfo = notify2.result_info;
                    Intrinsics.checkExpressionValueIsNotNull((Object)moraResultInfo, (String)"notify.result_info");
                    ChannelMoraDataService.access$generateMoraResultInfo(this.this$0, moraResultInfo);
                }
            }
            {
                this.this$0 = $outer;
            }
        };
    }

    public static final /* synthetic */ String access$getTag$p(ChannelMoraDataService $this) {
        return $this.tag;
    }

    public static final /* synthetic */ MutableLiveData access$get_moraHistory$p(ChannelMoraDataService $this) {
        return $this._moraHistory;
    }

    public static final /* synthetic */ void access$generateMoraInfo(ChannelMoraDataService $this, NewRecordInfo newRecordInfo) {
        $this.generateMoraInfo(newRecordInfo);
    }

    public static final /* synthetic */ MutableLiveData access$get_moraResultInfo$p(ChannelMoraDataService $this) {
        return $this._moraResultInfo;
    }

    public static final /* synthetic */ void access$generateMoraResultInfo(ChannelMoraDataService $this, MoraResultInfo resultInfo) {
        $this.generateMoraResultInfo(resultInfo);
    }
}

