/*
 * Decompiled with CFR 0.152.
 */
package com.yy.report.ui.dialog;

import android.app.Dialog;
import android.content.DialogInterface;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.view.Window;
import android.widget.ImageView;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResourceUtils;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.framework.core.ui.dialog.frame.DialogId;
import com.yy.report.R;
import com.yy.report.uicallback.IReportViewCallBack;
import java.util.ArrayList;
import java.util.List;

public class ReportDialog
implements BaseDialog {
    private IReportViewCallBack callBack;
    private Drawable radioNor;
    private Drawable radioPre;
    private List<YYTextView> radioList = new ArrayList<YYTextView>(4);
    private int index = 0;
    private String[] imgPath = new String[3];
    private List<RecycleImageView> previewImageViews = new ArrayList<RecycleImageView>(3);
    private List<RecycleImageView> addIconImageViews = new ArrayList<RecycleImageView>(3);
    private List<RecycleImageView> delIconImageViews = new ArrayList<RecycleImageView>(3);

    public ReportDialog(IReportViewCallBack callBack) {
        this.callBack = callBack;
    }

    public void init(final Dialog dialog) {
        Window window = dialog.getWindow();
        dialog.setCancelable(true);
        dialog.setCanceledOnTouchOutside(true);
        if (window == null) {
            return;
        }
        window.setContentView(R.layout.window_report_dialog);
        window.findViewById(R.id.report_submit).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ReportDialog.this.callBack.onSubmitClick(ReportDialog.this.getReportType(), ReportDialog.this.getImagesPath());
            }
        });
        window.findViewById(R.id.report_cancel).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                dialog.cancel();
            }
        });
        dialog.setOnCancelListener(new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialog) {
                ReportDialog.this.callBack.onDialogCancel();
            }
        });
        this.initViews(window);
    }

    private void initViews(Window window) {
        this.radioNor = ResourceUtils.getDrawable((int)R.drawable.report_radio_nor);
        this.radioNor.setBounds(0, 0, this.radioNor.getMinimumWidth(), this.radioNor.getMinimumHeight());
        this.radioPre = ResourceUtils.getDrawable((int)R.drawable.report_radio_pre);
        this.radioPre.setBounds(0, 0, this.radioPre.getMinimumWidth(), this.radioPre.getMinimumHeight());
        YYTextView tv0 = (YYTextView)window.findViewById(R.id.report_reason0);
        tv0.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ReportDialog.this.selectIndex(0);
            }
        });
        this.radioList.add(tv0);
        YYTextView tv1 = (YYTextView)window.findViewById(R.id.report_reason1);
        tv1.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ReportDialog.this.selectIndex(1);
            }
        });
        this.radioList.add(tv1);
        YYTextView tv2 = (YYTextView)window.findViewById(R.id.report_reason2);
        tv2.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ReportDialog.this.selectIndex(2);
            }
        });
        this.radioList.add(tv2);
        YYTextView tv3 = (YYTextView)window.findViewById(R.id.report_reason3);
        tv3.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ReportDialog.this.selectIndex(3);
            }
        });
        this.radioList.add(tv3);
        window.findViewById(R.id.report_img_0).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ReportDialog.this.callBack.reqGetImagePath(0);
            }
        });
        window.findViewById(R.id.report_img_1).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ReportDialog.this.callBack.reqGetImagePath(1);
            }
        });
        window.findViewById(R.id.report_img_2).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ReportDialog.this.callBack.reqGetImagePath(2);
            }
        });
        window.findViewById(R.id.report_del_img0).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ReportDialog.this.resetImageToView(0);
            }
        });
        window.findViewById(R.id.report_del_img1).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ReportDialog.this.resetImageToView(1);
            }
        });
        window.findViewById(R.id.report_del_img2).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ReportDialog.this.resetImageToView(2);
            }
        });
        this.previewImageViews.add((RecycleImageView)window.findViewById(R.id.report_preview_img0));
        this.previewImageViews.add((RecycleImageView)window.findViewById(R.id.report_preview_img1));
        this.previewImageViews.add((RecycleImageView)window.findViewById(R.id.report_preview_img2));
        this.addIconImageViews.add((RecycleImageView)window.findViewById(R.id.report_preview_pg0));
        this.addIconImageViews.add((RecycleImageView)window.findViewById(R.id.report_preview_pg1));
        this.addIconImageViews.add((RecycleImageView)window.findViewById(R.id.report_preview_pg2));
        this.delIconImageViews.add((RecycleImageView)window.findViewById(R.id.report_del_img0));
        this.delIconImageViews.add((RecycleImageView)window.findViewById(R.id.report_del_img1));
        this.delIconImageViews.add((RecycleImageView)window.findViewById(R.id.report_del_img2));
    }

    private void selectIndex(int index) {
        if (index < 0 || index > 3) {
            return;
        }
        for (YYTextView tv : this.radioList) {
            tv.setCompoundDrawables(this.radioNor, null, null, null);
        }
        this.radioList.get(index).setCompoundDrawables(this.radioPre, null, null, null);
        this.index = index;
    }

    private int getReportType() {
        return this.index;
    }

    public int getId() {
        return DialogId.ReportDialog;
    }

    private List<String> getImagesPath() {
        ArrayList<String> path = new ArrayList<String>();
        for (String s : this.imgPath) {
            if (FP.empty((CharSequence)s)) continue;
            path.add(s);
        }
        return path;
    }

    public void onGetPhotoPath(int index, String path) {
        if (index < 0 || index > 2) {
            return;
        }
        this.setImageToView(index, path);
    }

    public void setImageToView(int index, String path) {
        if (FP.empty((CharSequence)path)) {
            return;
        }
        this.imgPath[index] = path;
        this.addIconImageViews.get(index).setVisibility(8);
        this.delIconImageViews.get(index).setVisibility(0);
        ImageLoader.loadImage((ImageView)((ImageView)this.previewImageViews.get(index)), (String)path);
    }

    public void resetImageToView(int index) {
        this.imgPath[index] = "";
        this.delIconImageViews.get(index).setVisibility(4);
        this.previewImageViews.get(index).setImageDrawableToNull();
        this.addIconImageViews.get(index).setVisibility(0);
    }
}

