/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.relation.base.widget;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.SimpleItemAnimator;
import com.scwang.smartrefresh.layout.SmartRefreshLayout;
import com.scwang.smartrefresh.layout.api.RefreshLayout;
import com.scwang.smartrefresh.layout.listener.OnLoadMoreListener;
import com.scwang.smartrefresh.layout.listener.OnRefreshListener;
import com.yy.appbase.data.PageData;
import com.yy.appbase.ui.CommonFooter;
import com.yy.appbase.ui.adapter.PagingMultiTypeAdapter;
import com.yy.appbase.ui.widget.bar.SimpleTitleBar;
import com.yy.appbase.ui.widget.status.CommonStatusLayout;
import com.yy.architecture.LifecycleWindow;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.framework.core.ui.AbstractWindow;
import com.yy.framework.core.ui.UICallBacks;
import com.yy.hiyo.mvp.base.IMvpContext;
import com.yy.hiyo.relation.base.R;
import com.yy.hiyo.relation.base.follow.bean.ListDividerBean;
import com.yy.hiyo.relation.base.widget.BaseListEmptyView;
import com.yy.hiyo.relation.base.widget.BaseListUiCallback;
import com.yy.hiyo.relation.base.widget.DividerViewHolder;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import me.drakeet.multitype.ItemViewBinder;

public abstract class BaseListWindow
extends LifecycleWindow {
    protected SimpleTitleBar mTitleBar;
    protected RecyclerView mFollowList;
    protected SmartRefreshLayout mRefreshLayout;
    protected RecyclerView mRecyclerView;
    private CommonStatusLayout mCommonStatusLayout;
    private BaseListEmptyView mEmptyView;
    protected PagingMultiTypeAdapter mAdapter;
    private BaseListUiCallback mBaseListUiCallback;
    private PageData pageDataWhenWindowShown;
    private boolean isWindowShown = false;
    private boolean hasMorePage = true;

    public BaseListWindow(IMvpContext mvpContext, UICallBacks callBacks, String name) {
        super(mvpContext, callBacks, name);
        if (callBacks instanceof BaseListUiCallback) {
            this.mBaseListUiCallback = (BaseListUiCallback)callBacks;
        }
        this.createViews();
    }

    private void createViews() {
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.base_list_page_channel, this.getBaseLayer(), true);
        this.mTitleBar = (SimpleTitleBar)this.findViewById(R.id.titlebar);
        this.mFollowList = (RecyclerView)this.findViewById(R.id.rv_list);
        this.mRefreshLayout = (SmartRefreshLayout)this.findViewById(R.id.refresh_layout);
        this.mRecyclerView = (RecyclerView)this.findViewById(R.id.rv_list);
        this.mCommonStatusLayout = (CommonStatusLayout)this.findViewById(R.id.common_status);
        if (this.mBaseListUiCallback != null) {
            this.mTitleBar.setLeftTitle(this.mBaseListUiCallback.getWindowTitle());
        }
        this.mTitleBar.setLeftBtn(R.drawable.icon_nav_back, new View.OnClickListener(){

            public void onClick(View v) {
                BaseListWindow.this.onBackClick();
            }
        });
        this.mRefreshLayout.setOnRefreshListener(new OnRefreshListener(){

            public void onRefresh(@NonNull RefreshLayout refreshLayout) {
                BaseListWindow.this.onListRefresh();
            }
        });
        this.mRefreshLayout.setOnLoadMoreListener(new OnLoadMoreListener(){

            public void onLoadMore(@NonNull RefreshLayout refreshLayout) {
                BaseListWindow.this.onListLoadmore();
            }
        });
        this.mAdapter = new PagingMultiTypeAdapter(new CopyOnWriteArrayList());
        this.onRegisterViewHolder();
        this.mRecyclerView.setAdapter((RecyclerView.Adapter)this.mAdapter);
        this.mRecyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext()));
        if (this.mRecyclerView.getItemAnimator() instanceof SimpleItemAnimator) {
            ((SimpleItemAnimator)this.mRecyclerView.getItemAnimator()).setSupportsChangeAnimations(false);
        }
    }

    public void initDatas() {
        this.showLoadingView();
        this.onInitData();
    }

    public void onShown() {
        super.onShown();
        this.isWindowShown = true;
        if (this.pageDataWhenWindowShown != null) {
            this.showPageData(this.pageDataWhenWindowShown);
            this.pageDataWhenWindowShown = null;
        }
    }

    private void onBackClick() {
        if (this.mBaseListUiCallback != null) {
            this.mBaseListUiCallback.closeListWindow((AbstractWindow)this);
        }
    }

    protected void setPageData(PageData pageData) {
        if (this.isWindowShown) {
            this.showPageData(pageData);
        } else {
            this.pageDataWhenWindowShown = pageData;
        }
    }

    private void showPageData(PageData pageData) {
        this.hideLoadingView();
        if (pageData == null) {
            return;
        }
        List pageList = pageData.getData();
        if (pageData.isFirstPage()) {
            if (pageList == null || pageList.size() == 0) {
                this.showEmptyView();
            } else {
                ArrayList<ListDividerBean> list = new ArrayList<ListDividerBean>();
                list.add(new ListDividerBean());
                list.addAll(pageList);
                this.mAdapter.listRefresh(list);
                this.hideEmptyView();
            }
        } else {
            this.mAdapter.listAddMore(pageList);
        }
        this.hasMorePage = pageData.isHasNextPage();
        if (this.hasMorePage) {
            this.mRefreshLayout.setNoMoreData(false);
        } else {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (BaseListWindow.this.mRefreshLayout != null) {
                        if (BaseListWindow.this.mRefreshLayout.getRefreshFooter() instanceof CommonFooter) {
                            ((CommonFooter)BaseListWindow.this.mRefreshLayout.getRefreshFooter()).setNoMoreText(R.string.short_tips_list_load_all);
                        }
                        BaseListWindow.this.mRefreshLayout.setNoMoreData(!BaseListWindow.this.hasMorePage);
                    }
                }
            }, (long)300L);
        }
    }

    protected void setListCount(int count) {
        StringBuilder titleBuilder = new StringBuilder();
        if (this.mBaseListUiCallback != null) {
            titleBuilder.append(this.mBaseListUiCallback.getWindowTitle());
        }
        if (count > 0) {
            titleBuilder.append(String.format(" ( %d ) ", count));
        }
        this.mTitleBar.setLeftTitle(titleBuilder.toString());
    }

    @Nullable
    public View getNeedOffsetView() {
        return this.mTitleBar;
    }

    public boolean isTranslucentBar() {
        return true;
    }

    public boolean isDarkMode() {
        return true;
    }

    private void showEmptyView() {
        if (this.mEmptyView == null) {
            this.mEmptyView = (BaseListEmptyView)this.findViewById(R.id.empty_view);
            if (this.mEmptyView != null) {
                this.onInitEmpty(this.mEmptyView);
            }
        }
        this.mEmptyView.setVisibility(0);
        this.mRefreshLayout.setVisibility(8);
    }

    private void hideEmptyView() {
        if (this.mEmptyView != null) {
            this.mEmptyView.setVisibility(8);
        }
        this.mRefreshLayout.setVisibility(0);
    }

    protected void clearListStatus() {
        this.mRefreshLayout.finishLoadMore();
        this.mRefreshLayout.finishRefresh();
    }

    protected void onRegisterViewHolder() {
        this.mAdapter.register(ListDividerBean.class, (ItemViewBinder)DividerViewHolder.getItemBinder());
    }

    protected abstract void onInitData();

    protected abstract void onListRefresh();

    protected abstract void onListLoadmore();

    protected abstract void onInitEmpty(BaseListEmptyView var1);

    protected void showLoadingView() {
        this.mCommonStatusLayout.showLoading();
    }

    protected void hideLoadingView() {
        this.mCommonStatusLayout.hideLoading();
    }
}

