/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.radio.screenrecord;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.media.MediaScannerConnection;
import android.os.Build;
import android.os.SystemClock;
import androidx.annotation.RequiresApi;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.callback.ICommonCallback;
import com.yy.appbase.data.UserInfoBean;
import com.yy.appbase.permission.helper.IPermissionListener;
import com.yy.appbase.permission.helper.PermissionHelper;
import com.yy.appbase.service.IServiceManager;
import com.yy.appbase.service.IUserInfoService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.env.RuntimeContext;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ScreenUtils;
import com.yy.base.utils.SdkVersionUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.base.utils.YYFileUtils;
import com.yy.base.utils.filestorage.FileOperatorQ;
import com.yy.framework.core.INotify;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.NotificationDef;
import com.yy.hiyo.bbs.base.bean.LocationEntity;
import com.yy.hiyo.bbs.base.bean.MediaEntity;
import com.yy.hiyo.bbs.base.bean.OriginalPostParam;
import com.yy.hiyo.bbs.base.bean.postinfo.BasePostInfo;
import com.yy.hiyo.bbs.base.callback.IGetVideoDataCallback;
import com.yy.hiyo.bbs.base.callback.IPostPublishCallback;
import com.yy.hiyo.bbs.base.service.IPostService;
import com.yy.hiyo.camera.base.ablum_select.mulitablumselect.MimeType;
import com.yy.hiyo.channel.base.bean.ChannelInfo;
import com.yy.hiyo.channel.base.bean.plugins.ChannelPluginData;
import com.yy.hiyo.channel.base.service.IEnteredChannel;
import com.yy.hiyo.channel.base.service.IMediaService;
import com.yy.hiyo.channel.base.service.plugin.IPluginService;
import com.yy.hiyo.channel.cbase.channelhiido.RadioUtils;
import com.yy.hiyo.channel.cbase.context.IChannelPageContext;
import com.yy.hiyo.channel.cbase.module.ktv.base.IVideoKTVController;
import com.yy.hiyo.channel.cbase.module.radio.RadioConfigBean;
import com.yy.hiyo.channel.cbase.publicscreen.IPublicScreenService;
import com.yy.hiyo.channel.cbase.publicscreen.callback.IPublicScreenModulePresenter;
import com.yy.hiyo.channel.cbase.publicscreen.callback.IPublicScreenPresenter;
import com.yy.hiyo.channel.cbase.publicscreen.msg.SysTextMsg;
import com.yy.hiyo.channel.component.bottombar.BottomMvp;
import com.yy.hiyo.channel.component.bottombar.BottomPresenter;
import com.yy.hiyo.channel.plugins.radio.R;
import com.yy.hiyo.channel.plugins.radio.RadioNAB;
import com.yy.hiyo.channel.plugins.radio.RadioPresenter;
import com.yy.hiyo.channel.plugins.radio.screenrecord.CaptureScreenContract;
import com.yy.hiyo.channel.plugins.radio.screenrecord.CaptureScreenPresenter;
import com.yy.hiyo.channel.plugins.radio.screenrecord.impl.RecordCallback;
import com.yy.hiyo.channel.plugins.radio.screenrecord.impl.ScreenVideoRecorder;
import com.yy.hiyo.channel.plugins.radio.video.VideoPkPresenter;
import com.yy.hiyo.channel.plugins.voiceroom.BaseRoomPresenter;
import com.yy.hiyo.channel.plugins.voiceroom.RoomPageContext;
import com.yy.hiyo.channel.publicscreen.BaseImMsg;
import com.yy.hiyo.mvp.base.IMvpContext;
import com.yy.hiyo.voice.base.channelvoice.IKtvLiveServiceExtend;
import com.yy.hiyo.voice.base.channelvoice.LiveConstansUtil;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.lang.annotation.RetentionPolicy;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.annotation.AnnotationRetention;
import kotlin.annotation.Retention;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000e\n\u0002\b\u0011\u0018\u0000 N2\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004:\u0002NOB\u0007\b\u0000\u00a2\u0006\u0002\u0010\u0005J\b\u0010$\u001a\u00020%H\u0002J\b\u0010&\u001a\u00020%H\u0016J\u0006\u0010'\u001a\u00020%J\b\u0010(\u001a\u00020%H\u0002J\b\u0010)\u001a\u00020%H\u0016J\n\u0010*\u001a\u0004\u0018\u00010+H\u0016J\b\u0010,\u001a\u00020\u001dH\u0002J\b\u0010-\u001a\u00020\tH\u0016J\u0012\u0010.\u001a\u00020%2\b\u0010/\u001a\u0004\u0018\u000100H\u0016J\b\u00101\u001a\u00020%H\u0016J\u0010\u00102\u001a\u00020%2\u0006\u00103\u001a\u000204H\u0016J\b\u00105\u001a\u00020%H\u0016J\b\u00106\u001a\u00020%H\u0016J\b\u00107\u001a\u00020%H\u0016J\b\u00108\u001a\u00020%H\u0016J\u0010\u00109\u001a\u00020%2\u0006\u0010:\u001a\u00020\u001dH\u0002J\b\u0010;\u001a\u00020%H\u0002J\b\u0010<\u001a\u00020%H\u0016J\u0010\u0010=\u001a\u00020%2\u0006\u0010>\u001a\u00020?H\u0016J\u0010\u0010@\u001a\u00020%2\u0006\u0010A\u001a\u00020\u0007H\u0002J\b\u0010B\u001a\u00020%H\u0016J\u0010\u0010C\u001a\u00020%2\u0006\u0010D\u001a\u00020\tH\u0002J\u0010\u0010E\u001a\u00020%2\u0006\u0010F\u001a\u00020\fH\u0016J\u0010\u0010G\u001a\u00020%2\u0006\u0010H\u001a\u00020\u0011H\u0016J\b\u0010I\u001a\u00020%H\u0003J\b\u0010J\u001a\u00020%H\u0016J\u0010\u0010J\u001a\u00020%2\u0006\u0010K\u001a\u00020\tH\u0002J\u0010\u0010L\u001a\u00020%2\u0006\u0010M\u001a\u00020\u0007H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u0014\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0015\u0010\u0005\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006P"}, d2={"Lcom/yy/hiyo/channel/plugins/radio/screenrecord/CaptureScreenPresenter;", "Lcom/yy/hiyo/channel/plugins/voiceroom/BaseRoomPresenter;", "Lcom/yy/framework/core/INotify;", "Lcom/yy/hiyo/channel/plugins/radio/screenrecord/CaptureScreenContract$ICaptureScreenPresenter;", "Lcom/yy/hiyo/channel/plugins/radio/screenrecord/impl/RecordCallback;", "()V", "captureEndType", "", "isCancelAction", "", "isParsingCover", "mBottomView", "Lcom/yy/hiyo/channel/component/bottombar/BottomMvp$IView;", "mPrepareCountDownTask", "Ljava/lang/Runnable;", "mRecordCountDownTask", "mView", "Lcom/yy/hiyo/channel/plugins/radio/screenrecord/CaptureScreenContract$ICaptureScreenView;", "needDeleteFileWhenExit", "recordTimeSec", "screenRecordStatus", "screenRecordStatus$annotations", "getScreenRecordStatus", "()I", "setScreenRecordStatus", "(I)V", "screenRecorder", "Lcom/yy/hiyo/channel/plugins/radio/screenrecord/impl/ScreenVideoRecorder;", "screenVideoCoverFile", "Ljava/io/File;", "screenVideoFile", "videoDuring", "", "videoHeight", "videoStartTimeStamp", "videoWidth", "appendRecordScreenRule", "", "cancelRecord", "checkCaptureScreenGuideShow", "deleteRecordResources", "exitPreviewPanel", "getOwnerInfo", "Lcom/yy/appbase/data/UserInfoBean;", "getSaveDir", "isEnableCaptureScreen", "notify", "notification", "Lcom/yy/framework/core/Notification;", "onDestroy", "onInit", "mvpContext", "Lcom/yy/hiyo/channel/plugins/voiceroom/RoomPageContext;", "onPermissionReady", "onRecordError", "onStartRecord", "onStopRecord", "parseVideoCover", "videoFile", "prepareCountDown", "prepareRecord", "publishPost", "text", "", "recordCountDownTimer", "recordTime", "saveVideo", "saveVideoToAlbum", "publishFailed", "setBottomView", "bottomView", "setView", "captureScreenView", "startRecord", "stopRecord", "cancel", "updateRecordStatus", "status", "Companion", "ScreenRecordStatus", "radio_release"})
public final class CaptureScreenPresenter
extends BaseRoomPresenter
implements INotify,
CaptureScreenContract.ICaptureScreenPresenter,
RecordCallback {
    private int screenRecordStatus;
    private final ScreenVideoRecorder screenRecorder = new ScreenVideoRecorder();
    private CaptureScreenContract.ICaptureScreenView mView;
    private BottomMvp.IView mBottomView;
    private File screenVideoFile;
    private File screenVideoCoverFile;
    private int recordTimeSec;
    private final int videoWidth = 480;
    private long videoStartTimeStamp;
    private long videoDuring;
    private final int videoHeight;
    private int captureEndType = 1;
    private boolean isCancelAction;
    private boolean needDeleteFileWhenExit = true;
    private boolean isParsingCover;
    private final Runnable mPrepareCountDownTask;
    private final Runnable mRecordCountDownTask;
    private static final String TAG = "CaptureScreenPresenter";
    public static final int VIDEO_WIDTH = 480;
    public static final int MAX_RECORD_TIME = 60;
    public static final int MIN_RECORD_TIME_MILLIS = 3000;
    public static final int STATUS_IDLE = 0;
    public static final int STATUS_PREPARE_3 = 3;
    public static final int STATUS_PREPARE_2 = 2;
    public static final int STATUS_PREPARE_1 = 1;
    public static final int STATUS_RECORDING = 10;
    public static final int STATUS_RECORD_SUCCESS = 20;
    public static final Companion Companion = new Companion(null);

    public static /* synthetic */ void screenRecordStatus$annotations() {
    }

    public final int getScreenRecordStatus() {
        return this.screenRecordStatus;
    }

    public final void setScreenRecordStatus(int n) {
        this.screenRecordStatus = n;
    }

    public void onInit(@NotNull RoomPageContext mvpContext) {
        Intrinsics.checkParameterIsNotNull((Object)mvpContext, (String)"mvpContext");
        super.onInit((IChannelPageContext)mvpContext);
        IMvpContext iMvpContext = this.getMvpContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)iMvpContext, (String)"getMvpContext()");
        IMediaService iMediaService = ((RoomPageContext)iMvpContext).getMediaService();
        Intrinsics.checkExpressionValueIsNotNull((Object)iMediaService, (String)"getMvpContext().mediaService");
        this.screenRecorder.init(iMediaService, this.videoWidth, this.videoHeight);
        this.screenRecorder.setRecordCallback(this);
        NotificationCenter.getGlobalInstance().register(NotificationDef.N_FOREGROUND_CHANGE, (INotify)this);
        YYTaskExecutor.execute((Runnable)new Runnable(this){
            final /* synthetic */ CaptureScreenPresenter this$0;

            public final void run() {
                File dir = CaptureScreenPresenter.access$getSaveDir(this.this$0);
                boolean result = dir.mkdirs();
                MLog.info((Object)"CaptureScreenPresenter", (String)("Init SaveDir " + dir.exists() + ' ' + result), (Object[])new Object[0]);
            }
            {
                this.this$0 = captureScreenPresenter;
            }
        });
    }

    @Override
    public void setView(@NotNull CaptureScreenContract.ICaptureScreenView captureScreenView) {
        Intrinsics.checkParameterIsNotNull((Object)captureScreenView, (String)"captureScreenView");
        captureScreenView.setPresenter(this);
        this.mView = captureScreenView;
    }

    @Override
    public void setBottomView(@NotNull BottomMvp.IView bottomView) {
        Intrinsics.checkParameterIsNotNull((Object)bottomView, (String)"bottomView");
        this.mBottomView = bottomView;
        IPluginService iPluginService = this.getChannel().getPluginService();
        Intrinsics.checkExpressionValueIsNotNull((Object)iPluginService, (String)"channel.pluginService");
        ChannelPluginData channelPluginData = iPluginService.getCurPluginData();
        Intrinsics.checkExpressionValueIsNotNull((Object)channelPluginData, (String)"channel.pluginService.curPluginData");
        if (RadioNAB.INSTANCE.getVideoBarNAB(channelPluginData.isVideoMode())) {
            this.checkCaptureScreenGuideShow();
        }
    }

    @Override
    @Nullable
    public UserInfoBean getOwnerInfo() {
        IUserInfoService iUserInfoService = (IUserInfoService)ServiceManagerProxy.getService(IUserInfoService.class);
        return iUserInfoService != null ? iUserInfoService.getUserInfo(AccountUtil.getUid(), null) : null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void checkCaptureScreenGuideShow() {
        boolean isOwnerOrMaster;
        Object object;
        boolean displayVideoItem = false;
        IEnteredChannel iEnteredChannel = this.getChannel();
        if (iEnteredChannel != null && (iEnteredChannel = iEnteredChannel.getRoleService()) != null && iEnteredChannel.isMeAnchor()) {
            displayVideoItem = true;
        } else {
            IEnteredChannel iEnteredChannel2 = this.getChannel();
            if (iEnteredChannel2 != null && (iEnteredChannel2 = iEnteredChannel2.getRoleService()) != null && iEnteredChannel2.isMeOwner()) {
                ChannelInfo channelInfo = this.getChannel().getChannelDetail().baseInfo;
                Intrinsics.checkExpressionValueIsNotNull((Object)channelInfo, (String)"channel.channelDetail.baseInfo");
                if (!channelInfo.isGroupParty()) {
                    displayVideoItem = true;
                }
            }
        }
        if ((object = this.getChannel()) == null || (object = object.getPluginService()) == null || (object = object.getCurPluginData()) == null || (object = object.getPluginId()) == null) {
            object = "";
        }
        boolean isRadio = Intrinsics.areEqual((Object)"radio", (Object)object);
        IEnteredChannel iEnteredChannel3 = this.getChannel();
        boolean isVideoMode = iEnteredChannel3 != null && (iEnteredChannel3 = iEnteredChannel3.getPluginService()) != null && (iEnteredChannel3 = iEnteredChannel3.getCurPluginData()) != null ? iEnteredChannel3.isVideoMode() : false;
        IEnteredChannel iEnteredChannel4 = this.getChannel();
        boolean bl = iEnteredChannel4 != null && (iEnteredChannel4 = iEnteredChannel4.getRoleService()) != null ? iEnteredChannel4.isOwnerOrMaster(AccountUtil.getUid()) : (isOwnerOrMaster = false);
        if (!(isRadio && isOwnerOrMaster && isVideoMode && displayVideoItem)) {
            ((BottomPresenter)this.getPresenter(BottomPresenter.class)).setAddRedPoint(2, false);
            return;
        }
        if (Build.VERSION.SDK_INT < 21) {
            return;
        }
        ((RadioPresenter)this.getPresenter(RadioPresenter.class)).getRadioConfig((ICommonCallback<RadioConfigBean>)((ICommonCallback)new ICommonCallback<RadioConfigBean>(this){
            final /* synthetic */ CaptureScreenPresenter this$0;

            public void onSuccess(@Nullable RadioConfigBean data, Object ... ext) {
                Intrinsics.checkParameterIsNotNull((Object)ext, (String)"ext");
                RadioConfigBean radioConfigBean = data;
                if (radioConfigBean != null) {
                    if (radioConfigBean.getScreenCapWhiteList()) {
                        boolean captureScreenNewUser = LiveConstansUtil.INSTANCE.getRadioVideoSp().getBoolean("key_capture_screen_new_user", true);
                        if (LiveConstansUtil.INSTANCE.getRadioVideoSp().getBoolean("key_capture_screen_new_user_for_guide_1", captureScreenNewUser)) {
                            YYTaskExecutor.postToMainThread((Runnable)new Runnable(this){
                                final /* synthetic */ checkCaptureScreenGuideShow.1 this$0;

                                public final void run() {
                                    BottomMvp.IView iView = CaptureScreenPresenter.access$getMBottomView$p(this.this$0.this$0);
                                    if (iView != null) {
                                        if (iView.showCaptureScreenGuideWindow()) {
                                            LiveConstansUtil.INSTANCE.getRadioVideoSp().edit().putBoolean("key_capture_screen_new_user_for_guide_1", false).apply();
                                        }
                                    }
                                }
                                {
                                    this.this$0 = var1_1;
                                }
                            }, (long)500L);
                        }
                        if (captureScreenNewUser) {
                            if (this.this$0.isDestroyed()) {
                                return;
                            }
                            ((BottomPresenter)this.this$0.getPresenter(BottomPresenter.class)).setAddRedPoint(2, true);
                        }
                    }
                }
            }

            public void onFail(int errCode, @Nullable String msg, Object ... ext) {
                Intrinsics.checkParameterIsNotNull((Object)ext, (String)"ext");
            }
            {
                this.this$0 = $outer;
            }
        }));
    }

    @Override
    public void publishPost(@NotNull String text) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        File videoFile = this.screenVideoFile;
        if (videoFile == null || videoFile.length() < 1L) {
            return;
        }
        File coverFile = this.screenVideoCoverFile;
        if (coverFile == null || coverFile.length() < 1L) {
            this.saveVideo();
            return;
        }
        this.needDeleteFileWhenExit = false;
        long startPublish = System.currentTimeMillis();
        String string2 = videoFile.getAbsolutePath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"videoFile.absolutePath");
        int n = (int)this.videoDuring;
        String string3 = coverFile.getAbsolutePath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"coverFile.absolutePath");
        MediaEntity video = new MediaEntity(string2, n, string3, 1, this.videoWidth, this.videoHeight, null, null, null, null, 960, null);
        OriginalPostParam param = new OriginalPostParam(null, video, text, null, new LocationEntity(0.0f, 0.0f, null, 7, null), 0, null, null, null, 0, 0, null, 4073, null);
        ((IPostService)ServiceManagerProxy.getService(IPostService.class)).postWithResourceUpload(param, new IPostPublishCallback(this, startPublish){
            final /* synthetic */ CaptureScreenPresenter this$0;
            final /* synthetic */ long $startPublish;

            public void onSuccess(@Nullable BasePostInfo postInfo) {
                long time = System.currentTimeMillis() - this.$startPublish;
                if (MLog.isLogLevelBlowInfo()) {
                    BasePostInfo basePostInfo = postInfo;
                    MLog.info((Object)"CaptureScreenPresenter", (String)("Publish Post Success " + (basePostInfo != null ? basePostInfo.getPostId() : null) + " Spend " + time), (Object[])new Object[0]);
                }
                CaptureScreenPresenter.access$deleteRecordResources(this.this$0);
                String string2 = this.this$0.getChannelId();
                Object object = postInfo;
                if (object == null || (object = object.getPostId()) == null) {
                    object = "-1";
                }
                RadioUtils.INSTANCE.reportRecordScreenVideoPublishResult(string2, true, (String)object, time, "");
                ToastUtils.showToast((Context)((Context)((RoomPageContext)this.this$0.getMvpContext()).getContext()), (int)R.string.tips_screen_record_publish_success);
            }

            public void onFail(@Nullable String reason, int code) {
                long time = System.currentTimeMillis() - this.$startPublish;
                MLog.error((Object)"CaptureScreenPresenter", (String)("Publish Post Failed " + reason + ' ' + code), (Object[])new Object[0]);
                RadioUtils.INSTANCE.reportRecordScreenVideoPublishResult(this.this$0.getChannelId(), false, "", time, "Code:" + code + " Reason:" + reason);
                CaptureScreenPresenter.access$saveVideoToAlbum(this.this$0, true);
            }
            {
                this.this$0 = $outer;
                this.$startPublish = $captured_local_variable$1;
            }
        }, new IGetVideoDataCallback(){

            public void onVideoUploaded(@NotNull MediaEntity videoData) {
                Intrinsics.checkParameterIsNotNull((Object)videoData, (String)"videoData");
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)"CaptureScreenPresenter", (String)("Video uploaded " + videoData.getMRemoteUrl()), (Object[])new Object[0]);
                }
            }
        });
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)("Publish Start " + this.screenVideoFile), (Object[])new Object[0]);
        }
    }

    @Override
    public void saveVideo() {
        PermissionHelper.checkStoragePermission((Activity)((Activity)((RoomPageContext)this.getMvpContext()).getContext()), (IPermissionListener)new IPermissionListener(this){
            final /* synthetic */ CaptureScreenPresenter this$0;

            public void onPermissionGranted(@NotNull String[] permission) {
                Intrinsics.checkParameterIsNotNull((Object)permission, (String)"permission");
                CaptureScreenPresenter.access$saveVideoToAlbum(this.this$0, false);
            }

            public void onPermissionDenied(@NotNull String[] permission) {
                Intrinsics.checkParameterIsNotNull((Object)permission, (String)"permission");
            }
            {
                this.this$0 = $outer;
            }
        });
    }

    @Override
    public void exitPreviewPanel() {
        File videoFile = this.screenVideoFile;
        if (this.needDeleteFileWhenExit) {
            File file = videoFile;
            if (file != null) {
                if (file.exists()) {
                    this.deleteRecordResources();
                    this.needDeleteFileWhenExit = false;
                }
            }
        }
    }

    private final void saveVideoToAlbum(boolean publishFailed) {
        File videoFile = this.screenVideoFile;
        if (videoFile == null || videoFile.length() < 1L) {
            return;
        }
        YYTaskExecutor.execute((Runnable)new Runnable(this, videoFile, publishFailed){
            final /* synthetic */ CaptureScreenPresenter this$0;
            final /* synthetic */ File $videoFile;
            final /* synthetic */ boolean $publishFailed;

            public final void run() {
                String fileName = YYFileUtils.getFileName((String)this.$videoFile.getAbsolutePath());
                boolean saveResult = false;
                if (SdkVersionUtils.hasScopedStorage()) {
                    String string2 = this.$videoFile.getAbsolutePath();
                    String string3 = fileName;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"fileName");
                    saveResult = FileOperatorQ.INSTANCE.saveMediaFile(string2, true, string3);
                } else {
                    File destDir = new File(YYFileUtils.getSystemAlbumDir());
                    destDir.mkdirs();
                    File outputFile = new File(destDir, fileName);
                    File file = CaptureScreenPresenter.access$getScreenVideoFile$p(this.this$0);
                    if (file != null) {
                        if (outputFile.length() == file.length()) {
                            return;
                        }
                    }
                    String outputFileName = outputFile.getAbsolutePath();
                    String[] paths = new String[]{outputFileName};
                    String[] mimeTypes = new String[]{MimeType.MP4.toString()};
                    if (YYFileUtils.copyFile((String)this.$videoFile.getAbsolutePath(), (String)outputFileName)) {
                        MediaScannerConnection.scanFile((Context)RuntimeContext.sApplicationContext, (String[])paths, (String[])mimeTypes, (MediaScannerConnection.OnScanCompletedListener)saveVideoToAlbum.1.INSTANCE);
                        saveResult = true;
                    }
                }
                if (saveResult) {
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(this){
                        final /* synthetic */ saveVideoToAlbum.1 this$0;

                        public final void run() {
                            int tipsId = this.this$0.$publishFailed ? R.string.tips_screen_record_publish_failed_save_success : R.string.tips_screen_record_save_success;
                            CaptureScreenContract.ICaptureScreenView iCaptureScreenView = CaptureScreenPresenter.access$getMView$p(this.this$0.this$0);
                            if (iCaptureScreenView != null) {
                                iCaptureScreenView.onSaveLocalSuccess();
                            }
                            CaptureScreenPresenter.access$deleteRecordResources(this.this$0.this$0);
                            ToastUtils.showToast((Context)((Context)((RoomPageContext)this.this$0.this$0.getMvpContext()).getContext()), (int)tipsId);
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    });
                } else {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)"CaptureScreenPresenter", (String)"copy failed:", (Object[])new Object[0]);
                    }
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(this){
                        final /* synthetic */ saveVideoToAlbum.1 this$0;

                        public final void run() {
                            ToastUtils.showToast((Context)((Context)((RoomPageContext)this.this$0.this$0.getMvpContext()).getContext()), (int)R.string.tip_save_notice_failed);
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    });
                }
            }
            {
                this.this$0 = captureScreenPresenter;
                this.$videoFile = file;
                this.$publishFailed = bl;
            }
        });
    }

    private final void deleteRecordResources() {
        YYTaskExecutor.execute((Runnable)new Runnable(this){
            final /* synthetic */ CaptureScreenPresenter this$0;

            public final void run() {
                File file = CaptureScreenPresenter.access$getScreenVideoFile$p(this.this$0);
                if (file != null) {
                    if (file.exists()) {
                        YYFileUtils.delete((File)CaptureScreenPresenter.access$getScreenVideoFile$p(this.this$0));
                    }
                }
                File file2 = CaptureScreenPresenter.access$getScreenVideoCoverFile$p(this.this$0);
                if (file2 != null) {
                    if (file2.exists()) {
                        YYFileUtils.delete((File)CaptureScreenPresenter.access$getScreenVideoCoverFile$p(this.this$0));
                    }
                }
            }
            {
                this.this$0 = captureScreenPresenter;
            }
        });
    }

    @Override
    public boolean isEnableCaptureScreen() {
        return Build.VERSION.SDK_INT >= 21;
    }

    @Override
    public void prepareRecord() {
        if (Build.VERSION.SDK_INT < 21) {
            return;
        }
        this.screenRecorder.prepareCaputrePermission();
    }

    @RequiresApi(value=21)
    private final void startRecord() {
        File dir = this.getSaveDir();
        if (!dir.exists()) {
            dir.mkdirs();
        }
        long timeStamp = System.currentTimeMillis();
        File file = new File(dir, "video_" + timeStamp + ".mp4");
        File coverFile = new File(dir, "cover_" + timeStamp + ".jpg");
        this.screenVideoFile = file;
        this.screenVideoCoverFile = coverFile;
        this.isCancelAction = false;
        this.needDeleteFileWhenExit = true;
        IServiceManager iServiceManager = ServiceManagerProxy.getServiceManager();
        if (iServiceManager == null) {
            Intrinsics.throwNpe();
        }
        boolean isMicOpen = ((IKtvLiveServiceExtend)iServiceManager.getService(IKtvLiveServiceExtend.class)).isAudioPublishEnabled(1);
        IServiceManager iServiceManager2 = ServiceManagerProxy.getServiceManager();
        if (iServiceManager2 == null) {
            Intrinsics.throwNpe();
        }
        boolean isFileAudioOpen = ((IKtvLiveServiceExtend)iServiceManager2.getService(IKtvLiveServiceExtend.class)).isAudioPublishEnabled(2);
        boolean isLinkMic = ((RoomPageContext)this.getMvpContext()).hasPresenter(VideoPkPresenter.class) && ((VideoPkPresenter)this.getPresenter(VideoPkPresenter.class)).isLinkMic();
        this.screenRecorder.setEnableAudioTrace(isMicOpen || isLinkMic || isFileAudioOpen);
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)("startRecord Mic:" + isMicOpen + " FileAudio:" + isFileAudioOpen + " LinkMic:" + isLinkMic), (Object[])new Object[0]);
        }
        this.screenRecorder.startRecord(file);
        this.updateRecordStatus(10);
        this.recordCountDownTimer(0);
        IVideoKTVController iVideoKTVController = ((RadioPresenter)this.getPresenter(RadioPresenter.class)).getRadioKTVController();
        boolean isSinging = iVideoKTVController != null && iVideoKTVController.getCurrentSongStatus() == 1;
        boolean isPk = ((RoomPageContext)this.getMvpContext()).hasPresenter(VideoPkPresenter.class) && ((VideoPkPresenter)this.getPresenter(VideoPkPresenter.class)).isLinkMic();
        RadioUtils.INSTANCE.reportRecordScreenStart(isPk, isSinging, this.getChannelId());
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)("Start Record " + file.getAbsolutePath()), (Object[])new Object[0]);
        }
    }

    @Override
    public void onPermissionReady() {
        this.updateRecordStatus(3);
        YYTaskExecutor.postToMainThread((Runnable)this.mPrepareCountDownTask, (long)1000L);
    }

    @Override
    public void onStartRecord() {
        this.videoStartTimeStamp = SystemClock.elapsedRealtime();
    }

    @Override
    public void onStopRecord() {
        File file = this.screenVideoFile;
        if (file == null || file.length() < 1L) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)("File Not exist? " + file), (Object[])new Object[0]);
            }
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(this){
                final /* synthetic */ CaptureScreenPresenter this$0;

                public final void run() {
                    CaptureScreenPresenter.access$updateRecordStatus(this.this$0, 0);
                }
                {
                    this.this$0 = captureScreenPresenter;
                }
            });
            return;
        }
        if (this.isCancelAction) {
            YYTaskExecutor.execute((Runnable)new Runnable(file){
                final /* synthetic */ File $file;

                public final void run() {
                    YYFileUtils.delete((File)this.$file);
                }
                {
                    this.$file = file;
                }
            });
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(this){
                final /* synthetic */ CaptureScreenPresenter this$0;

                public final void run() {
                    CaptureScreenPresenter.access$updateRecordStatus(this.this$0, 0);
                }
                {
                    this.this$0 = captureScreenPresenter;
                }
            });
        } else {
            RadioUtils.INSTANCE.reportRecordScreenDone((int)file.length(), (int)this.videoDuring, this.getChannelId(), String.valueOf(this.captureEndType));
            this.parseVideoCover(file);
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(this){
                final /* synthetic */ CaptureScreenPresenter this$0;

                public final void run() {
                    CaptureScreenPresenter.access$updateRecordStatus(this.this$0, 20);
                }
                {
                    this.this$0 = captureScreenPresenter;
                }
            });
        }
    }

    @Override
    public void onRecordError() {
        this.updateRecordStatus(0);
        ToastUtils.showToast((Context)((Context)((RoomPageContext)this.getMvpContext()).getContext()), (int)R.string.tips_screen_record_failed);
    }

    @Override
    public void stopRecord() {
        if (Build.VERSION.SDK_INT < 21) {
            return;
        }
        this.captureEndType = 1;
        long videoEndTimeStamp = SystemClock.elapsedRealtime();
        if (videoEndTimeStamp - this.videoStartTimeStamp < (long)3000) {
            this.stopRecord(true);
            ToastUtils.showToast((Context)((Context)((RoomPageContext)this.getMvpContext()).getContext()), (int)R.string.tips_screen_record_less_min_time);
        } else {
            this.stopRecord(false);
        }
    }

    @Override
    public void cancelRecord() {
        if (this.screenRecordStatus == 10) {
            this.stopRecord(true);
        } else {
            this.updateRecordStatus(0);
            YYTaskExecutor.removeRunnableFromMainThread((Runnable)this.mRecordCountDownTask);
        }
        IVideoKTVController iVideoKTVController = ((RadioPresenter)this.getPresenter(RadioPresenter.class)).getRadioKTVController();
        boolean isSinging = iVideoKTVController != null && iVideoKTVController.getCurrentSongStatus() == 1;
        boolean isPk = ((VideoPkPresenter)this.getPresenter(VideoPkPresenter.class)).isLinkMic();
        RadioUtils.INSTANCE.reportRecordScreenCancelClick(isPk, isSinging, this.getChannelId());
    }

    private final File getSaveDir() {
        Context context = RuntimeContext.sApplicationContext;
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"RuntimeContext.sApplicationContext");
        return new File(context.getExternalCacheDir(), "screen");
    }

    private final void stopRecord(boolean cancel) {
        if (Build.VERSION.SDK_INT < 21) {
            return;
        }
        YYTaskExecutor.removeRunnableFromMainThread((Runnable)this.mRecordCountDownTask);
        this.isCancelAction = cancel;
        this.screenRecorder.stopRecord();
        long videoEndTimeStamp = SystemClock.elapsedRealtime();
        this.videoDuring = videoEndTimeStamp - this.videoStartTimeStamp;
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)("Stop record " + this.videoDuring), (Object[])new Object[0]);
        }
    }

    private final void parseVideoCover(File videoFile) {
        if (this.isParsingCover) {
            return;
        }
        this.isParsingCover = true;
        ImageLoader.loadBitmap((Context)RuntimeContext.sApplicationContext, (String)videoFile.getAbsolutePath(), (ImageLoader.BitmapLoadListener)new ImageLoader.BitmapLoadListener(this){
            final /* synthetic */ CaptureScreenPresenter this$0;

            public void onLoadFailed(@NotNull Exception e) {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                MLog.error((Object)"CaptureScreenPresenter", (String)"onLoadFailed!", (Throwable)e, (Object[])new Object[0]);
                CaptureScreenPresenter.access$setParsingCover$p(this.this$0, false);
            }

            public void onResourceReady(@NotNull Bitmap bitmap) {
                Intrinsics.checkParameterIsNotNull((Object)bitmap, (String)"bitmap");
                YYTaskExecutor.execute((Runnable)new Runnable(this, bitmap){
                    final /* synthetic */ parseVideoCover.1 this$0;
                    final /* synthetic */ Bitmap $bitmap;

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public final void run() {
                        File file;
                        File file2 = CaptureScreenPresenter.access$getScreenVideoCoverFile$p(this.this$0.this$0);
                        if (file2 != null) {
                            if (file2.exists()) {
                                File file3 = CaptureScreenPresenter.access$getScreenVideoCoverFile$p(this.this$0.this$0);
                                if (file3 != null) {
                                    file3.delete();
                                }
                            }
                        }
                        if ((file = CaptureScreenPresenter.access$getScreenVideoCoverFile$p(this.this$0.this$0)) == null) {
                            file = new File(CaptureScreenPresenter.access$getSaveDir(this.this$0.this$0), "cover_" + System.currentTimeMillis() + ".jpg");
                        }
                        File file4 = file;
                        Closeable closeable = new BufferedOutputStream(new FileOutputStream(file4));
                        boolean bl = false;
                        Throwable throwable = null;
                        try {
                            BufferedOutputStream it = (BufferedOutputStream)closeable;
                            boolean bl2 = false;
                            boolean bl3 = this.$bitmap.compress(Bitmap.CompressFormat.JPEG, 80, (OutputStream)it);
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                        }
                        CaptureScreenPresenter.access$setScreenVideoCoverFile$p(this.this$0.this$0, file4);
                        if (MLog.isLogLevelBlowInfo()) {
                            MLog.info((Object)"CaptureScreenPresenter", (String)("parse Cover Success " + file4), (Object[])new Object[0]);
                        }
                        CaptureScreenPresenter.access$setParsingCover$p(this.this$0.this$0, false);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$bitmap = bitmap;
                    }
                });
            }
            {
                this.this$0 = $outer;
            }
        });
    }

    private final void updateRecordStatus(int status) {
        int preStatus = this.screenRecordStatus;
        this.screenRecordStatus = status;
        switch (status) {
            case 0: {
                if (preStatus == 0) break;
                CaptureScreenContract.ICaptureScreenView iCaptureScreenView = this.mView;
                if (iCaptureScreenView != null) {
                    iCaptureScreenView.onExitCaptureScreenMode();
                }
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                if (preStatus == 0 || preStatus == 20) {
                    CaptureScreenContract.ICaptureScreenView iCaptureScreenView = this.mView;
                    if (iCaptureScreenView != null) {
                        iCaptureScreenView.onEnterCaptureScreenMode();
                    }
                    this.appendRecordScreenRule();
                }
                CaptureScreenContract.ICaptureScreenView iCaptureScreenView = this.mView;
                if (iCaptureScreenView != null) {
                    iCaptureScreenView.onEnterPrepareMode(status);
                }
                break;
            }
            case 10: {
                CaptureScreenContract.ICaptureScreenView iCaptureScreenView = this.mView;
                if (iCaptureScreenView != null) {
                    iCaptureScreenView.onEnterStartMode();
                }
                break;
            }
            case 20: {
                CaptureScreenContract.ICaptureScreenView iCaptureScreenView = this.mView;
                if (iCaptureScreenView == null) break;
                File file = this.screenVideoFile;
                if (file == null) {
                    Intrinsics.throwNpe();
                }
                iCaptureScreenView.onRecordSuccess(file);
                break;
            }
        }
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)("updateRecordStatus " + preStatus + " -> " + status), (Object[])new Object[0]);
        }
    }

    private final void appendRecordScreenRule() {
        block0: {
            String string2 = RuntimeContext.sApplicationContext.getString(R.string.title_screen_record_rule);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"RuntimeContext.sApplicat\u2026title_screen_record_rule)");
            String msg = string2;
            SysTextMsg sysTextMsg = ((IPublicScreenService)ServiceManagerProxy.getService(IPublicScreenService.class)).getMsgItemFactory().generateLocalTsSysMsg(msg);
            boolean bl = false;
            boolean bl2 = false;
            SysTextMsg it = sysTextMsg;
            boolean bl3 = false;
            IPublicScreenPresenter iPublicScreenPresenter = ((IPublicScreenModulePresenter)this.getPresenter(IPublicScreenModulePresenter.class)).getPublicScreenPresenter();
            if (iPublicScreenPresenter == null) break block0;
            iPublicScreenPresenter.appendLocalMsg((BaseImMsg)it);
        }
    }

    private final void prepareCountDown() {
        YYTaskExecutor.removeRunnableFromMainThread((Runnable)this.mPrepareCountDownTask);
        int curStatus = this.screenRecordStatus;
        switch (curStatus) {
            case 0: {
                if (!MLog.isLogLevelBlowInfo()) break;
                MLog.info((Object)TAG, (String)"Prepare Had Cancel?", (Object[])new Object[0]);
                break;
            }
            case 2: 
            case 3: {
                this.updateRecordStatus(curStatus - 1);
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)TAG, (String)("captureScreenStatusLiveData -> " + (curStatus - 1)), (Object[])new Object[0]);
                }
                YYTaskExecutor.postToMainThread((Runnable)this.mPrepareCountDownTask, (long)1000L);
                break;
            }
            case 1: {
                if (Build.VERSION.SDK_INT >= 21) {
                    this.startRecord();
                    break;
                }
                MLog.error((Object)TAG, (String)"MediaProject Had Been NULL??", (Object[])new Object[0]);
                this.updateRecordStatus(0);
            }
        }
    }

    private final void recordCountDownTimer(int recordTime) {
        YYTaskExecutor.removeRunnableFromMainThread((Runnable)this.mRecordCountDownTask);
        this.recordTimeSec = recordTime;
        if (this.recordTimeSec > 60) {
            this.captureEndType = 2;
            this.stopRecord(false);
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"Time is End", (Object[])new Object[0]);
            }
        } else {
            CaptureScreenContract.ICaptureScreenView iCaptureScreenView = this.mView;
            if (iCaptureScreenView != null) {
                iCaptureScreenView.onRecordTimeCountDown(this.recordTimeSec);
            }
            YYTaskExecutor.postToMainThread((Runnable)this.mRecordCountDownTask, (long)1000L);
        }
    }

    public void notify(@Nullable Notification notification) {
        Notification notification2 = notification;
        if (notification2 != null) {
            if (notification2.id == NotificationDef.N_FOREGROUND_CHANGE) {
                Object object = notification.extObj;
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Boolean");
                }
                if (!((Boolean)object).booleanValue()) {
                    if (this.screenRecordStatus != 20) {
                        this.captureEndType = 3;
                        this.stopRecord(false);
                    }
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)TAG, (String)("Move to background , Cancel Record " + this.screenRecordStatus), (Object[])new Object[0]);
                    }
                }
            }
        }
    }

    public void onDestroy() {
        super.onDestroy();
        this.mBottomView = null;
        this.screenRecorder.release();
        this.deleteRecordResources();
        NotificationCenter.getGlobalInstance().unregister(NotificationDef.N_FOREGROUND_CHANGE, (INotify)this);
    }

    public CaptureScreenPresenter() {
        ScreenUtils screenUtils = ScreenUtils.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)screenUtils, (String)"ScreenUtils.getInstance()");
        int n = screenUtils.getScreenRealHeight() * this.videoWidth;
        ScreenUtils screenUtils2 = ScreenUtils.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)screenUtils2, (String)"ScreenUtils.getInstance()");
        int height2 = n / screenUtils2.getScreenRealWidth();
        this.videoHeight = height2 + 7 >> 3 << 3;
        this.mPrepareCountDownTask = new Runnable(this){
            final /* synthetic */ CaptureScreenPresenter this$0;

            public final void run() {
                CaptureScreenPresenter.access$prepareCountDown(this.this$0);
            }
            {
                this.this$0 = captureScreenPresenter;
            }
        };
        this.mRecordCountDownTask = new Runnable(this){
            final /* synthetic */ CaptureScreenPresenter this$0;

            public final void run() {
                CaptureScreenPresenter.access$recordCountDownTimer(this.this$0, CaptureScreenPresenter.access$getRecordTimeSec$p(this.this$0) + 1);
            }
            {
                this.this$0 = captureScreenPresenter;
            }
        };
    }

    public static final /* synthetic */ File access$getSaveDir(CaptureScreenPresenter $this) {
        return $this.getSaveDir();
    }

    public static final /* synthetic */ BottomMvp.IView access$getMBottomView$p(CaptureScreenPresenter $this) {
        return $this.mBottomView;
    }

    public static final /* synthetic */ void access$setMBottomView$p(CaptureScreenPresenter $this, BottomMvp.IView iView) {
        $this.mBottomView = iView;
    }

    public static final /* synthetic */ void access$deleteRecordResources(CaptureScreenPresenter $this) {
        $this.deleteRecordResources();
    }

    public static final /* synthetic */ void access$saveVideoToAlbum(CaptureScreenPresenter $this, boolean publishFailed) {
        $this.saveVideoToAlbum(publishFailed);
    }

    public static final /* synthetic */ File access$getScreenVideoFile$p(CaptureScreenPresenter $this) {
        return $this.screenVideoFile;
    }

    public static final /* synthetic */ void access$setScreenVideoFile$p(CaptureScreenPresenter $this, File file) {
        $this.screenVideoFile = file;
    }

    public static final /* synthetic */ CaptureScreenContract.ICaptureScreenView access$getMView$p(CaptureScreenPresenter $this) {
        return $this.mView;
    }

    public static final /* synthetic */ void access$setMView$p(CaptureScreenPresenter $this, CaptureScreenContract.ICaptureScreenView iCaptureScreenView) {
        $this.mView = iCaptureScreenView;
    }

    public static final /* synthetic */ File access$getScreenVideoCoverFile$p(CaptureScreenPresenter $this) {
        return $this.screenVideoCoverFile;
    }

    public static final /* synthetic */ void access$setScreenVideoCoverFile$p(CaptureScreenPresenter $this, File file) {
        $this.screenVideoCoverFile = file;
    }

    public static final /* synthetic */ void access$updateRecordStatus(CaptureScreenPresenter $this, int status) {
        $this.updateRecordStatus(status);
    }

    public static final /* synthetic */ boolean access$isParsingCover$p(CaptureScreenPresenter $this) {
        return $this.isParsingCover;
    }

    public static final /* synthetic */ void access$setParsingCover$p(CaptureScreenPresenter $this, boolean bl) {
        $this.isParsingCover = bl;
    }

    public static final /* synthetic */ void access$prepareCountDown(CaptureScreenPresenter $this) {
        $this.prepareCountDown();
    }

    public static final /* synthetic */ void access$recordCountDownTimer(CaptureScreenPresenter $this, int recordTime) {
        $this.recordCountDownTimer(recordTime);
    }

    public static final /* synthetic */ int access$getRecordTimeSec$p(CaptureScreenPresenter $this) {
        return $this.recordTimeSec;
    }

    public static final /* synthetic */ void access$setRecordTimeSec$p(CaptureScreenPresenter $this, int n) {
        $this.recordTimeSec = n;
    }

    @Retention(value=AnnotationRetention.SOURCE)
    @java.lang.annotation.Retention(value=RetentionPolicy.SOURCE)
    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\n\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0000\b\u0087\u0002\u0018\u00002\u00020\u0001B\u0000\u00a8\u0006\u0002"}, d2={"Lcom/yy/hiyo/channel/plugins/radio/screenrecord/CaptureScreenPresenter$ScreenRecordStatus;", "", "radio_release"})
    public static @interface ScreenRecordStatus {
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/yy/hiyo/channel/plugins/radio/screenrecord/CaptureScreenPresenter$Companion;", "", "()V", "MAX_RECORD_TIME", "", "MIN_RECORD_TIME_MILLIS", "STATUS_IDLE", "STATUS_PREPARE_1", "STATUS_PREPARE_2", "STATUS_PREPARE_3", "STATUS_RECORDING", "STATUS_RECORD_SUCCESS", "TAG", "", "VIDEO_WIDTH", "radio_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

