/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.radio.seat.warpper;

import android.content.Context;
import android.graphics.Point;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.Nullable;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.MutableLiveData;
import androidx.lifecycle.Observer;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.push.pushhiido.ISimpleCallback;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.ui.widget.YYPlaceHolderView;
import com.yy.appbase.util.ScreenWrapperUtils;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResolutionUtils;
import com.yy.hiyo.channel.anchorfansclub.IFansClubService;
import com.yy.hiyo.channel.base.service.IChannel;
import com.yy.hiyo.channel.base.service.IEnteredChannel;
import com.yy.hiyo.channel.cbase.context.IChannelPageContext;
import com.yy.hiyo.channel.component.seat.bean.SeatItem;
import com.yy.hiyo.channel.plugins.radio.RadioUtil;
import com.yy.hiyo.channel.plugins.radio.fansclub.FansClubPresenter;
import com.yy.hiyo.channel.plugins.radio.seat.RadioSeatInfo;
import com.yy.hiyo.channel.plugins.radio.seat.RadioSeatPresenter;
import com.yy.hiyo.channel.plugins.radio.seat.view.RadioVideoSeatView;
import com.yy.hiyo.channel.plugins.radio.seat.warpper.BaseRadioSeatViewWrapper;
import com.yy.hiyo.channel.plugins.radio.video.top.RadioTopBarPresenter;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RadioVideoSeatViewWrapper
extends BaseRadioSeatViewWrapper {
    private final String TAG = "RadioVideoSeatView";
    protected RadioVideoSeatView mSeatView;
    protected RadioSeatPresenter.OnClickChannelOwnerListener mListener;
    protected RadioSeatPresenter mPresenter;
    Map<Long, Point> realLoctionMap = new HashMap<Long, Point>();
    private boolean isSupportReuse = false;
    private Observer<Boolean> mFansClubObserver = null;
    private ISimpleCallback<Boolean> lockChangeListener = new ISimpleCallback<Boolean>(){

        public void onSuccess(Boolean data) {
            if (RadioVideoSeatViewWrapper.this.mSeatView != null) {
                RadioVideoSeatViewWrapper.this.mSeatView.updateLockVisibility(data);
            }
        }
    };

    public RadioVideoSeatViewWrapper(RadioSeatPresenter.OnClickChannelOwnerListener listener2, IEnteredChannel channel, RadioSeatPresenter presenter, RadioSeatPresenter.OnAnchorSeatChangedListener showEndPageListener, boolean isSupportReuse) {
        super(showEndPageListener, channel);
        this.mPresenter = presenter;
        this.mListener = listener2;
        if (this.mSeatView != null) {
            this.mSeatView.updateConfig(this, listener2, (IChannel)this.mChannel);
            this.initSeatViewStarBg();
        }
        this.isSupportReuse = isSupportReuse;
    }

    @Override
    public void createView(Context context, ViewGroup parent) {
        this.changeSeatView(context);
    }

    @Override
    protected void setAvatarFrame(String frameUrl) {
        super.setAvatarFrame(frameUrl);
        if (this.mSeatView != null) {
            this.mSeatView.setAvatarFrame(frameUrl);
        }
    }

    @Override
    protected void setAvatar(UserInfoKS userInfoBean) {
        super.setAvatar(userInfoBean);
        if (this.mSeatView != null) {
            this.mSeatView.setAvatar(userInfoBean.avatar, userInfoBean.uid, userInfoBean.sex);
        }
    }

    @Override
    public void updateSeats(List<SeatItem> seatItems) {
        super.updateSeats(seatItems);
        if (!FP.empty(seatItems)) {
            if (this.mSeatView != null) {
                this.mSeatView.updateSeat(this.seatItem2RadioSeat(seatItems.get(0)), true);
            }
        } else if (this.mSeatView != null) {
            this.mSeatView.updateSeat(null, true);
        }
    }

    @Override
    public void updateSeat(int position, SeatItem data) {
        super.updateSeat(position, data);
        if (position == 0 && this.mSeatView != null) {
            this.mSeatView.updateSeat(this.seatItem2RadioSeat(data), true);
        }
    }

    private RadioSeatInfo seatItem2RadioSeat(SeatItem data) {
        if (data != null) {
            String nick = "";
            if (data.userInfo != null) {
                nick = data.userInfo.nick;
            }
            return new RadioSeatInfo(data.uid, nick, data.isMe());
        }
        return null;
    }

    public Map<Long, Point> getSeatViewLoaction(boolean isAbsolute) {
        if (((Boolean)this.mChannel.getDataService().getChannelExtra("key_radio_screen_close", (Object)false)).booleanValue()) {
            return this.realLoctionMap;
        }
        int[] loction = new int[2];
        if (this.mSeatView != null) {
            ScreenWrapperUtils.INSTANCE.getViewPoint(this.mSeatView.getLogoView(), isAbsolute, loction);
            this.realLoctionMap.clear();
            this.realLoctionMap.put(this.getShowingUid(), new Point(loction[0], loction[1]));
        }
        return this.realLoctionMap;
    }

    public int getSeatFaceSize() {
        return ResolutionUtils.dip2Px((float)28.0f);
    }

    public int[] getSeatViewPosition() {
        if (this.mSeatView != null) {
            return new int[]{(int)this.mSeatView.getX(), (int)this.mSeatView.getY()};
        }
        return new int[]{0, 0};
    }

    public void changeSeatView(Context context) {
        View seatView = this.getSeatViewContainer();
        if (seatView instanceof RadioVideoSeatView && this.mSeatView == null) {
            this.mSeatView = (RadioVideoSeatView)seatView;
            this.mSeatView.updateConfig(this, this.mListener, (IChannel)this.mChannel);
            ((RadioTopBarPresenter)this.mPresenter.getPresenter(RadioTopBarPresenter.class)).addLockUpdateListener(this.lockChangeListener);
            this.initSeatViewStarBg();
            this.mSeatView.setRootLayoutVisible(true);
            return;
        }
        if (this.mSeatView == null) {
            this.mSeatView = this.createRadioVideoSeatView(context);
            this.initSeatViewStarBg();
        }
        if (seatView instanceof YYPlaceHolderView) {
            YYPlaceHolderView holderView = (YYPlaceHolderView)seatView;
            if (!holderView.isInflated()) {
                if (null != this.mSeatView.getParent()) {
                    ((ViewGroup)this.mSeatView.getParent()).removeView((View)this.mSeatView);
                }
                holderView.inflate((View)this.mSeatView);
            }
            ((RadioTopBarPresenter)this.mPresenter.getPresenter(RadioTopBarPresenter.class)).addLockUpdateListener(this.lockChangeListener);
        }
    }

    protected RadioVideoSeatView createRadioVideoSeatView(Context context) {
        return new RadioVideoSeatView(context, this, this.mListener, (IChannel)this.mChannel);
    }

    @Nullable
    public View getSeatViewContainer() {
        YYPlaceHolderView view = this.checkSeatViewType();
        if (view != null) {
            return view;
        }
        return ((RadioTopBarPresenter)this.mPresenter.getPresenter(RadioTopBarPresenter.class)).getSeatView();
    }

    @Nullable
    protected YYPlaceHolderView checkSeatViewType() {
        boolean isValid;
        if (!this.isSupportReuse) {
            return null;
        }
        View seatView = ((RadioTopBarPresenter)this.mPresenter.getPresenter(RadioTopBarPresenter.class)).getSeatView();
        boolean bl = isValid = seatView instanceof YYPlaceHolderView || seatView instanceof RadioVideoSeatView;
        if (seatView != null && !isValid) {
            YYPlaceHolderView view = new YYPlaceHolderView((Context)((IChannelPageContext)this.mPresenter.getMvpContext()).getContext());
            RadioUtil.INSTANCE.replaceSelfWithView(seatView, (View)view);
            return view;
        }
        return null;
    }

    @Override
    public void destroy() {
        super.destroy();
        if (this.isSupportReuse && this.mSeatView != null) {
            this.mSeatView.resetViewState();
        }
        this.mSeatView = null;
    }

    private void initSeatViewStarBg() {
        YYTaskExecutor.postToMainThread(() -> {
            if (this.mPresenter == null || this.mPresenter.isDestroyed()) {
                return;
            }
            ((RadioTopBarPresenter)this.mPresenter.getPresenter(RadioTopBarPresenter.class)).getStarBgUrl().observe((LifecycleOwner)this.mPresenter.getLifeCycleOwner(), s -> {
                if (!TextUtils.isEmpty((CharSequence)s) && this.mSeatView != null && this.mSeatView.isSupportFollowScanAnim()) {
                    this.mSeatView.setBgViewUi((String)s);
                }
            });
        });
    }

    @Override
    public void checkFansClubEntryOrHideButton() {
        boolean isInit;
        if (this.mPresenter == null || this.mPresenter.isDestroyed()) {
            return;
        }
        final MutableLiveData<Boolean> fansClubData = ((FansClubPresenter)this.mPresenter.getPresenter(FansClubPresenter.class)).fansClubEntryLiveData();
        boolean bl = isInit = this.mFansClubObserver == null;
        if (!isInit) {
            fansClubData.removeObserver(this.mFansClubObserver);
        }
        this.mFansClubObserver = new Observer<Boolean>(){

            public void onChanged(Boolean hasFansClubEntry) {
                if (RadioVideoSeatViewWrapper.this.mPresenter == null || RadioVideoSeatViewWrapper.this.mPresenter.isDestroyed() || RadioVideoSeatViewWrapper.this.mSeatView == null) {
                    return;
                }
                MLog.debug((Object)"RadioVideoSeatView", (String)("check fansClubEntryLiveData:" + hasFansClubEntry), (Object[])new Object[0]);
                long anchorUid = ((FansClubPresenter)RadioVideoSeatViewWrapper.this.mPresenter.getPresenter(FansClubPresenter.class)).getAnchorUid();
                if (hasFansClubEntry.booleanValue() && anchorUid != AccountUtil.getUid()) {
                    RadioVideoSeatViewWrapper.this.mSeatView.setRightButtonVisibleFromWrapper(2);
                } else {
                    RadioVideoSeatViewWrapper.this.mSeatView.setRightButtonVisibleFromWrapper(3);
                }
            }
        };
        if (isInit) {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (!RadioVideoSeatViewWrapper.this.mPresenter.isDestroyed()) {
                        fansClubData.observe((LifecycleOwner)RadioVideoSeatViewWrapper.this.mPresenter.getLifeCycleOwner(), RadioVideoSeatViewWrapper.this.mFansClubObserver);
                    }
                }
            }, (long)600L);
        } else {
            fansClubData.observe((LifecycleOwner)this.mPresenter.getLifeCycleOwner(), this.mFansClubObserver);
        }
    }

    @Override
    public void clickFansClub() {
        if (this.mPresenter == null || this.mPresenter.isDestroyed()) {
            return;
        }
        ((IFansClubService)ServiceManagerProxy.getService(IFansClubService.class)).openFansClubCard(((FansClubPresenter)this.mPresenter.getPresenter(FansClubPresenter.class)).getAnchorUid());
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("60041647").put("function_id", "top_icon_entry_click"));
    }

    @Override
    public View getRealSeatView() {
        return this.mSeatView;
    }
}

