/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.radio.screenrecord;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.view.LayoutInflater;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.widget.TextView;
import com.yy.appbase.extensions.ViewExtensionsKt;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.ui.widget.CircleProgressView;
import com.yy.appbase.ui.widget.YYPlaceHolderView;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYImageView;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.ToastUtils;
import com.yy.framework.core.ui.DefaultWindow;
import com.yy.framework.core.ui.StatusBarManager;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.cbase.AbsChannelWindow;
import com.yy.hiyo.channel.cbase.channelhiido.RadioUtils;
import com.yy.hiyo.channel.plugins.radio.R;
import com.yy.hiyo.channel.plugins.radio.screenrecord.CaptureScreenContract;
import com.yy.hiyo.channel.plugins.radio.screenrecord.CaptureScreenPresenter;
import com.yy.hiyo.channel.plugins.radio.screenrecord.ScreenRecordVideoPreviewPanel;
import java.io.File;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u001f\u001a\u00020 H\u0002J\b\u0010!\u001a\u00020 H\u0002J\b\u0010\"\u001a\u00020 H\u0016J\u0010\u0010#\u001a\u00020 2\u0006\u0010$\u001a\u00020\u0011H\u0016J\b\u0010%\u001a\u00020 H\u0016J\b\u0010&\u001a\u00020 H\u0016J\u0010\u0010'\u001a\u00020 2\u0006\u0010(\u001a\u00020)H\u0016J\u0010\u0010*\u001a\u00020 2\u0006\u0010+\u001a\u00020\u0011H\u0016J\b\u0010,\u001a\u00020 H\u0016J\b\u0010-\u001a\u00020 H\u0002J\b\u0010.\u001a\u00020 H\u0002J\u0010\u0010/\u001a\u00020 2\u0006\u00100\u001a\u00020\u0013H\u0016J\b\u00101\u001a\u00020 H\u0002J\b\u00102\u001a\u00020 H\u0002R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001e\u00a8\u00063"}, d2={"Lcom/yy/hiyo/channel/plugins/radio/screenrecord/CaptureScreenView;", "Lcom/yy/hiyo/channel/plugins/radio/screenrecord/CaptureScreenContract$ICaptureScreenView;", "window", "Lcom/yy/hiyo/channel/cbase/AbsChannelWindow;", "pageView", "Landroid/view/View;", "(Lcom/yy/hiyo/channel/cbase/AbsChannelWindow;Landroid/view/View;)V", "cancelCaptureScreenIv", "Landroid/widget/TextView;", "captureScreenContentView", "captureScreenCountDownTv", "captureScreenHagoId", "Lcom/yy/base/memoryrecycle/views/YYTextView;", "captureScreenHolder", "Lcom/yy/appbase/ui/widget/YYPlaceHolderView;", "captureScreenOwner", "displayCutoutMode", "", "mCaptureScreenPresenter", "Lcom/yy/hiyo/channel/plugins/radio/screenrecord/CaptureScreenContract$ICaptureScreenPresenter;", "mPreviewPancel", "Lcom/yy/hiyo/channel/plugins/radio/screenrecord/ScreenRecordVideoPreviewPanel;", "getPageView", "()Landroid/view/View;", "preSystemUiVisibility", "recordProgress", "Lcom/yy/appbase/ui/widget/CircleProgressView;", "stopCaptureScreenIv", "Lcom/yy/base/memoryrecycle/views/YYImageView;", "getWindow", "()Lcom/yy/hiyo/channel/cbase/AbsChannelWindow;", "hideRadioComponents", "", "initView", "onEnterCaptureScreenMode", "onEnterPrepareMode", "countDown", "onEnterStartMode", "onExitCaptureScreenMode", "onRecordSuccess", "file", "Ljava/io/File;", "onRecordTimeCountDown", "countDownTime", "onSaveLocalSuccess", "recoverRadioComponents", "recoverSystemUiColor", "setPresenter", "presenter", "setSystemUiBlackColor", "showCaptureScreenView", "radio_debug"})
public final class CaptureScreenView
implements CaptureScreenContract.ICaptureScreenView {
    private CaptureScreenContract.ICaptureScreenPresenter mCaptureScreenPresenter;
    private YYPlaceHolderView captureScreenHolder;
    private View captureScreenContentView;
    private YYImageView stopCaptureScreenIv;
    private CircleProgressView recordProgress;
    private TextView captureScreenCountDownTv;
    private TextView cancelCaptureScreenIv;
    private YYTextView captureScreenHagoId;
    private YYTextView captureScreenOwner;
    private ScreenRecordVideoPreviewPanel mPreviewPancel;
    private int preSystemUiVisibility;
    private int displayCutoutMode;
    @NotNull
    private final AbsChannelWindow window;
    @NotNull
    private final View pageView;

    public void setPresenter(@NotNull CaptureScreenContract.ICaptureScreenPresenter presenter) {
        Intrinsics.checkParameterIsNotNull((Object)presenter, (String)"presenter");
        this.mCaptureScreenPresenter = presenter;
    }

    @Override
    public void onEnterCaptureScreenMode() {
        this.hideRadioComponents();
        this.showCaptureScreenView();
        this.setSystemUiBlackColor();
    }

    private final void hideRadioComponents() {
        block6: {
            View view = this.pageView.findViewById(R.id.topLeftActivityHolder);
            if (view != null) {
                ViewExtensionsKt.setInvisible((View)view);
            }
            View view2 = this.pageView.findViewById(R.id.bottomHolder);
            if (view2 != null) {
                ViewExtensionsKt.setInvisible((View)view2);
            }
            View view3 = this.pageView.findViewById(R.id.clTopContainer);
            if (view3 != null) {
                ViewExtensionsKt.setInvisible((View)view3);
            }
            View view4 = this.pageView.findViewById(R.id.btn_back);
            if (view4 != null) {
                ViewExtensionsKt.setInvisible((View)view4);
            }
            View view5 = this.pageView.findViewById(R.id.ktvContainerHolder);
            if (view5 != null) {
                ViewExtensionsKt.setInvisible((View)view5);
            }
            View view6 = this.pageView.findViewById(R.id.debugHolder);
            if (view6 != null) {
                ViewExtensionsKt.setInvisible((View)view6);
            }
            View view7 = this.pageView.findViewById(R.id.activityHolder);
            if (view7 == null) break block6;
            ViewExtensionsKt.setInvisible((View)view7);
        }
    }

    private final void setSystemUiBlackColor() {
        if (!(this.pageView.getContext() instanceof Activity)) {
            return;
        }
        Context context = this.pageView.getContext();
        if (context == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.app.Activity");
        }
        Window window = ((Activity)context).getWindow();
        Intrinsics.checkExpressionValueIsNotNull((Object)window, (String)"(pageView.context as Activity).window");
        Window window2 = window;
        View view = window2.getDecorView();
        Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"window.decorView");
        this.preSystemUiVisibility = view.getSystemUiVisibility();
        View view2 = window2.getDecorView();
        Intrinsics.checkExpressionValueIsNotNull((Object)view2, (String)"window.decorView");
        view2.setSystemUiVisibility(this.preSystemUiVisibility | 4 | 0x400 | 2 | 0x100 | 0x1000);
        if (Build.VERSION.SDK_INT >= 28) {
            WindowManager.LayoutParams layoutParams = window2.getAttributes();
            Intrinsics.checkExpressionValueIsNotNull((Object)layoutParams, (String)"window.attributes");
            WindowManager.LayoutParams lp = layoutParams;
            this.displayCutoutMode = lp.layoutInDisplayCutoutMode;
            lp.layoutInDisplayCutoutMode = 1;
            window2.setAttributes(lp);
        }
    }

    private final void recoverSystemUiColor() {
        if (!(this.pageView.getContext() instanceof Activity)) {
            return;
        }
        Context context = this.pageView.getContext();
        if (context == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.app.Activity");
        }
        Window window = ((Activity)context).getWindow();
        Intrinsics.checkExpressionValueIsNotNull((Object)window, (String)"(pageView.context as Activity).window");
        Window window2 = window;
        View view = window2.getDecorView();
        Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"window.decorView");
        view.setSystemUiVisibility(this.preSystemUiVisibility);
        if (Build.VERSION.SDK_INT >= 28 && this.displayCutoutMode > 0) {
            WindowManager.LayoutParams layoutParams = window2.getAttributes();
            Intrinsics.checkExpressionValueIsNotNull((Object)layoutParams, (String)"window.attributes");
            WindowManager.LayoutParams lp = layoutParams;
            lp.layoutInDisplayCutoutMode = this.displayCutoutMode;
            window2.setAttributes(lp);
            this.displayCutoutMode = -1;
        }
    }

    private final void recoverRadioComponents() {
        block6: {
            View view = this.pageView.findViewById(R.id.topLeftActivityHolder);
            if (view != null) {
                ViewExtensionsKt.setVisible((View)view);
            }
            View view2 = this.pageView.findViewById(R.id.bottomHolder);
            if (view2 != null) {
                ViewExtensionsKt.setVisible((View)view2);
            }
            View view3 = this.pageView.findViewById(R.id.clTopContainer);
            if (view3 != null) {
                ViewExtensionsKt.setVisible((View)view3);
            }
            View view4 = this.pageView.findViewById(R.id.btn_back);
            if (view4 != null) {
                ViewExtensionsKt.setVisible((View)view4);
            }
            View view5 = this.pageView.findViewById(R.id.activityHolder);
            if (view5 != null) {
                ViewExtensionsKt.setVisible((View)view5);
            }
            View view6 = this.pageView.findViewById(R.id.ktvContainerHolder);
            if (view6 != null) {
                ViewExtensionsKt.setVisible((View)view6);
            }
            View view7 = this.pageView.findViewById(R.id.debugHolder);
            if (view7 == null) break block6;
            ViewExtensionsKt.setVisible((View)view7);
        }
    }

    private final void showCaptureScreenView() {
        if (this.captureScreenContentView != null) {
            View view = this.captureScreenContentView;
            if (view != null) {
                ViewExtensionsKt.setVisible((View)view);
            }
        } else {
            YYPlaceHolderView yYPlaceHolderView = this.captureScreenHolder;
            View contentView = LayoutInflater.from((Context)(yYPlaceHolderView != null ? yYPlaceHolderView.getContext() : null)).inflate(R.layout.channel_page_radio_capture_screen, null);
            YYPlaceHolderView yYPlaceHolderView2 = this.captureScreenHolder;
            if (yYPlaceHolderView2 != null) {
                View view = contentView;
                Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"contentView");
                yYPlaceHolderView2.inflate(view);
            }
            this.captureScreenContentView = contentView;
            this.initView();
        }
    }

    private final void initView() {
        block6: {
            View statusBar;
            UserInfoKS userInfo;
            block5: {
                View captureScreenWaterMaskLayout;
                View view = this.captureScreenContentView;
                this.stopCaptureScreenIv = view != null ? (YYImageView)view.findViewById(R.id.stopCaptureScreenIv) : null;
                View view2 = this.captureScreenContentView;
                this.recordProgress = view2 != null ? (CircleProgressView)view2.findViewById(R.id.recordProgress) : null;
                View view3 = this.captureScreenContentView;
                this.captureScreenCountDownTv = view3 != null ? (TextView)view3.findViewById(R.id.captureScreenCountDownTv) : null;
                View view4 = this.captureScreenContentView;
                this.cancelCaptureScreenIv = view4 != null ? (TextView)view4.findViewById(R.id.cancelCaptureScreenTv) : null;
                View view5 = this.captureScreenContentView;
                this.captureScreenHagoId = view5 != null ? (YYTextView)view5.findViewById(R.id.captureScreenHagoId) : null;
                View view6 = this.captureScreenContentView;
                this.captureScreenOwner = view6 != null ? (YYTextView)view6.findViewById(R.id.captureScreenOwner) : null;
                TextView textView = this.cancelCaptureScreenIv;
                if (textView != null) {
                    textView.setOnClickListener(new View.OnClickListener(this){
                        final /* synthetic */ CaptureScreenView this$0;

                        public final void onClick(View it) {
                            block0: {
                                CaptureScreenContract.ICaptureScreenPresenter iCaptureScreenPresenter = CaptureScreenView.access$getMCaptureScreenPresenter$p(this.this$0);
                                if (iCaptureScreenPresenter == null) break block0;
                                iCaptureScreenPresenter.cancelRecord();
                            }
                        }
                        {
                            this.this$0 = captureScreenView;
                        }
                    });
                }
                YYImageView yYImageView = this.stopCaptureScreenIv;
                if (yYImageView != null) {
                    yYImageView.setOnClickListener(new View.OnClickListener(this){
                        final /* synthetic */ CaptureScreenView this$0;

                        public final void onClick(View it) {
                            block0: {
                                CaptureScreenContract.ICaptureScreenPresenter iCaptureScreenPresenter = CaptureScreenView.access$getMCaptureScreenPresenter$p(this.this$0);
                                if (iCaptureScreenPresenter == null) break block0;
                                iCaptureScreenPresenter.stopRecord();
                            }
                        }
                        {
                            this.this$0 = captureScreenView;
                        }
                    });
                }
                CaptureScreenContract.ICaptureScreenPresenter iCaptureScreenPresenter = this.mCaptureScreenPresenter;
                userInfo = iCaptureScreenPresenter != null ? iCaptureScreenPresenter.getOwnerInfo() : null;
                View view7 = this.captureScreenContentView;
                Object object = captureScreenWaterMaskLayout = view7 != null ? view7.findViewById(R.id.captureScreenWaterMaskLayout) : null;
                if (userInfo != null && userInfo.ver > 0L) break block5;
                View view8 = captureScreenWaterMaskLayout;
                if (view8 == null) break block6;
                ViewExtensionsKt.setGone((View)view8);
                break block6;
            }
            View view = this.captureScreenContentView;
            View view9 = statusBar = view != null ? view.findViewById(R.id.status_bar_layout) : null;
            Object lp = view9 != null ? view9.getLayoutParams() : null;
            if (lp != null) {
                (lp = view9 != null ? view9.getLayoutParams() : null).height = StatusBarManager.INSTANCE.getStatusBarHeightWithDefault(this.pageView.getContext());
            }
            View view10 = statusBar;
            if (view10 != null) {
                view10.setLayoutParams(lp);
            }
            YYTextView yYTextView = this.captureScreenHagoId;
            if (yYTextView != null) {
                YYTextView yYTextView2 = this.captureScreenHagoId;
                yYTextView.setText((CharSequence)(yYTextView2 != null && (yYTextView2 = yYTextView2.getResources()) != null ? yYTextView2.getString(R.string.title_channel_id_pre, new Object[]{String.valueOf(String.valueOf(userInfo.vid))}) : null));
            }
            YYTextView yYTextView3 = this.captureScreenOwner;
            if (yYTextView3 == null) break block6;
            yYTextView3.setText((CharSequence)userInfo.nick);
        }
    }

    @Override
    public void onExitCaptureScreenMode() {
        View view = this.captureScreenContentView;
        if (view != null) {
            ViewExtensionsKt.setGone((View)view);
        }
        this.recoverRadioComponents();
        this.recoverSystemUiColor();
    }

    @Override
    public void onEnterPrepareMode(int countDown) {
        block4: {
            TextView textView = this.captureScreenCountDownTv;
            if (textView != null) {
                ViewExtensionsKt.setVisible((View)((View)textView));
            }
            YYImageView yYImageView = this.stopCaptureScreenIv;
            if (yYImageView != null) {
                ViewExtensionsKt.setGone((View)((View)yYImageView));
            }
            TextView textView2 = this.cancelCaptureScreenIv;
            if (textView2 != null) {
                ViewExtensionsKt.setVisible((View)((View)textView2));
            }
            CircleProgressView circleProgressView = this.recordProgress;
            if (circleProgressView != null) {
                ViewExtensionsKt.setGone((View)((View)circleProgressView));
            }
            TextView textView3 = this.captureScreenCountDownTv;
            if (textView3 == null) break block4;
            textView3.setText((CharSequence)String.valueOf(countDown));
        }
    }

    @Override
    public void onRecordTimeCountDown(int countDownTime) {
        block1: {
            YYImageView yYImageView = this.stopCaptureScreenIv;
            if (yYImageView != null) {
                yYImageView.setEnabled(countDownTime >= 3);
            }
            int countDownProgress = countDownTime * 100 / 60;
            CircleProgressView circleProgressView = this.recordProgress;
            if (circleProgressView == null) break block1;
            circleProgressView.setProgress(countDownProgress);
        }
    }

    @Override
    public void onEnterStartMode() {
        block3: {
            TextView textView = this.captureScreenCountDownTv;
            if (textView != null) {
                ViewExtensionsKt.setGone((View)((View)textView));
            }
            YYImageView yYImageView = this.stopCaptureScreenIv;
            if (yYImageView != null) {
                ViewExtensionsKt.setVisible((View)((View)yYImageView));
            }
            YYImageView yYImageView2 = this.stopCaptureScreenIv;
            if (yYImageView2 != null) {
                yYImageView2.setEnabled(false);
            }
            CircleProgressView circleProgressView = this.recordProgress;
            if (circleProgressView == null) break block3;
            ViewExtensionsKt.setVisible((View)((View)circleProgressView));
        }
    }

    @Override
    public void onSaveLocalSuccess() {
        block0: {
            ScreenRecordVideoPreviewPanel screenRecordVideoPreviewPanel = this.mPreviewPancel;
            if (screenRecordVideoPreviewPanel == null) break block0;
            screenRecordVideoPreviewPanel.hidePanel();
        }
    }

    @Override
    public void onRecordSuccess(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        this.onExitCaptureScreenMode();
        if (this.window.getCurWindowShow()) {
            Object object;
            Context context = this.pageView.getContext();
            CaptureScreenContract.ICaptureScreenPresenter iCaptureScreenPresenter = this.mCaptureScreenPresenter;
            if (iCaptureScreenPresenter == null) {
                Intrinsics.throwNpe();
            }
            ScreenRecordVideoPreviewPanel panel = new ScreenRecordVideoPreviewPanel(context, iCaptureScreenPresenter);
            panel.setVideoPath(file);
            panel.showPanel((DefaultWindow)this.window);
            this.mPreviewPancel = panel;
            CaptureScreenContract.ICaptureScreenPresenter iCaptureScreenPresenter2 = this.mCaptureScreenPresenter;
            if (!(iCaptureScreenPresenter2 instanceof CaptureScreenPresenter)) {
                iCaptureScreenPresenter2 = null;
            }
            if ((object = (CaptureScreenPresenter)iCaptureScreenPresenter2) == null || (object = object.getChannelId()) == null) {
                object = "";
            }
            RadioUtils.INSTANCE.reportRecordVideoSharePageShow((String)object);
            ToastUtils.showToast((Context)this.pageView.getContext(), (String)"Record Success", (int)0);
        } else {
            MLog.info((Object)"CaptureScreenView", (String)"not show cur window", (Object[])new Object[0]);
        }
    }

    @NotNull
    public final AbsChannelWindow getWindow() {
        return this.window;
    }

    @NotNull
    public final View getPageView() {
        return this.pageView;
    }

    public CaptureScreenView(@NotNull AbsChannelWindow window, @NotNull View pageView) {
        Intrinsics.checkParameterIsNotNull((Object)window, (String)"window");
        Intrinsics.checkParameterIsNotNull((Object)pageView, (String)"pageView");
        this.window = window;
        this.pageView = pageView;
        View holder = this.pageView.findViewById(R.id.captureScreenHolder);
        if (holder instanceof YYPlaceHolderView) {
            this.captureScreenHolder = (YYPlaceHolderView)holder;
        } else {
            this.captureScreenContentView = holder;
            this.initView();
        }
        this.displayCutoutMode = -1;
    }

    public static final /* synthetic */ CaptureScreenContract.ICaptureScreenPresenter access$getMCaptureScreenPresenter$p(CaptureScreenView $this) {
        return $this.mCaptureScreenPresenter;
    }

    public static final /* synthetic */ void access$setMCaptureScreenPresenter$p(CaptureScreenView $this, CaptureScreenContract.ICaptureScreenPresenter iCaptureScreenPresenter) {
        $this.mCaptureScreenPresenter = iCaptureScreenPresenter;
    }
}

