/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.radio.audioeffect;

import android.text.TextUtils;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.hiyo.voice.base.channelvoice.IEngineAudioPlayer;
import com.yy.hiyo.voice.base.channelvoice.IKtvLiveServiceExtend;
import com.yy.hiyo.voice.base.channelvoice.IRtcEnginer;

public class RadioSoundRawPlayer {
    private static final String TAG = "RadioSoundRawPlayer";
    private IAudioPlayerStateObserver mAudioPlayerStateHandler;
    private int mRawId = -1;
    private IRtcEnginer mRtcEngine;
    private IEngineAudioPlayer mAudioPlayer = null;

    public RadioSoundRawPlayer(IAudioPlayerStateObserver handler) {
        this.mAudioPlayerStateHandler = handler;
        this.mRtcEngine = ((IKtvLiveServiceExtend)ServiceManagerProxy.getServiceManager().getService(IKtvLiveServiceExtend.class)).getRtcEngineEx();
    }

    public synchronized void startPlay(final int rawId, final String filePath) {
        this.stop();
        this.mRawId = rawId;
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                RadioSoundRawPlayer.this.doStart(rawId, filePath);
            }
        });
    }

    private synchronized void doStart(int rawId, String path) {
        if (TextUtils.isEmpty((CharSequence)path)) {
            this.onPlayError(rawId);
            return;
        }
        this.createAudioPlayer();
        boolean isOpenSucceed = this.mAudioPlayer.open(path);
        MLog.info((Object)"fileplay", (String)"isOpen:%b, path:%s", (Object[])new Object[]{isOpenSucceed, path});
        if (isOpenSucceed) {
            ((IKtvLiveServiceExtend)ServiceManagerProxy.getServiceManager().getService(IKtvLiveServiceExtend.class)).enablePublishAudio(2);
            this.mAudioPlayer.enablePublish(true);
            this.mAudioPlayer.play();
            this.onPlayStart(rawId);
        } else {
            this.onPlayError(rawId);
        }
    }

    public synchronized void releasePlayer() {
        if (this.mAudioPlayer != null) {
            MLog.info((Object)TAG, (String)"releasePlayer", (Object[])new Object[0]);
            this.mAudioPlayer.stop();
            this.mRtcEngine.destroyAudioFilePlayer(this.mAudioPlayer);
            this.mAudioPlayer = null;
        }
        this.mAudioPlayerStateHandler = null;
    }

    public synchronized void stop() {
        if (this.mAudioPlayer != null) {
            this.mAudioPlayer.stop();
        }
        this.onPlayStop(this.mRawId);
    }

    private void createAudioPlayer() {
        if (this.mAudioPlayer == null) {
            this.mAudioPlayer = this.mRtcEngine.createAudioFilePlayer();
            MLog.info((Object)TAG, (String)"createAudioPlayer", (Object[])new Object[0]);
            this.mAudioPlayer.setPlayerNotify(new IEngineAudioPlayer.NotifyCallback(){

                public void onAudioFilePlayEnd() {
                    MLog.info((Object)RadioSoundRawPlayer.TAG, (String)("onAudioFilePlayEnd" + RadioSoundRawPlayer.this.mRawId), (Object[])new Object[0]);
                    RadioSoundRawPlayer.this.onPlayComplete(RadioSoundRawPlayer.this.mRawId);
                }

                public void onAudioFileVolume(long volume, long currentMs, long totalMs) {
                }
            });
        }
    }

    private void onPlayStart(int rawId) {
        if (this.mRawId != rawId) {
            return;
        }
        if (this.mAudioPlayerStateHandler != null && rawId != -1) {
            this.mAudioPlayerStateHandler.onStateChanged(AudioPlayState.AUDIO_PLAY_START, rawId);
        }
    }

    private void onPlayError(int rawId) {
        if (this.mRawId != rawId) {
            return;
        }
        if (this.mAudioPlayerStateHandler != null && rawId != -1) {
            this.mAudioPlayerStateHandler.onStateChanged(AudioPlayState.AUDIO_PLAY_ERROR, rawId);
        }
        this.mRawId = -1;
        this.mAudioPlayer = null;
    }

    private void onPlayComplete(int rawId) {
        if (this.mRawId != rawId) {
            return;
        }
        if (this.mAudioPlayerStateHandler != null && rawId != -1) {
            this.mAudioPlayerStateHandler.onStateChanged(AudioPlayState.AUDIO_PLAY_COMPLETE, rawId);
        }
        this.mRawId = -1;
    }

    private void onPlayStop(int rawId) {
        if (this.mRawId != rawId) {
            return;
        }
        if (this.mAudioPlayerStateHandler != null && rawId != -1) {
            this.mAudioPlayerStateHandler.onStateChanged(AudioPlayState.AUDIO_PLAY_STOP, rawId);
        }
        this.mRawId = -1;
    }

    public static interface IAudioPlayerStateObserver {
        public void onStateChanged(AudioPlayState var1, int var2);
    }

    public static enum AudioPlayState {
        AUDIO_PLAY_NONE,
        AUDIO_PLAY_START,
        AUDIO_PLAY_STOP,
        AUDIO_PLAY_COMPLETE,
        AUDIO_PLAY_ERROR;

    }
}

