/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.radio.seat;

import android.content.Context;
import android.graphics.Point;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.Nullable;
import com.yy.appbase.data.UserInfoBean;
import com.yy.appbase.push.pushhiido.ISimpleCallback;
import com.yy.appbase.ui.widget.YYPlaceHolderView;
import com.yy.appbase.util.ScreenWrapperUtils;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResolutionUtils;
import com.yy.hiyo.channel.base.service.IChannel;
import com.yy.hiyo.channel.base.service.IEnteredChannel;
import com.yy.hiyo.channel.component.seat.bean.SeatItem;
import com.yy.hiyo.channel.component.topbar.TopPresenter;
import com.yy.hiyo.channel.plugins.radio.seat.BaseRadioSeatViewWrapper;
import com.yy.hiyo.channel.plugins.radio.seat.RadioSeatPresenter;
import com.yy.hiyo.channel.plugins.radio.seat.RadioVideoSeatView;
import com.yy.hiyo.channel.plugins.radio.video.top.RadioTopBarPresenter;
import com.yy.hiyo.mvp.base.BasePresenter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RadioVideoSeatViewWrapper
extends BaseRadioSeatViewWrapper {
    protected RadioVideoSeatView mSeatView;
    private RadioSeatPresenter.OnClickChannelOwnerListener mListener;
    private RadioSeatPresenter mPresenter;
    Map<Long, Point> realLoctionMap = new HashMap<Long, Point>();
    private ISimpleCallback<Boolean> lockChangeListener = new ISimpleCallback<Boolean>(){

        public void onSuccess(Boolean data) {
            if (RadioVideoSeatViewWrapper.this.mSeatView != null) {
                RadioVideoSeatViewWrapper.this.mSeatView.updateLockVisibility(data);
            }
        }
    };

    public RadioVideoSeatViewWrapper(RadioSeatPresenter.OnClickChannelOwnerListener listener2, IEnteredChannel channel, RadioSeatPresenter presenter, RadioSeatPresenter.OnAnchorSeatChangedListener showEndPageListener) {
        super(showEndPageListener, channel);
        this.mPresenter = presenter;
        this.mListener = listener2;
    }

    @Override
    public void createView(Context context, ViewGroup parent) {
        this.changeSeatView(context);
    }

    @Override
    protected void setAvatarFrame(String frameUrl) {
        super.setAvatarFrame(frameUrl);
        if (this.mSeatView != null) {
            this.mSeatView.setAvatarFrame(frameUrl);
        }
    }

    @Override
    protected void setAvatar(UserInfoBean userInfoBean) {
        super.setAvatar(userInfoBean);
        if (this.mSeatView != null) {
            this.mSeatView.setAvatar(userInfoBean.getAvatar(), userInfoBean.getUid(), userInfoBean.getSex());
        }
    }

    @Override
    public void updateSeats(List<SeatItem> seatItems) {
        super.updateSeats(seatItems);
        if (!FP.empty(seatItems)) {
            if (this.mSeatView != null) {
                this.mSeatView.updateSeat(seatItems.get(0));
            }
        } else if (this.mSeatView != null) {
            this.mSeatView.updateSeat(null);
        }
    }

    @Override
    public void updateSeat(int position, SeatItem data) {
        super.updateSeat(position, data);
        if (position == 0 && this.mSeatView != null) {
            this.mSeatView.updateSeat(data);
        }
    }

    public Map<Long, Point> getSeatViewLoaction(boolean isAbsolute) {
        if (((Boolean)this.mChannel.getDataService().getChannelExtra("key_radio_screen_close", (Object)false)).booleanValue()) {
            return this.realLoctionMap;
        }
        int[] loction = new int[2];
        if (this.mSeatView != null) {
            ScreenWrapperUtils.INSTANCE.getViewPoint(this.mSeatView.getLogoView(), isAbsolute, loction);
            this.realLoctionMap.clear();
            this.realLoctionMap.put(this.getShowingUid(), new Point(loction[0], loction[1]));
        }
        return this.realLoctionMap;
    }

    public int getSeatFaceSize() {
        return ResolutionUtils.dip2Px((float)28.0f);
    }

    public int[] getSeatViewPosition() {
        if (this.mSeatView != null) {
            return new int[]{(int)this.mSeatView.getX(), (int)this.mSeatView.getY()};
        }
        return new int[]{0, 0};
    }

    public void changeSeatView(Context context) {
        if (this.mSeatView == null) {
            if (null != this.mPresenter && null != this.mPresenter.getChannel().getEnterParam() && null != this.mPresenter.getChannel().getEnterParam().preloadChannelData && this.mPresenter.getChannel().getEnterParam().preloadChannelData.getRadioVideoView() instanceof RadioVideoSeatView) {
                this.mSeatView = (RadioVideoSeatView)this.mPresenter.getChannel().getEnterParam().preloadChannelData.getRadioVideoView();
                this.mSeatView.setChannel((IChannel)this.mChannel);
                this.mSeatView.setWrapperHandler(this);
                this.mSeatView.setClickChannelOwnerListener(this.mListener);
                this.mSeatView.setRadioSeatPresenter(this.mPresenter);
                this.mPresenter.getChannel().getEnterParam().preloadChannelData = null;
            } else {
                this.mSeatView = this.createRadioVideoSeatView(context);
            }
        }
        BasePresenter topPresenter = this.mPresenter.getPresenter(TopPresenter.class);
        View view = this.getSeatViewContainer();
        if (view instanceof YYPlaceHolderView) {
            YYPlaceHolderView holderView = (YYPlaceHolderView)view;
            if (!holderView.isInflated()) {
                if (null != this.mSeatView.getParent()) {
                    ((ViewGroup)this.mSeatView.getParent()).removeView((View)this.mSeatView);
                }
                holderView.inflate((View)this.mSeatView);
            }
            ((RadioTopBarPresenter)topPresenter).addLockUpdateListener(this.lockChangeListener);
        }
    }

    protected RadioVideoSeatView createRadioVideoSeatView(Context context) {
        return new RadioVideoSeatView(context, this, this.mListener, (IChannel)this.mChannel, this.mPresenter);
    }

    @Nullable
    public View getSeatViewContainer() {
        BasePresenter topPresenter = this.mPresenter.getPresenter(TopPresenter.class);
        if (topPresenter instanceof RadioTopBarPresenter) {
            return ((RadioTopBarPresenter)topPresenter).getSeatView();
        }
        return null;
    }
}

