/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.radio.seat;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.content.Context;
import android.graphics.Paint;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.view.animation.Interpolator;
import android.widget.ImageView;
import android.widget.LinearLayout;
import androidx.interpolator.view.animation.LinearOutSlowInInterpolator;
import com.opensource.svgaplayer.hago.SVGAImageView;
import com.opensource.svgaplayer.hago.SVGAVideoEntity;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.callback.ICommonCallback;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.ui.press.PressAlpha;
import com.yy.appbase.ui.utils.AvatarUtils;
import com.yy.appbase.ui.widget.headframe.HeadFrameImageView;
import com.yy.appbase.ui.widget.waveview.WaveView;
import com.yy.base.event.kvo.KvoEventIntent;
import com.yy.base.event.kvo.KvoMethodAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.event.kvo.helper.KvoBinder;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.memoryrecycle.views.YYImageView;
import com.yy.base.memoryrecycle.views.YYLinearLayout;
import com.yy.base.memoryrecycle.views.YYRelativeLayout;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ColorUtils;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.YYImageUtils;
import com.yy.framework.core.ui.svga.ISvgaLoadCallback;
import com.yy.framework.core.ui.svga.SvgaLoader;
import com.yy.hiyo.channel.base.bean.RecommendEnterData;
import com.yy.hiyo.channel.base.hiido.FollowStatisHelper;
import com.yy.hiyo.channel.base.service.IChannel;
import com.yy.hiyo.channel.cbase.channelhiido.RadioUtils;
import com.yy.hiyo.channel.component.seat.bean.SeatItem;
import com.yy.hiyo.channel.plugins.radio.R;
import com.yy.hiyo.channel.plugins.radio.RadioUtil;
import com.yy.hiyo.channel.plugins.radio.audioeffect.RadioSoundData;
import com.yy.hiyo.channel.plugins.radio.audioeffect.RadioSoundItem;
import com.yy.hiyo.channel.plugins.radio.audioeffect.RadioSoundRawPlayer;
import com.yy.hiyo.channel.plugins.radio.audioeffect.RadioSoundScrollView;
import com.yy.hiyo.channel.plugins.radio.seat.IRadioSeatView;
import com.yy.hiyo.channel.plugins.radio.seat.IWrapperHandler;
import com.yy.hiyo.channel.plugins.radio.seat.RadioSeatPresenter;
import com.yy.hiyo.relation.base.IBooleanCallback;
import com.yy.hiyo.relation.base.IRelationService;
import com.yy.hiyo.relation.base.data.LoadState;
import com.yy.hiyo.relation.base.data.RelationInfo;
import com.yy.hiyo.relation.base.follow.FollowerUtils;
import java.util.LinkedHashMap;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class RadioSeatView
extends YYRelativeLayout
implements IRadioSeatView {
    private YYTextView mNick;
    private View mFollow;
    private View mSoundBtn;
    private View mSoundLayout;
    private View mCover;
    private View mSoundMore;
    private View mBottomLayout;
    private RecycleImageView mFollowIcon;
    private RecycleImageView mLogoTipIcon;
    private YYImageView mSpeakSilent;
    private YYImageView mNickIcon;
    private WaveView mSpeakAnim;
    private SVGAImageView mSpeakWave;
    private HeadFrameImageView mLogo;
    private YYLinearLayout mSoundListLayout;
    private RadioSoundScrollView mSoundScroll;
    private SeatItem mSeatItem;
    private boolean mIsFollowing;
    private boolean mIsSpeaking;
    private boolean mIsOwnerIn;
    private ObjectAnimator mFollowingAnim;
    private ObjectAnimator mFollowDismissAnim;
    private List<RadioSoundData> mSoundDataList;
    private RadioSoundRawPlayer mAudioPlayer;
    private RadioSeatPresenter.OnClickChannelOwnerListener mLogoClickListener;
    private IChannel mChannel;
    private Animation mSoundShowAnim;
    private Animation mSoundDismissAnim;
    private RelationInfo mRelation;
    private IWrapperHandler mWrapperHandler;
    private final KvoBinder mBinder = new KvoBinder((Object)this);

    public RadioSeatView(Context context, IWrapperHandler wrapperHandler, RadioSeatPresenter.OnClickChannelOwnerListener listener2, IChannel channel) {
        super(context);
        this.mWrapperHandler = wrapperHandler;
        this.mLogoClickListener = listener2;
        this.mChannel = channel;
        this.init();
    }

    public RadioSeatView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public RadioSeatView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
    }

    private void init() {
        this.mIsFollowing = false;
        this.mIsSpeaking = false;
        this.mIsOwnerIn = false;
        RadioSeatView.inflate((Context)this.getContext(), (int)R.layout.layout_channel_radio_seat, (ViewGroup)this);
        this.mFollow = this.findViewById(R.id.lcrlp_follow);
        this.mNick = (YYTextView)this.findViewById(R.id.lcrlp_nick);
        this.mNickIcon = (YYImageView)this.findViewById(R.id.lcrlp_nick_icon);
        this.mSoundBtn = this.findViewById(R.id.lcrlp_sound);
        this.mSoundLayout = this.findViewById(R.id.lcrlp_sound_layout);
        this.mCover = this.findViewById(R.id.lcrlp_cover);
        this.mSoundMore = this.findViewById(R.id.lcrlp_sound_more);
        this.mFollowIcon = (RecycleImageView)this.findViewById(R.id.lcrlp_follow_icon);
        this.mLogoTipIcon = (RecycleImageView)this.findViewById(R.id.lcrlp_tip_icon);
        this.mSpeakAnim = (WaveView)this.findViewById(R.id.lcrlp_speak_anim);
        this.mLogo = (HeadFrameImageView)this.findViewById(R.id.lcrlp_logo);
        this.mSoundListLayout = (YYLinearLayout)this.findViewById(R.id.lcrlp_sound_list_layout);
        this.mSpeakSilent = (YYImageView)this.findViewById(R.id.lcrlp_speak_silent);
        this.mSpeakWave = (SVGAImageView)this.findViewById(R.id.lcrlp_speak_wave);
        this.mSoundScroll = (RadioSoundScrollView)this.findViewById(R.id.lcrlp_sound_scroll);
        this.mBottomLayout = this.findViewById(R.id.lcrlp_bottom_layout);
        this.mSpeakAnim.setDuration(4000L);
        this.mSpeakAnim.setStyle(Paint.Style.FILL);
        this.mSpeakAnim.setMaxRadius((float)ResolutionUtils.dip2Px((float)40.0f));
        this.mSpeakAnim.setInterpolator((Interpolator)new LinearOutSlowInInterpolator());
        this.mSpeakAnim.setInitialRadius((float)ResolutionUtils.dip2Px((float)37.0f));
        this.mSpeakAnim.setColor(ColorUtils.parseColor((String)"#31FFDB"));
        this.mSpeakWave.setScaleType(ImageView.ScaleType.FIT_XY);
        this.initListener();
    }

    private void initListener() {
        this.mFollow.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (!(RadioSeatView.this.mIsFollowing || RadioSeatView.this.mRelation == null || RadioSeatView.this.mFollowDismissAnim != null && RadioSeatView.this.mFollowDismissAnim.isRunning() || RadioSeatView.this.mRelation.isFollow())) {
                    int enterType = 7;
                    RadioSeatView.this.follow(enterType);
                    LinkedHashMap<String, String> ext = new LinkedHashMap<String, String>();
                    ext.put("radio_model", "2");
                    RecommendEnterData recommendEnterData = (RecommendEnterData)RadioSeatView.this.mChannel.getEnterParam().getExtra("from_recommend_info", null);
                    if (recommendEnterData != null) {
                        ext.put("token", recommendEnterData.getToken());
                    } else if (RadioSeatView.this.mWrapperHandler.getShowingUid() == ((RadioSeatView)RadioSeatView.this).mChannel.getEnterParam().matchedUid && !FP.empty((CharSequence)RadioSeatView.this.mWrapperHandler.getPostId())) {
                        ext.put("token", RadioSeatView.this.mWrapperHandler.getPostToken());
                        ext.put("post_id", RadioSeatView.this.mWrapperHandler.getPostId());
                        ext.put("send_post_uid", "" + RadioSeatView.this.mWrapperHandler.getShowingUid());
                        ext.put("post_pg_source", RadioSeatView.this.mWrapperHandler.getPostPgSource());
                    }
                    FollowStatisHelper.reportFollowClickWithExt((long)RadioSeatView.this.mWrapperHandler.getShowingUid(), (String)RadioSeatView.this.mChannel.getChannelId(), (int)enterType, ext);
                }
            }
        });
        this.mSoundBtn.setOnClickListener(v -> {
            if (this.mSoundLayout.getVisibility() != 0) {
                this.showSoundLayout();
            } else {
                this.dismissSoundLayout();
            }
        });
        this.mLogo.setOnClickListener(v -> {
            long ownerUid = this.mWrapperHandler.getShowingUid();
            if (ownerUid == AccountUtil.getUid() && !this.mIsOwnerIn && this.mLogoClickListener != null) {
                this.mLogoClickListener.enterSit(1);
            } else if (this.mLogoClickListener != null) {
                this.mLogoClickListener.onShowProfile(ownerUid);
            }
        });
        this.mCover.setOnClickListener(v -> {
            long ownerUid = this.mWrapperHandler.getShowingUid();
            if (ownerUid == AccountUtil.getUid() && !this.mIsOwnerIn && this.mLogoClickListener != null) {
                this.mLogoClickListener.enterSit(1);
            } else if (this.mLogoClickListener != null) {
                this.mLogoClickListener.onShowProfile(ownerUid);
            }
        });
        this.mSoundMore.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                RadioSeatView.this.mSoundScroll.smoothScrollBy(RadioSeatView.this.mSoundListLayout.getWidth(), 0);
                RadioUtils.INSTANCE.reportSoundPanelScroll(RadioSeatView.this.mChannel.getChannelId());
            }
        });
        this.mSoundScroll.setOnSoundScrollChangeListenerr(new RadioSoundScrollView.OnSoundScrollChangeListener(){

            @Override
            public void onScrollChange(View v, int scrollX, int scrollY, int oldScrollX, int oldScrollY) {
                if (RadioSeatView.this.mSoundScroll.getScrollX() + RadioSeatView.this.mSoundScroll.getWidth() == RadioSeatView.this.mSoundListLayout.getWidth()) {
                    RadioSeatView.this.mSoundMore.setVisibility(4);
                } else {
                    RadioSeatView.this.mSoundMore.setVisibility(0);
                }
                RadioUtils.INSTANCE.reportSoundPanelScroll(RadioSeatView.this.mChannel.getChannelId());
            }
        });
    }

    private void follow(int enterType) {
        if (this.mIsFollowing) {
            return;
        }
        this.mIsFollowing = true;
        this.mFollowIcon.setBackgroundResource(R.drawable.icon_radio_following);
        if (this.mFollowingAnim == null) {
            this.mFollowingAnim = ObjectAnimator.ofFloat((Object)this.mFollowIcon, (String)"rotation", (float[])new float[]{360.0f});
            this.mFollowingAnim.setRepeatCount(-1);
        }
        this.mFollowingAnim.start();
        if (this.mRelation != null) {
            this.mRelation.setLoadState(LoadState.NONE);
            ((IRelationService)ServiceManagerProxy.getInstance().getService(IRelationService.class)).requestFollow(this.mRelation, FollowerUtils.INSTANCE.enterType2ePath(enterType + ""), (ICommonCallback)new IBooleanCallback(){

                public void onResult(boolean success) {
                    RadioSeatView.this.followResult(success);
                }
            });
        }
    }

    private void startFollowDismissAnim() {
        if (this.mFollowDismissAnim == null) {
            this.mFollowDismissAnim = ObjectAnimator.ofFloat((Object)this.mFollow, (String)"alpha", (float[])new float[]{1.0f, 0.0f});
            this.mFollowDismissAnim.setDuration(700L);
            this.mFollowDismissAnim.addListener(new Animator.AnimatorListener(){

                public void onAnimationStart(Animator animation) {
                }

                public void onAnimationEnd(Animator animation) {
                    RadioSeatView.this.mFollow.setVisibility(8);
                }

                public void onAnimationCancel(Animator animation) {
                    RadioSeatView.this.mFollow.setVisibility(8);
                }

                public void onAnimationRepeat(Animator animation) {
                }
            });
        }
        if (!this.mFollowDismissAnim.isRunning()) {
            this.mFollowDismissAnim.start();
        }
    }

    public void startSpeakAnim() {
        if (!this.isAttachToWindow() || !this.mIsOwnerIn || this.mIsSpeaking) {
            return;
        }
        this.mIsSpeaking = true;
        this.mSpeakAnim.start();
        this.mLogo.getCircleImageView().setBorderColor(ColorUtils.parseColor((String)"#38B95F"));
    }

    public void stopSpeakAnim() {
        if (!(this.isAttachToWindow() && this.mIsOwnerIn && this.mIsSpeaking)) {
            return;
        }
        this.mIsSpeaking = false;
        this.mLogo.getCircleImageView().setBorderColor(R.color.transparent);
    }

    private void showSoundLayout() {
        this.getSoundItemList();
        if (this.mAudioPlayer == null) {
            this.mAudioPlayer = new RadioSoundRawPlayer(new RadioSoundRawPlayer.IAudioPlayerStateObserver(){

                @Override
                public void onStateChanged(final RadioSoundRawPlayer.AudioPlayState state, final int rawId) {
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (!RadioSeatView.this.isAttachToWindow()) {
                                return;
                            }
                            block3: for (int i = 0; i < RadioSeatView.this.mSoundDataList.size(); ++i) {
                                if (((RadioSoundData)((RadioSeatView)RadioSeatView.this).mSoundDataList.get((int)i)).soundResId != rawId) continue;
                                switch (state) {
                                    case AUDIO_PLAY_STOP: 
                                    case AUDIO_PLAY_NONE: 
                                    case AUDIO_PLAY_COMPLETE: 
                                    case AUDIO_PLAY_ERROR: {
                                        ((RadioSoundItem)RadioSeatView.this.mSoundListLayout.getChildAt(i)).onStop();
                                        continue block3;
                                    }
                                }
                            }
                        }
                    });
                }
            });
        }
        if (this.mSoundListLayout.getChildCount() == 0) {
            for (int i = 0; i < this.mSoundDataList.size(); ++i) {
                RadioSoundItem item = new RadioSoundItem(this.getContext(), this.mSoundDataList.get(i), this.mAudioPlayer, this.mChannel.getChannelId());
                LinearLayout.LayoutParams ll = new LinearLayout.LayoutParams(-2, -2);
                ll.leftMargin = ResolutionUtils.dip2Px((float)15.0f);
                this.mSoundListLayout.addView((View)item, (ViewGroup.LayoutParams)ll);
            }
        }
        if (this.mSoundShowAnim == null) {
            this.mSoundShowAnim = AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.anim_show_radio_sound_layout);
            this.mSoundShowAnim.setAnimationListener(new Animation.AnimationListener(){

                public void onAnimationStart(Animation animation) {
                    RadioSeatView.this.mSoundBtn.setSelected(true);
                }

                public void onAnimationEnd(Animation animation) {
                    RadioSeatView.this.mBottomLayout.setVisibility(4);
                }

                public void onAnimationRepeat(Animation animation) {
                }
            });
        }
        if (this.mSoundLayout.getVisibility() != 0) {
            this.mSoundLayout.setVisibility(0);
            this.mSoundLayout.startAnimation(this.mSoundShowAnim);
        }
    }

    private void dismissSoundLayout() {
        if (this.mAudioPlayer != null) {
            this.mAudioPlayer.stop();
        }
        this.mBottomLayout.setVisibility(0);
        if (this.mSoundDismissAnim == null) {
            this.mSoundDismissAnim = AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.anim_dismiss_radio_sound_layout);
            this.mSoundDismissAnim.setAnimationListener(new Animation.AnimationListener(){

                public void onAnimationStart(Animation animation) {
                    RadioSeatView.this.mSoundBtn.setSelected(false);
                }

                public void onAnimationEnd(Animation animation) {
                    RadioSeatView.this.mSoundLayout.setVisibility(8);
                }

                public void onAnimationRepeat(Animation animation) {
                }
            });
        }
        if (this.mSoundLayout.getVisibility() != 8) {
            this.mSoundLayout.startAnimation(this.mSoundDismissAnim);
        }
        RadioUtils.INSTANCE.reportCloseSound(this.mChannel.getChannelId());
    }

    public void updateSeat(SeatItem seatItem) {
        this.mSeatItem = seatItem;
        if (seatItem == null || seatItem.uid == 0L) {
            this.mIsOwnerIn = false;
            this.mLogoTipIcon.setImageResource(R.drawable.icon_radio_owner_not_in);
            this.mLogoTipIcon.setVisibility(0);
            this.mCover.setVisibility(0);
            this.mSpeakSilent.setVisibility(0);
            this.mSpeakSilent.setImageResource(R.drawable.bg_radio_owner_leave);
            this.mSpeakWave.stopAnimation();
            this.mNick.setText(R.string.tips_channel_radio_owner_not_in);
            this.mNickIcon.setVisibility(8);
            this.mFollow.setVisibility(8);
            this.dismissSoundLayout();
            this.mSoundBtn.setVisibility(8);
            this.mBinder.clearAllKvoConnections();
        } else {
            this.mIsOwnerIn = true;
            this.mCover.setVisibility(8);
            this.mNick.setText((CharSequence)seatItem.userInfo.nick);
            this.mNickIcon.setVisibility(0);
            if (this.mChannel.getRoleService().isOwner(seatItem.uid)) {
                this.mNickIcon.setImageResource(R.drawable.icon_seat_host);
            } else {
                this.mNickIcon.setImageResource(R.drawable.icon_room_host);
            }
            if (seatItem.isMe()) {
                if (seatItem.isMicOpen()) {
                    this.mSoundBtn.setVisibility(0);
                } else {
                    this.dismissSoundLayout();
                }
                this.mFollow.setVisibility(8);
                if (this.mRelation != null) {
                    this.mBinder.clearAllKvoConnections();
                }
            } else {
                this.dismissSoundLayout();
                this.mSoundBtn.setVisibility(8);
                this.mBinder.clearAllKvoConnections();
                this.mRelation = ((IRelationService)ServiceManagerProxy.getInstance().getService(IRelationService.class)).getRelationLocal(seatItem.uid);
                this.mBinder.singleBindSourceTo((KvoSource)this.mRelation);
            }
            if (!seatItem.isMicOpen()) {
                this.mLogoTipIcon.setImageResource(R.drawable.icon_voiceoff);
                this.mLogoTipIcon.setVisibility(0);
                this.mSpeakWave.stopAnimation();
                this.mSpeakSilent.setVisibility(0);
                this.mSpeakSilent.setImageResource(R.drawable.bg_radio_wave_owner_in);
            } else {
                this.mLogoTipIcon.setVisibility(8);
                this.mSpeakSilent.setVisibility(8);
                if (!this.mSpeakWave.isAnimating()) {
                    SvgaLoader.load((SVGAImageView)this.mSpeakWave, (String)"channel_radio_wave.svga", (ISvgaLoadCallback)new ISvgaLoadCallback(){

                        public void onFinished(SVGAVideoEntity svgaVideoEntity) {
                            if (RadioSeatView.this.isAttachToWindow() && RadioSeatView.this.mIsOwnerIn) {
                                RadioSeatView.this.mSpeakWave.startAnimation();
                            }
                        }

                        public void onFailed(Exception e) {
                        }
                    });
                }
            }
        }
    }

    public View getLogoView() {
        return this.mLogo;
    }

    private void getSoundItemList() {
        if (this.mSoundDataList != null) {
            return;
        }
        this.mSoundDataList = RadioUtil.INSTANCE.getSoundItemList(this.getContext());
    }

    @KvoMethodAnnotation(name="relation", sourceClass=RelationInfo.class, thread=1)
    public void updateFollowStatus(KvoEventIntent event) {
        this.mRelation = (RelationInfo)event.source();
        if (!this.isAttachToWindow()) {
            return;
        }
        if (this.mFollowingAnim != null) {
            this.mFollowingAnim.end();
        }
        this.mFollowIcon.setBackgroundResource(R.drawable.icon_radio_follow);
        if (!this.mRelation.isFollow()) {
            this.mFollow.setVisibility(0);
            this.mFollow.setAlpha(1.0f);
        } else if (!(this.mFollowDismissAnim != null && this.mFollowDismissAnim.isRunning() || this.mIsFollowing)) {
            this.mFollow.setVisibility(8);
        }
    }

    private void followResult(boolean success) {
        if (success) {
            this.mIsFollowing = false;
            if (this.mFollowingAnim != null && this.isAttachToWindow()) {
                this.mFollowingAnim.end();
                this.mFollowIcon.setBackgroundResource(R.drawable.icon_radio_follow);
                this.startFollowDismissAnim();
            }
        } else {
            this.mIsFollowing = false;
            if (this.mFollowingAnim != null && this.isAttachToWindow()) {
                this.mFollowingAnim.end();
                this.mFollowIcon.setBackgroundResource(R.drawable.icon_radio_follow);
            }
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (null != this.mSeatItem && !this.mSeatItem.isMe()) {
            this.mBinder.clearAllKvoConnections();
            this.mRelation = ((IRelationService)ServiceManagerProxy.getInstance().getService(IRelationService.class)).getRelationLocal(this.mSeatItem.uid);
            this.mBinder.singleBindSourceTo((KvoSource)this.mRelation);
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.dismissSoundLayout();
        if (this.mAudioPlayer != null) {
            this.mAudioPlayer.releasePlayer();
            this.mAudioPlayer = null;
        }
        this.mSoundListLayout.removeAllViews();
        this.stopSpeakAnim();
        if (this.mFollowingAnim != null) {
            this.mFollowingAnim.end();
            this.mFollowingAnim = null;
        }
        this.mBinder.clearAllKvoConnections();
    }

    @Override
    public void setAvatarFrame(@Nullable String frameUrl) {
        if (!this.isAttachToWindow()) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)frameUrl)) {
            this.mLogo.setHeadFrame(null);
        } else {
            this.mLogo.setFrameWidthAndHeight(ResolutionUtils.dip2Px((float)70.0f));
            this.mLogo.setHeadFrame(frameUrl, 0.9f);
        }
    }

    @Override
    public void setAvatar(@Nullable String url, long uid, int sex) {
        if (url == null) {
            return;
        }
        this.mLogo.setTag((Object)uid);
        Object keyTag = this.mLogo.getTag(R.id.lcrlp_logo);
        if (url.equals(keyTag)) {
            return;
        }
        int defaultAvatar = AvatarUtils.getDefaultAvatar((int)sex);
        ImageLoader.Builder.obtain((RecycleImageView)this.mLogo.getCircleImageView(), (String)(url + YYImageUtils.getThumbnailPostfix((int)75))).placeholder(ResourceUtils.getDrawable((int)defaultAvatar)).error(defaultAvatar).load();
        this.mLogo.setTag(R.id.lcrlp_logo, (Object)url);
        PressAlpha.of((View)this.mLogo.getCircleImageView(), (float)1.0f);
    }
}

