/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.radio.seat;

import android.content.Context;
import android.view.View;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.data.UserInfoBean;
import com.yy.base.logger.MLog;
import com.yy.hiyo.channel.base.bean.ChannelDetailInfo;
import com.yy.hiyo.channel.base.service.IChannel;
import com.yy.hiyo.channel.cbase.context.IChannelPageContext;
import com.yy.hiyo.channel.component.profile.profilecard.base.ProfileCardPresenter;
import com.yy.hiyo.channel.plugins.radio.R;
import com.yy.hiyo.channel.plugins.radio.RadioContract;
import com.yy.hiyo.channel.plugins.radio.RadioNAB;
import com.yy.hiyo.channel.plugins.radio.end.RadioLiveEndPresenter;
import com.yy.hiyo.channel.plugins.radio.seat.BaseRadioSeatViewWrapper;
import com.yy.hiyo.channel.plugins.radio.seat.RadioSeatViewWrapper;
import com.yy.hiyo.channel.plugins.radio.seat.RadioVideoPkSeatViewWrapper;
import com.yy.hiyo.channel.plugins.radio.seat.RadioVideoSeatViewWrapper;
import com.yy.hiyo.channel.plugins.radio.video.VideoPkPresenter;
import com.yy.hiyo.channel.plugins.voiceroom.base.AbsRoomSeatPresenter;
import com.yy.hiyo.user.base.profilecard.OpenProfileFrom;

public class RadioSeatPresenter
extends AbsRoomSeatPresenter<BaseRadioSeatViewWrapper>
implements RadioContract.IRadio {
    private static final String TAG = "RadioSeatPresenter";
    private BaseRadioSeatViewWrapper mRadioWrapper;
    private BaseRadioSeatViewWrapper mVideoWrapper;
    protected OnAnchorSeatChangedListener mOnAnchorSeatChangedListener = new OnAnchorSeatChangedListener(){

        @Override
        public void onSeatAnchorChanged(Long uid) {
            if (RadioSeatPresenter.this.isDestroyed()) {
                return;
            }
            RadioSeatPresenter.this.seatAnchorChanged(uid);
        }

        @Override
        public void onUpdateUserInfo(UserInfoBean userInfo) {
            if (RadioSeatPresenter.this.isDestroyed()) {
                return;
            }
            RadioSeatPresenter.this.updateUserInfo(userInfo);
        }

        @Override
        public void onUpdateAvatarFrame(String frameUrl) {
            if (RadioSeatPresenter.this.isDestroyed()) {
                return;
            }
            RadioSeatPresenter.this.updateAvatarFrame(frameUrl);
        }
    };

    protected void seatAnchorChanged(Long uid) {
        if (!this.isGroupParty() && this.getShowingUid() != AccountUtil.getUid()) {
            if (uid <= 0L) {
                View endPage;
                if (this.getPage() != null && this.getPage().getPageView() != null && (endPage = this.getPage().getPageView().findViewById(R.id.liveEndPage)) != null) {
                    ((RadioLiveEndPresenter)this.getPresenter(RadioLiveEndPresenter.class)).setContainer(endPage);
                }
            } else {
                ((RadioLiveEndPresenter)this.getPresenter(RadioLiveEndPresenter.class)).dismissEndLivePage();
            }
        }
    }

    protected void updateUserInfo(UserInfoBean userInfo) {
        if (!this.isGroupParty() && this.getShowingUid() != AccountUtil.getUid()) {
            ((RadioLiveEndPresenter)this.getPresenter(RadioLiveEndPresenter.class)).setUserInfo(userInfo);
        }
    }

    protected void updateAvatarFrame(String frameUrl) {
        if (!this.isGroupParty() && this.getShowingUid() != AccountUtil.getUid()) {
            ((RadioLiveEndPresenter)this.getPresenter(RadioLiveEndPresenter.class)).setUserAvatarFrame(frameUrl);
        }
    }

    public long getShowingUid() {
        if (this.mVideoWrapper != null) {
            return this.mVideoWrapper.getShowingUid();
        }
        if (this.mRadioWrapper != null) {
            return this.mRadioWrapper.getShowingUid();
        }
        return 0L;
    }

    private boolean isGroupParty() {
        ChannelDetailInfo detailInfo = this.getChannel().getDataService().getChannelDetailInfo(null);
        return null == detailInfo || detailInfo.baseInfo.isGroupParty();
    }

    public void changeSeatView(boolean isVideoMode) {
        if (isVideoMode) {
            if (!(this.mSeatViewWrapper instanceof RadioVideoSeatViewWrapper)) {
                this.setSeatViewWrapper(this.getRadioVideoSeatViewWrapper());
            }
        } else {
            MLog.info((Object)TAG, (String)("mSeatViewWrapper:" + this.mSeatViewWrapper), (Object[])new Object[0]);
            if (!(this.mSeatViewWrapper instanceof RadioSeatViewWrapper)) {
                this.setSeatViewWrapper(this.getRadioSeatViewWrapper());
            }
        }
    }

    @Override
    public void onChangeRadioMode(boolean isOwner, int mode, boolean isVideo) {
        MLog.info((Object)TAG, (String)"changeVideoSeatViewMode: videoMode = %s", (Object[])new Object[]{mode});
        if (mode == 0) {
            this.setSeatVisibility(true);
            if (!(this.mSeatViewWrapper instanceof RadioSeatViewWrapper)) {
                this.setSeatViewWrapper(this.getRadioSeatViewWrapper());
            }
        } else if (mode == 1 || mode == 10 || mode == 11 || RadioNAB.INSTANCE.getVideoBarNAB((IChannel)this.getChannel())) {
            this.setSeatVisibility(true);
            MLog.info((Object)TAG, (String)("mSeatViewWrapper:" + this.mSeatViewWrapper), (Object[])new Object[0]);
            RadioVideoSeatViewWrapper wrapper = null;
            if (!(this.mSeatViewWrapper instanceof RadioVideoSeatViewWrapper)) {
                wrapper = (RadioVideoSeatViewWrapper)this.getRadioVideoSeatViewWrapper();
                this.setSeatViewWrapper(wrapper);
            } else {
                wrapper = (RadioVideoSeatViewWrapper)this.mSeatViewWrapper;
            }
            if (RadioNAB.INSTANCE.getVideoBarNAB((IChannel)this.getChannel())) {
                wrapper.changeSeatView((Context)((IChannelPageContext)this.getMvpContext()).getContext());
            }
        } else if (this.isLinkMicModel(mode)) {
            this.setSeatVisibility(false);
            if (!(this.mSeatViewWrapper instanceof RadioVideoPkSeatViewWrapper)) {
                this.setSeatViewWrapper(this.getRadioVideoSeatPkViewWrapper());
            }
        }
    }

    private boolean isLinkMicModel(int model2) {
        return model2 == 3 || model2 == 4 || model2 == 2 || model2 == 9 || model2 == 8 || model2 == 7;
    }

    protected BaseRadioSeatViewWrapper createSeatViewWrapper() {
        if (this.getChannel().getPluginService().getCurPluginData().isVideoMode()) {
            return this.getRadioVideoSeatViewWrapper();
        }
        return this.getRadioSeatViewWrapper();
    }

    private BaseRadioSeatViewWrapper getRadioSeatViewWrapper() {
        if (null == this.mRadioWrapper || !(this.mRadioWrapper instanceof RadioSeatViewWrapper)) {
            this.mRadioWrapper = new RadioSeatViewWrapper(new OnClickChannelOwnerListener(){

                @Override
                public void onShowProfile(long uid) {
                    ((ProfileCardPresenter)RadioSeatPresenter.this.getPresenter(ProfileCardPresenter.class)).showProfileCard(uid, true, OpenProfileFrom.FROM_SEAT);
                }

                @Override
                public void enterSit(int index) {
                    RadioSeatPresenter.this.onSitDown(index, null);
                }
            }, this.getChannel(), this.mOnAnchorSeatChangedListener);
        }
        return this.mRadioWrapper;
    }

    protected BaseRadioSeatViewWrapper getRadioVideoSeatViewWrapper() {
        if (null == this.mVideoWrapper || !(this.mVideoWrapper instanceof RadioVideoSeatViewWrapper)) {
            this.mVideoWrapper = new RadioVideoSeatViewWrapper(this.newOnClickChannelOwnerListener(), this.getChannel(), this, this.mOnAnchorSeatChangedListener);
        }
        return this.mVideoWrapper;
    }

    protected OnClickChannelOwnerListener newOnClickChannelOwnerListener() {
        return new OnClickChannelOwnerListener(){

            @Override
            public void onShowProfile(long uid) {
                ((ProfileCardPresenter)RadioSeatPresenter.this.getPresenter(ProfileCardPresenter.class)).showProfileCard(uid, true, OpenProfileFrom.FROM_SEAT);
            }

            @Override
            public void enterSit(int index) {
                RadioSeatPresenter.this.onSitDown(index, null);
            }
        };
    }

    private BaseRadioSeatViewWrapper getRadioVideoSeatPkViewWrapper() {
        if (null == this.mVideoWrapper || !(this.mVideoWrapper instanceof RadioVideoPkSeatViewWrapper)) {
            this.mVideoWrapper = new RadioVideoPkSeatViewWrapper(new RadioVideoPkSeatViewWrapper.IPkVidoSeatCallback(){

                @Override
                public int[] getPkOwnerSeat(boolean isAbsolute) {
                    return ((VideoPkPresenter)RadioSeatPresenter.this.getPresenter(VideoPkPresenter.class)).getOwnerSeat(isAbsolute);
                }

                @Override
                public void setOnLayoutChangeListener(View.OnLayoutChangeListener listener2) {
                    ((VideoPkPresenter)RadioSeatPresenter.this.getPresenter(VideoPkPresenter.class)).setOnLayoutChangeListener(listener2);
                }
            }, this.getChannel(), this.mOnAnchorSeatChangedListener);
        }
        return this.mVideoWrapper;
    }

    public void onDestroy() {
        super.onDestroy();
        if (this.mSeatViewWrapper != null) {
            ((BaseRadioSeatViewWrapper)this.mSeatViewWrapper).destroy();
        }
        this.mRadioWrapper = null;
        this.mVideoWrapper = null;
        this.mOnAnchorSeatChangedListener = null;
    }

    public boolean isSupportFollowScanAnim() {
        return true;
    }

    public static interface OnAnchorSeatChangedListener {
        public void onSeatAnchorChanged(Long var1);

        public void onUpdateUserInfo(UserInfoBean var1);

        public void onUpdateAvatarFrame(String var1);
    }

    public static interface OnClickChannelOwnerListener {
        public void onShowProfile(long var1);

        public void enterSit(int var1);
    }
}

