/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.radio.screenrecord.impl;

import android.media.MediaCodec;
import android.media.MediaFormat;
import android.media.MediaMuxer;
import androidx.annotation.RequiresApi;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import java.io.File;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.LinkedList;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000 &2\u00020\u0001:\u0002&'B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0014J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0002J0\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020\u0006H\u0002J\u000e\u0010 \u001a\u00020\u00192\u0006\u0010!\u001a\u00020\"J\u0006\u0010#\u001a\u00020\u0006J\b\u0010$\u001a\u00020\u0019H\u0002J(\u0010%\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u0016H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/yy/hiyo/channel/plugins/radio/screenrecord/impl/VideoMuxerWrapper;", "", "()V", "mAudioTraceIndex", "", "mHadMuxerStarted", "", "mMuxer", "Landroid/media/MediaMuxer;", "mOnlyVideoTrace", "getMOnlyVideoTrace", "()Z", "setMOnlyVideoTrace", "(Z)V", "mVideoTraceIndex", "pendingTraceDatas", "Ljava/util/LinkedList;", "Lcom/yy/hiyo/channel/plugins/radio/screenrecord/impl/VideoMuxerWrapper$MediaTrackData;", "addTrack", "format", "Landroid/media/MediaFormat;", "copy", "Landroid/media/MediaCodec$BufferInfo;", "bufferInfo", "performWriteSampleData", "", "trackIndex", "codec", "Landroid/media/MediaCodec;", "index", "info", "discard", "prepareMuxer", "file", "Ljava/io/File;", "releaseMuxer", "signalStop", "writeMediaCodecBufferData", "Companion", "MediaTrackData", "radio_release"})
@RequiresApi(value=21)
public final class VideoMuxerWrapper {
    private MediaMuxer mMuxer;
    private boolean mHadMuxerStarted;
    private int mVideoTraceIndex = -1;
    private int mAudioTraceIndex = -1;
    private boolean mOnlyVideoTrace;
    private final LinkedList<MediaTrackData> pendingTraceDatas = new LinkedList();
    private static final int INVALID_TRACE_INDEX = -1;
    @NotNull
    public static final String TAG = "VideoMuxerWrapper";
    public static final Companion Companion = new Companion(null);

    public final boolean getMOnlyVideoTrace() {
        return this.mOnlyVideoTrace;
    }

    public final void setMOnlyVideoTrace(boolean bl) {
        this.mOnlyVideoTrace = bl;
    }

    public final void prepareMuxer(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        this.mMuxer = new MediaMuxer(file.getAbsolutePath(), 0);
        this.pendingTraceDatas.clear();
    }

    public final int addTrack(@NotNull MediaFormat format) {
        Intrinsics.checkParameterIsNotNull((Object)format, (String)"format");
        MediaMuxer muxer = this.mMuxer;
        if (muxer == null) {
            MLog.error((Object)TAG, (String)"No Prepare Muxer??", (Object[])new Object[0]);
            return -1;
        }
        int trackId = muxer.addTrack(format);
        String mime = format.getString("mime");
        if (mime != null) {
            if (StringsKt.startsWith$default((String)mime, (String)"video/", (boolean)false, (int)2, null)) {
                this.mVideoTraceIndex = trackId;
            } else if (StringsKt.startsWith$default((String)mime, (String)"audio/", (boolean)false, (int)2, null)) {
                this.mAudioTraceIndex = trackId;
            } else {
                MLog.info((Object)TAG, (String)("addTrack Failed Invalid " + mime + ' '), (Object[])new Object[0]);
                return -1;
            }
        }
        MLog.info((Object)TAG, (String)("addTrack " + mime + " --> " + trackId), (Object[])new Object[0]);
        if (!this.mHadMuxerStarted && this.mVideoTraceIndex >= 0 && (this.mAudioTraceIndex >= 0 || this.mOnlyVideoTrace)) {
            muxer.start();
            while (true) {
                Collection collection = this.pendingTraceDatas;
                boolean bl = false;
                if (!(!collection.isEmpty())) break;
                MediaTrackData data = this.pendingTraceDatas.poll();
                this.performWriteSampleData(data.getTrackIndex(), data.getCodec(), data.getIndex(), data.getInfo(), false);
            }
            this.mHadMuxerStarted = true;
        }
        return trackId;
    }

    @RequiresApi(value=21)
    public final void writeMediaCodecBufferData(int trackIndex, @NotNull MediaCodec codec, int index, @NotNull MediaCodec.BufferInfo info) {
        Intrinsics.checkParameterIsNotNull((Object)codec, (String)"codec");
        Intrinsics.checkParameterIsNotNull((Object)info, (String)"info");
        MediaMuxer muxer = this.mMuxer;
        if (muxer == null) {
            this.performWriteSampleData(trackIndex, codec, index, info, true);
            return;
        }
        if (!this.mHadMuxerStarted) {
            MediaCodec.BufferInfo copyBufferInfo = this.copy(info);
            MediaTrackData traceData = new MediaTrackData(trackIndex, codec, index, copyBufferInfo);
            this.pendingTraceDatas.add(traceData);
            return;
        }
        while (true) {
            Collection copyBufferInfo = this.pendingTraceDatas;
            boolean bl = false;
            if (!(!copyBufferInfo.isEmpty())) break;
            MediaTrackData data = this.pendingTraceDatas.poll();
            this.performWriteSampleData(data.getTrackIndex(), data.getCodec(), data.getIndex(), data.getInfo(), false);
        }
        this.performWriteSampleData(trackIndex, codec, index, info, false);
    }

    private final void performWriteSampleData(int trackIndex, MediaCodec codec, int index, MediaCodec.BufferInfo info, boolean discard) {
        ByteBuffer byteBuffer = codec.getOutputBuffer(index);
        if (byteBuffer == null) {
            throw (Throwable)new RuntimeException("encoderBuffer " + index + " was null");
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)byteBuffer, (String)"codec.getOutputBuffer(in\u2026rBuffer $index was null\")");
        ByteBuffer encodedData = byteBuffer;
        if ((info.flags & 2) != 0) {
            info.size = 0;
        }
        if (info.size != 0 && !discard) {
            encodedData.position(info.offset);
            encodedData.limit(info.offset + info.size);
            try {
                MediaMuxer mediaMuxer = this.mMuxer;
                if (mediaMuxer != null) {
                    mediaMuxer.writeSampleData(trackIndex, encodedData, info);
                }
            }
            catch (Throwable e) {
                MLog.error((Object)TAG, (String)("writeSampleData Error " + trackIndex + ' '), (Throwable)e, (Object[])new Object[0]);
            }
        }
        codec.releaseOutputBuffer(index, false);
        if (RuntimeContext.sIsDebuggable) {
            MLog.debug((Object)TAG, (String)("write " + trackIndex + ' ' + discard + " Index: " + index + " Flag:" + info.flags + "  " + info.presentationTimeUs), (Object[])new Object[0]);
        }
    }

    private final void signalStop() {
        MediaCodec.BufferInfo bufferInfo = new MediaCodec.BufferInfo();
        ByteBuffer data = ByteBuffer.allocate(0);
        bufferInfo.set(0, 0, 0L, 4);
        if (this.mVideoTraceIndex != -1) {
            MediaMuxer mediaMuxer = this.mMuxer;
            if (mediaMuxer != null) {
                mediaMuxer.writeSampleData(this.mVideoTraceIndex, data, bufferInfo);
            }
            MLog.info((Object)TAG, (String)("Signal Video Stop " + this.mVideoTraceIndex), (Object[])new Object[0]);
            this.mVideoTraceIndex = -1;
        }
        if (this.mAudioTraceIndex != -1) {
            MediaMuxer mediaMuxer = this.mMuxer;
            if (mediaMuxer != null) {
                mediaMuxer.writeSampleData(this.mAudioTraceIndex, data, bufferInfo);
            }
            MLog.info((Object)TAG, (String)("Signal Audio Stop " + this.mAudioTraceIndex), (Object[])new Object[0]);
            this.mAudioTraceIndex = -1;
        }
    }

    public final boolean releaseMuxer() {
        boolean result = true;
        this.signalStop();
        if (this.mHadMuxerStarted) {
            try {
                MediaMuxer mediaMuxer = this.mMuxer;
                if (mediaMuxer != null) {
                    mediaMuxer.stop();
                }
            }
            catch (Throwable e) {
                MLog.error((Object)TAG, (String)"Close Muxer", (Throwable)e, (Object[])new Object[0]);
                result = false;
            }
            try {
                MediaMuxer mediaMuxer = this.mMuxer;
                if (mediaMuxer != null) {
                    mediaMuxer.release();
                }
            }
            catch (Throwable e) {
                MLog.error((Object)TAG, (String)"release Muxer", (Throwable)e, (Object[])new Object[0]);
                result = false;
            }
            this.mMuxer = null;
        }
        this.pendingTraceDatas.clear();
        this.mHadMuxerStarted = false;
        MLog.info((Object)TAG, (String)("Release Muxer " + result), (Object[])new Object[0]);
        return result;
    }

    private final MediaCodec.BufferInfo copy(MediaCodec.BufferInfo bufferInfo) {
        MediaCodec.BufferInfo info = new MediaCodec.BufferInfo();
        info.set(bufferInfo.offset, bufferInfo.size, bufferInfo.presentationTimeUs, bufferInfo.flags);
        return info;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\bH\u00c6\u0003J1\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\r\u00a8\u0006\u001c"}, d2={"Lcom/yy/hiyo/channel/plugins/radio/screenrecord/impl/VideoMuxerWrapper$MediaTrackData;", "", "trackIndex", "", "codec", "Landroid/media/MediaCodec;", "index", "info", "Landroid/media/MediaCodec$BufferInfo;", "(ILandroid/media/MediaCodec;ILandroid/media/MediaCodec$BufferInfo;)V", "getCodec", "()Landroid/media/MediaCodec;", "getIndex", "()I", "getInfo", "()Landroid/media/MediaCodec$BufferInfo;", "getTrackIndex", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toString", "", "radio_release"})
    public static final class MediaTrackData {
        private final int trackIndex;
        @NotNull
        private final MediaCodec codec;
        private final int index;
        @NotNull
        private final MediaCodec.BufferInfo info;

        public final int getTrackIndex() {
            return this.trackIndex;
        }

        @NotNull
        public final MediaCodec getCodec() {
            return this.codec;
        }

        public final int getIndex() {
            return this.index;
        }

        @NotNull
        public final MediaCodec.BufferInfo getInfo() {
            return this.info;
        }

        public MediaTrackData(int trackIndex, @NotNull MediaCodec codec, int index, @NotNull MediaCodec.BufferInfo info) {
            Intrinsics.checkParameterIsNotNull((Object)codec, (String)"codec");
            Intrinsics.checkParameterIsNotNull((Object)info, (String)"info");
            this.trackIndex = trackIndex;
            this.codec = codec;
            this.index = index;
            this.info = info;
        }

        public final int component1() {
            return this.trackIndex;
        }

        @NotNull
        public final MediaCodec component2() {
            return this.codec;
        }

        public final int component3() {
            return this.index;
        }

        @NotNull
        public final MediaCodec.BufferInfo component4() {
            return this.info;
        }

        @NotNull
        public final MediaTrackData copy(int trackIndex, @NotNull MediaCodec codec, int index, @NotNull MediaCodec.BufferInfo info) {
            Intrinsics.checkParameterIsNotNull((Object)codec, (String)"codec");
            Intrinsics.checkParameterIsNotNull((Object)info, (String)"info");
            return new MediaTrackData(trackIndex, codec, index, info);
        }

        public static /* synthetic */ MediaTrackData copy$default(MediaTrackData mediaTrackData, int n, MediaCodec mediaCodec, int n2, MediaCodec.BufferInfo bufferInfo, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = mediaTrackData.trackIndex;
            }
            if ((n3 & 2) != 0) {
                mediaCodec = mediaTrackData.codec;
            }
            if ((n3 & 4) != 0) {
                n2 = mediaTrackData.index;
            }
            if ((n3 & 8) != 0) {
                bufferInfo = mediaTrackData.info;
            }
            return mediaTrackData.copy(n, mediaCodec, n2, bufferInfo);
        }

        @NotNull
        public String toString() {
            return "MediaTrackData(trackIndex=" + this.trackIndex + ", codec=" + this.codec + ", index=" + this.index + ", info=" + this.info + ")";
        }

        public int hashCode() {
            MediaCodec mediaCodec = this.codec;
            MediaCodec.BufferInfo bufferInfo = this.info;
            return ((this.trackIndex * 31 + (mediaCodec != null ? mediaCodec.hashCode() : 0)) * 31 + this.index) * 31 + (bufferInfo != null ? bufferInfo.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof MediaTrackData)) break block3;
                    MediaTrackData mediaTrackData = (MediaTrackData)object;
                    if (this.trackIndex != mediaTrackData.trackIndex || !Intrinsics.areEqual((Object)this.codec, (Object)mediaTrackData.codec) || this.index != mediaTrackData.index || !Intrinsics.areEqual((Object)this.info, (Object)mediaTrackData.info)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/yy/hiyo/channel/plugins/radio/screenrecord/impl/VideoMuxerWrapper$Companion;", "", "()V", "INVALID_TRACE_INDEX", "", "TAG", "", "radio_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

