/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.radio.audioeffect;

import android.content.Context;
import android.text.TextUtils;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.filestorage.FileStorageUtils;
import com.yy.hiyo.voice.base.channelvoice.IEngineAudioPlayer;
import com.yy.hiyo.voice.base.channelvoice.IKtvLiveServiceExtend;
import com.yy.hiyo.voice.base.channelvoice.IRtcEnginer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class RadioSoundRawPlayer {
    private static final String TAG = "RadioSoundRawPlayer";
    private IAudioPlayerStateObserver mAudioPlayerStateHandler;
    private int mRawId = -1;
    private IRtcEnginer mRtcEngine;
    private IEngineAudioPlayer mAudioPlayer = null;

    public RadioSoundRawPlayer(IAudioPlayerStateObserver handler) {
        this.mAudioPlayerStateHandler = handler;
        this.mRtcEngine = ((IKtvLiveServiceExtend)ServiceManagerProxy.getServiceManager().getService(IKtvLiveServiceExtend.class)).getRtcEngineEx();
    }

    public synchronized void startPlay(final Context context, final int rawId, final String name) {
        this.stop();
        this.mRawId = rawId;
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                RadioSoundRawPlayer.this.doStart(context, rawId, name);
            }
        });
    }

    private synchronized void doStart(Context context, int rawId, String name) {
        String path = this.writeRawToFile(context, rawId, name);
        if (TextUtils.isEmpty((CharSequence)path)) {
            this.onPlayError(rawId);
            return;
        }
        this.createAudioPlayer();
        boolean isOpenSucceed = this.mAudioPlayer.open(path);
        MLog.info((Object)"fileplay", (String)"isOpen:%b, path:%s", (Object[])new Object[]{isOpenSucceed, path});
        if (isOpenSucceed) {
            ((IKtvLiveServiceExtend)ServiceManagerProxy.getServiceManager().getService(IKtvLiveServiceExtend.class)).enablePublishAudio(2);
            this.mAudioPlayer.enablePublish(true);
            this.mAudioPlayer.play();
            this.onPlayStart(rawId);
        } else {
            this.onPlayError(rawId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized String writeRawToFile(Context context, int rawId, String name) {
        InputStream is = null;
        FileOutputStream fos = null;
        File file = null;
        byte[] buffer = new byte[4096];
        try {
            int bytes;
            File directory = new File(FileStorageUtils.getInstance().getInternalCacheRootDir() + "/sound");
            if (!directory.exists()) {
                directory.mkdirs();
            }
            if ((file = new File(directory.getAbsolutePath() + "/" + name)).exists()) {
                String string2 = file.getAbsolutePath();
                return string2;
            }
            if (!file.createNewFile()) {
                String string3 = null;
                return string3;
            }
            is = context.getResources().openRawResource(rawId);
            fos = new FileOutputStream(file);
            while ((bytes = is.read(buffer)) != -1) {
                fos.write(buffer, 0, bytes);
            }
        }
        catch (IOException e) {
            String string4 = null;
            return string4;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
                if (fos != null) {
                    fos.close();
                }
            }
            catch (Exception exception) {}
        }
        if (file == null) {
            return null;
        }
        String string5 = file.getAbsolutePath();
        return string5;
    }

    public synchronized void releasePlayer() {
        if (this.mAudioPlayer != null) {
            MLog.info((Object)TAG, (String)"releasePlayer", (Object[])new Object[0]);
            this.mAudioPlayer.stop();
            this.mRtcEngine.destroyAudioFilePlayer(this.mAudioPlayer);
            this.mAudioPlayer = null;
        }
        this.mAudioPlayerStateHandler = null;
    }

    public synchronized void stop() {
        if (this.mAudioPlayer != null) {
            this.mAudioPlayer.stop();
        }
        this.onPlayStop(this.mRawId);
    }

    private void createAudioPlayer() {
        if (this.mAudioPlayer == null) {
            this.mAudioPlayer = this.mRtcEngine.createAudioFilePlayer();
            MLog.info((Object)TAG, (String)"createAudioPlayer", (Object[])new Object[0]);
            this.mAudioPlayer.setPlayerNotify(new IEngineAudioPlayer.NotifyCallback(){

                public void onAudioFilePlayEnd() {
                    MLog.info((Object)RadioSoundRawPlayer.TAG, (String)("onAudioFilePlayEnd" + RadioSoundRawPlayer.this.mRawId), (Object[])new Object[0]);
                    RadioSoundRawPlayer.this.onPlayComplete(RadioSoundRawPlayer.this.mRawId);
                }

                public void onAudioFileVolume(long volume, long currentMs, long totalMs) {
                }
            });
        }
    }

    private void onPlayStart(int rawId) {
        if (this.mRawId != rawId) {
            return;
        }
        if (this.mAudioPlayerStateHandler != null && rawId != -1) {
            this.mAudioPlayerStateHandler.onStateChanged(AudioPlayState.AUDIO_PLAY_START, rawId);
        }
    }

    private void onPlayError(int rawId) {
        if (this.mRawId != rawId) {
            return;
        }
        if (this.mAudioPlayerStateHandler != null && rawId != -1) {
            this.mAudioPlayerStateHandler.onStateChanged(AudioPlayState.AUDIO_PLAY_ERROR, rawId);
        }
        this.mRawId = -1;
        this.mAudioPlayer = null;
    }

    private void onPlayComplete(int rawId) {
        if (this.mRawId != rawId) {
            return;
        }
        if (this.mAudioPlayerStateHandler != null && rawId != -1) {
            this.mAudioPlayerStateHandler.onStateChanged(AudioPlayState.AUDIO_PLAY_COMPLETE, rawId);
        }
        this.mRawId = -1;
    }

    private void onPlayStop(int rawId) {
        if (this.mRawId != rawId) {
            return;
        }
        if (this.mAudioPlayerStateHandler != null && rawId != -1) {
            this.mAudioPlayerStateHandler.onStateChanged(AudioPlayState.AUDIO_PLAY_STOP, rawId);
        }
        this.mRawId = -1;
    }

    public static interface IAudioPlayerStateObserver {
        public void onStateChanged(AudioPlayState var1, int var2);
    }

    public static enum AudioPlayState {
        AUDIO_PLAY_NONE,
        AUDIO_PLAY_START,
        AUDIO_PLAY_STOP,
        AUDIO_PLAY_COMPLETE,
        AUDIO_PLAY_ERROR;

    }
}

