/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.radio.audioeffect;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.opensource.svgaplayer.hago.SVGAImageView;
import com.opensource.svgaplayer.hago.SVGAVideoEntity;
import com.yy.appbase.ui.widget.image.CircleImageView;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYRelativeLayout;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.framework.core.ui.svga.ISvgaLoadCallback;
import com.yy.framework.core.ui.svga.SvgaLoader;
import com.yy.hiyo.channel.cbase.channelhiido.RadioUtils;
import com.yy.hiyo.channel.plugins.radio.R;
import com.yy.hiyo.channel.plugins.radio.audioeffect.RadioSoundData;
import com.yy.hiyo.channel.plugins.radio.audioeffect.RadioSoundRawPlayer;

public class RadioSoundItem
extends YYRelativeLayout {
    private YYTextView mName;
    private SVGAImageView mAnim;
    private CircleImageView mImage;
    private View mCover;
    private boolean mIsPlaying;
    private RadioSoundData mData;
    private RadioSoundRawPlayer mPlayer;
    private String mChannelId;

    public RadioSoundItem(Context context, RadioSoundData data, RadioSoundRawPlayer player, String channelId) {
        super(context);
        this.mChannelId = channelId;
        this.mData = data;
        this.mPlayer = player;
        this.init();
    }

    private void init() {
        this.mIsPlaying = false;
        RadioSoundItem.inflate((Context)this.getContext(), (int)R.layout.layout_channel_radio_sound_item, (ViewGroup)this);
        this.mImage = (CircleImageView)this.findViewById(R.id.lcrsi_image);
        this.mName = (YYTextView)this.findViewById(R.id.lcrsi_name);
        this.mAnim = (SVGAImageView)this.findViewById(R.id.lcrsi_anim);
        this.mCover = this.findViewById(R.id.lcrsi_cover);
        this.mName.setText((CharSequence)this.mData.name);
        this.mImage.setImageResource(this.mData.iconResId);
        this.setOnClickListener(v -> {
            if (this.mIsPlaying) {
                this.mPlayer.stop();
                this.onStop();
            } else {
                this.startPlay();
            }
        });
    }

    public void setIamgeSize(int size) {
        RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams)this.mImage.getLayoutParams();
        params.width = size;
        params.height = size;
        this.mImage.setLayoutParams((ViewGroup.LayoutParams)params);
    }

    public void setTextColor(int color2) {
        this.mName.setTextColor(color2);
    }

    private void startPlay() {
        if (this.mIsPlaying) {
            return;
        }
        this.mIsPlaying = true;
        this.mPlayer.startPlay(this.getContext(), this.mData.soundResId, this.mData.fileName);
        this.mCover.setVisibility(0);
        this.mAnim.setVisibility(0);
        if (!this.mAnim.isAnimating()) {
            SvgaLoader.load((SVGAImageView)this.mAnim, (String)"channel_radio_sound_play.svga", (ISvgaLoadCallback)new ISvgaLoadCallback(){

                public void onFinished(SVGAVideoEntity svgaVideoEntity) {
                    if (RadioSoundItem.this.isAttachToWindow() && RadioSoundItem.this.mIsPlaying) {
                        RadioSoundItem.this.mAnim.startAnimation();
                    }
                }

                public void onFailed(Exception e) {
                }
            });
        }
        MLog.info((Object)"RadioSoundItem", (String)("sound click channelId " + this.mChannelId + "---soundId : " + this.mData.soundId), (Object[])new Object[0]);
        RadioUtils.INSTANCE.reportPlaySound(this.mChannelId, this.mData.soundId);
    }

    public void onStop() {
        if (!this.mIsPlaying) {
            return;
        }
        this.mIsPlaying = false;
        this.mAnim.stopAnimation();
        this.mAnim.setVisibility(8);
        this.mCover.setVisibility(8);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.onStop();
    }
}

