/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.radio;

import android.os.Message;
import androidx.annotation.NonNull;
import androidx.lifecycle.MutableLiveData;
import com.yy.appbase.AppbaseMsgDef;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.floatnotice.FloatNoticeInfo;
import com.yy.appbase.floatnotice.IFloatNoticeListener;
import com.yy.appbase.floatnotice.ImageIcon;
import com.yy.appbase.floatnotice.TextStyle;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.ui.toast.GloatToastUtils;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.framework.core.INotify;
import com.yy.framework.core.MsgDispatcher;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.hago.media.MEAudienceLinkMic;
import com.yy.hago.media.MEBizCode;
import com.yy.hago.media.MEVideoPK;
import com.yy.hago.media.MediaEntity;
import com.yy.hiyo.channel.ChannelNotifyDef;
import com.yy.hiyo.channel.base.EnterParam;
import com.yy.hiyo.channel.base.bean.SeatUser;
import com.yy.hiyo.channel.base.bean.plugins.ChannelPluginData;
import com.yy.hiyo.channel.base.bean.video.LiveVideoStreamInfo;
import com.yy.hiyo.channel.base.service.IChannel;
import com.yy.hiyo.channel.base.service.ISeatUpdateListener;
import com.yy.hiyo.channel.base.service.plugin.IPluginService;
import com.yy.hiyo.channel.cbase.context.IChannelPageContext;
import com.yy.hiyo.channel.cbase.context.pagelifecycle.IPageLifeCycle;
import com.yy.hiyo.channel.cbase.module.lunmic.ILunMicPresenter;
import com.yy.hiyo.channel.cbase.module.radio.live.OnLinkMicTypeChangedListener;
import com.yy.hiyo.channel.cbase.module.radio.live.VideoStreamCallback;
import com.yy.hiyo.channel.common.FacePoint;
import com.yy.hiyo.channel.component.bottombar.ChannelToolsPresenter;
import com.yy.hiyo.channel.component.debug.DebugPresenter;
import com.yy.hiyo.channel.component.theme.ThemePresenter;
import com.yy.hiyo.channel.component.theme.model.DrawableResThemeBean;
import com.yy.hiyo.channel.module.main.enter.LoadingBgHellper;
import com.yy.hiyo.channel.module.recommend.base.bean.MiniInfo;
import com.yy.hiyo.channel.plugins.radio.DR;
import com.yy.hiyo.channel.plugins.radio.R;
import com.yy.hiyo.channel.plugins.radio.RadioPage;
import com.yy.hiyo.channel.plugins.radio.RadioPresenter;
import com.yy.hiyo.channel.plugins.radio.video.UserLinkMicPresenter;
import com.yy.hiyo.channel.plugins.radio.video.VideoPresenter;
import com.yy.hiyo.channel.plugins.radio.video.live.RadioPlayCallback;
import com.yy.hiyo.channel.plugins.radio.video.live.RadioPlayPresenter;
import com.yy.hiyo.channel.plugins.voiceroom.plugin.AbsPluginPresenter;
import com.yy.hiyo.im.ImBaseMsgDef;
import com.yy.hiyo.mvp.base.callback.IDestroyable;
import com.yy.hiyo.mvp.base.callback.WeakRunnable;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.IProtoNotify;
import com.yy.hiyo.voice.base.channelvoice.IKtvLiveServiceExtend;
import com.yy.hiyo.voice.base.channelvoice.OnRecvMediaExtraInfoListener;
import java.util.List;
import java.util.Map;
import net.ihago.channel.srv.carousel.Notify;
import net.ihago.channel.srv.carousel.ShowStartNotify;
import net.ihago.channel.srv.carousel.Uri;
import net.ihago.channel.srv.mgr.JoinMicStatus;
import net.ihago.channel.srv.mgr.JoinMicType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RadioNewPresenter
extends AbsPluginPresenter
implements INotify {
    private static final int THEME_UNKNOWN = 0;
    private static final int THEME_VIDEO_PK = 1;
    private static final int THEME_USER_LINK_MIC = 2;
    private Runnable mThemeDelayRunnable = null;
    private RadioPlayPresenter mPlayPresenter;
    private IPluginService.IPluginDataChangedCallBack pluginCallBack;
    private ICallBack myStepCallback;
    private boolean isResetTheme = false;
    private boolean needPreLinkMicVideoSize = true;
    private int mCurrentTheme = 0;
    private ISeatUpdateListener iSeatUpdateListener = null;
    private OnRecvMediaExtraInfoListener mOnRecvMediaExtraInfoListener = (uid, info) -> this.recvMediaExtraInfo(uid, info);
    private final IProtoNotify<Notify> mCarouselNotify = new IProtoNotify<Notify>(){

        public String serviceName() {
            return "net.ihago.channel.srv.carousel";
        }

        public void onNotify(@NonNull Notify notify) {
            List uris = notify.uris;
            if (uris != null && uris.size() > 0) {
                for (Integer uri : uris) {
                    if (uri == null || uri.intValue() != Uri.UriShowStart.getValue()) continue;
                    RadioNewPresenter.this.handlerShowStartNotify(notify.show_start_notify);
                }
            }
        }
    };

    public void init(ICallBack callBack) {
        this.myStepCallback = callBack;
        NotificationCenter.getGlobalInstance().register(ChannelNotifyDef.CHANNEL_MINIMISE_CHANGED, (INotify)this);
        NotificationCenter.getGlobalInstance().register(ChannelNotifyDef.VIDEO_WARN_NOTIFY, (INotify)this);
        boolean played = this.play();
        if (played) {
            if (this.getPlayPresenter().isVideoStarted()) {
                this.myStepCallback.onVideoStarted();
            }
        } else {
            this.myStepCallback.onVideoStoped();
        }
        if (!this.getPage().isPageVisible()) {
            ((IChannelPageContext)this.getMvpContext()).getPageLifeDispatcher().addLifeListener(new IPageLifeCycle(){

                public void onShown() {
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            RadioNewPresenter.this.myStepCallback.onWindowShown();
                            if (RadioNewPresenter.this.mPlayPresenter != null) {
                                RadioNewPresenter.this.mPlayPresenter.onPageShown();
                            }
                        }
                    });
                }
            });
        } else {
            this.myStepCallback.onWindowShown();
            if (this.mPlayPresenter != null) {
                this.mPlayPresenter.onPageShown();
            }
        }
        this.getPlayPresenter().setVideoStreamCallback(new VideoStreamCallback(){

            public void onVideoStart(long anchorId, int width, int height2, boolean isCdn) {
                if (RadioNewPresenter.this.isDestroyed()) {
                    return;
                }
                ((RadioPage)RadioNewPresenter.this.getPage()).onVideoStart(RadioNewPresenter.this.isMeShowing(), anchorId, width, height2, isCdn);
                RadioNewPresenter.this.myStepCallback.onVideoStarted();
                RadioNewPresenter.this.checkCurrentTheme(width, height2);
            }

            public void videoStreamOpen(long anchorId, LiveVideoStreamInfo streamInfo) {
                if (RadioNewPresenter.this.isDestroyed()) {
                    return;
                }
                if (streamInfo.getWidth() > 0 && streamInfo.getHeight() > 0) {
                    ((RadioPage)RadioNewPresenter.this.getPage()).onVideoSizeChange(RadioNewPresenter.this.isMeShowing(), anchorId, streamInfo.getWidth(), streamInfo.getHeight(), streamInfo.getRotation());
                }
                RadioNewPresenter.this.checkCurrentTheme(streamInfo.getWidth(), streamInfo.getHeight());
            }

            public void videoStreamClose(long anchorId) {
            }

            public void onVideoSizeChange(long anchorId, int width, int height2, int rotation) {
                if (RadioNewPresenter.this.isDestroyed()) {
                    return;
                }
                ((RadioPage)RadioNewPresenter.this.getPage()).onVideoSizeChange(RadioNewPresenter.this.isMeShowing(), anchorId, width, height2, rotation);
                RadioNewPresenter.this.checkCurrentTheme(width, height2);
                MLog.info((Object)"RadioPlugin", (String)"onVideoSizeChange anchorId: %d, ownerUid: %d", (Object[])new Object[]{anchorId, RadioNewPresenter.this.getChannel().getOwnerUid()});
            }
        });
        this.registerMediaExtend();
        ProtoManager.getInstance().registerNotify(this.mCarouselNotify);
    }

    void handlerShowStartNotify(ShowStartNotify notify) {
        MLog.debug((Object)"openNotify", (String)"\u6536\u5230\u5f00\u64ad\u901a\u77e5%s", (Object[])new Object[]{notify});
        if (!this.getChannelId().equals(notify.cid)) {
            this.showFloatNotice(notify);
        }
    }

    private void recvMediaExtraInfo(@Nullable String uid, @Nullable MediaEntity info) {
        if (info == null) {
            return;
        }
        if (info.bizCode.intValue() == MEBizCode.kVideoPK.getValue()) {
            this.onRecMediaPkInfo(info);
        } else if (info.bizCode.intValue() == MEBizCode.KAudienceLinkMic.getValue()) {
            this.onRecMediaAudienceLinkMic(info);
        }
    }

    private void onRecMediaPkInfo(MediaEntity info) {
        if (!this.needPreLinkMicVideoSize) {
            return;
        }
        YYTaskExecutor.execute(() -> {
            try {
                MEVideoPK pk = (MEVideoPK)MEVideoPK.ADAPTER.decode(info.info);
                if (pk.isLinkMic.booleanValue()) {
                    this.needPreLinkMicVideoSize = false;
                    YYTaskExecutor.postToMainThread(() -> {
                        if (this.isDestroyed()) {
                            return;
                        }
                        this.checkCurrentTheme(true, 1);
                        ((RadioPage)this.getPage()).preLinkMicVideoSize(true);
                    });
                }
            }
            catch (Exception e) {
                MLog.error((Object)"RadioNewPresenter", (Throwable)e);
            }
        });
    }

    private void onRecMediaAudienceLinkMic(MediaEntity info) {
        if (!this.needPreLinkMicVideoSize) {
            return;
        }
        YYTaskExecutor.execute(() -> {
            try {
                MEAudienceLinkMic linker = (MEAudienceLinkMic)MEAudienceLinkMic.ADAPTER.decode(info.info);
                if (linker.status.intValue() == JoinMicStatus.JOIN_MIC_GOING.getValue() && linker.joinMicType.intValue() == JoinMicType.JAT_VIDEO.getValue()) {
                    this.needPreLinkMicVideoSize = false;
                    YYTaskExecutor.postToMainThread(() -> {
                        if (this.isDestroyed()) {
                            return;
                        }
                        this.checkCurrentTheme(true, 2);
                        ((RadioPage)this.getPage()).preLinkMicVideoSize(false);
                    });
                }
            }
            catch (Exception e) {
                MLog.error((Object)"RadioNewPresenter", (Throwable)e);
            }
        });
    }

    private void checkCurrentTheme(int streamWidth, int streamHeight) {
        if (streamWidth == 0 || streamHeight == 0 || this.isResetTheme) {
            return;
        }
        this.checkCurrentTheme(streamWidth > streamHeight, 0);
    }

    private void checkCurrentTheme(boolean isLinkMic, int theme) {
        if (isLinkMic) {
            if (this.mThemeDelayRunnable != null) {
                YYTaskExecutor.removeRunnableFromMainThread((Runnable)this.mThemeDelayRunnable);
                this.mThemeDelayRunnable = null;
            }
            switch (theme) {
                case 1: {
                    this.mCurrentTheme = 2;
                    ((ThemePresenter)this.getPresenter(ThemePresenter.class)).getModeTheme().postValue((Object)new DrawableResThemeBean(R.drawable.audio_pk_blue_vs_red_bg_min, com.yy.hiyo.pk.base.DR.audio_pk_blue_vs_red_bg, false));
                    break;
                }
                case 2: {
                    this.mCurrentTheme = 3;
                    ((ThemePresenter)this.getPresenter(ThemePresenter.class)).getModeTheme().postValue((Object)new DrawableResThemeBean(LoadingBgHellper.getLoadingBgDefaultResId(), DR.bg_link_mic));
                    break;
                }
                case 0: {
                    this.mThemeDelayRunnable = () -> {
                        this.mCurrentTheme = 1;
                        ((ThemePresenter)this.getPresenter(ThemePresenter.class)).getModeTheme().postValue((Object)new DrawableResThemeBean(LoadingBgHellper.getLoadingBgDefaultResId()));
                        this.mThemeDelayRunnable = null;
                    };
                    YYTaskExecutor.postToMainThread((Runnable)this.mThemeDelayRunnable, (long)250L);
                    break;
                }
            }
            this.isResetTheme = true;
        }
    }

    public int getCurrentTheme() {
        return this.mCurrentTheme;
    }

    public RadioPlayPresenter getPlayPresenter() {
        if (this.mPlayPresenter == null) {
            long uid = 0L;
            if (this.getChannelDetailInfo() != null && this.getChannelDetailInfo().baseInfo != null) {
                uid = this.getChannelDetailInfo().baseInfo.ownerUid;
            }
            this.mPlayPresenter = new RadioPlayPresenter((IChannel)this.getChannel(), (RadioPage)this.getPage(), uid, new RadioPlayCallback(){

                @Override
                public boolean isMeShowing() {
                    return RadioNewPresenter.this.isMeShowing();
                }

                @Override
                public void setOnLinkMicTypeChangedListener(@NotNull OnLinkMicTypeChangedListener listener2) {
                    if (!RadioNewPresenter.this.isDestroyed()) {
                        ((UserLinkMicPresenter)RadioNewPresenter.this.getPresenter(UserLinkMicPresenter.class)).setOnLinkMicTypeChangedListener(listener2);
                    }
                }

                @Override
                public int getLinkMicType() {
                    if (RadioNewPresenter.this.isDestroyed()) {
                        return JoinMicType.JOIN_MIC_TYPE_NONE.getValue();
                    }
                    return ((UserLinkMicPresenter)RadioNewPresenter.this.getPresenter(UserLinkMicPresenter.class)).getCurrentLinkMicType();
                }

                @Override
                public boolean isLinkMicAudience() {
                    if (RadioNewPresenter.this.isDestroyed()) {
                        return false;
                    }
                    return ((UserLinkMicPresenter)RadioNewPresenter.this.getPresenter(UserLinkMicPresenter.class)).isLinkMicAudience();
                }

                @Override
                public boolean isLinkMicTwoSourceVideoMode() {
                    if (RadioNewPresenter.this.isDestroyed()) {
                        return false;
                    }
                    return ((VideoPresenter)RadioNewPresenter.this.getPresenter(VideoPresenter.class)).isWatchTwoUserSourceLive();
                }

                @Override
                public void showQualityGuide() {
                    if (RadioNewPresenter.this.isDestroyed()) {
                        return;
                    }
                    ((ChannelToolsPresenter)RadioNewPresenter.this.getPresenter(ChannelToolsPresenter.class)).openPanelWithQualitySwitchGuide();
                }

                @Override
                public boolean isCurrLinkMic() {
                    if (RadioNewPresenter.this.isDestroyed()) {
                        return false;
                    }
                    return ((VideoPresenter)RadioNewPresenter.this.getPresenter(VideoPresenter.class)).isLinkMic();
                }

                @Override
                public boolean isRadioReady() {
                    if (RadioNewPresenter.this.isDestroyed()) {
                        return false;
                    }
                    return ((IChannelPageContext)RadioNewPresenter.this.getMvpContext()).hasPresenter(RadioPresenter.class);
                }

                @Override
                public void showDebugInfo(final String debugInfo) {
                    if (RuntimeContext.sIsDebuggable) {
                        YYTaskExecutor.postToMainThread((Runnable)WeakRunnable.of((IDestroyable)RadioNewPresenter.this, (Runnable)new Runnable(){

                            @Override
                            public void run() {
                                ((DebugPresenter)RadioNewPresenter.this.getPresenter(DebugPresenter.class)).updateSubDebugInfo(debugInfo);
                            }
                        }), (long)5000L);
                    }
                }

                @Override
                public boolean isLoopMicRoomAndNoLiving() {
                    if (((IChannelPageContext)RadioNewPresenter.this.getMvpContext()).hasPresenter(ILunMicPresenter.class)) {
                        return ((ILunMicPresenter)((IChannelPageContext)RadioNewPresenter.this.getMvpContext()).getPresenter(ILunMicPresenter.class)).isAnchorNotInSeat();
                    }
                    return false;
                }
            });
            this.getPlayPresenter().setMode(1);
        }
        return this.mPlayPresenter;
    }

    public boolean play() {
        if (this.pluginCallBack == null) {
            this.pluginCallBack = new IPluginService.IPluginDataChangedCallBack(){

                public void onVideoModeChanged(String channelId, boolean isVideoMode) {
                    if (RadioNewPresenter.this.isDestroyed() || RadioNewPresenter.this.isMeShowing()) {
                        return;
                    }
                    if (isVideoMode) {
                        ((RadioPage)RadioNewPresenter.this.getPage()).setLiveViewVisible(true);
                        RadioNewPresenter.this.getPlayPresenter().startWatch();
                        if (RadioNewPresenter.this.getPlayPresenter().isVideoStarted()) {
                            RadioNewPresenter.this.myStepCallback.onVideoStarted();
                        }
                    } else {
                        ((RadioPage)RadioNewPresenter.this.getPage()).setLiveViewVisible(false);
                        RadioNewPresenter.this.getPlayPresenter().stopWatchLive();
                        RadioNewPresenter.this.myStepCallback.onVideoStoped();
                    }
                }
            };
        }
        this.getChannel().getPluginService().addPluginDataListener(this.pluginCallBack);
        if (!this.isMeShowing()) {
            if (this.isVideoMode()) {
                ((RadioPage)this.getPage()).setLiveViewVisible(true);
                this.getPlayPresenter().startWatch();
                boolean isLoopMicRoom = this.isLoopMic();
                if (isLoopMicRoom) {
                    this.iSeatUpdateListener = seatUserList -> {
                        if (this.iSeatUpdateListener != null) {
                            this.getChannel().getSeatService().getSeatData().removeSeatUpdateListener(this.iSeatUpdateListener);
                            this.iSeatUpdateListener = null;
                        }
                        if (seatUserList == null || seatUserList.isEmpty() || ((SeatUser)seatUserList.get((int)0)).uid == 0L) {
                            this.myStepCallback.onVideoStoped();
                        }
                    };
                    this.getChannel().getSeatService().getSeatData().addSeatUpdateListener(this.iSeatUpdateListener);
                }
                return true;
            }
            ((RadioPage)this.getPage()).setLiveViewVisible(false);
            this.getPlayPresenter().stopWatchLive();
            return false;
        }
        return false;
    }

    private boolean isLoopMic() {
        return this.getChannel().getChannelDetail().baseInfo.isLoopMicRoom();
    }

    public void onDestroy() {
        super.onDestroy();
        NotificationCenter.getGlobalInstance().unregister(ChannelNotifyDef.CHANNEL_MINIMISE_CHANGED, (INotify)this);
        NotificationCenter.getGlobalInstance().unregister(ChannelNotifyDef.VIDEO_WARN_NOTIFY, (INotify)this);
        if (this.mPlayPresenter != null) {
            this.mPlayPresenter.destroy();
            this.mPlayPresenter = null;
        }
        if (this.mThemeDelayRunnable != null) {
            YYTaskExecutor.removeRunnableFromMainThread((Runnable)this.mThemeDelayRunnable);
            this.mThemeDelayRunnable = null;
        }
        if (this.pluginCallBack != null) {
            this.getChannel().getPluginService().removePluginDataListener(this.pluginCallBack);
            this.pluginCallBack = null;
        }
        this.unregisterMediaExtend();
        ProtoManager.getInstance().unregisterNotify(this.mCarouselNotify);
    }

    private void registerMediaExtend() {
        ((IKtvLiveServiceExtend)ServiceManagerProxy.getService(IKtvLiveServiceExtend.class)).registerMediaExtraInfoReceiver(MEBizCode.kVideoPK.getValue(), this.mOnRecvMediaExtraInfoListener);
        ((IKtvLiveServiceExtend)ServiceManagerProxy.getService(IKtvLiveServiceExtend.class)).registerMediaExtraInfoReceiver(MEBizCode.KAudienceLinkMic.getValue(), this.mOnRecvMediaExtraInfoListener);
    }

    private void unregisterMediaExtend() {
        ((IKtvLiveServiceExtend)ServiceManagerProxy.getService(IKtvLiveServiceExtend.class)).unRegisterMediaExtraInfoReceiver(MEBizCode.kVideoPK.getValue(), this.mOnRecvMediaExtraInfoListener);
        ((IKtvLiveServiceExtend)ServiceManagerProxy.getService(IKtvLiveServiceExtend.class)).unRegisterMediaExtraInfoReceiver(MEBizCode.KAudienceLinkMic.getValue(), this.mOnRecvMediaExtraInfoListener);
    }

    public void notify(Notification notification) {
        if (notification == null || this.isDestroyed()) {
            return;
        }
        if (notification.id == ChannelNotifyDef.CHANNEL_MINIMISE_CHANGED) {
            if (notification.extObj instanceof MiniInfo) {
                MiniInfo miniInfo = (MiniInfo)notification.extObj;
                if (SettingFlags.getBoolean((String)"adjustensureradippresenter", (boolean)true)) {
                    if (miniInfo.isMinimized() && this.myStepCallback != null) {
                        this.myStepCallback.ensurePresentersInit();
                    }
                    if (this.myStepCallback != null && this.myStepCallback.isPresentersInited()) {
                        ((RadioPresenter)this.getPresenter(RadioPresenter.class)).handleMini(miniInfo);
                    }
                } else {
                    if (this.myStepCallback != null) {
                        this.myStepCallback.ensurePresentersInit();
                    }
                    ((RadioPresenter)this.getPresenter(RadioPresenter.class)).handleMini(miniInfo);
                }
                this.getPlayPresenter().showOrHideFuzzyBg(miniInfo.isMinimized());
            }
        } else if (notification.id == ChannelNotifyDef.VIDEO_WARN_NOTIFY && notification.extObj instanceof String && this.isMeShowing() && this.isVideoMode() && StringUtils.equal((String)this.getChannelId(), (String)((String)notification.extObj))) {
            int marginTop = ResolutionUtils.getScreenHeight() / 2 - ResolutionUtils.dip2Px((float)100.0f);
            GloatToastUtils.showToast((CharSequence)ResourceUtils.getString((int)R.string.tips_video_warn), (long)15000L, (float)marginTop, (boolean)false);
        }
    }

    public boolean canChangeSeat() {
        return true;
    }

    public boolean haveSelfFaceLocation() {
        return false;
    }

    public MutableLiveData<Map<Long, FacePoint>> getFaceLocation() {
        return null;
    }

    public boolean interceptRunningState() {
        return false;
    }

    public boolean isVideoMode() {
        ChannelPluginData data = this.getChannel().getPluginService().getCurPluginData();
        return data != null && data.isVideoMode();
    }

    public boolean isVideoStart() {
        if (this.mPlayPresenter != null) {
            return this.mPlayPresenter.isVideoStarted();
        }
        return false;
    }

    public boolean isMeShowing() {
        return AccountUtil.getUid() == this.getShowingUid();
    }

    public long getShowingUid() {
        return this.getChannel().getRoleService().getAnchorUid();
    }

    void showFloatNotice(final ShowStartNotify notify) {
        FloatNoticeInfo floatNotice = new FloatNoticeInfo(new ImageIcon(0, notify.avatar), null, new TextStyle((CharSequence)notify.Title), new TextStyle((CharSequence)notify.Content), new TextStyle((CharSequence)ResourceUtils.getString((int)R.string.btn_enter)), 5000L);
        floatNotice.putExtend("cid", (Object)notify.cid);
        floatNotice.setListener(new IFloatNoticeListener(){

            public void onTimeout(@NotNull FloatNoticeInfo info) {
            }

            public void onCancel(@NotNull FloatNoticeInfo info) {
            }

            public void onDismiss(@NotNull FloatNoticeInfo info) {
            }

            public void onShown(@NotNull FloatNoticeInfo info) {
            }

            public void onClickBtn(@NotNull FloatNoticeInfo info) {
                Message message = Message.obtain();
                message.what = AppbaseMsgDef.ChannelMsgDef.ENTRY_CHANNEL;
                EnterParam enterParam = EnterParam.obtain((String)notify.cid, (int)40);
                message.obj = enterParam;
                MsgDispatcher.getInstance().sendMessage(message);
            }
        });
        floatNotice.addWhiteWindows(new String[]{"ChannelWindow"});
        MsgDispatcher.getInstance().sendMessage(ImBaseMsgDef.MSG_SHOW_FLOAT_NOTICE, (Object)floatNotice);
    }

    public static interface ICallBack {
        public void onVideoStarted();

        public void onVideoStoped();

        public void ensurePresentersInit();

        public void onWindowShown();

        public boolean isPresentersInited();
    }
}

