/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.module.push;

import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import androidx.annotation.RequiresApi;
import com.yy.appbase.push.NotificationManager;
import com.yy.appbase.push.PayloadUtil;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ToastUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.hiyo.module.push.stat.PushMsgArrStat;
import com.yy.hiyo.push.base.IHagoMsgArriveCallback;
import com.yy.hiyo.push.base.PushSDKHelper;
import com.yy.pushsvc.IMsgArriveCallback;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import ikxd.msg.MsgInnerType;
import ikxd.msg.PushPayloadType;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class HagoIMsgArriveCallback
implements IMsgArriveCallback,
IHagoMsgArriveCallback {
    private static final String TAG = "YYLitePushReceiver";
    public static final int PUSH_TYPE_NO_FCM = 1;
    private long mStartBindTime = System.currentTimeMillis();

    private HagoIMsgArriveCallback() {
    }

    public static HagoIMsgArriveCallback getInstance() {
        return SingleHolder.INSTANCE;
    }

    public void syncBindStartTime(long startBindTime) {
        this.mStartBindTime = startBindTime;
    }

    public void onTokenReceived(String type, byte[] token, boolean isThirdPartyToken, Context ctx) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)("onTokenReceived " + new String(token)), (Object[])new Object[0]);
        }
    }

    public void onPushMessageReceived(long msgId, byte[] msgBody, String channelType, Context ctx, Map<String, String> msgData) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"onPushMessageReceived\uff0c channelType\uff1a%s", (Object[])new Object[]{channelType});
        }
        if (RuntimeContext.sIsDebuggable) {
            ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)("Push\u900f\u4f20\u6d88\u606f\u5230\u8fbe\uff0cchannel is " + channelType), (int)1);
        }
        PushMsgArrStat.INSTANCE.statPushMessageReceived();
        this.handleMsg(msgBody, channelType, ctx, false);
    }

    private void handleMsg(byte[] msgBody, String channelType, Context ctx, boolean isOfflineMsg) {
        PushSDKHelper.getPushService().getUnReadHandler().init();
        this.handlePushMsg(msgBody, msg -> this.reportPushArriveId(ctx, msg, this.getChannelType(channelType), true, isOfflineMsg));
    }

    private String getChannelType(String channelType) {
        if (channelType.equals("FCM")) {
            return "128";
        }
        if (channelType.equals("HUAWEI")) {
            return "2";
        }
        if (channelType.equals("Xiaomi")) {
            return "1";
        }
        return channelType;
    }

    public void onAppBindRes(int resCode, String account, Context ctx) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"onAppBindRes", (Object[])new Object[0]);
        }
        if (RuntimeContext.sIsDebuggable) {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)"\u7ed1\u5b9a\u8c37\u6b4c\u63a8\u9001\u6210\u529f", (int)0);
                }
            });
        }
        int tempResCode = resCode;
        resCode = resCode == 200 ? 0 : (resCode == 0 ? -1 : resCode);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("res_code", "" + tempResCode);
        HiidoStatis.reportAppMonitorReturnCodeNow((String)"push_token_bind", (long)(System.currentTimeMillis() - this.mStartBindTime), (String)(resCode + ""), map);
    }

    public void onAppUnbindRes(int resCode, String account, Context ctx) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"onAppUnbindRes", (Object[])new Object[0]);
        }
    }

    public void onNotificationArrived(long msgID, byte[] payload, final String channelType, final Context ctx) {
        PushSDKHelper.getPushService().getUnReadHandler().init();
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"onNotificationArrived, channelType:%s, msgId:%s", (Object[])new Object[]{channelType, msgID});
        }
        this.handlePushMsg(payload, new IPushJsonParseCallback(){

            @Override
            public void onSuccess(String msg) {
                HagoIMsgArriveCallback.this.reportPushArriveId(ctx, msg, HagoIMsgArriveCallback.this.getChannelType(channelType), false, false);
            }
        });
    }

    public void onNotificationClicked(long msgID, byte[] msgBody, String channelType, Context ctx) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"onNotificationClicked, channelTyep:%s, msgId:%s", (Object[])new Object[]{channelType, msgID});
        }
        this.handlePushMsg(msgBody, msg -> {
            if (!TextUtils.isEmpty((CharSequence)msg)) {
                Intent resultIntent = new Intent(ctx, PushSDKHelper.getMainActivityClass());
                JSONObject payloadJson = null;
                try {
                    if (!TextUtils.isEmpty((CharSequence)msg)) {
                        payloadJson = JsonParser.obtainJSONObject((String)msg);
                        payloadJson.put("push_channel", (Object)this.getChannelType(channelType));
                        msg = payloadJson.toString();
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                boolean isPushSdkStyle = false;
                boolean isFcmType = false;
                if (TextUtils.equals((CharSequence)channelType, (CharSequence)"FCM")) {
                    isPushSdkStyle = true;
                    isFcmType = true;
                }
                resultIntent.putExtra("payload", msg);
                resultIntent.setAction("yylitepushinfo");
                resultIntent.putExtra("is_fcm_type", isFcmType);
                resultIntent.putExtra("is_push_sdk_style", isPushSdkStyle);
                resultIntent.addFlags(0x10000000);
                ctx.startActivity(resultIntent);
            }
        });
    }

    public void onSetTagRes(int resCode, Context ctx) {
    }

    public void onDelTagRes(int resCode, Context ctx) {
    }

    public void onPushUnreadMsgReceived(Context context, String channelType, JSONArray msgJsonArray) {
        if (RuntimeContext.sIsDebuggable) {
            int num = msgJsonArray != null ? msgJsonArray.length() : 0;
            ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)("Push\u79bb\u7ebf\u6d88\u606f\u5230\u8fbe\uff0cchannel is " + channelType + " \u6d88\u606f\u6570\u91cf " + num), (int)1);
        }
        if (msgJsonArray == null) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)"Receiver", (String)"onPushUnreadMsgReceived msgJsonArray is null", (Object[])new Object[0]);
            }
            return;
        }
        PushMsgArrStat.INSTANCE.statPushUnreadMsgReceived();
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)"Receiver", (String)("onPushUnreadMsgReceived msgJsonArray = " + msgJsonArray.toString()), (Object[])new Object[0]);
        }
        try {
            for (int i = 0; i < msgJsonArray.length() && i < 3; ++i) {
                JSONObject jsonObject = (JSONObject)msgJsonArray.get(i);
                String payload = jsonObject.getString("payload");
                YYTaskExecutor.postToMainThread(() -> this.handleMsg(payload.getBytes(), channelType, context, true), (long)(60000 * i));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onPushSDKNotificationShow(long msgID, byte[] payload, String channelType, int type, Context ctx) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)("onPushSDKNotificationShow:   channel : " + channelType + ", type: " + type), (Object[])new Object[0]);
        }
        this.handlePushMsg(payload, msg -> {
            try {
                JSONObject payloadJson = JsonParser.obtainJSONObject((String)msg);
                PayloadUtil.reportPushSdkNotificationShow((int)type, (JSONObject)payloadJson);
            }
            catch (JSONException e) {
                MLog.error((Object)TAG, (Throwable)e);
            }
        });
    }

    public void onPushSDKNotificationArrived(long msgId, byte[] msgBody, String channelType, Context ctx) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)("onPushSDKNotificationArrived:   channel : " + channelType), (Object[])new Object[0]);
        }
        this.handlePushMsg(msgBody, msg -> {
            JSONObject payloadJson = null;
            try {
                payloadJson = JsonParser.obtainJSONObject((String)msg);
                PayloadUtil.reportPushSdkNotificationArrived((JSONObject)payloadJson);
            }
            catch (JSONException e) {
                MLog.error((Object)TAG, (Throwable)e);
            }
        });
    }

    public void onPushSDKNotificationReShow(long msgID, byte[] payload, String channelType, Context ctx) {
    }

    private void reportPushArriveId(final Context context, final String msg, final String channelType, final boolean isShowPush, final boolean isOfflineMsg) {
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            @RequiresApi(api=26)
            public void run() {
                JSONObject payloadJson = null;
                try {
                    JSONObject imJson;
                    payloadJson = JsonParser.obtainJSONObject((String)msg);
                    long pushId = 0L;
                    if (payloadJson.has("push_id")) {
                        pushId = payloadJson.optLong("push_id");
                    }
                    String pushTitle = "";
                    if (payloadJson.has("push_title")) {
                        pushTitle = payloadJson.optString("push_title");
                    }
                    String pushContent = "";
                    if (payloadJson.has("push_content")) {
                        pushContent = payloadJson.optString("push_content");
                    }
                    String avatar = "";
                    if (payloadJson.has("avatar")) {
                        avatar = payloadJson.optString("avatar");
                    }
                    int type = -1;
                    if (payloadJson.has("type")) {
                        type = payloadJson.optInt("type");
                    }
                    int pushSource = -1;
                    if (payloadJson.has("push_source")) {
                        pushSource = payloadJson.optInt("push_source");
                    }
                    long uid = 0L;
                    if (payloadJson.has("im") && (imJson = payloadJson.optJSONObject("im")).has("from_uid")) {
                        uid = imJson.optLong("from_uid");
                    }
                    if (payloadJson.has("friend") && (imJson = payloadJson.optJSONObject("friend")).has("from_uid")) {
                        uid = imJson.optLong("from_uid");
                    }
                    PushSDKHelper.getPushService().getUnReadHandler().onPushMsg(payloadJson);
                    HagoIMsgArriveCallback.this.showNotification(context, type, pushContent, pushTitle, payloadJson.toString(), avatar, uid, pushId, pushSource, channelType, isShowPush, isOfflineMsg);
                }
                catch (JSONException e) {
                    MLog.error((Object)HagoIMsgArriveCallback.TAG, (Throwable)e);
                }
            }
        });
    }

    @RequiresApi(api=26)
    private void showNotification(Context context, int type, String pushContent, String pushTitle, String payload, String avatar, long uid, long pushId, int pushSource, String channelType, boolean isShowPush, boolean isOfflineMsg) {
        String reportid = "";
        if (TextUtils.isEmpty((CharSequence)pushContent) && TextUtils.isEmpty((CharSequence)pushTitle)) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"showNotification null", (Object[])new Object[0]);
            }
            return;
        }
        if (pushSource != -1) {
            NotificationManager.Instance.showNotification(context, pushSource + "", pushContent, pushTitle, avatar, payload, uid, pushId, channelType, isShowPush, isOfflineMsg);
            return;
        }
        if (type == PushPayloadType.kPushPayloadFriend.getValue()) {
            NotificationManager.Instance.showNotification(context, "1", pushContent, pushTitle, avatar, payload, uid, pushId, channelType, isShowPush, isOfflineMsg);
        } else if (type == PushPayloadType.kPushPayloadIm.getValue()) {
            NotificationManager.Instance.showNotification(context, "", pushContent, pushTitle, avatar, payload, uid, pushId, channelType, isShowPush, isOfflineMsg);
        } else if (type == MsgInnerType.kMsgInnerAgreeFriend.getValue() || type == MsgInnerType.kMsgInnerTxtPic.getValue() || type == MsgInnerType.kMsgInnerIMTxtPic.getValue() || type == MsgInnerType.kMsgInnerTxt.getValue() || type == MsgInnerType.kMsgInnerReport.getValue() || type == MsgInnerType.kMsgInnerRoomRedPacket.getValue() || type == MsgInnerType.kMsgInnerPic.getValue() || type == MsgInnerType.kMsgInnerNewFriend.getValue() || type == MsgInnerType.kMsgInnerLike.getValue() || type == MsgInnerType.kMsgInnerIMJump.getValue() || type == MsgInnerType.kMsgInnerGameTxtPic.getValue() || type == MsgInnerType.kMsgInnerEmojiLike.getValue() || type == MsgInnerType.kMsgInnerEm.getValue() || type == MsgInnerType.kMsgInnerVoiceChatInvite.getValue() || type == MsgInnerType.kMsgInnerChannelInvite.getValue()) {
            reportid = "10";
            NotificationManager.Instance.showDefaultPush(context, pushContent, "", pushTitle, payload, uid, reportid, avatar, channelType, isShowPush, isOfflineMsg);
        } else if (type == MsgInnerType.kMsgInnerCustomerServiceNotify.getValue()) {
            reportid = "-1";
            NotificationManager.Instance.showDefaultPush(context, pushContent, "", pushTitle, payload, uid, reportid, avatar, channelType, isShowPush, isOfflineMsg);
        } else if (type == MsgInnerType.kMsgInnerDressupInvite.getValue() || type == MsgInnerType.kMsgInnerContactsQuizRegisterNotify.getValue() || type == MsgInnerType.kMsgInnerContactsQuizOfficialWelcome.getValue()) {
            reportid = "3";
            NotificationManager.Instance.showDefaultPush(context, pushContent, "", pushTitle, payload, uid, reportid, avatar, channelType, isShowPush, isOfflineMsg);
        } else {
            NotificationManager.Instance.showDefaultPush(context, pushContent, "", pushTitle, payload, uid, reportid, avatar, channelType, isShowPush, isOfflineMsg);
        }
    }

    private void handlePushMsg(final byte[] msgBody, final IPushJsonParseCallback callback) {
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                String msg = "";
                if (msgBody != null && msgBody.length > 0) {
                    try {
                        msg = new String(msgBody, "UTF-8");
                        msg = msg.replace("\"skiptype\":\"IM\"", "\"skiptype\":-1");
                        if (MLog.isLogLevelBlowInfo()) {
                            MLog.info((Object)HagoIMsgArriveCallback.TAG, (String)("thirdpush-onNotificationClicked got msg msgbody = " + msg), (Object[])new Object[0]);
                        }
                    }
                    catch (Exception e) {
                        MLog.error((Object)HagoIMsgArriveCallback.TAG, (String)("parseJson notifyInfo error:" + e), (Object[])new Object[0]);
                    }
                } else {
                    MLog.warn((Object)HagoIMsgArriveCallback.TAG, (String)"msgBody null", (Object[])new Object[0]);
                }
                if (!TextUtils.isEmpty((CharSequence)msg)) {
                    final String pushMsg = msg;
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (callback != null) {
                                callback.onSuccess(pushMsg);
                            }
                        }
                    });
                } else if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)HagoIMsgArriveCallback.TAG, (String)"\u89e3\u6790\u5931\u8d25", (Object[])new Object[0]);
                }
            }
        });
    }

    static interface IPushJsonParseCallback {
        public void onSuccess(String var1);
    }

    private static final class SingleHolder {
        private static final HagoIMsgArriveCallback INSTANCE = new HagoIMsgArriveCallback();

        private SingleHolder() {
        }
    }
}

