/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.component.publicscreen.holder;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Message;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.text.method.MovementMethod;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import com.scwang.smartrefresh.layout.util.DensityUtil;
import com.yy.appbase.service.IServiceManager;
import com.yy.appbase.service.IWebService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.span.ChainSpan;
import com.yy.appbase.span.MarginInfo;
import com.yy.appbase.span.Size;
import com.yy.appbase.ui.dialog.OkDialog;
import com.yy.appbase.ui.utils.CrashCatchLinkMovementMethod;
import com.yy.appbase.ui.widget.FlowLayout;
import com.yy.appbase.unifyconfig.config.HyperLinkConfig;
import com.yy.appbase.util.RegexUtils;
import com.yy.base.event.kvo.KvoEventIntent;
import com.yy.base.event.kvo.KvoMethodAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYLinearLayout;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.framework.core.ui.dialog.frame.DialogLinkManager;
import com.yy.hiyo.channel.base.IChannelCenterService;
import com.yy.hiyo.channel.base.bean.ActionDefine;
import com.yy.hiyo.channel.base.bean.FamilyInfoBean;
import com.yy.hiyo.channel.base.service.IChannel;
import com.yy.hiyo.channel.base.service.familypartyactivity.FamilyPartyModuleData;
import com.yy.hiyo.channel.base.service.familypartyactivity.IFamilyPartyActivityService;
import com.yy.hiyo.channel.cbase.publicscreen.msg.PureTextMsg;
import com.yy.hiyo.channel.component.publicscreen.holder.MsgLeadingMarginSpan;
import com.yy.hiyo.channel.publicscreen.BaseImMsg;
import com.yy.hiyo.component.publicscreen.R;
import com.yy.hiyo.component.publicscreen.helper.FirstChargeReportHelper;
import com.yy.hiyo.component.publicscreen.holder.AbsMsgTitleBarHolder;
import com.yy.hiyo.component.publicscreen.model.INewUserTagService;
import com.yy.hiyo.component.publicscreen.model.NewUserLabel;
import com.yy.hiyo.component.publicscreen.model.NewUserTagData;
import com.yy.hiyo.component.publicscreen.msg.BubbleMessage;
import com.yy.hiyo.component.publicscreen.msg.GiftMsg;
import com.yy.hiyo.component.publicscreen.theme.IThemeRes;
import com.yy.hiyo.component.publicscreen.widge.BaseUserTitleView;
import java.util.Map;
import java.util.regex.Matcher;
import kotlin.Unit;
import net.ihago.base.srv.msgcheck.LinkLevel;
import net.ihago.money.api.familyparty.ActStatus;
import org.jetbrains.annotations.NotNull;

public class PureTextHolder
extends AbsMsgTitleBarHolder<PureTextMsg> {
    private static final String TAG = "PureTextHolder";
    private static final int DP_5_IN_DIMEN = ResourceUtils.getDimen((int)R.dimen.dp_5);
    private static final int DP_2_IN_DIMEN = ResourceUtils.getDimen((int)R.dimen.dp_2);
    private int recyclerViewWidth = 0;
    private YYTextView tvText;
    private YYTextView tvTag;
    private RecycleImageView mIvFamilyParty;
    private YYLinearLayout mLlContainer;
    private RecycleImageView ivChargeLabel;
    private View[] mViews = new View[2];
    private BaseUserTitleView titleView;

    public PureTextHolder(@NotNull View v, boolean self, int viewType) {
        super(v, self, viewType);
        this.tvText = (YYTextView)this.itemView.findViewById(R.id.tv_c_text);
        this.titleView = (BaseUserTitleView)this.itemView.findViewById(R.id.butv_c);
        this.tvTag = (YYTextView)this.itemView.findViewById(R.id.tvTag);
        this.mIvFamilyParty = (RecycleImageView)this.itemView.findViewById(R.id.iv_family_party);
        this.mLlContainer = (YYLinearLayout)this.itemView.findViewById(R.id.ll_container);
        this.ivChargeLabel = (RecycleImageView)this.itemView.findViewById(R.id.iv_charge_label);
        this.tvText.setMovementMethod((MovementMethod)CrashCatchLinkMovementMethod.getInstance());
        this.mViews[0] = this.itemView;
        this.mViews[1] = this.tvText;
        this.tvText.setOnClickListener(v1 -> {
            if (this.tvText.getSelectionStart() == -1 && this.tvText.getSelectionEnd() == -1 && this.mActionHandler != null) {
                Message msg = Message.obtain();
                msg.obj = this.getItemMsg();
                msg.what = ActionDefine.CLICK_PURE_TEXT_MSG;
                this.mActionHandler.onAction(msg);
            }
        });
        this.itemView.setOnClickListener(v12 -> {
            if (this.mActionHandler != null) {
                Message msg = Message.obtain();
                msg.obj = this.getItemMsg();
                msg.what = ActionDefine.CLICK_PURE_TEXT_ITEM;
                this.mActionHandler.onAction(msg);
            }
        });
        this.titleView.setOnMeasuredListener((width, height) -> this.updateText());
        this.tvText.setAutoLinkMask(0);
    }

    @KvoMethodAnnotation(name="isFirstCharge", sourceClass=BaseImMsg.class, thread=1)
    public void updateFirstCharge(KvoEventIntent event) {
        this.updateTag();
    }

    private void updateTag() {
        Object extendInfo;
        if (this.tvTag == null) {
            return;
        }
        boolean isNewUser = false;
        if (this.mActionHandler != null && (extendInfo = this.mActionHandler.getExtendInfo("isNewComer", new Object())) instanceof Boolean) {
            isNewUser = (Boolean)extendInfo;
        }
        NewUserTagData tagData = ((INewUserTagService)ServiceManagerProxy.getService(INewUserTagService.class)).getData();
        if (((PureTextMsg)this.getItemMsg()).isNewComer() && ((PureTextMsg)this.getItemMsg()).getUpgradeLabelId() > 0L && tagData.isMeInWhiteList()) {
            this.ivChargeLabel.setVisibility(8);
            this.tvTag.setVisibility(0);
            NewUserLabel label = tagData.findLabel(((PureTextMsg)this.getItemMsg()).getUpgradeLabelId());
            if (label != null) {
                this.updateUserUpgradeTag(label);
                this.tvTag.setOnClickListener(v -> ToastUtils.showToast((Context)this.tvTag.getContext(), (CharSequence)label.getToastText()));
            }
        } else if (((PureTextMsg)this.getItemMsg()).isFirstCharge()) {
            if (this.ivChargeLabel.getVisibility() == 8) {
                this.reportChargeShow();
            }
            this.ivChargeLabel.setVisibility(0);
            this.tvTag.setVisibility(8);
        } else if (((PureTextMsg)this.getItemMsg()).isNewComer() && !isNewUser) {
            this.ivChargeLabel.setVisibility(8);
            this.tvTag.setVisibility(0);
            this.tvTag.setBackgroundResource(R.drawable.shape_bg_new_user_tag);
            this.tvTag.setText(R.string.tip_public_screen_new_user_tag);
            this.tvTag.setTextColor(-1);
            this.tvTag.setOnClickListener(v -> ToastUtils.showToast((Context)this.tvTag.getContext(), (int)R.string.tip_new_user_tag_click));
        } else {
            this.ivChargeLabel.setVisibility(8);
            this.tvTag.setVisibility(8);
        }
        int padding = DensityUtil.dp2px((float)2.0f);
        if (this.tvTag.getVisibility() != 0 && this.ivChargeLabel.getVisibility() != 0) {
            if (((PureTextMsg)this.getItemMsg()).hasPartyLabel()) {
                this.mIvFamilyParty.setVisibility(0);
                this.mLlContainer.setPadding(padding, padding, padding, padding);
            } else if (this.self && this.isInFamilyParty()) {
                this.mIvFamilyParty.setVisibility(0);
                this.mLlContainer.setPadding(padding, padding, padding, padding);
            } else {
                this.mIvFamilyParty.setVisibility(8);
                this.mLlContainer.setPadding(0, 0, 0, 0);
            }
        } else {
            this.mIvFamilyParty.setVisibility(8);
            this.mLlContainer.setPadding(0, 0, 0, 0);
        }
        this.ivChargeLabel.setOnClickListener(v -> {
            ToastUtils.showToast((Context)this.tvTag.getContext(), (int)R.string.tips_click_first_charge_label);
            this.reportChargeClick();
        });
    }

    @Override
    public void bindView(PureTextMsg newData, int position) {
        super.bindView(newData, position);
        MLog.debug((Object)TAG, (String)"bindView isFirstCharge %s, isNewComer %s", (Object[])new Object[]{newData.isFirstCharge(), newData.isNewComer()});
        this.updateTag();
        this.mBinder.singleBindSourceTo("new_user_tag", (KvoSource)((INewUserTagService)ServiceManagerProxy.getService(INewUserTagService.class)).getData());
    }

    private boolean isInFamilyParty() {
        FamilyPartyModuleData activityInfo = ((IFamilyPartyActivityService)ServiceManagerProxy.getService(IFamilyPartyActivityService.class)).getFamilyPartyActivity();
        IChannel channel = ((IChannelCenterService)ServiceManagerProxy.getService(IChannelCenterService.class)).getCurrentChannel();
        if (channel == null) {
            return false;
        }
        FamilyInfoBean familyInfo = channel.getFamilyService().getCachedMyFamilyInfo();
        return activityInfo != null && activityInfo.getActivity() != null && familyInfo != null && activityInfo.getActivityState() == ActStatus.Beginning.getValue() && channel != null && StringUtils.equal((String)activityInfo.getActivity().cid, (String)channel.getChannelId()) && StringUtils.equal((String)activityInfo.getActivity().family.fid, (String)familyInfo.getFid());
    }

    @KvoMethodAnnotation(name="refreshForce", sourceClass=PureTextMsg.class, thread=1)
    final void onForceChange(@NotNull KvoEventIntent event) {
        this.onTextChanged();
    }

    @KvoMethodAnnotation(name="msgText", sourceClass=PureTextMsg.class, thread=1)
    final void onMsgTextChange(@NotNull KvoEventIntent event) {
        this.onTextChanged();
    }

    private void onTextChanged() {
        if (this.tvText == null) {
            return;
        }
        this.updateText();
    }

    private void updateText() {
        boolean isBaseMode;
        CharSequence msgText;
        CharSequence charSequence = msgText = this.getItemMsg() == null ? null : ((PureTextMsg)this.getItemMsg()).getMsgText();
        if (msgText == null || msgText.length() == 0) {
            return;
        }
        MLog.debug((Object)TAG, (String)"hash: %d, updateText %s", (Object[])new Object[]{((Object)((Object)this)).hashCode(), msgText});
        boolean bl = isBaseMode = this.mThemeRes != null && this.mThemeRes.getCurrentMode() == 1;
        if (isBaseMode) {
            SpannableStringBuilder builder = this.getUrlLinkSpan(msgText);
            this.tvText.setText((CharSequence)builder);
        } else {
            int offset = this.calculateTextIndentOffset((ViewGroup.MarginLayoutParams)this.tvText.getLayoutParams());
            this.setTextIndent(msgText, offset);
        }
    }

    private SpannableStringBuilder getUrlLinkSpan(CharSequence msgText) {
        SpannableStringBuilder builder = new SpannableStringBuilder(msgText);
        if (this.self) {
            Matcher matcher = RegexUtils.INSTANCE.matchUrl((CharSequence)builder);
            while (matcher.find()) {
                String url = matcher.group();
                int start = matcher.start();
                int end = matcher.end();
                builder.setSpan((Object)new ChainSpan.ClickSpan(() -> {
                    IServiceManager serviceManager = ServiceManagerProxy.getServiceManager();
                    if (serviceManager != null) {
                        ((IWebService)serviceManager.getService(IWebService.class)).loadUrl(url, "");
                    }
                    return Unit.INSTANCE;
                }, true, Color.parseColor((String)"#00A8FF")), start, end, 34);
                MLog.debug((Object)TAG, (String)("self msg url = " + url), (Object[])new Object[0]);
            }
        } else if (((PureTextMsg)this.getItemMsg()).getLinkMap() != null) {
            this.matchLink(builder, ((PureTextMsg)this.getItemMsg()).getLinkMap());
        }
        return builder;
    }

    private int calculateTextIndentOffset(ViewGroup.MarginLayoutParams params) {
        FlowLayout flowLayout = this.titleView.getFlowLayout();
        int topOffset = 0;
        if (flowLayout.getRowsCount() > 0) {
            int maxHeight = flowLayout.getHeightForRow(flowLayout.getRowsCount() - 1);
            Paint.FontMetrics metrics = this.tvText.getPaint().getFontMetrics();
            int textHeight = (int)(metrics.descent - metrics.ascent);
            topOffset = textHeight + (maxHeight - textHeight) / 2;
            MLog.debug((Object)TAG, (String)"rowSize %d, maxHeight %d, textHeight %d, topOffset %d", (Object[])new Object[]{flowLayout.getRowsCount(), maxHeight, textHeight, topOffset});
        }
        int lastRowWidth = flowLayout.getLastRowWidth();
        this.makeSureRecyclerViewWidth();
        MLog.debug((Object)TAG, (String)("recyclerViewWidth = " + this.recyclerViewWidth + ", lastRowWidth = " + lastRowWidth), (Object[])new Object[0]);
        if (this.recyclerViewWidth > 0 && (double)((float)lastRowWidth / (float)this.recyclerViewWidth) <= 0.9) {
            params.topMargin = -topOffset;
            this.tvText.setLayoutParams((ViewGroup.LayoutParams)params);
            return lastRowWidth + DP_2_IN_DIMEN;
        }
        params.topMargin = DP_5_IN_DIMEN;
        this.tvText.setLayoutParams((ViewGroup.LayoutParams)params);
        return 0;
    }

    @Override
    protected View[] getLongClickView() {
        return this.mViews;
    }

    @Override
    protected void updateThemeLayout(@NotNull IThemeRes themeRes, boolean isSimplify) {
        super.updateThemeLayout(themeRes, isSimplify);
        this.setTitleSingleLine(true);
        this.updateText();
        if (this.getItemMsg() instanceof GiftMsg) {
            ((GiftMsg)this.getItemMsg()).buildContent(isSimplify);
        } else if (this.getItemMsg() instanceof BubbleMessage) {
            ((BubbleMessage)this.getItemMsg()).build();
        }
    }

    private void setTextIndent(CharSequence text, int indentDistance) {
        MLog.debug((Object)TAG, (String)("setTextIndent: " + text + ", indentDistance: " + indentDistance), (Object[])new Object[0]);
        SpannableStringBuilder builder = new SpannableStringBuilder(text);
        MsgLeadingMarginSpan standard = new MsgLeadingMarginSpan(1, indentDistance);
        int end = text.toString().indexOf("\n");
        if (end == -1) {
            end = builder.length();
        }
        builder.setSpan((Object)standard, 0, end, 17);
        this.tvText.setText((CharSequence)builder);
    }

    private void makeSureRecyclerViewWidth() {
        if (this.recyclerViewWidth != 0) {
            return;
        }
        ViewParent parent = this.itemView.getParent();
        if (parent == null) {
            return;
        }
        this.recyclerViewWidth = ((View)parent).getWidth();
    }

    private void reportChargeShow() {
        if (this.mActionHandler != null) {
            Object pluginId = this.mActionHandler.getExtendInfo("pluginId", new Object());
            Object pluginMode = this.mActionHandler.getExtendInfo("pluginMode", new Object());
            if (pluginId instanceof String && pluginMode instanceof Integer) {
                FirstChargeReportHelper.reportLabelShow((Integer)pluginMode, (String)pluginId);
            }
        }
    }

    private void reportChargeClick() {
        if (this.mActionHandler != null) {
            Object pluginId = this.mActionHandler.getExtendInfo("pluginId", new Object());
            Object pluginMode = this.mActionHandler.getExtendInfo("pluginMode", new Object());
            if (pluginId instanceof String && pluginMode instanceof Integer) {
                FirstChargeReportHelper.reportLabelClick((Integer)pluginMode, (String)pluginId);
            }
        }
    }

    @KvoMethodAnnotation(name="dataChangedFlag", sourceClass=NewUserTagData.class, thread=1)
    private void onNewUseLabelsChange(@NotNull KvoEventIntent event) {
        Object msg = this.getItemMsg();
        if (msg != null && !FP.empty(((NewUserTagData)event.source()).getLabels()) && msg.isNewComer() && msg.getUpgradeLabelId() > 0L) {
            this.updateTag();
        }
    }

    private void updateUserUpgradeTag(final NewUserLabel label) {
        this.tvTag.setText((CharSequence)label.getText());
        this.tvTag.setTextColor(label.getTextColor());
        ImageLoader.loadBitmap((Context)this.itemView.getContext(), (String)label.getIcon(), (ImageLoader.BitmapLoadListener)new ImageLoader.BitmapLoadListener(){

            public void onResourceReady(Bitmap bitmap) {
                int width = (int)(PureTextHolder.this.tvTag.getPaint().measureText(label.getText()) + (float)ResolutionUtils.dip2Px((float)8.0f));
                width = Math.max(ResolutionUtils.dip2Px((float)32.0f), width);
                BitmapDrawable drawable2 = new BitmapDrawable(PureTextHolder.this.itemView.getResources(), Bitmap.createScaledBitmap((Bitmap)bitmap, (int)width, (int)ResolutionUtils.dip2Px((float)10.0f), (boolean)false));
                PureTextHolder.this.tvTag.setBackground((Drawable)drawable2);
            }

            public void onLoadFailed(Exception e) {
            }
        }, (int)200, (int)200);
    }

    private void matchLink(SpannableStringBuilder builder, Map<String, Integer> linkMap) {
        int nextIndex = 0;
        for (Map.Entry<String, Integer> entry : linkMap.entrySet()) {
            String link = entry.getKey();
            int level = entry.getValue();
            int start = builder.toString().indexOf(link, nextIndex);
            if (start == -1) continue;
            int end = start + link.length();
            int icon = R.drawable.icon_link_unknown;
            int textColor = Color.parseColor((String)"#FF9702");
            String tips = ResourceUtils.getString((int)R.string.tips_link_url_unknown);
            String url = HyperLinkConfig.Companion.getTipUrl(link, level);
            if (TextUtils.isEmpty((CharSequence)url)) break;
            if (level == LinkLevel.LinkLevel_Safe.getValue()) {
                icon = R.drawable.icon_link_safe;
                textColor = Color.parseColor((String)"#00A8FF");
                url = link;
                tips = ResourceUtils.getString((int)R.string.tips_link_url_safe);
            } else if (level == LinkLevel.LinkLevel_Unsafe.getValue()) {
                icon = R.drawable.icon_link_danger;
                textColor = Color.parseColor((String)"#FF5E79");
                tips = ResourceUtils.getString((int)R.string.tips_link_url_danger);
            }
            String finalTips = tips;
            int newStart = start;
            int newEnd = end;
            if (HyperLinkConfig.Companion.needShowLabel()) {
                SpannableStringBuilder imageSpan = ChainSpan.of().beginBlock().append(icon, Size.of((int)ResolutionUtils.dip2Px((float)12.0f), (int)ResolutionUtils.dip2Px((float)12.0f)), MarginInfo.of().right(ResolutionUtils.dip2Px((float)4.0f))).onBlockClick(() -> {
                    OkDialog okDialog = new OkDialog((CharSequence)finalTips, true, null);
                    okDialog.setShowCancel(false);
                    new DialogLinkManager(this.itemView.getContext()).showDialog((BaseDialog)okDialog);
                }).endBlock().buildSync();
                builder.insert(start, (CharSequence)imageSpan);
                newStart += imageSpan.length();
                newEnd += imageSpan.length();
            }
            String finalUrl = url;
            builder.setSpan((Object)new ChainSpan.ClickSpan(() -> {
                IServiceManager serviceManager = ServiceManagerProxy.getServiceManager();
                if (serviceManager != null) {
                    ((IWebService)serviceManager.getService(IWebService.class)).loadUrl(finalUrl, "");
                }
                return Unit.INSTANCE;
            }, true, textColor), newStart, newEnd, 34);
            MLog.debug((Object)TAG, (String)("other msg url = " + link), (Object[])new Object[0]);
        }
    }
}

