/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.component.publicscreen.holder;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Message;
import android.text.Spannable;
import android.text.style.LeadingMarginSpan;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.constraintlayout.widget.ConstraintLayout;
import biz.SourceEntry;
import com.yy.appbase.service.IYYUriService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.span.ChainSpan;
import com.yy.appbase.span.TextSpan;
import com.yy.appbase.ui.widget.image.CircleImageView;
import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.UnifyConfig;
import com.yy.appbase.unifyconfig.config.AConfigData;
import com.yy.appbase.unifyconfig.config.EnterRoomSourceConfig;
import com.yy.base.env.RuntimeContext;
import com.yy.base.event.kvo.KvoEventIntent;
import com.yy.base.event.kvo.KvoMethodAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.base.utils.YYImageUtils;
import com.yy.hiyo.channel.base.bean.ActionDefine;
import com.yy.hiyo.channel.base.bean.SimpleCardInfo;
import com.yy.hiyo.channel.base.bean.UserTagConfigs;
import com.yy.hiyo.channel.base.bean.UserTagInfo;
import com.yy.hiyo.channel.base.bean.UserTagLocation;
import com.yy.hiyo.channel.base.bean.UserTagSource;
import com.yy.hiyo.channel.base.service.IChannelHonorService;
import com.yy.hiyo.channel.base.widget.UserTagsLayout;
import com.yy.hiyo.component.publicscreen.R;
import com.yy.hiyo.component.publicscreen.holder.AbsMsgItemHolder;
import com.yy.hiyo.component.publicscreen.model.INewUserTagService;
import com.yy.hiyo.component.publicscreen.model.NewUserLabel;
import com.yy.hiyo.component.publicscreen.model.NewUserTagData;
import com.yy.hiyo.component.publicscreen.msg.EnterRoomMsg;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class EnterRoomMsgHolder
extends AbsMsgItemHolder<EnterRoomMsg> {
    private static final String TAG = "EnterRoomMsgHolder";
    private CircleImageView ivhead;
    private YYTextView tvText;
    private RecycleImageView ivIcon;
    private RecycleImageView ivTag;
    private YYTextView tvNewTag;
    private final UserTagsLayout userTagsLayout;
    private int simpleContentMarginStart = -1;
    private HashMap<String, String> mSourceMap;

    public EnterRoomMsgHolder(@NonNull View itemView) {
        super(itemView, false);
        this.ivhead = (CircleImageView)itemView.findViewById(R.id.iv_c_head);
        this.tvText = (YYTextView)itemView.findViewById(R.id.tv_c_text);
        this.ivIcon = (RecycleImageView)itemView.findViewById(R.id.iv_c_img);
        this.ivTag = (RecycleImageView)itemView.findViewById(R.id.iv_tag);
        this.tvNewTag = (YYTextView)itemView.findViewById(R.id.tv_new_tag);
        this.userTagsLayout = (UserTagsLayout)itemView.findViewById(R.id.userTagsLayout);
        this.userTagsLayout.setClickSource(UserTagSource.ENTER_ROOM_MSG);
        this.ivhead.setOnClickListener(v -> {
            if (this.mActionHandler != null) {
                Message msg = Message.obtain();
                msg.what = ActionDefine.SHOW_USER_PROFILE;
                msg.obj = ((EnterRoomMsg)((Object)((Object)this.getItemMsg()))).getUid();
                this.mActionHandler.onAction(msg);
            }
        });
        AConfigData config = UnifyConfig.INSTANCE.getConfigData(BssCode.ENTER_ROOM_SOURCE_CONFIG);
        if (config instanceof EnterRoomSourceConfig) {
            this.mSourceMap = ((EnterRoomSourceConfig)config).getData().getData();
        }
        this.tvNewTag.setOnClickListener(v -> ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (int)R.string.tip_new_user_tag_click));
        this.ivTag.setOnClickListener(v -> ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (int)R.string.tips_click_first_charge_label));
    }

    @Override
    public void bindView(EnterRoomMsg newData, int position) {
        super.bindView(newData, position);
        MLog.info((Object)TAG, (String)("bindView source = " + newData.getSource()), (Object[])new Object[0]);
        ImageLoader.loadImage((ImageView)this.ivhead, (String)(newData.getIconUrl() + YYImageUtils.getThumbSmall()));
        if (newData.isOwner() && newData.getSource() == SourceEntry.SE_FRIEND_BROADCAST.getValue()) {
            HiidoStatis.reportEventNow((HiidoEvent)HiidoEvent.obtain().eventId("20028823").put("function_id", "owner_screen_welcome_show"));
            this.greetMessage(newData, ResourceUtils.getString((int)R.string.tips_enter_room_from_broadcast));
        } else {
            this.greetMessage(newData, ResourceUtils.getString((int)R.string.tips_enter_room));
        }
        this.setVipCards(newData);
        this.setTag(newData);
        this.mBinder.singleBindSourceTo("new_user_tag", (KvoSource)((INewUserTagService)ServiceManagerProxy.getService(INewUserTagService.class)).getData());
    }

    private void setVipCards(EnterRoomMsg newData) {
        boolean isNobbleIcon;
        ViewGroup.LayoutParams param;
        IChannelHonorService service = (IChannelHonorService)ServiceManagerProxy.getService(IChannelHonorService.class);
        List<SimpleCardInfo> vipCards = newData.getTitleCards();
        MLog.info((Object)TAG, (String)"setVipCards size %s", (Object[])new Object[]{FP.size(vipCards)});
        if (!FP.empty(vipCards)) {
            this.userTagsLayout.setData(service.getUserTagsFromConfig(vipCards), UserTagLocation.LOCATION_MSG_APP.getLocation(), newData.getUid(), ResolutionUtils.dip2Px((float)20.0f));
            this.userTagsLayout.setVisibility(0);
            param = this.userTagsLayout.getLayoutParams();
            if (param != null) {
                param.width = -2;
                this.userTagsLayout.requestLayout();
            }
        } else {
            this.userTagsLayout.setVisibility(8);
            this.userTagsLayout.removeAllViews();
            param = this.userTagsLayout.getLayoutParams();
            if (param != null) {
                param.width = 0;
                this.userTagsLayout.requestLayout();
            }
        }
        boolean bl = isNobbleIcon = newData.isNobleEntry() && !StringUtils.isEmpty((String)newData.getNobleIcon());
        if (isNobbleIcon) {
            this.setNobleIcon(newData);
        } else {
            SimpleCardInfo vipBgCard = newData.getVipBackgroundCard();
            if (vipBgCard != null) {
                List tags = service.getUserTagsFromConfig(Collections.singletonList(vipBgCard));
                if (!FP.empty((Collection)tags)) {
                    this.ivIcon.setVisibility(0);
                    UserTagConfigs.UserTagItemConfig config = ((UserTagInfo)tags.get(0)).getConfigs();
                    ImageLoader.loadImage((ImageView)this.ivIcon, (String)config.getBgUrl());
                    this.ivIcon.setOnClickListener(v -> ((IYYUriService)ServiceManagerProxy.getService(IYYUriService.class)).handleUriString(config.getJumpUrl()));
                } else {
                    this.ivIcon.setVisibility(8);
                }
            } else {
                this.ivIcon.setVisibility(8);
            }
        }
    }

    private void greerMessageByFrom(EnterRoomMsg newData) {
        if (FP.empty(this.mSourceMap)) {
            MLog.info((Object)TAG, (String)"config source not fetch success, source map is empty", (Object[])new Object[0]);
            this.greetMessage(newData, ResourceUtils.getString((int)R.string.tips_enter_room));
        } else if (this.mSourceMap.containsKey(newData.getSource() + "")) {
            this.greetMessage(newData, this.mSourceMap.get(newData.getSource() + ""));
        } else {
            MLog.info((Object)TAG, (String)"the source %s not contains in source map", (Object[])new Object[]{newData.getSource()});
            this.greetMessage(newData, ResourceUtils.getString((int)R.string.tips_enter_room));
        }
    }

    private void setNobleIcon(EnterRoomMsg newData) {
        if (!newData.isNobleEntry() || StringUtils.isEmpty((String)newData.getNobleIcon())) {
            this.ivIcon.setVisibility(8);
        } else {
            this.ivIcon.setVisibility(0);
            ImageLoader.loadImage((ImageView)this.ivIcon, (String)newData.getNobleIcon());
        }
        this.ivIcon.setOnClickListener(null);
    }

    private void setTag(EnterRoomMsg data) {
        Object extendInfo;
        boolean isNewUser = false;
        if (this.mActionHandler != null && (extendInfo = this.mActionHandler.getExtendInfo("isNewComer", new Object())) instanceof Boolean) {
            isNewUser = (Boolean)extendInfo;
        }
        NewUserTagData tagData = ((INewUserTagService)ServiceManagerProxy.getService(INewUserTagService.class)).getData();
        if (((EnterRoomMsg)((Object)this.getItemMsg())).isNewComer() && ((EnterRoomMsg)((Object)this.getItemMsg())).getUpgradeLabelId() > 0L && tagData.isMeInWhiteList()) {
            this.ivTag.setVisibility(8);
            this.tvNewTag.setVisibility(0);
            NewUserLabel label = tagData.findLabel(((EnterRoomMsg)((Object)this.getItemMsg())).getUpgradeLabelId());
            if (label != null) {
                this.updateUserUpgradeTag((TextView)this.tvNewTag, label);
                this.tvNewTag.setOnClickListener(v -> ToastUtils.showToast((Context)this.tvNewTag.getContext(), (CharSequence)label.getToastText()));
            }
        } else if (data.isFirstCharge()) {
            this.ivTag.setVisibility(0);
            this.tvNewTag.setVisibility(8);
        } else if (((EnterRoomMsg)((Object)this.getItemMsg())).isNewComer() && !isNewUser) {
            this.ivTag.setVisibility(8);
            this.tvNewTag.setVisibility(0);
            this.tvNewTag.setBackgroundResource(R.drawable.shape_bg_new_user_tag);
            this.tvNewTag.setText(R.string.tip_public_screen_new_user_tag);
            this.tvNewTag.setTextColor(-1);
            this.tvNewTag.setOnClickListener(v -> ToastUtils.showToast((Context)this.tvNewTag.getContext(), (int)R.string.tip_new_user_tag_click));
        } else {
            this.ivTag.setVisibility(8);
            this.tvNewTag.setVisibility(8);
        }
    }

    private void greetMessage(EnterRoomMsg newData, String msg) {
        ChainSpan.of().append((CharSequence)newData.getNick()).space().append((CharSequence)msg, new Object[]{TextSpan.of().color(ResourceUtils.getColor((int)R.color.color_ffec87)).build()}).build(spannable -> {
            this.updateContent((Spannable)spannable);
            return null;
        });
    }

    private void updateContent(Spannable text) {
        ConstraintLayout.LayoutParams layoutParams = (ConstraintLayout.LayoutParams)this.tvText.getLayoutParams();
        layoutParams.leftMargin = this.getSimpleContentMarginStart(this.tvText.getContext());
        this.tvText.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.ivhead.post(() -> {
            int tagWidth = this.userTagsLayout.getVisibility() == 8 ? 0 : this.userTagsLayout.getMeasuredWidth();
            int indentDistance = this.ivhead.getWidth() + this.getSimpleContentMarginStart(this.ivhead.getContext()) + tagWidth;
            this.setTextIndent(text, indentDistance);
        });
    }

    private void setTextIndent(Spannable text, int indentDistance) {
        MLog.debug((Object)TAG, (String)("setTextIndent: " + text + ", indentDistance: " + indentDistance), (Object[])new Object[0]);
        LeadingMarginSpan.Standard what = new LeadingMarginSpan.Standard(indentDistance, 0);
        text.setSpan((Object)what, 0, text.length(), 18);
        this.tvText.setText((CharSequence)text);
    }

    private int getSimpleContentMarginStart(Context context) {
        if (this.simpleContentMarginStart != -1) {
            return this.simpleContentMarginStart;
        }
        this.simpleContentMarginStart = context.getResources().getDimensionPixelSize(R.dimen.dp_5);
        return this.simpleContentMarginStart;
    }

    @KvoMethodAnnotation(name="dataChangedFlag", sourceClass=NewUserTagData.class, thread=1)
    private void onNewUseLabelsChange(@NotNull KvoEventIntent event) {
        EnterRoomMsg msg = (EnterRoomMsg)((Object)this.getItemMsg());
        if (msg != null && !FP.empty(((NewUserTagData)event.source()).getLabels()) && msg.isNewComer() && msg.getUpgradeLabelId() > 0L) {
            this.setTag(msg);
        }
    }

    private void updateUserUpgradeTag(final TextView tvTag2, final NewUserLabel label) {
        tvTag2.setText((CharSequence)label.getText());
        tvTag2.setTextColor(label.getTextColor());
        ImageLoader.loadBitmap((Context)this.itemView.getContext(), (String)label.getIcon(), (ImageLoader.BitmapLoadListener)new ImageLoader.BitmapLoadListener(){

            public void onResourceReady(Bitmap bitmap) {
                int width = (int)(tvTag2.getPaint().measureText(label.getText()) + (float)ResolutionUtils.dip2Px((float)8.0f));
                width = Math.max(ResolutionUtils.dip2Px((float)32.0f), width);
                BitmapDrawable drawable2 = new BitmapDrawable(EnterRoomMsgHolder.this.itemView.getResources(), Bitmap.createScaledBitmap((Bitmap)bitmap, (int)width, (int)ResolutionUtils.dip2Px((float)10.0f), (boolean)false));
                tvTag2.setBackground((Drawable)drawable2);
            }

            public void onLoadFailed(Exception e) {
            }
        }, (int)200, (int)200);
    }
}

